/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.cadastro.ModeloTabRendererExames;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.SolicitarPercentual;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoUtil;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

class AlterarPrecosCBHPM
extends JDialog
implements ActionListener {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_CODIGO_CBHPM = 3;
    private final int COLUNA_PERCENTUAL = 4;
    private final int COLUNA_PORTE = 5;
    private final int COLUNA_CUSTO = 6;
    private final int COLUNA_TOTAL = 7;
    private final int COLUNA_PROIBIR = 8;
    private final int COLUNA_INSERINDO = 9;
    JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonAlterar = ComponenteFactory.novoJButton("OK", this, null, null);
    JButton buttonLimpaCodigo = ComponenteFactory.novoJButton("Limpar C\u00f3digos", this, null, null);
    JButton buttonLimpaValor = ComponenteFactory.novoJButton("Limpar Valores", this, null, null);
    private JCheckBox checkIgnorarMaterial = ComponenteFactory.novoJCheckBox("Alterar o pre\u00e7o do exame ignorando material", 'm');
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("Atualizar exames", 't', this);
    ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "C\u00f3digo", "%", "Porte", "Custo", "Total", "Proibir"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : (c == 8 ? Boolean.class : String.class);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            AlterarPrecosCBHPM.this.modelo.setValueAt("*", row, 9);
            return col == 8;
        }
    };
    JTable tableExames = new JTable(this.modelo);
    JLabel labelCodigo = ComponenteFactory.novoJLabel("", new Dimension(69, 20));
    JLabel labelMaterial = ComponenteFactory.novoJLabel("", new Dimension(40, 20));
    JLabel labelExame = ComponenteFactory.novoJLabel("", new Dimension(150, 20));
    JLabel labelUCO = ComponenteFactory.novoJLabel("", new Dimension(69, 20));
    JLabel labelTotal = ComponenteFactory.novoJLabel("", new Dimension(69, 20));
    TTextField textCodigoCBHPM = new TTextField(14, 19);
    TTextField textPercentual = new TTextField(8, 2, 3);
    JComboBox comboPorte = new JComboBox();
    TTextField textCusto = new TTextField(8, 2, 3);
    TTextField textLocalizar = ComponenteFactory.novoTTextField(100, 3, new Dimension(70, 20), new Dimension(70, 20), null, null, null);
    JLabel labelLocalizar = ComponenteFactory.novoJLabel("Localizar:", 'L', null, this.textLocalizar);
    private JButton buttonProibirTodos = ComponenteFactory.novoJButton("Proibir todos", this);
    private JButton buttonLimparProibidos = ComponenteFactory.novoJButton("Limpar proibidos", this);
    private JButton buttonAtualizarPrecoAumentar = ComponenteFactory.novoJButton("Aumentar percentual", this);
    private JButton buttonAtualizarPrecoDiminuir = ComponenteFactory.novoJButton("Diminuir percentual", this);
    private boolean ok = false;
    private int codigoTabela = -1;
    private int linhaAlterada = -1;
    private int colunaOrdenada = 0;

    public static AlterarPrecosCBHPM novaInstancia(Object owner) {
        if (owner instanceof JFrame) {
            return new AlterarPrecosCBHPM((Frame)owner);
        }
        if (owner instanceof JDialog) {
            return new AlterarPrecosCBHPM((Dialog)owner);
        }
        return null;
    }

    public AlterarPrecosCBHPM(Frame owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public AlterarPrecosCBHPM(Dialog owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public void setTabela(int codigoTabela) {
        this.codigoTabela = codigoTabela;
        this.buscaDados();
    }

    public void setPortes(ArrayList<PorteTabelaCBHPM> portes) {
        this.comboPorte.removeAllItems();
        for (PorteTabelaCBHPM p : portes) {
            this.comboPorte.addItem(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDados() {
        if (this.codigoTabela == -1) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, a.dtp_proibido, a.dtp_valor, a.dtp_codamb, ");
        buf.append("a.dtp_percentual, a.tpp_porte, b.exa_descricao, c.tpp_valor, d.tpe_uco ");
        buf.append("from detalhetabelapreco a ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("left join tabelaprecoexamesporte c on a.fil_codigo = c.fil_codigo and a.tpe_codigo = c.tpe_codigo and a.tpp_porte = c.tpp_porte ");
        buf.append("left join tabelaprecoexames d on a.fil_codigo = d.fil_codigo and a.tpe_codigo = d.tpe_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.tpe_codigo = ").append(this.codigoTabela);
        buf.append(" order by a.exa_codigo, a.mco_codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modelo.clear();
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                material.setShowAbreviatura(true);
                PorteTabelaCBHPM porte = new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor"));
                double total = TabelaPrecoUtil.calculaTotalExameTipoCBHPM(rs.getString("dtp_percentual"), rs.getString("dtp_valor"), rs.getString("tpe_uco"), porte);
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), DBUtil.campoNull(rs.getString("dtp_codamb")) ? "" : rs.getString("dtp_codamb"), DBUtil.campoNull(rs.getString("dtp_percentual")) ? "" : Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), rs.getDouble("dtp_percentual")), rs.getString("tpp_porte"), DBUtil.campoNull(rs.getString("dtp_valor")) ? "" : Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), rs.getDouble("dtp_valor")), Funcoes.formataDecimal(total), rs.getBoolean("dtp_proibido"), ""});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TabelaPreco (1430)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private PorteTabelaCBHPM pegaPorte(String porte) {
        for (int i = 0; i < this.comboPorte.getItemCount(); ++i) {
            PorteTabelaCBHPM p = (PorteTabelaCBHPM)this.comboPorte.getItemAt(i);
            if (!p.getPorte().equalsIgnoreCase(porte)) continue;
            return p;
        }
        return null;
    }

    public void setPrecos(ArrayList<PrecosAlterados> precos) {
        for (PrecosAlterados p : precos) {
            PorteTabelaCBHPM porte = this.pegaPorte(p.getPorte());
            double valorUCO = Funcoes.isNumeric(this.labelUCO.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.labelUCO.getText())) : 0.0;
            double total = p.getPercentual() * (porte != null ? porte.getValor() : 0.0) + p.getValorCusto() * valorUCO;
            this.modelo.addLine(new Object[]{p.getCodigoExame(), p.getMaterial(), p.getDescricaoExame(), p.getCodigoAMB(), Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), p.getPercentual()), p.getPorte(), Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), p.getValorCusto()), Funcoes.formataDecimal(total), p.isProibido(), p.isInserindoExame() ? "*" : ""});
        }
    }

    public ArrayList<PrecosAlterados> getPrecosAlterados() {
        ArrayList<PrecosAlterados> precos = new ArrayList<PrecosAlterados>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            boolean inserir = !Funcoes.textoVazio(this.modelo.getValueAt(i, 9).toString());
            precos.add(new PrecosAlterados(this.modelo.getValueAt(i, 0).toString(), (DadosMaterial)this.modelo.getValueAt(i, 1), this.modelo.getValueAt(i, 2).toString(), this.modelo.getValueAt(i, 3).toString(), Funcoes.isNumeric(this.modelo.getValueAt(i, 6).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 6).toString())) : 0.0, Funcoes.isNumeric(this.modelo.getValueAt(i, 4).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 4).toString())) : 0.0, this.modelo.getValueAt(i, 5) != null ? this.modelo.getValueAt(i, 5).toString() : "", (Boolean)this.modelo.getValueAt(i, 8), inserir, null, null));
        }
        return precos;
    }

    private void montaTela() {
        this.tableExames.setToolTipText("F2 - Pesquisa avan\u00e7ada");
        this.tableExames.setDefaultRenderer(Object.class, new ModeloTabRendererExames(5));
        this.tableExames.getTableHeader().setReorderingAllowed(false);
        this.tableExames.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlterarPrecosCBHPM.this.colunaOrdenada = AlterarPrecosCBHPM.this.tableExames.getColumnModel().getColumnIndexAtX(e.getX());
                AlterarPrecosCBHPM.this.modelo.mouseClicked(e);
            }
        });
        JPanel panelCentral = new JPanel(new GridBagLayout());
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentral, "Center");
        this.setModal(true);
        this.setSize(new Dimension(740, 528));
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.labelCodigo, this.labelMaterial, this.labelExame, this.labelTotal, this.labelUCO}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        panelCentral.add((Component)new JLabel("C\u00f3digo"), c);
        c.gridx = 1;
        panelCentral.add((Component)new JLabel("Mat."), c);
        c.gridx = 2;
        panelCentral.add((Component)new JLabel("Exame"), c);
        c.gridx = 3;
        panelCentral.add((Component)new JLabel("C\u00f3digo"), c);
        c.gridx = 4;
        panelCentral.add((Component)new JLabel("Percentual"), c);
        c.gridx = 5;
        panelCentral.add((Component)new JLabel("Porte"), c);
        c.gridx = 6;
        panelCentral.add((Component)new JLabel("Custo"), c);
        c.gridx = 7;
        panelCentral.add((Component)new JLabel("UCO"), c);
        c.gridx = 8;
        panelCentral.add((Component)new JLabel("Total"), c);
        c.gridx = 9;
        panelCentral.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        this.labelCodigo.setMinimumSize(new Dimension(70, 20));
        panelCentral.add((Component)this.labelCodigo, c);
        c.gridx = 1;
        this.labelMaterial.setMinimumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.labelMaterial, c);
        c.gridx = 3;
        this.textCodigoCBHPM.setPreferredSize(new Dimension(120, 20));
        this.textCodigoCBHPM.setMinimumSize(new Dimension(120, 20));
        panelCentral.add((Component)this.textCodigoCBHPM, c);
        c.gridx = 4;
        this.textPercentual.setPreferredSize(new Dimension(80, 20));
        this.textPercentual.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textPercentual, c);
        c.gridx = 5;
        this.comboPorte.setPreferredSize(new Dimension(80, 20));
        this.comboPorte.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.comboPorte, c);
        c.gridx = 6;
        this.textCusto.setPreferredSize(new Dimension(80, 20));
        this.textCusto.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textCusto, c);
        c.gridx = 7;
        this.labelUCO.setPreferredSize(new Dimension(80, 20));
        this.labelUCO.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.labelUCO, c);
        c.gridx = 8;
        this.labelTotal.setPreferredSize(new Dimension(80, 20));
        this.labelTotal.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.labelTotal, c);
        c.gridx = 9;
        this.buttonAlterar.setPreferredSize(new Dimension(40, 20));
        this.buttonAlterar.setMinimumSize(new Dimension(40, 20));
        this.buttonAlterar.setMaximumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.buttonAlterar, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelExame.setMinimumSize(new Dimension(30, 20));
        panelCentral.add((Component)this.labelExame, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 10;
        JPanel panelLocalizar = new JPanel(new GridBagLayout());
        panelCentral.add((Component)panelLocalizar, c);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        panelLocalizar.add((Component)this.labelLocalizar, cons);
        cons.gridx = 1;
        cons.fill = 2;
        cons.weightx = 1.0;
        panelLocalizar.add((Component)this.textLocalizar, cons);
        c.gridy = 4;
        JPanel panelBotoes = new JPanel(new GridBagLayout());
        panelCentral.add((Component)panelBotoes, c);
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tableExames), c);
        GridBagConstraints cAux = new GridBagConstraints();
        cAux.weightx = 1.0;
        cAux.fill = 2;
        panelBotoes.add((Component)this.buttonAtualizar, cAux);
        cAux.gridx = 1;
        panelBotoes.add((Component)this.buttonLimpaCodigo, cAux);
        cAux.gridx = 2;
        panelBotoes.add((Component)this.buttonLimpaValor, cAux);
        cAux.gridy = 1;
        cAux.gridx = 0;
        panelBotoes.add((Component)this.buttonProibirTodos, cAux);
        cAux.gridx = 1;
        panelBotoes.add((Component)this.buttonLimparProibidos, cAux);
        cAux.gridx = 2;
        panelBotoes.add((Component)this.buttonAtualizarPrecoAumentar, cAux);
        cAux.gridy = 2;
        cAux.gridx = 0;
        panelBotoes.add((Component)this.buttonAtualizarPrecoDiminuir, cAux);
        cAux.gridy = 3;
        cAux.gridwidth = 3;
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)this.checkIgnorarMaterial, "West");
        JPanel p = new JPanel(new FlowLayout(2));
        p.add(this.buttonOK);
        p.add(this.buttonCancelar);
        p1.add((Component)p, "East");
        panelBotoes.add((Component)p1, cAux);
        Funcoes.montaEnter((JComponent)panelCentral);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.modelo.setColumnSize(new int[]{70, 40, 0, 105, 70, 40, 70, 70, 40}, this.tableExames);
        this.tableExames.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && AlterarPrecosCBHPM.this.tableExames.getSelectedColumn() < 8) {
                    AlterarPrecosCBHPM.this.alterarLinha(AlterarPrecosCBHPM.this.tableExames.getSelectedRow());
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlterarPrecosCBHPM.this.tableExames.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlterarPrecosCBHPM.this.alterarLinha(AlterarPrecosCBHPM.this.tableExames.getSelectedRow());
                        }
                    });
                } else if (e.getKeyCode() == 113) {
                    AlterarPrecosCBHPM.this.pesquisaAvancada();
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarPrecosCBHPM.this.pesquisaAvancada();
                } else {
                    int pos = AlterarPrecosCBHPM.this.modelo.localizarParcial(AlterarPrecosCBHPM.this.colunaOrdenada, AlterarPrecosCBHPM.this.textLocalizar.getText() + (Funcoes.textoVazio(String.valueOf(e.getKeyChar())) ? "" : String.valueOf(e.getKeyChar())));
                    if (pos > -1) {
                        AlterarPrecosCBHPM.this.tableExames.setRowSelectionInterval(pos, pos);
                        AlterarPrecosCBHPM.this.tableExames.scrollRectToVisible(AlterarPrecosCBHPM.this.tableExames.getCellRect(pos, 0, true));
                    }
                }
            }
        });
        this.textPercentual.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosCBHPM.this.textPercentual.selectAll();
            }
        });
        this.textCusto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosCBHPM.this.textCusto.selectAll();
            }
        });
        this.textPercentual.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AlterarPrecosCBHPM.this.mostraTotal();
            }
        });
        this.textCusto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AlterarPrecosCBHPM.this.mostraTotal();
            }
        });
        this.comboPorte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarPrecosCBHPM.this.mostraTotal();
            }
        });
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigoCBHPM);
        this.modelo.ordenarColuna(this.colunaOrdenada);
    }

    private void pesquisaAvancada() {
        Hashtable resultado = Pesquisas.exameAMB(this, false, false);
        if (resultado != null) {
            String codigo = resultado.get("exa_codigo").toString();
            this.modelo.ordenarColuna(0);
            int pos = this.modelo.localizar(0, codigo);
            if (pos > -1) {
                this.tableExames.setRowSelectionInterval(pos, pos);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(pos, 0, true));
            }
        }
    }

    public boolean getOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAlterar) {
            this.alterarPreco();
        } else if (e.getSource() == this.buttonLimpaCodigo) {
            this.limpaValores(new int[]{3}, "C\u00f3digos");
        } else if (e.getSource() == this.buttonLimpaValor) {
            this.limpaValores(new int[]{6, 4, 5, 7}, "Percentuais/Portes/Custos");
        } else if (e.getSource() == this.buttonAtualizar) {
            this.atualizar();
        } else if (e.getSource() == this.buttonProibirTodos) {
            if (Funcoes.mensagem(this, "Confirma a proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    this.modelo.setValueAt(true, i, 8);
                    this.modelo.setValueAt("*", i, 9);
                }
            }
        } else if (e.getSource() == this.buttonLimparProibidos) {
            if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o da proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    if (Funcoes.textoVazio(this.modelo.getValueAt(i, 8).toString())) continue;
                    this.modelo.setValueAt(false, i, 8);
                    this.modelo.setValueAt("*", i, 9);
                }
            }
        } else if (e.getSource() == this.buttonAtualizarPrecoAumentar || e.getSource() == this.buttonAtualizarPrecoDiminuir) {
            boolean isDiminuirPercentual = e.getSource() == this.buttonAtualizarPrecoDiminuir;
            SolicitarPercentual sp = SolicitarPercentual.novaInstancia(this);
            if (sp != null) {
                sp.setApenasExamesSelecionados(this.tableExames.getSelectedRowCount() > 1);
                sp.setVisible(true);
                if (sp.ok() && sp.getPercentual() > 0.0) {
                    int[] linhas = new int[this.modelo.getRowCount()];
                    if (sp.isApenasExamesSelecionados() && this.tableExames.getSelectedRowCount() > 0) {
                        linhas = this.tableExames.getSelectedRows();
                    } else {
                        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                            linhas[i] = i;
                        }
                    }
                    for (int i : linhas) {
                        if (this.modelo.getValueAt(i, 6) == null || Funcoes.textoVazio(this.modelo.getValueAt(i, 6).toString()) || !Funcoes.isNumeric(this.modelo.getValueAt(i, 6).toString())) continue;
                        double valorAtual = Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 6).toString()));
                        BigDecimal valor = Funcoes.calculaPercentual(sp.getPercentual(), valorAtual, sp.isArredondarCentavos(), isDiminuirPercentual, 4);
                        this.modelo.setValueAt(Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), valor.doubleValue()), i, 6);
                        String percentual = this.modelo.getValueAt(i, 4).toString();
                        String custo = this.modelo.getValueAt(i, 6).toString();
                        String porte = this.modelo.getValueAt(i, 5) != null ? this.modelo.getValueAt(i, 5).toString() : "";
                        this.modelo.setValueAt(Funcoes.formataDecimal(this.calculaTotalExame(percentual, custo, this.labelUCO.getText(), porte)), i, 7);
                        this.modelo.setValueAt("*", i, 9);
                    }
                }
            }
        } else {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizar() {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, b.mco_codigo, a.exa_descricao from exames a ");
        buf.append("left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" order by a.exa_codigo, b.mco_codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                if (material == null) continue;
                material.setShowAbreviatura(true);
                if (this.achaExame(rs.getString("exa_codigo"), material)) continue;
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), "", "", "", "", "0,00", false, "*"});
            }
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                this.modelo.setValueAt("*", i, 9);
            }
            Funcoes.mensagem(this, "A atualiza\u00e7\u00e3o de pre\u00e7os dos exames foi conclu\u00edda com sucesso.", 5);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco (1686)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean achaExame(String exame, DadosMaterial material) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String e = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial m = (DadosMaterial)this.modelo.getValueAt(i, 1);
            if (!e.equalsIgnoreCase(exame) || m.getCodigo() != material.getCodigo()) continue;
            return true;
        }
        return false;
    }

    private void limpaValores(int[] colunas, String textoLimpar) {
        if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o dos valores da coluna " + textoLimpar, 4) == 0) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                for (int c : colunas) {
                    if (c >= this.modelo.getColumnCount()) continue;
                    this.modelo.setValueAt("", i, c);
                    this.modelo.setValueAt("*", i, 9);
                }
            }
        }
    }

    private void alterarLinha(int linha) {
        if (linha > -1) {
            PorteTabelaCBHPM p;
            String porte;
            this.labelCodigo.setText((String)this.modelo.getValueAt(linha, 0));
            this.labelMaterial.setText(((DadosMaterial)this.modelo.getValueAt(linha, 1)).getAbreviatura());
            this.labelExame.setText((String)this.modelo.getValueAt(linha, 2));
            this.textCodigoCBHPM.setText((String)this.modelo.getValueAt(linha, 3));
            this.textPercentual.setText((String)this.modelo.getValueAt(linha, 4));
            String string = porte = this.modelo.getValueAt(linha, 5) != null ? this.modelo.getValueAt(linha, 5).toString() : "";
            if (!Funcoes.textoVazio(porte) && (p = this.pegaPorte(porte)) != null) {
                this.comboPorte.setSelectedItem(p);
            }
            this.textCusto.setText(this.modelo.getValueAt(linha, 6).toString());
            this.labelTotal.setText(this.modelo.getValueAt(linha, 7).toString());
            this.linhaAlterada = linha;
            ScreenUtil.requisitarFoco(this.textCodigoCBHPM);
        }
    }

    private void mostraTotal() {
        PorteTabelaCBHPM p = (PorteTabelaCBHPM)this.comboPorte.getSelectedItem();
        this.labelTotal.setText(Funcoes.formataDecimal(TabelaPrecoUtil.calculaTotalExameTipoCBHPM(this.textPercentual.getText(), this.textCusto.getText(), this.labelUCO.getText(), p)));
    }

    private double calculaTotalExame(String percentual, String custo, String uco, String porte) {
        PorteTabelaCBHPM p = this.pegaPorte(porte);
        if (p == null) {
            return 0.0;
        }
        return TabelaPrecoUtil.calculaTotalExameTipoCBHPM(percentual, custo, uco, p);
    }

    public void setValorUCO(double uco) {
        this.labelUCO.setText(Funcoes.formataDecimal(uco));
    }

    private void alterarPreco() {
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        if (this.linhaAlterada > -1) {
            linhas.add(this.linhaAlterada);
        }
        if (this.checkIgnorarMaterial.isSelected()) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelCodigo.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        }
        Iterator iterator = linhas.iterator();
        while (iterator.hasNext()) {
            int linha = (Integer)iterator.next();
            this.modelo.setValueAt(this.textCodigoCBHPM.getText(), linha, 3);
            this.modelo.setValueAt(this.comboPorte.getSelectedItem().toString(), linha, 5);
            if (!Funcoes.isNumeric(this.textPercentual.getText().replaceAll(",", "."))) {
                this.modelo.setValueAt("0,00", linha, 4);
            } else {
                this.modelo.setValueAt(Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(this.textPercentual.getText().replaceAll(",", "."))), linha, 4);
            }
            if (!Funcoes.isNumeric(this.textCusto.getText().replaceAll(",", "."))) {
                this.modelo.setValueAt("0,00", linha, 6);
            } else {
                this.modelo.setValueAt(Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), Double.parseDouble(this.textCusto.getText().replaceAll(",", "."))), linha, 6);
            }
            this.modelo.setValueAt(this.labelTotal.getText(), linha, 7);
            this.modelo.setValueAt("*", linha, 9);
        }
        this.labelCodigo.setText("");
        this.labelMaterial.setText("");
        this.labelExame.setText("");
        this.textPercentual.clear();
        this.textCodigoCBHPM.clear();
        this.textCusto.clear();
        this.labelTotal.setText("");
        this.linhaAlterada = -1;
        ScreenUtil.requisitarFoco(this.tableExames);
    }
}

