/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.cadastro.SolicitarPercentual;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

class AlterarPrecosAMBMetodologia
extends JDialog
implements ActionListener {
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO_EXAME = 2;
    private final int COLUNA_DESCRICAO_METODOLOGIA = 3;
    private final int COLUNA_AMB = 4;
    private final int COLUNA_VALOR = 5;
    private final int COLUNA_PROIBIR = 6;
    private final int COLUNA_ADICIONAR = 7;
    private final int COLUNA_CODIGO_METODOLOGIA = 8;
    private int CASAS = 4;
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonAlterar = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonLimpaAMB = ComponenteFactory.novoJButton("Limpar AMB", this);
    private JButton buttonLimpaValor = ComponenteFactory.novoJButton("Limpar valores", this);
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("Atualizar exames", this);
    private JButton buttonProibirTodos = ComponenteFactory.novoJButton("Proibir todos", this);
    private JButton buttonLimparProibidos = ComponenteFactory.novoJButton("Limpar proibidos", this);
    private JButton buttonAtualizarPrecoAumentar = ComponenteFactory.novoJButton("Aumentar percentual", this);
    private JButton buttonAtualizarPrecoDiminuir = ComponenteFactory.novoJButton("Diminuir percentual", this);
    private JCheckBox checkIgnorarMaterial = ComponenteFactory.novoJCheckBox("Alterar pre\u00e7o ignorando material", 'x');
    private JCheckBox checkIgnorarMetodologia = ComponenteFactory.novoJCheckBox("Alterar pre\u00e7o ignorando metodologia", 'l');
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Metodologia", "AMB", "Valor", "Proibir"}){

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Boolean.class;
                }
                case 7: {
                    return Boolean.class;
                }
                case 8: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            AlterarPrecosAMBMetodologia.this.modelo.setValueAt(true, row, 7);
            return col == 6;
        }
    };
    private JTable tableExames = new JTable(this.modelo);
    private TTextField textAMB = new TTextField(14, 19);
    private TTextField textValor = new TTextField(10, 2);
    private TTextField textLocalizar = ComponenteFactory.novoTTextField(100, 3, new Dimension(70, 20), new Dimension(70, 20), null, null, null);
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelVlrMaterial = new JLabel();
    private JLabel labelVlrExame = new JLabel();
    private JLabel labelVlrMetodologia = new JLabel();
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JLabel labelCodigo = new JLabel("C\u00f3digo");
    private JLabel labelMaterial = new JLabel("Mat.");
    private JLabel labelExame = new JLabel("Exame");
    private JLabel labelAmb = new JLabel("AMB");
    private JLabel labelValor = new JLabel("Valor");
    private JLabel labelMetodologia = new JLabel("Metodologia");
    private JPanel panelLocalizar = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new GridLayout(2, 3));
    private JPanel panelBotoesJanela = new JPanel(new BorderLayout());
    private boolean ok = false;
    private int codigoTabela = -1;
    private int linhaAlterada = -1;
    private int colunaOrdenada = 0;

    public static AlterarPrecosAMBMetodologia novaInstancia(Window owner) {
        if (owner instanceof JFrame) {
            return new AlterarPrecosAMBMetodologia((Frame)owner);
        }
        if (owner instanceof JDialog) {
            return new AlterarPrecosAMBMetodologia((Dialog)owner);
        }
        return null;
    }

    public AlterarPrecosAMBMetodologia(Frame owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public AlterarPrecosAMBMetodologia(Dialog owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public void setTabela(int codigoTabela) {
        this.codigoTabela = codigoTabela;
        this.buscaDados();
    }

    public void setPrecos(ArrayList<PrecosAlterados> precos) {
        this.modelo.clear();
        for (PrecosAlterados p : precos) {
            this.modelo.addLine(new Object[]{p.getCodigoExame(), p.getMaterial(), p.getDescricaoExame(), p.getDescricaoMetodologia(), p.getCodigoAMB(), Funcoes.formataDecimal(p.getValorCusto()), p.isProibido(), p.isInserindoExame(), p.getCodigoMetodologia()});
        }
    }

    public ArrayList<PrecosAlterados> getPrecosAlterados() {
        ArrayList<PrecosAlterados> precos = new ArrayList<PrecosAlterados>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String codigoExame = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial dadosMaterial = (DadosMaterial)this.modelo.getValueAt(i, 1);
            String descricaoExame = this.modelo.getValueAt(i, 2).toString();
            String amb = this.modelo.getValueAt(i, 4) != null ? this.modelo.getValueAt(i, 4).toString() : null;
            Double valor = this.modelo.getValueAt(i, 5) != null && Funcoes.isNumeric(this.modelo.getValueAt(i, 5).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 5).toString())) : 0.0;
            Boolean proibir = (Boolean)this.modelo.getValueAt(i, 6);
            Boolean adicionar = (Boolean)this.modelo.getValueAt(i, 7);
            Integer codigoMetodologia = this.modelo.getValueAt(i, 8) != null ? (Integer)this.modelo.getValueAt(i, 8) : null;
            String descricaoMetodologia = this.modelo.getValueAt(i, 3) != null ? this.modelo.getValueAt(i, 3).toString() : null;
            precos.add(new PrecosAlterados(codigoExame, dadosMaterial, descricaoExame, amb, valor, proibir, adicionar, codigoMetodologia, descricaoMetodologia));
        }
        return precos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDados() {
        if (this.codigoTabela == -1) {
            return;
        }
        this.modelo.clear();
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select dtm.exa_codigo ");
        buf.append("       ,dtm.mco_codigo ");
        buf.append("       ,dtm.dtm_proibido ");
        buf.append("       ,dtm.dtm_valor ");
        buf.append("       ,dtm.dtm_codamb ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,met.met_codigo ");
        buf.append("       ,met.met_descricao ");
        buf.append("   from detalhetabelaprecometodologia dtm ");
        buf.append("   join exames exa on dtm.fil_codigo = exa.fil_codigo and dtm.exa_codigo = exa.exa_codigo ");
        buf.append("   join metodologia met on dtm.fil_codigo = met.fil_codigo and dtm.met_codigo = met.met_codigo ");
        buf.append("  where dtm.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and dtm.tpe_codigo = ").append(this.codigoTabela);
        buf.append("  order by dtm.exa_codigo ");
        buf.append("          ,dtm.mco_codigo ");
        buf.append("          ,met.met_descricao ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                material.setShowAbreviatura(true);
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), rs.getString("met_descricao"), DBUtil.campoNull(rs.getString("dtm_codamb")) ? "" : rs.getString("dtm_codamb"), DBUtil.campoNull(rs.getString("dtm_valor")) ? "" : Funcoes.formataDecimal(rs.getDouble("dtm_valor")), rs.getBoolean("dtm_proibido"), false, rs.getInt("met_codigo")});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void montaTela() {
        this.tableExames.setToolTipText("F2 - Pesquisa avan\u00e7ada");
        this.tableExames.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlterarPrecosAMBMetodologia.this.modelo.mouseClicked(e);
                AlterarPrecosAMBMetodologia.this.colunaOrdenada = AlterarPrecosAMBMetodologia.this.modelo.getColunaOrdenacao();
            }
        });
        JPanel panelCentral = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentral, "Center");
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.setModal(true);
        this.setSize(new Dimension(750, 550));
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.labelVlrCodigo, this.labelVlrMaterial, this.labelVlrExame, this.labelVlrMetodologia}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 1);
        panelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelMaterial, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelExame, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelMetodologia, c);
        ++c.gridx;
        this.labelAmb.setDisplayedMnemonic('A');
        this.labelAmb.setLabelFor(this.textAMB);
        panelCentral.add((Component)this.labelAmb, c);
        ++c.gridx;
        this.labelValor.setDisplayedMnemonic('V');
        this.labelValor.setLabelFor(this.textValor);
        panelCentral.add((Component)this.labelValor, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelVlrCodigo.setMinimumSize(new Dimension(70, 20));
        this.labelVlrCodigo.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.labelVlrCodigo, c);
        ++c.gridx;
        this.labelVlrMaterial.setMinimumSize(new Dimension(40, 20));
        this.labelVlrMaterial.setPreferredSize(new Dimension(40, 20));
        panelCentral.add((Component)this.labelVlrMaterial, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelVlrExame.setMinimumSize(new Dimension(20, 20));
        this.labelVlrExame.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelVlrExame, c);
        ++c.gridx;
        this.labelVlrMetodologia.setMinimumSize(new Dimension(20, 20));
        this.labelVlrMetodologia.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelVlrMetodologia, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.textAMB.setPreferredSize(new Dimension(120, 20));
        this.textAMB.setMinimumSize(new Dimension(120, 20));
        panelCentral.add((Component)this.textAMB, c);
        ++c.gridx;
        this.textValor.setPreferredSize(new Dimension(80, 20));
        this.textValor.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textValor, c);
        ++c.gridx;
        this.buttonAlterar.setPreferredSize(new Dimension(40, 20));
        this.buttonAlterar.setMinimumSize(new Dimension(40, 20));
        this.buttonAlterar.setMnemonic('K');
        panelCentral.add((Component)this.buttonAlterar, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tableExames), c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelLocalizar.add((Component)this.labelLocalizar, "West");
        this.panelLocalizar.add((Component)this.textLocalizar, "Center");
        this.labelLocalizar.setDisplayedMnemonic('L');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        panelCentral.add((Component)this.panelLocalizar, c);
        ++c.gridy;
        this.buttonAtualizar.setMnemonic('t');
        this.panelBotoes.add(this.buttonAtualizar);
        this.buttonLimpaAMB.setMnemonic('i');
        this.panelBotoes.add(this.buttonLimpaAMB);
        this.buttonLimpaValor.setMnemonic('r');
        this.panelBotoes.add(this.buttonLimpaValor);
        this.buttonProibirTodos.setMnemonic('P');
        this.panelBotoes.add(this.buttonProibirTodos);
        this.buttonLimparProibidos.setMnemonic('m');
        this.panelBotoes.add(this.buttonLimparProibidos);
        this.buttonAtualizarPrecoAumentar.setMnemonic('u');
        this.panelBotoes.add(this.buttonAtualizarPrecoAumentar);
        ++c.gridy;
        this.buttonAtualizarPrecoDiminuir.setMnemonic('d');
        this.panelBotoes.add(this.buttonAtualizarPrecoDiminuir);
        panelCentral.add((Component)this.panelBotoes, c);
        ++c.gridy;
        JPanel esquerda = new JPanel(new FlowLayout(0));
        esquerda.add(this.checkIgnorarMaterial);
        esquerda.add(this.checkIgnorarMetodologia);
        this.panelBotoesJanela.add((Component)esquerda, "West");
        JPanel direita = new JPanel(new FlowLayout(2));
        direita.add(this.buttonOK);
        direita.add(this.buttonCancelar);
        this.panelBotoesJanela.add((Component)direita, "East");
        panelCentral.add((Component)this.panelBotoesJanela, c);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.modelo.setColumnSize(new int[]{70, 40, 0, 180, 90, 70, 45}, this.tableExames);
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (AlterarPrecosAMBMetodologia.this.tableExames.getSelectedColumn() < 6) {
                    AlterarPrecosAMBMetodologia.this.alterarLinha(AlterarPrecosAMBMetodologia.this.tableExames.getSelectedRow());
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlterarPrecosAMBMetodologia.this.tableExames.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlterarPrecosAMBMetodologia.this.alterarLinha(AlterarPrecosAMBMetodologia.this.tableExames.getSelectedRow());
                        }
                    });
                } else if (e.getKeyCode() == 113) {
                    AlterarPrecosAMBMetodologia.this.pesquisaAvancada();
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarPrecosAMBMetodologia.this.pesquisaAvancada();
                } else {
                    int pos = AlterarPrecosAMBMetodologia.this.modelo.localizarParcial(AlterarPrecosAMBMetodologia.this.colunaOrdenada, AlterarPrecosAMBMetodologia.this.textLocalizar.getText() + (Funcoes.textoVazio(String.valueOf(e.getKeyChar())) ? "" : String.valueOf(e.getKeyChar())));
                    if (pos > -1) {
                        AlterarPrecosAMBMetodologia.this.tableExames.setRowSelectionInterval(pos, pos);
                        AlterarPrecosAMBMetodologia.this.tableExames.scrollRectToVisible(AlterarPrecosAMBMetodologia.this.tableExames.getCellRect(pos, 0, true));
                    }
                }
            }
        });
        this.textValor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosAMBMetodologia.this.textValor.selectAll();
            }
        });
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textAMB);
        this.modelo.ordenarColuna(this.colunaOrdenada);
    }

    private void pesquisaAvancada() {
        Hashtable resultado = Pesquisas.exameAMB(this, false, false);
        if (resultado != null) {
            String codigo = resultado.get("exa_codigo").toString();
            this.modelo.ordenarColuna(0);
            int pos = this.modelo.localizar(0, codigo);
            if (pos > -1) {
                this.tableExames.setRowSelectionInterval(pos, pos);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(pos, 0, true));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAlterar) {
            this.alterarPreco();
        } else if (e.getSource() == this.buttonLimpaAMB) {
            this.limpaValores(4, "AMB");
        } else if (e.getSource() == this.buttonLimpaValor) {
            this.limpaValores(5, "Pre\u00e7os");
        } else if (e.getSource() == this.buttonAtualizar) {
            this.atualizar();
        } else if (e.getSource() == this.buttonProibirTodos) {
            if (Funcoes.mensagem(this, "Confirma a proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    this.modelo.setValueAt(true, i, 6);
                    this.modelo.setValueAt(true, i, 7);
                }
            }
        } else if (e.getSource() == this.buttonLimparProibidos) {
            if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o da proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    this.modelo.setValueAt(false, i, 6);
                    this.modelo.setValueAt(true, i, 7);
                }
            }
        } else if (e.getSource() == this.buttonAtualizarPrecoAumentar || e.getSource() == this.buttonAtualizarPrecoDiminuir) {
            boolean isDiminuirPercentual = e.getSource() == this.buttonAtualizarPrecoDiminuir;
            SolicitarPercentual sp = SolicitarPercentual.novaInstancia(this);
            if (sp != null) {
                sp.setApenasExamesSelecionados(this.tableExames.getSelectedRowCount() > 1);
                sp.setVisible(true);
                if (sp.ok() && sp.getPercentual() > 0.0) {
                    int[] linhas = new int[this.modelo.getRowCount()];
                    if (sp.isApenasExamesSelecionados() && this.tableExames.getSelectedRowCount() > 0) {
                        linhas = this.tableExames.getSelectedRows();
                    } else {
                        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                            linhas[i] = i;
                        }
                    }
                    for (int i : linhas) {
                        if (this.modelo.getValueAt(i, 5) == null || Funcoes.textoVazio(this.modelo.getValueAt(i, 5).toString()) || !Funcoes.isNumeric(this.modelo.getValueAt(i, 5).toString())) continue;
                        BigDecimal valorAtual = new BigDecimal(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 5).toString())).setScale(this.CASAS, this.ROUND);
                        BigDecimal valor = Funcoes.calculaPercentual(sp.getPercentual(), valorAtual.doubleValue(), sp.isArredondarCentavos(), isDiminuirPercentual, 4);
                        this.modelo.setValueAt(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), valor.doubleValue()), i, 5);
                        this.modelo.setValueAt(true, i, 7);
                    }
                }
            }
        } else {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizar() {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select exa.exa_codigo ");
        buf.append("       ,emc.mco_codigo ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,elm.met_codigo ");
        buf.append("       ,met.met_descricao ");
        buf.append("       ,dtp.dtp_valor ");
        buf.append("       ,dtp.dtp_codamb ");
        buf.append("       ,COALESCE(dtp.dtp_proibido, false) as dtp_proibido ");
        buf.append("   from exames exa ");
        buf.append("   join examematcoleta emc on exa.fil_codigo = emc.fil_codigo and exa.exa_codigo = emc.exa_codigo ");
        buf.append("   join examelayoutmetodo elm on exa.fil_codigo = elm.fil_codigo and exa.exa_codigo = elm.exa_codigo and emc.mco_codigo = elm.mco_codigo ");
        buf.append("   join metodologia met on elm.fil_codigo = met.fil_codigo and elm.met_codigo = met.met_codigo ");
        buf.append("   left join detalhetabelapreco dtp on emc.fil_codigo = dtp.fil_codigo and emc.exa_codigo = dtp.exa_codigo and emc.mco_codigo = dtp.mco_codigo and dtp.tpe_codigo = ").append(this.codigoTabela);
        buf.append("  where exa.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("  order by exa.exa_codigo ");
        buf.append("          ,emc.mco_codigo ");
        buf.append("          ,met.met_descricao ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                Integer codigoMetodologia = rs.getInt("met_codigo");
                if (material == null) continue;
                material.setShowAbreviatura(true);
                if (this.achaExame(rs.getString("exa_codigo"), material, codigoMetodologia)) continue;
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), rs.getString("met_descricao"), rs.getString("dtp_codamb"), rs.getString("dtp_valor") == null ? null : Funcoes.formataDecimal(rs.getDouble("dtp_valor")), rs.getBoolean("dtp_proibido"), true, rs.getInt("met_codigo")});
            }
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.getColunaOrdenacao());
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                this.modelo.setValueAt(true, i, 7);
            }
            Funcoes.mensagem(this, "A atualiza\u00e7\u00e3o de pre\u00e7os dos exames foi conclu\u00edda com sucesso.", 5);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean achaExame(String exame, DadosMaterial material, int metodologia) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String exameAux = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial materialAux = (DadosMaterial)this.modelo.getValueAt(i, 1);
            int metodologiaAux = (Integer)this.modelo.getValueAt(i, 8);
            if (!exameAux.equalsIgnoreCase(exame) || materialAux.getCodigo() != material.getCodigo() || metodologiaAux != metodologia) continue;
            return true;
        }
        return false;
    }

    private void limpaValores(int coluna, String textoLimpar) {
        if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o dos valores da coluna " + textoLimpar + "?", 4) == 0 && coluna < this.modelo.getColumnCount()) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                this.modelo.setValueAt("", i, coluna);
                this.modelo.setValueAt(true, i, 7);
            }
        }
    }

    private void alterarLinha(int linha) {
        if (linha > -1) {
            this.labelVlrCodigo.setText((String)this.modelo.getValueAt(linha, 0));
            this.labelVlrMaterial.setText(((DadosMaterial)this.modelo.getValueAt(linha, 1)).getAbreviatura());
            this.labelVlrExame.setText((String)this.modelo.getValueAt(linha, 2));
            this.labelVlrMetodologia.setText((String)this.modelo.getValueAt(linha, 3));
            if (Funcoes.textoVazio(this.textAMB.getText()) && this.textAMB.getValue() != null && !Funcoes.textoVazio(this.textAMB.getValue().toString())) {
                this.textAMB.setText(this.textAMB.getText());
            } else {
                this.textAMB.setText((String)this.modelo.getValueAt(linha, 4));
            }
            this.textValor.setText((String)this.modelo.getValueAt(linha, 5));
            this.linhaAlterada = linha;
            ScreenUtil.requisitarFoco(this.textAMB);
        }
    }

    private void alterarPreco() {
        int i;
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        if (this.linhaAlterada > -1) {
            linhas.add(this.linhaAlterada);
        }
        if (this.checkIgnorarMaterial.isSelected() && this.checkIgnorarMetodologia.isSelected()) {
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelVlrCodigo.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        } else if (this.checkIgnorarMaterial.isSelected()) {
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelVlrCodigo.getText()) || linhas.indexOf(i) >= 0 || !this.modelo.getValueAt(i, 3).toString().equals(this.labelVlrMetodologia.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        } else if (this.checkIgnorarMetodologia.isSelected()) {
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelVlrCodigo.getText()) || linhas.indexOf(i) >= 0 || !this.modelo.getValueAt(i, 1).toString().equals(this.labelVlrMaterial.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        }
        Iterator iterator = linhas.iterator();
        while (iterator.hasNext()) {
            int linha = (Integer)iterator.next();
            this.modelo.setValueAt(this.textAMB.getText(), linha, 4);
            if (!Funcoes.isNumeric(this.textValor.getText().replaceAll(",", "."))) {
                this.modelo.setValueAt("0,00", linha, 5);
            } else {
                this.modelo.setValueAt(Funcoes.formataDecimal(Double.parseDouble(this.textValor.getText().replaceAll(",", "."))), linha, 5);
            }
            this.modelo.setValueAt(true, linha, 7);
        }
        this.labelVlrCodigo.setText("");
        this.labelVlrMaterial.setText("");
        this.labelVlrExame.setText("");
        this.labelVlrMetodologia.setText("");
        this.textAMB.clear();
        this.textValor.clear();
        this.linhaAlterada = -1;
        this.tableExames.grabFocus();
    }

    public boolean getOK() {
        return this.ok;
    }
}

