/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.cadastro.DadosPrecoExame;
import jalis.laboratorio.cadastro.ModeloTabRendererExamesConvenio;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

class AlterarPrecosAMBConvenio
extends JDialog
implements ActionListener {
    JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonOKExame = ComponenteFactory.novoJButton("OK", this, null, null);
    ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Valor"});
    JTable tableExames = new JTable(this.modelo);
    TTextField textCodigo = new TTextField(5);
    JButton buttonBuscaExame = ComponenteFactory.novoJButton(this, true);
    JComboBox comboMaterial = new JComboBox();
    JLabel labelExame = ComponenteFactory.novoJLabel("", new Dimension(150, 20));
    TTextField textValor = new TTextField(10, 2);
    private boolean ok = false;
    private int linhaAlterada = -1;
    private int colunaOrdenada = 0;

    public static AlterarPrecosAMBConvenio novaInstancia(Object owner) {
        if (owner instanceof JFrame) {
            return new AlterarPrecosAMBConvenio((Frame)owner);
        }
        if (owner instanceof JDialog) {
            return new AlterarPrecosAMBConvenio((Dialog)owner);
        }
        return null;
    }

    public AlterarPrecosAMBConvenio(Frame owner) {
        super(owner, "Pre\u00e7os diferenciados");
        this.montaTela();
    }

    public AlterarPrecosAMBConvenio(Dialog owner) {
        super(owner, "Pre\u00e7o diferenciados");
        this.montaTela();
    }

    private void montaTela() {
        this.tableExames.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlterarPrecosAMBConvenio.this.colunaOrdenada = AlterarPrecosAMBConvenio.this.tableExames.getColumnModel().getColumnIndexAtX(e.getX());
                AlterarPrecosAMBConvenio.this.modelo.mouseClicked(e);
            }
        });
        JPanel panelCentral = new JPanel(new GridBagLayout());
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentral, "Center");
        this.setModal(true);
        this.setSize(new Dimension(568, 548));
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.labelExame}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        panelCentral.add((Component)new JLabel("C\u00f3digo"), c);
        c.gridx = 2;
        panelCentral.add((Component)new JLabel("Mat."), c);
        c.gridx = 3;
        panelCentral.add((Component)new JLabel("Exame"), c);
        c.gridx = 4;
        panelCentral.add((Component)new JLabel("Valor"), c);
        c.gridx = 5;
        panelCentral.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        this.textCodigo.setMinimumSize(new Dimension(70, 20));
        this.textCodigo.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textCodigo, c);
        c.gridx = 1;
        this.buttonBuscaExame.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaExame.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaExame.setMaximumSize(new Dimension(20, 20));
        panelCentral.add((Component)this.buttonBuscaExame, c);
        c.gridx = 2;
        this.comboMaterial.setMinimumSize(new Dimension(120, 20));
        this.comboMaterial.setPreferredSize(new Dimension(120, 20));
        panelCentral.add((Component)this.comboMaterial, c);
        c.gridx = 4;
        this.textValor.setPreferredSize(new Dimension(80, 20));
        this.textValor.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textValor, c);
        c.gridx = 5;
        this.buttonOKExame.setPreferredSize(new Dimension(40, 20));
        this.buttonOKExame.setMinimumSize(new Dimension(40, 20));
        this.buttonOKExame.setMaximumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.buttonOKExame, c);
        c.gridx = 3;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelExame.setMinimumSize(new Dimension(30, 20));
        panelCentral.add((Component)this.labelExame, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 6;
        JPanel panelBotoes = new JPanel(new GridBagLayout());
        panelCentral.add((Component)panelBotoes, c);
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tableExames), c);
        GridBagConstraints cAux = new GridBagConstraints();
        cAux.weightx = 1.0;
        cAux.fill = 2;
        cAux.gridx = 0;
        cAux.gridy = 0;
        cAux.gridwidth = 2;
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(2));
        p.add(this.buttonOK);
        p.add(this.buttonCancelar);
        p1.add((Component)p, "East");
        panelBotoes.add((Component)p1, cAux);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.modelo.setColumnSize(new int[]{70, 40, 0, 70}, this.tableExames);
        this.tableExames.setDefaultRenderer(Object.class, new ModeloTabRendererExamesConvenio(new int[]{3}));
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && AlterarPrecosAMBConvenio.this.tableExames.getSelectedColumn() < 5) {
                    AlterarPrecosAMBConvenio.this.alterarLinha(AlterarPrecosAMBConvenio.this.tableExames.getSelectedRow());
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlterarPrecosAMBConvenio.this.tableExames.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlterarPrecosAMBConvenio.this.alterarLinha(AlterarPrecosAMBConvenio.this.tableExames.getSelectedRow());
                        }
                    });
                } else if (e.getKeyCode() == 127 && Funcoes.mensagem(AlterarPrecosAMBConvenio.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    AlterarPrecosAMBConvenio.this.modelo.removeLine(AlterarPrecosAMBConvenio.this.tableExames.getSelectedRow());
                }
            }
        });
        this.textValor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosAMBConvenio.this.textValor.selectAll();
            }
        });
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JButton) && !e.isTemporary()) {
                    AlterarPrecosAMBConvenio.this.buscaDescricaoExame(null);
                }
            }
        });
        this.textCodigo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarPrecosAMBConvenio.this.pesquisaExame();
                }
            }
        });
        this.textCodigo.setUpperCase(true);
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigo);
        this.modelo.ordenarColuna(this.colunaOrdenada);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKExame) {
            this.adicionarExame();
        } else if (e.getSource() == this.buttonBuscaExame) {
            this.pesquisaExame();
        } else {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }
    }

    private void adicionarExame() {
        if (!Funcoes.textoVazio(this.textCodigo.getText()) && !this.labelExame.getText().equals("N\u00e3o cadastrado") && Funcoes.isNumeric(this.textValor.getText())) {
            int pos = this.achaExame(this.textCodigo.getText(), (DadosMaterial)this.comboMaterial.getSelectedItem());
            String valor = Funcoes.formataDecimal(this.textValor.getMaskDecimal(), Double.parseDouble(Funcoes.limpaDecimal(this.textValor.getText())));
            if (pos > -1) {
                this.modelo.setValueAt(valor, pos, 3);
            } else {
                this.modelo.addLine(new Object[]{this.textCodigo.getText(), (DadosMaterial)this.comboMaterial.getSelectedItem(), this.labelExame.getText(), valor});
            }
        }
        this.linhaAlterada = -1;
        this.controlaCampos();
        this.textCodigo.clear();
        this.comboMaterial.removeAllItems();
        this.labelExame.setText("");
        this.textValor.clear();
        this.textCodigo.grabFocus();
    }

    private void pesquisaExame() {
        this.textCodigo.clear();
        this.comboMaterial.grabFocus();
        Hashtable resultado = Pesquisas.exameAMB(this, false, true);
        if (resultado != null) {
            this.textCodigo.setText(resultado.get("exa_codigo").toString());
            int codMaterial = Integer.parseInt(resultado.get("mco_codigo").toString());
            DadosMaterial material = null;
            try {
                material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, codMaterial);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.buscaDescricaoExame(material);
            this.comboMaterial.grabFocus();
        } else {
            this.textCodigo.grabFocus();
        }
    }

    private void buscaDescricaoExame(DadosMaterial materialSelecionado) {
        block5: {
            if (!Funcoes.textoVazio(this.textCodigo.getText())) {
                try {
                    Statement st = Conexao.getStatement();
                    if (st == null) break block5;
                    ResultSet rs = Conexao.executeQuery(st, "select exa_descricao from exames where fil_codigo=" + Variaveis.filialPadrao + " and upper(exa_codigo)=upper(" + this.textCodigo.getTextDBEscape() + ")");
                    if (rs.next()) {
                        this.labelExame.setText(rs.getString("exa_descricao"));
                        ExameUtil.carregarMateriaisColeta(this.textCodigo.getText(), Variaveis.filialPadrao, this.comboMaterial, materialSelecionado, false);
                        break block5;
                    }
                    this.labelExame.setText("N\u00e3o cadastrado");
                    ScreenUtil.requisitarFoco(this.textCodigo);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AlterarPrecosAMBConvenio (5922)");
                }
            } else {
                this.labelExame.setText("");
            }
        }
    }

    private int achaExame(String exame, DadosMaterial material) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String e = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial m = (DadosMaterial)this.modelo.getValueAt(i, 1);
            if (!e.equalsIgnoreCase(exame) || m.getCodigo() != material.getCodigo()) continue;
            return i;
        }
        return -1;
    }

    private void alterarLinha(int linha) {
        if (linha > -1) {
            this.textCodigo.setText((String)this.modelo.getValueAt(linha, 0));
            DadosMaterial mat = (DadosMaterial)this.modelo.getValueAt(linha, 1);
            this.buscaDescricaoExame(mat);
            this.textValor.setText((String)this.modelo.getValueAt(linha, 3));
            this.linhaAlterada = linha;
            this.textValor.grabFocus();
        }
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.textCodigo.setEnabled(this.linhaAlterada < 0);
        this.comboMaterial.setEnabled(this.linhaAlterada < 0);
        this.buttonBuscaExame.setEnabled(this.linhaAlterada < 0);
    }

    public boolean getOK() {
        return this.ok;
    }

    public void setExames(ArrayList<DadosPrecoExame> exames) {
        this.modelo.clear();
        for (DadosPrecoExame exame : exames) {
            this.modelo.addLine(new Object[]{exame.getCodigoExame(), exame.getMaterial(), exame.getDescricaoExame(), Funcoes.formataDecimal(this.textValor.getMaskDecimal(), exame.getValor())});
        }
    }

    public ArrayList<DadosPrecoExame> getExames() {
        ArrayList<DadosPrecoExame> retorno = new ArrayList<DadosPrecoExame>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String codigo = this.modelo.getValueAt(i, 0).toString();
            String descricao = this.modelo.getValueAt(i, 2).toString();
            DadosMaterial material = (DadosMaterial)this.modelo.getValueAt(i, 1);
            double valor = Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 3).toString()));
            DadosPrecoExame exame = new DadosPrecoExame(codigo, descricao, material, valor);
            retorno.add(exame);
        }
        return retorno;
    }
}

