/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.cadastro.ModeloTabRendererExames;
import jalis.laboratorio.cadastro.SolicitarPercentual;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AlterarPrecosAMB
extends JDialog
implements ActionListener {
    JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonAlterar = ComponenteFactory.novoJButton("OK", this, null, null);
    JButton buttonLimpaAMB = ComponenteFactory.novoJButton("Limpar AMB", this, null, null);
    JButton buttonLimpaValor = ComponenteFactory.novoJButton("Limpar Valores", this, null, null);
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("Atualizar exames", 't', this);
    private JButton buttonProibirTodos = ComponenteFactory.novoJButton("Proibir todos", this);
    private JButton buttonLimparProibidos = ComponenteFactory.novoJButton("Limpar proibidos", this);
    private JButton buttonAtualizarPrecoAumentar = ComponenteFactory.novoJButton("Aumentar percentual", this);
    private JButton buttonAtualizarPrecoDiminuir = ComponenteFactory.novoJButton("Diminuir percentual", this);
    private JCheckBox checkIgnorarMaterial = ComponenteFactory.novoJCheckBox("Alterar o pre\u00e7o do exame ignorando material", 'm');
    ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "AMB", "Valor", "Proibir"});
    JTable tableExames = new JTable(this.modelo);
    JLabel labelCodigo = ComponenteFactory.novoJLabel("", new Dimension(69, 20));
    JLabel labelMaterial = ComponenteFactory.novoJLabel("", new Dimension(40, 20));
    JLabel labelExame = ComponenteFactory.novoJLabel("", new Dimension(150, 20));
    TTextField textAMB = new TTextField(14, 19);
    TTextField textValor = new TTextField(10, 2);
    TTextField textLocalizar = ComponenteFactory.novoTTextField(100, 3, new Dimension(70, 20), new Dimension(70, 20), null, null, null);
    JLabel labelLocalizar = ComponenteFactory.novoJLabel("Localizar:", 'L', null, this.textLocalizar);
    private boolean ok = false;
    private int codigoTabela = -1;
    private int linhaAlterada = -1;
    private int colunaOrdenada = 0;

    public static AlterarPrecosAMB novaInstancia(Object owner) {
        if (owner instanceof JFrame) {
            return new AlterarPrecosAMB((Frame)owner);
        }
        if (owner instanceof JDialog) {
            return new AlterarPrecosAMB((Dialog)owner);
        }
        return null;
    }

    public AlterarPrecosAMB(Frame owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public AlterarPrecosAMB(Dialog owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public void setTabela(int codigoTabela) {
        this.codigoTabela = codigoTabela;
        this.buscaDados();
    }

    public void setPrecos(ArrayList<PrecosAlterados> precos) {
        this.modelo.clear();
        for (PrecosAlterados p : precos) {
            this.modelo.addLine(new Object[]{p.getCodigoExame(), p.getMaterial(), p.getDescricaoExame(), p.getCodigoAMB(), Funcoes.formataDecimal(p.getValorCusto()), p.isProibido() ? "*" : "", p.isInserindoExame() ? "*" : ""});
        }
    }

    public ArrayList<PrecosAlterados> getPrecosAlterados() {
        ArrayList<PrecosAlterados> precos = new ArrayList<PrecosAlterados>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            boolean inserir = !Funcoes.textoVazio(this.modelo.getValueAt(i, 6).toString());
            precos.add(new PrecosAlterados(this.modelo.getValueAt(i, 0).toString(), (DadosMaterial)this.modelo.getValueAt(i, 1), this.modelo.getValueAt(i, 2).toString(), this.modelo.getValueAt(i, 3).toString(), Funcoes.isNumeric(this.modelo.getValueAt(i, 4).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 4).toString())) : 0.0, !Funcoes.textoVazio(this.modelo.getValueAt(i, 5).toString()), inserir, null, null));
        }
        return precos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDados() {
        if (this.codigoTabela == -1) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, a.dtp_proibido, a.dtp_valor, a.dtp_codamb, ");
        buf.append("b.exa_descricao from detalhetabelapreco a ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.tpe_codigo = ").append(this.codigoTabela);
        buf.append(" order by a.exa_codigo, a.mco_codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modelo.clear();
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                material.setShowAbreviatura(true);
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), DBUtil.campoNull(rs.getString("dtp_codamb")) ? "" : rs.getString("dtp_codamb"), DBUtil.campoNull(rs.getString("dtp_valor")) ? "" : Funcoes.formataDecimal(rs.getDouble("dtp_valor")), rs.getBoolean("dtp_proibido") ? "*" : "", ""});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TabelaPreco (1040)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void montaTela() {
        this.tableExames.setToolTipText("F2 - Pesquisa avan\u00e7ada");
        this.tableExames.setDefaultRenderer(Object.class, new ModeloTabRendererExames(5));
        this.tableExames.getTableHeader().setReorderingAllowed(false);
        this.tableExames.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlterarPrecosAMB.this.colunaOrdenada = AlterarPrecosAMB.this.tableExames.getColumnModel().getColumnIndexAtX(e.getX());
                AlterarPrecosAMB.this.modelo.mouseClicked(e);
            }
        });
        JPanel panelCentral = new JPanel(new GridBagLayout());
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentral, "Center");
        this.setModal(true);
        this.setSize(new Dimension(568, 548));
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.labelCodigo, this.labelMaterial, this.labelExame}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        panelCentral.add((Component)new JLabel("C\u00f3digo"), c);
        c.gridx = 1;
        panelCentral.add((Component)new JLabel("Mat."), c);
        c.gridx = 2;
        panelCentral.add((Component)new JLabel("Exame"), c);
        c.gridx = 3;
        panelCentral.add((Component)new JLabel("AMB"), c);
        c.gridx = 4;
        panelCentral.add((Component)new JLabel("Valor"), c);
        c.gridx = 5;
        panelCentral.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        this.labelCodigo.setMinimumSize(new Dimension(70, 20));
        panelCentral.add((Component)this.labelCodigo, c);
        c.gridx = 1;
        this.labelMaterial.setMinimumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.labelMaterial, c);
        c.gridx = 3;
        this.textAMB.setPreferredSize(new Dimension(120, 20));
        this.textAMB.setMinimumSize(new Dimension(120, 20));
        panelCentral.add((Component)this.textAMB, c);
        c.gridx = 4;
        this.textValor.setPreferredSize(new Dimension(80, 20));
        this.textValor.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textValor, c);
        c.gridx = 5;
        this.buttonAlterar.setPreferredSize(new Dimension(40, 20));
        this.buttonAlterar.setMinimumSize(new Dimension(40, 20));
        this.buttonAlterar.setMaximumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.buttonAlterar, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelExame.setMinimumSize(new Dimension(30, 20));
        panelCentral.add((Component)this.labelExame, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 6;
        JPanel panelLocalizar = new JPanel(new GridBagLayout());
        panelCentral.add((Component)panelLocalizar, c);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        panelLocalizar.add((Component)this.labelLocalizar, cons);
        cons.gridx = 1;
        cons.fill = 2;
        cons.weightx = 1.0;
        panelLocalizar.add((Component)this.textLocalizar, cons);
        c.gridy = 4;
        JPanel panelBotoes = new JPanel(new GridBagLayout());
        panelCentral.add((Component)panelBotoes, c);
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tableExames), c);
        GridBagConstraints cAux = new GridBagConstraints();
        cAux.weightx = 1.0;
        cAux.fill = 2;
        panelBotoes.add((Component)this.buttonAtualizar, cAux);
        cAux.gridx = 1;
        panelBotoes.add((Component)this.buttonLimpaAMB, cAux);
        cAux.gridx = 2;
        panelBotoes.add((Component)this.buttonLimpaValor, cAux);
        cAux.gridy = 1;
        cAux.gridx = 0;
        panelBotoes.add((Component)this.buttonProibirTodos, cAux);
        cAux.gridx = 1;
        panelBotoes.add((Component)this.buttonLimparProibidos, cAux);
        cAux.gridx = 2;
        panelBotoes.add((Component)this.buttonAtualizarPrecoAumentar, cAux);
        cAux.gridy = 2;
        cAux.gridx = 0;
        panelBotoes.add((Component)this.buttonAtualizarPrecoDiminuir, cAux);
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(2));
        p1.add((Component)this.checkIgnorarMaterial, "West");
        p.add(this.buttonOK);
        p.add(this.buttonCancelar);
        p1.add((Component)p, "East");
        cAux.gridy = 3;
        cAux.gridx = 0;
        cAux.gridwidth = 3;
        panelBotoes.add((Component)p1, cAux);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.modelo.setColumnSize(new int[]{70, 40, 0, 90, 70, 45}, this.tableExames);
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && AlterarPrecosAMB.this.tableExames.getSelectedColumn() < 5) {
                    AlterarPrecosAMB.this.alterarLinha(AlterarPrecosAMB.this.tableExames.getSelectedRow());
                } else if (e.getClickCount() == 2 && AlterarPrecosAMB.this.tableExames.getSelectedColumn() == 5) {
                    if (AlterarPrecosAMB.this.modelo.getValueAt(AlterarPrecosAMB.this.tableExames.getSelectedRow(), 5).toString().equals("*")) {
                        AlterarPrecosAMB.this.modelo.setValueAt("", AlterarPrecosAMB.this.tableExames.getSelectedRow(), 5);
                    } else {
                        AlterarPrecosAMB.this.modelo.setValueAt("*", AlterarPrecosAMB.this.tableExames.getSelectedRow(), 5);
                    }
                    AlterarPrecosAMB.this.modelo.setValueAt("*", AlterarPrecosAMB.this.tableExames.getSelectedRow(), 6);
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlterarPrecosAMB.this.tableExames.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlterarPrecosAMB.this.alterarLinha(AlterarPrecosAMB.this.tableExames.getSelectedRow());
                        }
                    });
                } else if (e.getKeyCode() == 113) {
                    AlterarPrecosAMB.this.pesquisaAvancada();
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarPrecosAMB.this.pesquisaAvancada();
                } else {
                    int pos = AlterarPrecosAMB.this.modelo.localizarParcial(AlterarPrecosAMB.this.colunaOrdenada, AlterarPrecosAMB.this.textLocalizar.getText() + (Funcoes.textoVazio(String.valueOf(e.getKeyChar())) ? "" : String.valueOf(e.getKeyChar())));
                    if (pos > -1) {
                        AlterarPrecosAMB.this.tableExames.setRowSelectionInterval(pos, pos);
                        AlterarPrecosAMB.this.tableExames.scrollRectToVisible(AlterarPrecosAMB.this.tableExames.getCellRect(pos, 0, true));
                    }
                }
            }
        });
        this.textValor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosAMB.this.textValor.selectAll();
            }
        });
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textAMB);
        this.modelo.ordenarColuna(this.colunaOrdenada);
    }

    private void pesquisaAvancada() {
        Hashtable resultado = Pesquisas.exameAMB(this, false, false);
        if (resultado != null) {
            String codigo = resultado.get("exa_codigo").toString();
            this.modelo.ordenarColuna(0);
            int pos = this.modelo.localizar(0, codigo);
            if (pos > -1) {
                this.tableExames.setRowSelectionInterval(pos, pos);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(pos, 0, true));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAlterar) {
            this.alterarPreco();
        } else if (e.getSource() == this.buttonLimpaAMB) {
            this.limpaValores(3, "AMB");
        } else if (e.getSource() == this.buttonLimpaValor) {
            this.limpaValores(4, "Pre\u00e7os");
        } else if (e.getSource() == this.buttonAtualizar) {
            this.atualizar();
        } else if (e.getSource() == this.buttonProibirTodos) {
            if (Funcoes.mensagem(this, "Confirma a proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    this.modelo.setValueAt("*", i, 5);
                    this.modelo.setValueAt("*", i, 6);
                }
            }
        } else if (e.getSource() == this.buttonLimparProibidos) {
            if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o da proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    if (Funcoes.textoVazio(this.modelo.getValueAt(i, 5).toString())) continue;
                    this.modelo.setValueAt("", i, 5);
                    this.modelo.setValueAt("*", i, 6);
                }
            }
        } else if (e.getSource() == this.buttonAtualizarPrecoAumentar || e.getSource() == this.buttonAtualizarPrecoDiminuir) {
            boolean isDiminuirPercentual = e.getSource() == this.buttonAtualizarPrecoDiminuir;
            SolicitarPercentual sp = SolicitarPercentual.novaInstancia(this);
            if (sp != null) {
                sp.setApenasExamesSelecionados(this.tableExames.getSelectedRowCount() > 1);
                sp.setVisible(true);
                if (sp.ok() && sp.getPercentual() > 0.0) {
                    int[] linhas = new int[this.modelo.getRowCount()];
                    if (sp.isApenasExamesSelecionados() && this.tableExames.getSelectedRowCount() > 0) {
                        linhas = this.tableExames.getSelectedRows();
                    } else {
                        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                            linhas[i] = i;
                        }
                    }
                    for (int i : linhas) {
                        if (Funcoes.textoVazio(this.modelo.getValueAt(i, 4).toString()) || !Funcoes.isNumeric(this.modelo.getValueAt(i, 4).toString())) continue;
                        Double valorAtual = Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 4).toString()));
                        BigDecimal valor = Funcoes.calculaPercentual(sp.getPercentual(), valorAtual, sp.isArredondarCentavos(), isDiminuirPercentual, 4);
                        this.modelo.setValueAt(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), valor.doubleValue()), i, 4);
                        this.modelo.setValueAt("*", i, 6);
                    }
                }
            }
        } else {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizar() {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, b.mco_codigo, a.exa_descricao from exames a ");
        buf.append("left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" order by a.exa_codigo, b.mco_codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                if (material == null) continue;
                material.setShowAbreviatura(true);
                if (this.achaExame(rs.getString("exa_codigo"), material)) continue;
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), "", "", "", "*"});
            }
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                this.modelo.setValueAt("*", i, 6);
            }
            Funcoes.mensagem(this, "A atualiza\u00e7\u00e3o de pre\u00e7os dos exames foi conclu\u00edda com sucesso.", 5);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaPreco (841)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean achaExame(String exame, DadosMaterial material) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String e = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial m = (DadosMaterial)this.modelo.getValueAt(i, 1);
            if (!e.equalsIgnoreCase(exame) || m.getCodigo() != material.getCodigo()) continue;
            return true;
        }
        return false;
    }

    private void limpaValores(int coluna, String textoLimpar) {
        if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o dos valores da coluna " + textoLimpar, 4) == 0 && coluna < this.modelo.getColumnCount()) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                this.modelo.setValueAt("", i, coluna);
                this.modelo.setValueAt("*", i, 6);
            }
        }
    }

    private void alterarLinha(int linha) {
        if (linha > -1) {
            this.labelCodigo.setText((String)this.modelo.getValueAt(linha, 0));
            this.labelMaterial.setText(((DadosMaterial)this.modelo.getValueAt(linha, 1)).getAbreviatura());
            this.labelExame.setText((String)this.modelo.getValueAt(linha, 2));
            if (Funcoes.textoVazio(this.textAMB.getText()) && this.textAMB.getValue() != null && !Funcoes.textoVazio(this.textAMB.getValue().toString())) {
                this.textAMB.setText(this.textAMB.getText());
            } else {
                this.textAMB.setText((String)this.modelo.getValueAt(linha, 3));
            }
            this.textValor.setText((String)this.modelo.getValueAt(linha, 4));
            this.linhaAlterada = linha;
            this.textAMB.grabFocus();
        }
    }

    private void alterarPreco() {
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        if (this.linhaAlterada > -1) {
            linhas.add(this.linhaAlterada);
        }
        if (this.checkIgnorarMaterial.isSelected()) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelCodigo.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        }
        Iterator iterator = linhas.iterator();
        while (iterator.hasNext()) {
            int linha = (Integer)iterator.next();
            this.modelo.setValueAt(this.textAMB.getText(), linha, 3);
            if (!Funcoes.isNumeric(this.textValor.getText().replaceAll(",", "."))) {
                this.modelo.setValueAt("0,00", linha, 4);
            } else {
                this.modelo.setValueAt(Funcoes.formataDecimal(Double.parseDouble(this.textValor.getText().replaceAll(",", "."))), linha, 4);
            }
            this.modelo.setValueAt("*", linha, 6);
        }
        this.labelCodigo.setText("");
        this.labelMaterial.setText("");
        this.labelExame.setText("");
        this.textAMB.clear();
        this.textValor.clear();
        this.linhaAlterada = -1;
        this.tableExames.grabFocus();
    }

    public boolean getOK() {
        return this.ok;
    }
}

