/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.AcaoNaoConformidadeBean;
import jalis.model.vo.cadastro.AcaoNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.AcaoNaoConformidadeService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AcaoNaoConformidade
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JCheckBox checkSolicitarDescricao = new JCheckBox("Solicitar descri\u00e7\u00e3o");
    private TTextField textCodigo = new TTextField(12, 1);
    private TTextField textDescricao = new TTextField(80, 3);
    private String retornoParaPesquisa = "";

    public AcaoNaoConformidade() {
        this.setName("AcaoNaoConformidade");
        this.setLabelDescricao("Cadastro de A\u00e7\u00e3o de N\u00e3o Conformidade");
        this.setLabelFormulario("Cadastro de a\u00e7\u00e3o de n\u00e3o conformidade");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_acaonaoconformidade.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setName("textCodigo");
        d = new Dimension(20, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.painelCentral.add((Component)this.checkSolicitarDescricao, c);
        this.checkSolicitarDescricao.setName("checkSolicitarDescricao");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        Funcoes.montaEnter((JComponent)this);
        this.service = new AcaoNaoConformidadeService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        boolean podeAtivar = this.getStatus() == 3 || this.getStatus() == 2;
        this.textDescricao.setEnabled(podeAtivar);
        this.checkSolicitarDescricao.setEnabled(podeAtivar);
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.clear();
        this.textDescricao.clear();
        this.checkSolicitarDescricao.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AcaoNaoConformidadeVO vo = (AcaoNaoConformidadeVO)this.service.pesquisaVO(Laboratorio.getInstancia(), new AcaoNaoConformidadeVO(), "Pesquisando A\u00e7\u00e3o de N\u00e3o Conformidade", false);
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("anc_codigo", vo.getCodigo());
                AcaoNaoConformidadeBean acaoBean = (AcaoNaoConformidadeBean)((AcaoNaoConformidadeService)this.service).getBean(chaves);
                return acaoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        AcaoNaoConformidadeBean bean = new AcaoNaoConformidadeBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (!Funcoes.textoVazio(this.textCodigo)) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setSolicitarDescricao(this.checkSolicitarDescricao.isSelected());
        return bean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        AcaoNaoConformidadeBean acaoBean = (AcaoNaoConformidadeBean)bean;
        this.textCodigo.setText(Integer.toString(acaoBean.getCodigo()));
        this.textDescricao.setText(acaoBean.getDescricao());
        this.checkSolicitarDescricao.setSelected(acaoBean.getSolicitarDescricao());
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaAcaoNaoConformidade();
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(AcaoNaoConformidade.getModuloAcesso());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0105000100");
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        return true;
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AcaoNaoConformidadeBean bean;
        if (this.validaCampos() && (bean = (AcaoNaoConformidadeBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "anc_codigo";
    }
}

