/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.HorarioLembrete;
import jalis.laboratorio.Laboratorio;
import jalis.mensagens.IAvisaMensagens;
import jalis.mensagens.VerificaMensagens;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class ThreadCompromisso
extends Thread {
    private boolean parar = false;
    private ArrayList<HorarioLembrete> horarios = new ArrayList();
    private static ArrayList<Integer> compromissosAvisadas = new ArrayList();
    private static ArrayList<IAvisaMensagens> listener = new ArrayList();
    private boolean mostrarAviso;

    public ThreadCompromisso(boolean mostrarAviso) {
        super("Timer compromissos");
        this.mostrarAviso = mostrarAviso;
        this.setPriority(1);
    }

    public void parar() {
        this.parar = true;
    }

    @Override
    public void run() {
        while (!this.parar && !ThreadCompromisso.interrupted()) {
            this.verificarCompromisso();
            this.notificarMensagemRecebida();
            for (HorarioLembrete h : this.horarios) {
                if (h.getData().compareTo(new Date()) > 0 || h.isLembrado()) continue;
                VerificaMensagens.mostraAlarmeCompromisso(Laboratorio.getInstancia(), h.getTitulo());
                h.setLembrado(true);
                this.alterarLembrado(h.getcodigo());
            }
            try {
                ThreadCompromisso.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterarLembrado(int codigo) {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("update usuariocompromisso set uco_lembrado = true where uco_codigo = ").append(codigo);
            Conexao.execute(Variaveis.filialPadrao, st, buf);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void verificarCompromisso() {
        if (this.mostrarAviso) {
            Statement st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select uco_codigo,uco_titulo, uco_lembrado, uco_datahora, uco_tempolembrete from usuariocompromisso where uco_lembrado = 'f' and usr_codigo = '");
                buf.append(Variaveis.login);
                buf.append("'");
                ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
                int contagem = 0;
                int tempoLembrete = 0;
                while (rs.next()) {
                    if (compromissosAvisadas.contains(rs.getInt("uco_codigo"))) continue;
                    compromissosAvisadas.add(rs.getInt("uco_codigo"));
                    ++contagem;
                    Calendar c = Calendar.getInstance();
                    c.setTime(rs.getDate("uco_datahora"));
                    c.add(12, rs.getInt("uco_tempolembrete") * -1);
                    tempoLembrete = rs.getInt("uco_tempolembrete");
                    if (tempoLembrete <= 0) continue;
                    Laboratorio.getInstancia();
                    Laboratorio.getThreadCompromisso().adicionaHorarioLembrete(c.getTime(), rs.getString("uco_titulo"), rs.getInt("uco_codigo"));
                }
                if (contagem > 0 && tempoLembrete > 0) {
                    VerificaMensagens.mostraAlarmeCompromisso(Laboratorio.getInstancia(), "Voc\u00ea tem " + contagem + " novos compromissos.");
                    this.notificarMensagemRecebida();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.mostrarAviso = true;
        }
    }

    public synchronized void adicionaHorarioLembrete(Date data, String titulo, int codigo) {
        this.horarios.add(new HorarioLembrete(data, titulo, codigo));
    }

    public synchronized void limparHorarioLembrete() {
        this.horarios.clear();
    }

    public void addAvisaMensagem(IAvisaMensagens l) {
        if (!listener.contains(l)) {
            listener.add(l);
        }
    }

    public void removeAvisaMensagem(IAvisaMensagens l) {
        listener.remove(l);
    }

    public void removeAllAvisaMensagem() {
        listener.clear();
    }

    public void notificarMensagemRecebida() {
        for (IAvisaMensagens o : listener) {
            o.novaMensagemRecebida();
        }
    }
}

