/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import jalis.comum.ConstantesGerais;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

class Splash
extends JFrame {
    Imagem imagemUnica = new Imagem();
    JLabel labelMensagens = new JLabel("Iniciando...");
    JLabel labelVersao = new JLabel("Vers\u00e3o " + ConstantesGerais.NRVERSAO);
    private boolean parado = false;
    private final int TAMANHO_LABEL = 14;
    private final int TAMANHO_BORDA = 20;

    public Splash() {
        this.carregarImagens();
        int w = this.imagemUnica.getImageIcon().getIconWidth();
        int h1 = this.imagemUnica.getImageIcon().getIconHeight();
        this.setSize(new Dimension(w, h1));
        this.setForeground(Color.BLUE);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.imagemUnica);
        this.getContentPane().add(this.labelMensagens);
        this.getContentPane().add(this.labelVersao);
        this.imagemUnica.setLocation(0, 0);
        this.imagemUnica.setSize(new Dimension(w, h1));
        this.labelMensagens.setLocation(20, this.getHeight() - 14 - 20);
        this.labelMensagens.setSize(new Dimension(this.getWidth() - 40, 14));
        this.labelMensagens.setOpaque(false);
        this.labelMensagens.setHorizontalAlignment(2);
        this.labelMensagens.setForeground(Color.WHITE);
        this.labelVersao.setLocation(20, this.getHeight() - 14 - 20);
        this.labelVersao.setSize(new Dimension(this.getWidth() - 40, 14));
        this.labelVersao.setOpaque(false);
        this.labelVersao.setHorizontalAlignment(4);
        this.labelVersao.setForeground(Color.WHITE);
        this.getContentPane().setComponentZOrder(this.imagemUnica, 2);
        this.getContentPane().setComponentZOrder(this.labelMensagens, 1);
        this.getContentPane().setComponentZOrder(this.labelVersao, 0);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(0);
    }

    public void setEstagio(int estagio, String mensagem) {
        this.labelMensagens.setText(mensagem);
        this.labelMensagens.repaint();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean terminouEstagio() {
        return this.parado;
    }

    public void pararEstagio() {
        this.parado = true;
    }

    private void carregarImagens() {
        this.imagemUnica.setImagem(ImagemUtils.carregaImagemJalis("splash/splash2020.png"));
    }

    class Imagem
    extends JComponent {
        ImageIcon imagem;

        Imagem() {
        }

        public void setImagem(ImageIcon imagem) {
            this.imagem = imagem;
            this.repaint();
        }

        public ImageIcon getImageIcon() {
            return this.imagem;
        }

        @Override
        public void paint(Graphics g) {
            if (this.imagem != null) {
                this.imagem.paintIcon(this, g, 0, 0);
            }
        }
    }

    class Animacao
    extends Thread {
        Imagem imagem;
        ImageIcon[] imgs;
        int indiceEspera;

        public Animacao(Imagem imagem, ImageIcon[] imgs, int indiceEspera) {
            super("Animacao - thread");
            this.imagem = imagem;
            this.imgs = imgs;
            this.indiceEspera = indiceEspera;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.imgs.length && !this.isInterrupted(); ++i) {
                    this.imagem.setImagem(this.imgs[i]);
                    if (i + 1 == this.indiceEspera) {
                        Animacao.sleep(700L);
                    }
                    Animacao.sleep(60L);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Laboratorio");
            }
        }
    }

    class Carregando
    extends Thread {
        Imagem imagem;
        ImageIcon[] imgs;
        int on;
        int off;
        boolean terminou;
        boolean parar;

        public Carregando(Imagem imagem, ImageIcon[] imgs, int on, int off) {
            super("Carregando imagens - Thread");
            this.terminou = false;
            this.parar = false;
            this.imagem = imagem;
            this.imgs = imgs;
            this.on = on;
            this.off = off;
        }

        public void alterar(Imagem imagem, int on, int off) {
            this.imagem = imagem;
            this.on = on;
            this.off = off;
            this.parar = false;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (this.on < this.imgs.length) {
                    if (i % 2 == 0) {
                        this.imagem.setImagem(this.imgs[this.on]);
                        Carregando.sleep(400L);
                    } else {
                        this.imagem.setImagem(this.imgs[this.off]);
                        Carregando.sleep(200L);
                        this.terminou = true;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Splash.this, e.getMessage(), e.getStackTrace(), "Laboratorio");
            }
        }

        public void parar() {
            this.parar = true;
        }

        public boolean terminou() {
            return this.terminou;
        }
    }
}

