/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.servidor.Cliente;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MudarFilial
extends JDialog
implements DisposeListener {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JTable tabela = new JTable();
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Filial"});
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonMudar = new JButton("Mudar");
    private JButton buttonFechar = new JButton("Fechar");
    private boolean ok = false;

    public MudarFilial(Frame owner) {
        try {
            if (owner instanceof Laboratorio) {
                ((Laboratorio)owner).addDisposeListener(this);
            }
            this.jbInit(owner);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace(), "MudarFilial");
        }
    }

    private void jbInit(Component owner) throws Exception {
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setSize(new Dimension(370, 400));
        this.setLocationRelativeTo(owner);
        this.add((Component)this.panelCentro, "Center");
        Funcoes.criaBarraDescricao(this.panelCentro, "Mudar filial", "Seleciona uma nova filial padr\u00e3o para o sistema", "mudar_filial.jpg");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.panelCentro.add((Component)this.scroll, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonMudar);
        this.panelBotoes.add(this.buttonFechar);
        this.buttonMudar.setMnemonic('M');
        this.buttonFechar.setMnemonic('F');
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.tabela.setModel(this.modelo);
        this.modelo.setColumnSize(new int[]{70, 0}, this.tabela);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MudarFilial.this.ok = false;
                MudarFilial.this.setVisible(false);
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MudarFilial.this.buttonMudar.doClick();
                }
            }
        });
        this.tabela.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MudarFilial.this.controlaCampos();
            }
        });
        this.buttonMudar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MudarFilial.this.ok = true;
                Laboratorio.pegaDadosFilial(MudarFilial.this.modelo.getValueAt(MudarFilial.this.tabela.getSelectedRow(), 0).toString());
                if (Cliente.getInstancia() != null) {
                    Cliente.getInstancia().logar(Variaveis.login);
                }
                MudarFilial.this.setVisible(false);
            }
        });
        Statement st = Conexao.getStatement();
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("select a.fil_codigo, b.fil_descricao, b.fil_baseweb ");
            buf.append(" from usuariofilial a join filiais_postocoleta b on a.fil_codigo = b.fil_codigo ");
            buf.append(" where usr_codigo = '").append(StringUtil.textoDB(Variaveis.login)).append("' ");
            buf.append("order by a.fil_codigo");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (!rs.next()) {
                buf.setLength(0);
                buf.append("select fil_codigo, fil_descricao, fil_baseweb ");
                buf.append(" from filiais_postocoleta order by fil_codigo");
                rs = Conexao.executeQuery(st, buf.toString());
                rs.next();
            }
            this.modelo.clear();
            do {
                this.modelo.addLine(new String[]{rs.getString("fil_codigo"), rs.getString("fil_descricao")});
            } while (rs.next());
            rs.close();
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "MudarFilial");
        }
        Conexao.fecharStatement(st);
        this.controlaCampos();
    }

    public static Long getModuloAcesso() {
        return new Long(1L);
    }

    public boolean ok() {
        return this.ok;
    }

    private void controlaCampos() {
        this.buttonMudar.setEnabled(this.tabela.getSelectedRow() >= 0);
    }
}

