/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.IntelliJTheme;
import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ConexaoAplicativo;
import jalis.comum.ConexaoEmail;
import jalis.comum.ConexaoSMS;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ConstantesGerais;
import jalis.comum.PanelUsuario;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Senha;
import jalis.comum.SolicitarBanco;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoConvenio;
import jalis.comum.informacao.InfoExame;
import jalis.comum.informacao.InfoRequisicao;
import jalis.integracao.painelsenhas.InformacaoSenha;
import jalis.integracao.painelsenhas.PainelSenhas;
import jalis.integracao.painelsenhas.SolicitarFila;
import jalis.integracao.painelsenhas.dto.FilaTotemDTO;
import jalis.integracao.painelsenhas.dto.SenhaGeradaDTO;
import jalis.integracao.servidor.ExportaIntegracao2;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.IntegracaoHospital;
import jalis.integracaohospitais.sistemas.salux.IntegracaoHospitalSalux;
import jalis.integracaohospitais.util.ErrosIntegracaoHospital;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.TimerIntegracaoHospital;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.JanelaErrosIntegracaoOperadora;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.DadosIntegracaoOperadora;
import jalis.laboratorio.DadosIntegradoraHospital;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.MenuSistema;
import jalis.laboratorio.Splash;
import jalis.laboratorio.ThreadCompromisso;
import jalis.laboratorio.ThreadHeap;
import jalis.laboratorio.configuracao.Impressoras;
import jalis.laboratorio.configuracao.LicencaEstacoes;
import jalis.laboratorio.exportacao.ids.ErrosIntegracaoIds;
import jalis.laboratorio.exportacao.thread.ExportaEmail;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.exportacao.thread.ThreadCriaHtmlWeb;
import jalis.laboratorio.exportacao.thread.ThreadCriaPdfWeb;
import jalis.laboratorio.exportacao.thread.ThreadExportaWebRequisicao;
import jalis.laboratorio.exportacao.thread.ThreadExportacaoIds;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacao;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacaoWebIntegracao;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacaoAplicativo;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacaoEmail;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacaoSms;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacaoWeb;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoIntegracaoOffline;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.lancamentos.Lancamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.recepcao.Orcamento;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.laboratorio.util.autocopia.ExportarEntreFilais;
import jalis.mensagens.VerificaMensagens;
import jalis.model.dao.integracaohospitais.salux.IntegracaoHospitalSaluxDao;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.service.configuracao.UsuarioFilialService;
import jalis.servidor.Cliente;
import jalis.servidor.ConexaoListener;
import jalis.servidor.Servidor;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.estacao.ValidaEstacao;
import jalis.util.logger.ErroParada;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class Laboratorio
extends JFrame
implements WindowListener,
ComponentListener,
MouseListener,
ActionListener {
    private static final Dimension TAMANHO_JANELA = new Dimension(1024, 696);
    static Dimension screenSize = new Dimension(0, 0);
    static Laboratorio instancia;
    static boolean perguntar;
    static JWindow preSplash;
    static VerificaMensagens verificaMensagens;
    private static Object bloqueio;
    JPanel panelCentral = new JPanel(new BorderLayout());
    JPanel panelStatus = new JPanel(new BorderLayout());
    JPanel panelIntegracaoOperadora = new JPanel(new GridBagLayout());
    JPanel panelIntegracaoHospital = new JPanel(new GridBagLayout());
    MenuSistema menu;
    JProgressBar barraHeap = new JProgressBar();
    JLabel labelUsuario = new JLabel();
    JLabel labelEstacao = new JLabel("", 0);
    JLabel labelInterface = new JLabel("");
    JLabel labelIntegracao = new JLabel("", 0);
    DadosIntegradoraHospital[] labelsIntegracaoHospital = null;
    DadosIntegracaoOperadora[] labelsIntegracoesOperadora = null;
    JLabel labelEnvioEmail = new JLabel("", 0);
    JLabel labelEnvioSMS = new JLabel("", 0);
    JLabel labelVersao = new JLabel("Vers\u00e3o: " + ConstantesGerais.NRVERSAO + "  ", 0);
    JPanel panelVersao = new JPanel(new GridBagLayout());
    JLabel labelInfoRequisicao = new JLabel(ImagemUtils.carregaImagemJalis("tray_i_requisicao.gif"));
    JLabel labelInfoExame = new JLabel(ImagemUtils.carregaImagemJalis("tray_h_exame.gif"));
    JLabel labelInfoConvenio = new JLabel(ImagemUtils.carregaImagemJalis("tray_j_convenio.gif"));
    JLabel labelTelefones = new JLabel(ImagemUtils.carregaImagemJalis("tray_agenda.gif"));
    JLabel labelOrcamento = new JLabel(ImagemUtils.carregaImagemJalis("tray_o_orcamento.gif"));
    JLabel labelLancamento = new JLabel(ImagemUtils.carregaImagemJalis("tray_o_lancamento.gif"));
    JLabel labelImpressoras = new JLabel(ImagemUtils.carregaImagemJalis("tray_I_Impressora.gif"));
    JPopupMenu menuSenha = new JPopupMenu();
    final JMenuItem itemSolicitarAtendimento = new JMenuItem("Solicitar Atendimento");
    final JMenuItem itemSolicitarFila = new JMenuItem("Solicitar Fila");
    final JMenuItem itemRepetirUltimaSenha = new JMenuItem("Repetir \u00daltima Senha");
    JLabel labelSenhaAtendimento = new JLabel(ImagemUtils.carregaImagemJalis("tray_on_senhaatendimento.gif"));
    private EventListenerList listenerList = new EventListenerList();
    private static ExportaWeb exportaWeb;
    private static ExportaWeb2 exportaWeb2;
    public static ThreadCriaPdfWeb threadCriaPdfWeb;
    private static ThreadExportaWebRequisicao threadExportaWebRequisicao;
    private static ThreadCriaHtmlWeb threadCriaHtmlWeb;
    public static ThreadInterfaceExportacao threadInterfaceExportacao;
    private static ThreadInterfaceExportacaoWebIntegracao threadInterfaceExportacaoWebIntegracao;
    private static boolean antigaWeb;
    private static ThreadExportacaoIds threadIds;
    private static ExportarEntreFilais exportaFiliais;
    private static ExportaIntegracao2 exportaIntegracao2;
    private static TimerIntegracaoHospital integracaoHospital;
    private static ErrosIntegracaoHospital errosIntegracaoHospital;
    private static ErrosIntegracaoIds errosIntegracaoIds;
    private static ExportaSMS exportaSms;
    private static ExportaEmail exportaEmail;
    private static JanelaMonitoramentoExportacaoEmail janelaMonitoramentoExportacaoEmail;
    private static JanelaMonitoramentoExportacaoSms janelaMonitoramentoExportacaoSms;
    private static JanelaMonitoramentoExportacaoWeb janelaMonitoramentoExportacaoWeb;
    private static JanelaMonitoramentoIntegracaoOffline janelaMonitoramentoExportacaoOffLine;
    private static JanelaMonitoramentoExportacaoAplicativo janelaMonitoramentoExportacaoAplicativo;
    private static ThreadHeap threadHeap;
    private static ThreadCompromisso threadCompromisso;
    private boolean interromperInfoRequisicao = false;
    public static SplashMensagem splashAtiva;
    public static boolean isSistemaFinalizando;
    private GlassPaneMensagem glassPaneMensagem = new GlassPaneMensagem();
    private static BufferedWriter log;
    public static SistemaEmissaoNFSe sistemaEmissorNFSe;

    private Laboratorio() {
        this.setName("Laboratorio");
        try {
            FlatLaf.install((LookAndFeel)IntelliJTheme.createLaf((InputStream)Laboratorio.class.getResourceAsStream("/jalis/arc-theme-orange.theme.json")));
            UIManager.put("TabbedPane.showTabSeparators", true);
            UIManager.put("ComboBox.padding", new InsetsUIResource(1, 6, 1, 2));
            UIManager.put("Table.gridColor", new Color(255, 231, 179));
            UIManager.put("Component.hideMnemonics", false);
            UIManager.put("Table.showHorizontalLines", true);
            UIManager.put("Table.showVerticalLines", true);
            UIManager.put("Panel.background", Color.WHITE);
            UIManager.put("CheckBox.background", Color.WHITE);
            if (UIManager.get("defaultFont") instanceof Font) {
                Font atual = (Font)UIManager.get("defaultFont");
                FontUIResource f = new FontUIResource(atual.deriveFont(12));
                UIManager.getDefaults().put("defaultFont", new Font(atual.getFontName(), atual.getStyle(), 13));
                UIManager.getDefaults().put("TableHeader.font", new Font(atual.getFontName(), atual.getStyle(), 11));
            }
        }
        catch (Exception ex) {
            System.err.println("N\u00e3o foi poss\u00edvel alterar a visualiza\u00e7\u00e3o do sistema");
        }
        ImageIcon icone8x8 = ImagemUtils.carregaImagemJalis("icone8x8.png");
        ImageIcon icone16x16 = ImagemUtils.carregaImagemJalis("icone16x16.png");
        ImageIcon icone32x32 = ImagemUtils.carregaImagemJalis("icone32x32.png");
        ImageIcon icone50x50 = ImagemUtils.carregaImagemJalis("icone50x50.png");
        ImageIcon icone64x64 = ImagemUtils.carregaImagemJalis("icone64x64.png");
        ImageIcon icone100x100 = ImagemUtils.carregaImagemJalis("icone100x100.png");
        ImageIcon icone128x128 = ImagemUtils.carregaImagemJalis("icone128x128.png");
        ImageIcon icone256x256 = ImagemUtils.carregaImagemJalis("icone256x256.png");
        ArrayList<Image> listaIcones = new ArrayList<Image>();
        listaIcones.add(icone8x8.getImage());
        listaIcones.add(icone16x16.getImage());
        listaIcones.add(icone32x32.getImage());
        listaIcones.add(icone50x50.getImage());
        listaIcones.add(icone64x64.getImage());
        listaIcones.add(icone100x100.getImage());
        listaIcones.add(icone128x128.getImage());
        listaIcones.add(icone256x256.getImage());
        this.setIconImages(listaIcones);
        janelaMonitoramentoExportacaoEmail = new JanelaMonitoramentoExportacaoEmail((Frame)Laboratorio.getInstancia(), 1);
        janelaMonitoramentoExportacaoSms = JanelaMonitoramentoExportacaoSms.getInstancia(Laboratorio.getInstancia(), 0);
        janelaMonitoramentoExportacaoWeb = new JanelaMonitoramentoExportacaoWeb((Frame)Laboratorio.getInstancia(), 2);
        janelaMonitoramentoExportacaoOffLine = JanelaMonitoramentoIntegracaoOffline.getInstancia(Laboratorio.getInstancia());
        janelaMonitoramentoExportacaoAplicativo = new JanelaMonitoramentoExportacaoAplicativo((Frame)Laboratorio.getInstancia(), 4);
        Funcoes.configurarHorarioVerao(ParametrosLocais.getParametro("horarioVerao") != null && ParametrosLocais.getParametro("horarioVerao").equals("1"));
        antigaWeb = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "antigaweb.jalis");
        instancia = this;
        this.panelCentral.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
        this.panelCentral.setBackground(Color.WHITE);
        this.panelCentral.setFocusable(false);
        this.setSize(TAMANHO_JANELA);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        panelAux.setPreferredSize(TAMANHO_JANELA);
        panelAux.setMinimumSize(TAMANHO_JANELA);
        this.setContentPane(panelAux);
        this.getContentPane().add((Component)this.panelCentral, "Center");
        this.getContentPane().add((Component)this.panelStatus, "South");
        this.panelStatus.setPreferredSize(new Dimension(10, 15));
        FlowLayout flow = new FlowLayout(0);
        flow.setVgap(0);
        JPanel panelTemp = new JPanel(flow);
        panelTemp.setPreferredSize(new Dimension(380, 15));
        this.barraHeap.setPreferredSize(new Dimension(60, 12));
        this.barraHeap.setMaximumSize(new Dimension(60, 12));
        this.barraHeap.setStringPainted(true);
        panelTemp.add(this.barraHeap);
        panelTemp.add(this.labelInfoRequisicao);
        panelTemp.add(this.labelInfoConvenio);
        panelTemp.add(this.labelInfoExame);
        panelTemp.add(this.labelOrcamento);
        panelTemp.add(this.labelLancamento);
        panelTemp.add(this.labelSenhaAtendimento);
        panelTemp.add(this.labelImpressoras);
        panelTemp.add(this.labelUsuario);
        this.menuSenha.add(this.itemSolicitarAtendimento);
        this.menuSenha.add(this.itemSolicitarFila);
        this.menuSenha.add(this.itemRepetirUltimaSenha);
        this.panelStatus.add((Component)panelTemp, "West");
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.gridy = 0;
        cons.gridx = 0;
        this.panelIntegracaoHospital.add((Component)this.labelEstacao, cons);
        ++cons.gridx;
        this.panelIntegracaoHospital.add((Component)this.labelIntegracao, cons);
        ++cons.gridx;
        this.panelIntegracaoHospital.add((Component)this.labelEnvioEmail, cons);
        ++cons.gridx;
        this.panelIntegracaoHospital.add((Component)this.labelEnvioSMS, cons);
        ++cons.gridx;
        this.panelIntegracaoHospital.add((Component)this.panelIntegracaoOperadora, cons);
        ++cons.gridx;
        this.panelIntegracaoHospital.add((Component)this.labelInterface, cons);
        this.panelStatus.add((Component)this.panelIntegracaoHospital, "Center");
        Laboratorio.setNomeEstacao(Variaveis.nomeEstacao);
        cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.gridy = 0;
        cons.gridx = 0;
        this.panelVersao.add((Component)this.labelVersao, cons);
        this.panelVersao.setBackground(Color.WHITE);
        this.panelStatus.add((Component)this.panelVersao, "East");
        this.panelStatus.setBackground(Color.WHITE);
        panelTemp.setBackground(this.panelStatus.getBackground());
        this.panelIntegracaoHospital.setBackground(this.panelStatus.getBackground());
        this.panelIntegracaoOperadora.setBackground(this.panelStatus.getBackground());
        this.labelTelefones.addMouseListener(this);
        this.labelInfoRequisicao.addMouseListener(this);
        this.labelInfoRequisicao.setToolTipText("Clique para visualizar informa\u00e7\u00f5es de requisi\u00e7\u00f5es");
        this.labelInfoExame.addMouseListener(this);
        this.labelInfoExame.setToolTipText("Clique para visualizar informa\u00e7\u00f5es sobre exames");
        this.labelInfoConvenio.addMouseListener(this);
        this.labelInfoConvenio.setToolTipText("Clique para visualizar informa\u00e7\u00f5es sobre conv\u00eanios");
        this.labelOrcamento.addMouseListener(this);
        this.labelOrcamento.setToolTipText("Clique para visualizar informa\u00e7\u00f5es sobre or\u00e7amentos");
        this.labelLancamento.addMouseListener(this);
        this.labelLancamento.setToolTipText("Clique para visualizar a tela de Lan\u00e7amentos");
        this.labelImpressoras.addMouseListener(this);
        this.labelImpressoras.setToolTipText("Clique para visualizar a tela de Impressoras");
        this.labelSenhaAtendimento.addMouseListener(this);
        Font fonte = new Font(this.labelUsuario.getFont().getName(), 0, 10);
        this.labelUsuario.setPreferredSize(new Dimension(180, 10));
        this.labelUsuario.setFont(fonte);
        this.barraHeap.setFont(new Font(this.labelUsuario.getFont().getName(), 0, 6));
        this.labelEstacao.setFont(fonte);
        this.labelEstacao.setHorizontalTextPosition(2);
        this.labelInterface.addMouseListener(this);
        this.labelInterface.setToolTipText("Clique para reabrir o interfaceamento");
        this.labelIntegracao.setFont(fonte);
        this.labelIntegracao.setHorizontalTextPosition(2);
        this.labelEnvioEmail.setFont(fonte);
        this.labelEnvioEmail.setHorizontalTextPosition(2);
        this.labelEnvioSMS.setFont(fonte);
        this.labelEnvioSMS.setHorizontalTextPosition(2);
        this.labelVersao.setFont(fonte);
        this.addWindowListener(this);
        this.addComponentListener(this);
        ScreenUtil.addActionMap(this.panelCentral, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Laboratorio.this.interromperInfoRequisicao) {
                    InfoRequisicao info = new InfoRequisicao((Frame)Laboratorio.this, Laboratorio.this.glassPaneMensagem);
                    info.setVisible(true);
                    if (Laboratorio.this.getRootPane() != null) {
                        Laboratorio.this.getRootPane().setGlassPane(Laboratorio.this.glassPaneMensagem);
                    }
                }
            }
        });
        ScreenUtil.addActionMap(this.panelCentral, KeyStroke.getKeyStroke(72, 2, true), "TELA_INFORMACAO_EXAME", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoExame info = new InfoExame(Laboratorio.this);
                info.setVisible(true);
            }
        });
        ScreenUtil.addActionMap(this.panelCentral, KeyStroke.getKeyStroke(74, 2, true), "TELA_INFORMACAO_CONVENIO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Acesso.getAcesso(InfoConvenio.getModuloAcesso())) {
                    InfoConvenio infoConv = new InfoConvenio(Laboratorio.this);
                    infoConv.setVisible(true);
                }
            }
        });
        ScreenUtil.addActionMap(this.panelCentral, KeyStroke.getKeyStroke(79, 2, true), "TELA_INFORMACAO_ORCAMENTO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.this.abrirOrcamento();
            }
        });
        ScreenUtil.addActionMap(this.panelCentral, KeyStroke.getKeyStroke(76, 2, true), "TELA_INFORMACAO_LANCAMENTO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.this.abrirLancamento();
            }
        });
        this.labelIntegracao.addMouseListener(new MouseAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && errosIntegracaoHospital != null) {
                    errosIntegracaoHospital;
                    if (!ErrosIntegracaoHospital.isAguardando) {
                        errosIntegracaoHospital.mostrarJanelaErrosIntegracao(Laboratorio.this, ParametrosGerais.getProtocoloIntegracaoHospital(), e.getModifiersEx() == 64);
                        return;
                    }
                }
                if (e.getClickCount() != 2) return;
                if (errosIntegracaoIds == null) return;
                errosIntegracaoIds.mostraJanela(Laboratorio.this, threadIds.getDadosErrosIntegracaIds(), false);
            }
        });
        this.labelEnvioSMS.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && exportaSms != null && exportaSms.getMonitorExportacao() != null) {
                    janelaMonitoramentoExportacaoSms.setVisible(true);
                }
            }
        });
        this.labelEnvioEmail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && exportaEmail != null && exportaEmail.podeApresentarJanelaMonitoramento() && exportaEmail.getMonitorExportacao() != null) {
                    janelaMonitoramentoExportacaoEmail.setVisible(true);
                }
            }
        });
        this.labelEstacao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (Variaveis.estacaoExportaIntegracao && Variaveis.estacaoFilialIntegracao > -1 && (ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W"))) {
                        if (exportaIntegracao2 != null && exportaIntegracao2.podeApresentarJanelaMonitoramento() && exportaIntegracao2.getMonitorExportacao() != null) {
                            janelaMonitoramentoExportacaoOffLine.setVisible(true);
                        }
                    } else if (antigaWeb && exportaWeb != null && exportaWeb.podeApresentarJanelaMonitoramento() && exportaWeb.getMonitorExportacao() != null) {
                        janelaMonitoramentoExportacaoWeb.setVisible(true);
                    } else if (!antigaWeb && exportaWeb2 != null && exportaWeb2.podeApresentarJanelaMonitoramento() && exportaWeb2.getMonitorExportacao() != null) {
                        janelaMonitoramentoExportacaoWeb.setVisible(true);
                    }
                }
            }
        });
        this.itemSolicitarAtendimento.addActionListener(action -> this.painelSenhaSolicitarAtendimento());
        this.itemSolicitarFila.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.this.painelSenhaSolicitarFila();
            }
        });
        this.itemRepetirUltimaSenha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.this.painelRepetirUltimaSenha();
            }
        });
        if (this.getRootPane() != null) {
            this.getRootPane().setGlassPane(this.glassPaneMensagem);
        }
        this.setTitle("jalis [" + Variaveis.descricaoFilialPadrao + "]");
        this.setDefaultCloseOperation(0);
    }

    private void painelSenhaSolicitarAtendimento() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            SenhaGeradaDTO senha = painelSenhas.solicitarAtendimento(false);
            if (senha == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 senhas na fila de atendimento.", 2);
                return;
            }
            Variaveis.retornoAtendimentoPainelSenhas = senha;
            InformacaoSenha infoSenha = InformacaoSenha.novaInstancia(this, senha);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
                if (infoSenha.getOK()) {
                    Variaveis.retornoAtendimentoPainelSenhas = senha;
                }
            }
        }
    }

    private void painelSenhaSolicitarFila() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Aguarde... Buscando filas de atendimento.");
            List<FilaTotemDTO> filasTotem = painelSenhas.carregarFilasPorTotem();
            if (filasTotem.isEmpty()) {
                splash.apagar();
                Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma fila de atendimemento encontrada.", 2);
                return;
            }
            splash.apagar();
            SolicitarFila infoSenha = SolicitarFila.novaInstancia(this, filasTotem);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
            }
        }
    }

    private void painelRepetirUltimaSenha() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            SenhaGeradaDTO senha = painelSenhas.solicitarAtendimento(true);
            if (senha == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 senhas na fila de atendimento.", 2);
                return;
            }
            InformacaoSenha infoSenha = InformacaoSenha.novaInstancia(this, senha);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
            }
        }
    }

    @Override
    public Component getGlassPane() {
        return this.glassPaneMensagem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void finalizaSistema(boolean isErroConexao) {
        isSistemaFinalizando = true;
        Senha.atualizarLogoutUsuario(Variaveis.login);
        SplashMensagem splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        if (exportaWeb != null) {
            exportaWeb.parar();
            splash.setFinalizada(false);
            splash.mostrar("Finalizando exporta\u00e7\u00e3o de dados para web");
            while (exportaWeb.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exportaWeb2 != null) {
            exportaWeb2.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o de dados para web");
            while (exportaWeb2.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (threadCriaPdfWeb != null && threadCriaPdfWeb.exportando()) {
            threadCriaPdfWeb.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o de PDF para web");
            while (!threadCriaPdfWeb.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (threadIds != null && threadIds.exportando()) {
            threadIds.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o para IDS");
            while (!threadIds.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (threadCriaHtmlWeb != null && threadCriaHtmlWeb.exportando()) {
            threadCriaHtmlWeb.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o de Html para web");
            while (!threadCriaHtmlWeb.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (threadInterfaceExportacao != null && threadInterfaceExportacao.exportando()) {
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o do interfaceamento");
            while (!threadInterfaceExportacao.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (threadInterfaceExportacaoWebIntegracao != null) {
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o do interfaceamento");
            while (!threadInterfaceExportacaoWebIntegracao.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exportaFiliais != null) {
            exportaFiliais.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando exporta\u00e7\u00e3o de dados para filiais");
            while (exportaFiliais.exportando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exportaIntegracao2 != null) {
            exportaIntegracao2.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando integra\u00e7\u00e3o de dados");
            while (exportaIntegracao2.isIntegrandoDados()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exportaSms != null) {
            exportaSms.setParar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando envio de SMS");
            while (exportaSms.isEnviandoSms()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exportaEmail != null) {
            exportaEmail.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando envio de e-mail");
            while (exportaEmail.isEnviandoEmail()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (integracaoHospital != null) {
            integracaoHospital.parar();
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Finalizando integra\u00e7\u00e3o com hospital");
            while (integracaoHospital.isExecutando()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (Laboratorio.instancia.labelsIntegracoesOperadora != null) {
            for (DadosIntegracaoOperadora integracao : Laboratorio.instancia.labelsIntegracoesOperadora) {
                integracao.interrompeIntegracao();
            }
        }
        splash.apagar();
        if (Variaveis.equip != null) {
            Variaveis.equip.finalizarInterfaceamento(false);
        }
        String xmlParametros = ParametrosLocais.getXML();
        Statement st = null;
        if (Conexao.getConnection() != null && Conexao.getConnected()) {
            st = Conexao.getStatement();
        }
        if (st != null && !isErroConexao) {
            try {
                if (!Funcoes.textoVazio(xmlParametros)) {
                    StringBuilder b = new StringBuilder();
                    b.append("update estacoes set est_backup='");
                    b.append(StringUtil.textoDB(xmlParametros)).append("' ");
                    b.append(", est_enderecomac =");
                    b.append(" '");
                    b.append(Laboratorio.getEnderecoMac());
                    b.append("', ");
                    b.append("est_ultimoacesso = '");
                    b.append(Funcoes.getDataHoraAtual());
                    b.append("'");
                    b.append("where est_codigo = ").append(Variaveis.codigoEstacao);
                    Conexao.execute(Variaveis.filialPadrao, st, b.toString(), true);
                }
                if (Laboratorio.getVerificaMensagens() != null) {
                    Laboratorio.getVerificaMensagens().gravarAvisadas(st);
                }
                if (!ParametrosUsuarios.salvarParametros(false)) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel salvar os par\u00e2metros de usu\u00e1rio", 1);
                }
                Conexao.arquivaSQL();
            }
            catch (SQLException sqlex) {
                try {
                    sqlex.printStackTrace();
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        boolean fechamentoOk = false;
        if (Cliente.getInstancia() != null && !isErroConexao) {
            fechamentoOk = Cliente.getInstancia().desconectar();
        }
        Conexao.shutdown();
        if (ConexaoTemporaria.conectado()) {
            ConexaoTemporaria.shutdown();
        }
        if (ConexaoEmail.conectado()) {
            ConexaoEmail.shutdown();
        }
        if (ConexaoSMS.conectado()) {
            ConexaoSMS.shutdown();
        }
        if (ConexaoAplicativo.conectado()) {
            ConexaoAplicativo.shutdown();
        }
        if (fechamentoOk) {
            ParametrosLocais.removerParametro("chaveConexaoEstacao");
        }
        ParametrosLocais.setParametro("executandoSistema", "0");
        ParametrosLocais.salvaParametros();
        System.exit(0);
    }

    public static String getEnderecoMac() {
        String nomeInterface = null;
        HashMap<String, String> mapEnderecoMac = new HashMap<String, String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                byte[] bmac = network.getHardwareAddress();
                if (bmac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < bmac.length; ++i) {
                    sb.append(String.format("%02X%s", bmac[i], i < bmac.length - 1 ? "-" : ""));
                }
                if (sb.toString().isEmpty() || sb.length() > 17 || !sb.toString().matches("^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$")) continue;
                mapEnderecoMac.put(network.getName(), sb.toString());
                if (nomeInterface != null) continue;
                nomeInterface = network.getName();
            }
        }
        catch (SocketException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter o endere\u00e7o mac da esta\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        if (nomeInterface != null) {
            return (String)mapEnderecoMac.get(nomeInterface);
        }
        return "";
    }

    public static Dimension getAreaUtil() {
        if (instancia != null) {
            Dimension dim = instancia.getSize();
            return new Dimension(dim.width - Laboratorio.instancia.menu.getPreferredSize().width, dim.height);
        }
        return new Dimension();
    }

    public static void mostrarHeapStatus(boolean ativar) {
        if (ativar) {
            threadHeap = new ThreadHeap(Laboratorio.instancia.barraHeap);
            threadHeap.start();
        } else if (threadHeap != null) {
            threadHeap.parar();
        }
        Laboratorio.instancia.barraHeap.setVisible(ativar);
        if (ativar) {
            Laboratorio.instancia.labelUsuario.setPreferredSize(new Dimension(140, Laboratorio.instancia.labelUsuario.getPreferredSize().height));
        }
    }

    public static void setNomeUsuario(String nome) {
        if (instancia != null) {
            Laboratorio.instancia.labelUsuario.setText(nome);
        }
    }

    public static void setIconeEstacao(ImageIcon icone) {
        if (instancia != null && icone != null) {
            Laboratorio.instancia.labelEstacao.setIcon(icone);
            Laboratorio.instancia.labelEstacao.repaint();
        } else if (instancia != null) {
            Laboratorio.instancia.labelEstacao.setIcon(null);
        }
    }

    public static void setIconeInterfaceamento(ImageIcon icone) {
        if (instancia != null && icone != null) {
            Laboratorio.instancia.labelInterface.setIcon(icone);
            Laboratorio.instancia.labelInterface.repaint();
        } else if (instancia != null) {
            Laboratorio.instancia.labelInterface.setIcon(null);
        }
    }

    public static void setIconInfoConvenio(boolean isVisivel) {
        if (instancia != null) {
            Laboratorio.instancia.labelInfoConvenio.setVisible(isVisivel);
        }
    }

    public static void setIconOrcamento(boolean isVisivel) {
        if (instancia != null) {
            Laboratorio.instancia.labelOrcamento.setVisible(isVisivel);
        }
    }

    public static void setIconLancamento(boolean isVisivel) {
        if (instancia != null) {
            Laboratorio.instancia.labelLancamento.setVisible(isVisivel);
        }
    }

    public static void setIconeSenhaAtendimento(boolean isVisibel) {
        if (instancia != null) {
            Laboratorio.instancia.labelSenhaAtendimento.setVisible(isVisibel);
        }
    }

    public static void setIconImpressora(boolean isVisivel) {
        if (instancia != null) {
            Laboratorio.instancia.labelImpressoras.setVisible(isVisivel);
        }
    }

    public static void setIconeIntegracaoHospital(ImageIcon icone) {
        if (instancia != null && icone != null) {
            Laboratorio.instancia.labelIntegracao.setIcon(icone);
            Laboratorio.instancia.labelIntegracao.repaint();
        } else if (instancia != null) {
            Laboratorio.instancia.labelIntegracao.setIcon(null);
        }
    }

    public static void setIconeIntegracaoOperadora(AbstractIntegracaoOperadora integracao, ImageIcon icone) {
        if (instancia != null && integracao != null) {
            for (DadosIntegracaoOperadora labelIntegracaoOperadora : Laboratorio.instancia.labelsIntegracoesOperadora) {
                if (labelIntegracaoOperadora == null || !labelIntegracaoOperadora.getIntegracaoOperadora().equals(integracao)) continue;
                labelIntegracaoOperadora.setIcon(icone);
                labelIntegracaoOperadora.repaint();
            }
        }
    }

    private void instanciaIntegracoesOperadoras() {
        int n;
        ArrayList<AbstractIntegracaoOperadora> listaIntegracoes = this.getIntegracoesOperadoras();
        if (listaIntegracoes != null && !listaIntegracoes.isEmpty()) {
            Laboratorio.instancia.labelsIntegracoesOperadora = new DadosIntegracaoOperadora[listaIntegracoes.size()];
        }
        if (listaIntegracoes != null) {
            for (int i = 0; i < listaIntegracoes.size(); ++i) {
                Laboratorio.instancia.labelsIntegracoesOperadora[i] = new DadosIntegracaoOperadora(listaIntegracoes.get(i));
            }
        }
        if (Laboratorio.instancia.labelsIntegracoesOperadora != null) {
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.fill = 0;
            cons.gridheight = 1;
            cons.gridwidth = 1;
            cons.gridx = 0;
            cons.gridy = 0;
            cons.insets = new Insets(0, 0, 0, 0);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            DadosIntegracaoOperadora[] dadosIntegracaoOperadoraArray = Laboratorio.instancia.labelsIntegracoesOperadora;
            n = dadosIntegracaoOperadoraArray.length;
            for (int i = 0; i < n; ++i) {
                DadosIntegracaoOperadora labelIntegracaoOperadora = dadosIntegracaoOperadoraArray[i];
                Laboratorio.instancia.panelIntegracaoOperadora.add((Component)labelIntegracaoOperadora, cons);
                ++cons.gridx;
            }
        }
        if (this.labelsIntegracoesOperadora != null) {
            DadosIntegracaoOperadora[] dadosIntegracaoOperadoraArray = this.labelsIntegracoesOperadora;
            int n2 = dadosIntegracaoOperadoraArray.length;
            for (n = 0; n < n2; ++n) {
                DadosIntegracaoOperadora labelIntegracaoOperadora;
                final DadosIntegracaoOperadora aux = labelIntegracaoOperadora = dadosIntegracaoOperadoraArray[n];
                aux.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2 && aux.getIntegracaoOperadora().getErros() != null && aux.getIntegracaoOperadora().getErros().haErros()) {
                            JanelaErrosIntegracaoOperadora janelaErros = new JanelaErrosIntegracaoOperadora((Frame)Laboratorio.this, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloDescricao(aux.getIntegracaoOperadora().getNomeIntegracaoOperadora()), aux.getIntegracaoOperadora().getErros(), e.getModifiersEx() == 64);
                            janelaErros.setVisible(true);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AbstractIntegracaoOperadora> getIntegracoesOperadoras() {
        ArrayList<AbstractIntegracaoOperadora> arrayList;
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,con_tipointegracaooperadora as tipoIntegracao ");
        buf.append("       ,con_integracaooperadora as xmlConfiguracao ");
        buf.append("  from convenios ");
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and NULLIF(TRIM(con_tipointegracaooperadora), '') IS NOT NULL ");
        buf.append("   and NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL ");
        boolean simularEstacao = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrp.jalis");
        if (!simularEstacao) {
            buf.append("   and con_integracaooperadora ilike '%<").append("estacao").append(">").append(Variaveis.codigoEstacao).append("</").append("estacao").append(">%' ");
        }
        boolean usaConvenio = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrpConvenio.jalis");
        String convenio = "";
        try {
            String x;
            if (usaConvenio && !Funcoes.textoVazio(x = StringUtil.lerArquivoTexto(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrpConvenio.jalis"))) {
                convenio = " and con_codigo in(" + x + ") ";
            }
        }
        catch (Exception e) {
            System.out.println("N\u00e3o foi poss\u00edvel verificar a configura\u00e7\u00e3o no arquivo");
        }
        if (usaConvenio && !Funcoes.textoVazio(convenio)) {
            buf.append(convenio);
        }
        buf.append(" order by fil_codigo, con_codigo ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            ArrayList<AbstractIntegracaoOperadora> listaIntegracoes = new ArrayList<AbstractIntegracaoOperadora>();
            while (rs.next()) {
                listaIntegracoes.add(FabricaIntegracaoOperadora.novaIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(rs.getString("tipoIntegracao")), rs.getString("xmlConfiguracao"), rs.getInt("codigoConvenio")));
            }
            arrayList = listaIntegracoes;
        }
        catch (SQLException e) {
            ArrayList<AbstractIntegracaoOperadora> arrayList2;
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as integra\u00e7oes com operadoras de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return arrayList2;
        }
        Conexao.fecharStatement(st);
        return arrayList;
    }

    public static void setIconeEnvioEmail(ImageIcon icone) {
        if (instancia != null && icone != null) {
            Laboratorio.instancia.labelEnvioEmail.setIcon(icone);
            Laboratorio.instancia.labelEnvioEmail.repaint();
        } else if (instancia != null) {
            Laboratorio.instancia.labelEnvioEmail.setIcon(null);
        }
    }

    public static void setIconeEnvioSMS(ImageIcon icone) {
        if (instancia != null && icone != null) {
            Laboratorio.instancia.labelEnvioSMS.setIcon(icone);
            Laboratorio.instancia.labelEnvioSMS.repaint();
        } else if (instancia != null) {
            Laboratorio.instancia.labelEnvioSMS.setIcon(null);
        }
    }

    public static void setHintEstacao(String hint) {
        if (instancia != null && hint != null) {
            Laboratorio.instancia.labelEstacao.setToolTipText(hint);
        } else if (instancia != null) {
            Laboratorio.instancia.labelEstacao.setToolTipText(null);
        }
    }

    public static void setHintIntegracaoHospital(String hint) {
        if (instancia != null && hint != null) {
            Laboratorio.instancia.labelIntegracao.setToolTipText(hint);
        } else if (instancia != null) {
            Laboratorio.instancia.labelIntegracao.setToolTipText(null);
        }
    }

    public static void setHintIntegracaoOperadora(AbstractIntegracaoOperadora integracao, String hint) {
        if (instancia != null && integracao != null) {
            for (DadosIntegracaoOperadora labelIntegracaoOperadora : Laboratorio.instancia.labelsIntegracoesOperadora) {
                if (!labelIntegracaoOperadora.getIntegracaoOperadora().equals(integracao)) continue;
                labelIntegracaoOperadora.setToolTipText(hint);
            }
        }
    }

    public static void setHintEnvioEmail(String hint) {
        if (instancia != null && hint != null) {
            Laboratorio.instancia.labelEnvioEmail.setToolTipText(hint);
        } else if (instancia != null) {
            Laboratorio.instancia.labelEnvioEmail.setToolTipText(null);
        }
    }

    public static void setHintEnvioSMS(String hint) {
        if (instancia != null && hint != null) {
            Laboratorio.instancia.labelEnvioSMS.setToolTipText(hint);
        } else if (instancia != null) {
            Laboratorio.instancia.labelEnvioSMS.setToolTipText(null);
        }
    }

    public static void setNomeEstacao(String nome) {
        if (instancia != null) {
            Laboratorio.instancia.labelEstacao.setText("Esta\u00e7\u00e3o: " + nome + " [" + Variaveis.codigoEstacao + "]");
        }
    }

    public static void filialAlterada() {
        if (instancia != null) {
            instancia.setTitle("jalis [" + Variaveis.descricaoFilialPadrao + "]");
            Laboratorio.instancia.menu.setTipoFilial(Variaveis.tipoFilialPadrao);
        }
    }

    public static Laboratorio getInstancia() {
        return instancia;
    }

    public static ThreadCompromisso getThreadCompromisso() {
        return threadCompromisso;
    }

    public static void escreverLog(String mensagem) {
        try {
            if (log == null) {
                log = new BufferedWriter(new FileWriter(System.getProperty("user.home") + "/logInicializacao.jalis", true));
            }
            if (log != null) {
                log.write(mensagem + "\n");
                log.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void finalizarLog() {
        if (log != null) {
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void verificarParametroParaLog(String mensagem) {
        if (ParametrosLocais.isTrue("criarLogInicializacao")) {
            Laboratorio.escreverLog(Funcoes.formataData("dd/MM/yy HH:mm", new Date()) + ">>" + mensagem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ErrorLogger.setMostrarMensagemErro(true);
        System.setProperty("Djava.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("swing.legacySortingFTPEnabled", "false");
        try {
            Class.forName("br.com.thread.openpdf.text.pdf.PdfGraphics2D");
            Variaveis.openPdfCorreto = true;
        }
        catch (ClassNotFoundException e1) {
            Variaveis.openPdfCorreto = false;
            Funcoes.mensagem(null, "Biblioteca impressao-pdf n\u00e3o encontrada.", 1);
            System.exit(0);
        }
        try {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = bloqueio;
        synchronized (object) {
            String valor;
            int posSistemaNFSe;
            int posPorta;
            int posDb;
            block43: {
                Object temp;
                Laboratorio.mostrarPreSplash("Iniciando sistema Jalis");
                int posPorperties = Funcoes.procuraArg(args, "-properties");
                if (posPorperties > -1 && args.length >= posPorperties + 1) {
                    temp = args[posPorperties + 1];
                    if (((String)temp).endsWith(System.getProperty("file.separator"))) {
                        temp = ((String)temp).substring(0, ((String)temp).length() - 1);
                    }
                    Variaveis.caminhoProperties = temp;
                }
                try {
                    temp = Class.forName("gnu.io.CommDriver");
                }
                catch (ClassNotFoundException e1) {
                    if (!e1.getMessage().equalsIgnoreCase("gnu.io.CommDriver")) break block43;
                    String modem_sms = ParametrosLocais.getParametro("modemSms");
                    String xml_interfaceamento = ParametrosLocais.getParametro("xml_interfaceamento");
                    if ((Funcoes.textoVazio(modem_sms) || modem_sms.equalsIgnoreCase("Sem modem") || modem_sms.equalsIgnoreCase("Biblioteca n\u00e3o configurada")) && Funcoes.textoVazio(xml_interfaceamento)) break block43;
                    Funcoes.mensagem(null, "Biblioteca RXTXcomm.jar n\u00e3o encontrada", 1);
                }
            }
            Laboratorio.verificarParametroParaLog("Iniciando sistema Jalis");
            int estagio = 0;
            Splash splash = new Splash();
            splash.setLocation(ScreenUtil.getCentralizado(new Rectangle(0, 0, Laboratorio.screenSize.width, Laboratorio.screenSize.height), splash.getSize()));
            splash.setEstagio(estagio++, "Inicializando...");
            Laboratorio.verificarParametroParaLog("Inicializando...");
            splash.setLocationRelativeTo(null);
            splash.setVisible(true);
            Laboratorio.verificarParametroParaLog("Finalizando presplash");
            Laboratorio.fecharPreSplash();
            Laboratorio.verificarParametroParaLog("Iniciando instancia do laboratorio");
            Laboratorio.instanciarLaboratorio();
            Laboratorio.verificarParametroParaLog("Criacao da instancia finalizada, verificando bibliotecas");
            splash.setEstagio(estagio++, "Verificando bibliotecas...");
            if (!Funcoes.textoVazio(ParametrosLocais.getParametro("jmfPath")) && Funcoes.diretorioExiste(ParametrosLocais.getParametro("jmfPath"))) {
                Laboratorio.verificarParametroParaLog("Adicionando path do jmf");
                StringBuilder bui = new StringBuilder(System.getProperty("java.class.path"));
                bui.append(System.getProperty("path.separator"));
                bui.append(ParametrosLocais.getParametro("jmfPath"));
                System.setProperty("java.class.path", bui.toString());
            }
            System.setProperty("deployment.security.mixcode", "DISABLE");
            splash.setEstagio(estagio++, "Recuperando par\u00e2metros de configura\u00e7\u00e3o local...");
            Laboratorio.verificarParametroParaLog("Recuperando parametros locais");
            String banco = ParametrosLocais.getParametro("caminhoBanco");
            if (banco == null) {
                SolicitarBanco sb = new SolicitarBanco();
                sb.setLocationRelativeTo(instancia);
                sb.setVisible(true);
                banco = sb.getPath();
                ParametrosLocais.setParametro("caminhoBanco", banco);
                if (!ParametrosLocais.salvaParametros()) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel salvar os par\u00e2metros", 1);
                    Laboratorio.verificarParametroParaLog("N\u00e3o foi poss\u00edvel salvar os parametros");
                }
            }
            splash.pararEstagio();
            while (!splash.terminouEstagio()) {
            }
            splash.setEstagio(estagio++, "Conectando ao banco de dados...");
            Laboratorio.verificarParametroParaLog("Conectando ao banco de dados (" + banco + ")");
            Variaveis.caminhoBanco = "jdbc:postgresql://" + banco + "/jalis";
            Variaveis.ipBanco = banco;
            int posIp = Funcoes.procuraArg(args, "-ip");
            if (posIp > -1 && args.length >= posIp + 1) {
                Variaveis.ipBanco = args[posIp + 1];
                Variaveis.caminhoBanco = "jdbc:postgresql://" + args[posIp + 1] + "/jalis";
            }
            if ((posDb = Funcoes.procuraArg(args, "-db")) > -1 && args.length >= posDb + 1 && !Funcoes.textoVazio(args[posDb + 1])) {
                Variaveis.caminhoBanco = "jdbc:postgresql://" + Variaveis.ipBanco + "/" + args[posDb + 1];
            }
            if ((posPorta = Funcoes.procuraArg(args, "-porta")) > -1 && args.length >= posPorta + 1 && !Funcoes.textoVazio(args[posPorta + 1]) && Funcoes.isNumeric(args[posPorta + 1])) {
                Servidor.setPorta(Integer.parseInt(args[posPorta + 1]));
            }
            if ((posSistemaNFSe = Funcoes.procuraArg(args, "-sistemanfse")) > -1 && args.length >= posSistemaNFSe + 1 && !Funcoes.textoVazio(args[posSistemaNFSe + 1]) && (valor = args[posSistemaNFSe + 1]).toLowerCase().equalsIgnoreCase(SistemaEmissaoNFSe.NEOGRID.toString())) {
                sistemaEmissorNFSe = SistemaEmissaoNFSe.NEOGRID;
            }
            if (!Conexao.getConnected()) {
                System.out.println(Conexao.getUltimoErro());
                Laboratorio.verificarParametroParaLog("N\u00e3o foi poss\u00edvel conetar ao banco de dados (" + Conexao.getUltimoErro() + ")");
                StringBuilder msg = new StringBuilder("N\u00e3o foi poss\u00edvel conectar ao banco de dados");
                if (!(args.length <= 0 || Funcoes.textoVazio(args[posDb + 1]) || args[posDb + 1].equalsIgnoreCase("-db") || args[posDb + 1].equalsIgnoreCase("-ip"))) {
                    msg.append(" \"" + args[posDb + 1] + "\"");
                } else {
                    msg.append(" \"" + "/jalis".replaceAll("/", "") + "\"");
                }
                if (args.length > 0 && !Funcoes.textoVazio(args[posPorta + 1]) && Funcoes.isNumeric(args[posPorta + 1])) {
                    msg.append(" na porta \"" + args[posPorta + 1] + "\"");
                }
                msg.append(".\nDetalhe:" + Conexao.getUltimoErro());
                Laboratorio.notificarErro(msg.toString(), false, false);
            }
            splash.pararEstagio();
            if (Funcoes.procuraArg(args, "-s") > -1) {
                LicencaEstacoes licenca = new LicencaEstacoes(null);
                licenca.setVisible(true);
            }
            splash.setEstagio(estagio++, "Carregando par\u00e2metros gerais...");
            Laboratorio.verificarParametroParaLog("Carregando parametros gerais");
            if (!ParametrosGerais.carregaParametros()) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel carregar os par\u00e2metros gerais do sistema", 1);
                Laboratorio.verificarParametroParaLog("N\u00e3o foi poss\u00edvel carregar os parametros gerais");
            }
            if (ParametrosGerais.getCodigoCliente() == 0L || ParametrosGerais.getCodigoCliente() <= 0L) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O c\u00f3digo de licen\u00e7as \u00e9 inv\u00e1lido, solicite um novo c\u00f3digo atrav\u00e9s do suporte do sistema \nO sistema ser\u00e1 fechado ", 1);
                System.exit(0);
            }
            while (!splash.terminouEstagio()) {
            }
            splash.setEstagio(estagio++, "Validando esta\u00e7\u00e3o...");
            Laboratorio.verificarParametroParaLog("Iniciando validacao da estacao");
            if (!ValidaEstacao.validaEstacao(Laboratorio.getInstancia(), log)) {
                Laboratorio.notificarErro("N\u00e3o foi poss\u00edvel validar a esta\u00e7\u00e3o.", false, false);
                Laboratorio.verificarParametroParaLog("N\u00e3o foi poss\u00edvel validar a estacao");
            }
            Cliente cli = Cliente.getInstancia();
            cli.addLoginListener(new ConexaoListener(){

                @Override
                public void usuarioLogadoEmOutraEstacao(List<String> estacoes) {
                    Laboratorio.notificarUsuarioLogado(estacoes);
                }

                @Override
                public void erroAoRevalidarEstacao() {
                    Laboratorio.notificarErro("N\u00e3o foi poss\u00edvel revalidar esta\u00e7\u00e3o.", instancia != null, false);
                }

                @Override
                public void erroAoRestabelecerConexao() {
                    Laboratorio.notificarErro("N\u00e3o foi poss\u00edvel restabelecer conex\u00e3o.", instancia != null, true);
                }
            });
            String chave = null;
            Laboratorio.verificarParametroParaLog("Validando chave da estacao");
            if (ParametrosLocais.getParametro("chaveConexaoEstacao") != null && !Funcoes.textoVazio(ParametrosLocais.getParametro("chaveConexaoEstacao"))) {
                chave = ParametrosLocais.getParametro("chaveConexaoEstacao");
            }
            Laboratorio.verificarParametroParaLog("Enviando codigo de validacao");
            boolean validou = cli.validar(Variaveis.codigoEstacao, Variaveis.nomeEstacao, Variaveis.ipBanco, chave);
            Laboratorio.verificarParametroParaLog("Estacao validada");
            if (!validou) {
                Laboratorio.verificarParametroParaLog("N\u00e3o foi poss\u00edvel validar a estacao");
                Laboratorio.notificarErro(cli.getErroValidacao(), instancia != null, false);
            } else {
                ParametrosLocais.setParametro("chaveConexaoEstacao", cli.getChaveEstacao());
                Laboratorio.verificarParametroParaLog("Gravando parametros de validacao");
                ParametrosLocais.salvaParametros();
                Laboratorio.verificarParametroParaLog("Parametros gravados com sucesso pela validacao");
            }
            Laboratorio.verificarParametroParaLog("Finalizando splash");
            splash.pararEstagio();
            if (!Funcoes.temImpressoraPadraoConfigurada()) {
                Laboratorio.notificarErro("O sistema n\u00e3o pode localizar nenhuma impressora como padr\u00e3o.\nVerifique a configura\u00e7\u00e3o de impressoras e adicione uma impressora como padr\u00e3o.", false, false);
            }
            while (!splash.terminouEstagio()) {
            }
            splash.setEstagio(estagio++, "Verificando filial padr\u00e3o...");
            Laboratorio.verificarParametroParaLog("Buscando dados da filial padrao");
            if (Funcoes.textoVazio(Variaveis.filialPadrao)) {
                Variaveis.filialPadrao = ParametrosLocais.getParametro("filialPadrao");
                Variaveis.descricaoFilialPadrao = "filial n\u00e3o encontrada";
            }
            splash.setEstagio(estagio++, "Criando menu...");
            Laboratorio.verificarParametroParaLog("Criando menu");
            if (instancia == null) {
                int contador = 1;
                boolean continuar = true;
                while (continuar) {
                    try {
                        Thread.sleep(100L);
                        boolean bl = continuar = instancia == null;
                        if (++contador <= 100) continue;
                        Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel iniciar o menu do sistema (tempo excedido)", 1);
                        System.out.println("N\u00e3o foi poss\u00edvel iniciar o menu do sistema (tempo excedido)");
                        Laboratorio.finalizaSistema(false);
                        break;
                    }
                    catch (InterruptedException e) {
                        continuar = false;
                        e.printStackTrace();
                    }
                }
            }
            Laboratorio.instancia.menu = new MenuSistema(Laboratorio.instancia.panelCentral);
            instancia.getContentPane().add((Component)Laboratorio.instancia.menu, "East");
            Laboratorio.instancia.menu.setPreferredSize(new Dimension(130, 10));
            splash.setEstagio(estagio++, "Iniciando login...");
            Laboratorio.verificarParametroParaLog("Iniciando login");
            if (!Laboratorio.login()) {
                Laboratorio.finalizaSistema(false);
            }
            splash.pararEstagio();
            while (!splash.terminouEstagio()) {
            }
            splash.setEstagio(estagio++, "Carregando par\u00e2metros do usu\u00e1rio...");
            Laboratorio.verificarParametroParaLog("Carregando parametros do usuario");
            if (!ParametrosUsuarios.carregarParametros()) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel carregar os par\u00e2metros de usu\u00e1rio", 1);
                Laboratorio.verificarParametroParaLog("N\u00e3o foi poss\u00edvel carregar os parametros do usuario");
            }
            Laboratorio.verificarParametroParaLog("Iniciando verificador de mensagens");
            verificaMensagens = new VerificaMensagens(instancia);
            verificaMensagens.start();
            threadCompromisso = new ThreadCompromisso(false);
            threadCompromisso.start();
            splash.pararEstagio();
            while (!splash.terminouEstagio()) {
            }
            splash.setEstagio(estagio++, "Finalizando...");
            Laboratorio.verificarParametroParaLog("Lendo dados da filial");
            Laboratorio.pegaDadosFilial(Variaveis.filialPadrao);
            Laboratorio.verificarParametroParaLog("Carregando xml de interfaceamento");
            Variaveis.equipamentos = ConfiguracaoSerial.loadConfiguracoes(ParametrosLocais.getParametro("xml_interfaceamento"));
            splash.pararEstagio();
            while (!splash.terminouEstagio()) {
            }
            splash.dispose();
            Funcoes.atualizaDataHoraComServidor();
            Laboratorio.mostrarPreSplash("Abrindo sistema Jalis");
            Laboratorio.verificarParametroParaLog("Abrindo jalis");
            Laboratorio.avisaContaCaixaPadrao();
            Laboratorio.finalizarLog();
        }
    }

    private static boolean diferenciaMaiorQue5(int dif) {
        return dif > 5;
    }

    private static boolean compararData(Date d, Date atual) {
        return d.compareTo(atual) > 0;
    }

    private static void instanciarLaboratorio() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    new Laboratorio();
                    Object object = bloqueio;
                    synchronized (object) {
                        instancia.verificaThreadExportacao();
                        if (ParametrosLocais.getParametro("executandoSistema") != null && ParametrosLocais.getParametro("executandoSistema").equals("1") && ParametrosGerais.getApresentarErroParada()) {
                            Laboratorio.fecharPreSplash();
                            ErroParada.mostraMensagem(instancia);
                        }
                        ParametrosLocais.setParametro("executandoSistema", "1");
                        ParametrosLocais.salvaParametros();
                        PanelUsuario p = new PanelUsuario(Variaveis.login, verificaMensagens);
                        Laboratorio.instancia.panelCentral.add((Component)p, "Center");
                        Laboratorio.instancia.menu.validarAcessos();
                        Laboratorio.setNomeUsuario("  Usu\u00e1rio: " + Variaveis.login);
                        Laboratorio.setNomeEstacao(Variaveis.nomeEstacao);
                        Laboratorio.filialAlterada();
                        Laboratorio.mostrarHeapStatus(ParametrosLocais.getParametro("apresentarHeapStatus") != null && ParametrosLocais.getParametro("apresentarHeapStatus").equalsIgnoreCase("1"));
                        if (ParametrosGerais.getCodigoCliente() > 0L && ParametrosGerais.getCodigoCliente() < 100L) {
                            StringBuilder bui = new StringBuilder();
                            bui.append("Vers\u00e3o de demonstra\u00e7\u00e3o ativada em ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
                            bui.append("\nUsu\u00e1rio em uso: ").append(Variaveis.login);
                            bui.append("\nC\u00f3digo cliente: ").append(ParametrosGerais.getCodigoCliente());
                            bui.append("\nVers\u00e3o Jalis: ").append(ConstantesGerais.NRVERSAO);
                            bui.append("\n\nSistema operacional: ").append(System.getProperty("os.name"));
                            bui.append("\nUsu\u00e1rio SO: ").append(System.getProperty("user.name"));
                            bui.append("\nVers\u00e3o Java: ").append(System.getProperty("java.vm.version"));
                            ErrorLogger.enviarEmail("comercial@lode.com.br", bui.toString(), "Vers\u00e3o de demonstra\u00e7\u00e3o em uso");
                        }
                        if (ParametrosGerais.getProtocoloIntegracaoHospital() != ProtocoloIntegracaoHospital.NENHUM) {
                            instancia.verificaThreadIntegracaoHospital();
                        }
                        instancia.instanciaIntegracoesOperadoras();
                        instancia.pack();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                instancia.setLocationRelativeTo(null);
                                instancia.setVisible(true);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Laboratorio");
                }
            }
        }.start();
    }

    protected void instanciaIntegracaoSalux() {
        IntegracaoHospitalSaluxDao dao = new IntegracaoHospitalSaluxDao();
        try {
            List<Registro> listaIntegracoes = dao.buscaDadosConvenio(Variaveis.filialPadrao);
            Laboratorio.instancia.labelsIntegracaoHospital = new DadosIntegradoraHospital[listaIntegracoes.size()];
            Integer i = 0;
            for (Registro registro : listaIntegracoes) {
                IntegracaoHospital integracao = FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), registro.getString("con_integracaohospital"));
                ((IntegracaoHospitalSalux)integracao).setCodigoConvenio(registro.getString("codigoconvenio"));
                Laboratorio.instancia.labelsIntegracaoHospital[i.intValue()] = new DadosIntegradoraHospital(integracao, registro);
                String url = ((IntegracaoHospitalSalux)integracao).getWebService();
                String login = ((IntegracaoHospitalSalux)integracao).getLogin();
                String senha = ((IntegracaoHospitalSalux)integracao).getSenha();
                errosIntegracaoHospital = new ErrosIntegracaoHospital();
                integracaoHospital = new TimerIntegracaoHospital("1", integracao, errosIntegracaoHospital, url, login, senha);
                Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            if (Laboratorio.instancia.labelsIntegracaoHospital != null) {
                GridBagConstraints cons = new GridBagConstraints();
                cons.anchor = 17;
                cons.fill = 0;
                cons.gridheight = 1;
                cons.gridwidth = 1;
                cons.gridx = 1;
                cons.gridy = 0;
                cons.insets = new Insets(0, 0, 0, 0);
                cons.weightx = 0.0;
                cons.weighty = 0.0;
                for (DadosIntegradoraHospital labelIntegracaoHospital : Laboratorio.instancia.labelsIntegracaoHospital) {
                    Laboratorio.instancia.panelIntegracaoHospital.add((Component)labelIntegracaoHospital, cons);
                    ++cons.gridx;
                }
            }
            if (this.labelsIntegracaoHospital != null) {
                DadosIntegradoraHospital[] dadosIntegradoraHospitalArray = this.labelsIntegracaoHospital;
                int n = dadosIntegradoraHospitalArray.length;
                for (int j = 0; j < n; ++j) {
                    DadosIntegradoraHospital labelIntegracaoHospital;
                    DadosIntegradoraHospital dadosIntegradoraHospital = labelIntegracaoHospital = dadosIntegradoraHospitalArray[j];
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "Laboratorio (528)");
        }
    }

    public static VerificaMensagens getVerificaMensagens() {
        return verificaMensagens;
    }

    private static void avisaContaCaixaPadrao() {
        int contaCaixa = ParametrosGerais.getContaCaixa();
        if (ParametrosLocais.getParametro("contaCaixa") != null && Funcoes.isNumeric(ParametrosLocais.getParametro("contaCaixa"))) {
            contaCaixa = Integer.parseInt(ParametrosLocais.getParametro("contaCaixa"));
        }
        Statement st = Conexao.getStatement();
        try {
            if (Funcoes.isNumeric(Variaveis.filialPadrao) && FinanceiroUtil.contaInativa(st, Variaveis.filialPadrao, String.valueOf(contaCaixa))) {
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "A conta caixa padr\u00e3o da esta\u00e7\u00e3o esta inativa, entre em contato com o Administrador");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "Laboratorio (528)");
        }
    }

    public static void pegaDadosFilial(String codigo) {
        Statement st = Conexao.getStatement();
        FilialService filialService = new FilialService();
        try {
            FilialVOAux filialVO = filialService.buscaFilial(codigo);
            if (Funcoes.carregouVO(filialVO)) {
                Variaveis.filialPadrao = String.valueOf(filialVO.getCodigo());
                Variaveis.descricaoFilialPadrao = filialVO.getDescricao();
                Variaveis.integrarDadosEntreFiliais = filialVO.isIntegrar();
                Variaveis.codigoBaseWeb = ExportaWeb.getCodigoBaseWeb(st, codigo);
                Variaveis.tipoFilialPadrao = filialVO.getTipoBase();
                Variaveis.exportarWebFilial = Funcoes.isExportarBaseWeb(filialVO);
                Variaveis.baseWebAgrupada = Laboratorio.contemBaseWebAgrupada(codigo);
                Laboratorio.definirSistemaEmissorNFSe(filialVO.getConfigNFSE());
                if (!antigaWeb) {
                    Variaveis.codigoBaseWeb = ExportaWeb2.getCodigoBaseWeb(st, codigo);
                    Variaveis.exportarWebFilial = Funcoes.isExportarBaseWeb(filialVO);
                    Variaveis.baseWebAgrupada = ExportaWeb2.isBaseWebAgrupada(st, codigo);
                }
            } else {
                Funcoes.mensagem(null, "A filial informada nas configura\u00e7\u00f5es n\u00e3o foi encontrada.", 1);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Laboratorio");
        }
    }

    private static void definirSistemaEmissorNFSe(String configNFSe) {
        if (!Funcoes.textoVazio(configNFSe)) {
            String configuracaoENotas = StringUtil.getValor(configNFSe, "configuracaoEnotas");
            sistemaEmissorNFSe = !Funcoes.textoVazio(configuracaoENotas) ? SistemaEmissaoNFSe.ENOTAS : SistemaEmissaoNFSe.TECNOSPEED;
        }
    }

    private static boolean contemBaseWebAgrupada(String codigo) throws SQLException {
        FilialService filialService = new FilialService();
        FilialVOAux filialVO = filialService.contemAgrupamento(Conexao.getStatement(), codigo);
        return Funcoes.carregouVO(filialVO);
    }

    private void verificaThreadExportacao() throws Exception {
        String confIntegracao;
        if (Variaveis.estacaoExportaIntegracao && Variaveis.estacaoFilialIntegracao > -1) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_int_offline_off.jpg"));
            exportaIntegracao2 = new ExportaIntegracao2();
            exportaIntegracao2.start();
        }
        if (Laboratorio.getFilialExportaPDFWeb()) {
            threadCriaPdfWeb = new ThreadCriaPdfWeb();
            threadCriaPdfWeb.setPriority(1);
            threadCriaPdfWeb.start();
            threadCriaPdfWeb.gerarPdfPendentes();
        }
        if (Laboratorio.getFilialExportaHtmlWeb()) {
            threadCriaHtmlWeb = new ThreadCriaHtmlWeb();
            threadCriaHtmlWeb.setPriority(1);
            threadCriaHtmlWeb.start();
        }
        threadInterfaceExportacao = new ThreadInterfaceExportacao();
        threadInterfaceExportacao.setPriority(1);
        threadInterfaceExportacao.recuperacaoAutomaticaInterface();
        threadInterfaceExportacao.start();
        threadInterfaceExportacaoWebIntegracao = new ThreadInterfaceExportacaoWebIntegracao();
        threadInterfaceExportacaoWebIntegracao.setPriority(1);
        threadInterfaceExportacaoWebIntegracao.start();
        if (Funcoes.isExportaWeb(Conexao.getStatement(), Variaveis.filialPadrao)) {
            threadExportaWebRequisicao = new ThreadExportaWebRequisicao();
            threadExportaWebRequisicao.setPriority(1);
            threadExportaWebRequisicao.start();
        }
        if (!Funcoes.textoVazio(confIntegracao = ParametrosGerais.getConfiguracaoIntegracaoIDS())) {
            String infoEstacao = StringUtil.getValor(confIntegracao, "estacao");
            String codigoEstacao = StringUtil.getValor(infoEstacao, "codigo");
            if (ParametrosGerais.isIntegracaoIds() && !Funcoes.textoVazio(codigoEstacao) && Variaveis.codigoEstacao.equals(codigoEstacao)) {
                threadIds = new ThreadExportacaoIds();
                ThreadExportacaoIds.setIsEstacao(false);
                Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
                ThreadExportacaoIds.setIsEstacao(true);
                threadIds.setPriority(1);
                errosIntegracaoIds = new ErrosIntegracaoIds();
                threadIds.setInstanciaErrosIntegracaoIds(errosIntegracaoIds);
                threadIds.start();
            }
        }
        if (ParametrosGerais.getTipoIntegracao().equals("F")) {
            return;
        }
        if (Variaveis.estacaoExportaWeb) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
            if (!antigaWeb) {
                exportaWeb2 = new ExportaWeb2();
                exportaWeb2.start();
            } else {
                exportaWeb = new ExportaWeb();
                exportaWeb.start();
            }
        }
        if (Variaveis.estacaoExportaFiliais) {
            exportaFiliais = new ExportarEntreFilais();
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
            exportaFiliais.start();
        }
        if (Variaveis.estacaoExportaSms) {
            exportaSms = new ExportaSMS();
            if (exportaSms.isSmsApi()) {
                janelaMonitoramentoExportacaoSms.setSmsSenderApi(exportaSms.getSMSSenderApi());
            } else {
                janelaMonitoramentoExportacaoSms.setSmsSender(exportaSms.getSMSSender());
            }
            if (!exportaSms.isParar()) {
                exportaSms.start();
            }
        }
        if (Variaveis.estacaoExportaEmail) {
            exportaEmail = new ExportaEmail();
            Laboratorio.setIconeEnvioEmail(ExportaEmail.ICONE_ENVIANDO_E_MAIL_OFF);
            if (!exportaEmail.isParar()) {
                exportaEmail.start();
            }
        }
    }

    public static boolean getFilialExportaPDFWeb() {
        FilialService filService = new FilialService();
        try {
            return filService.getFilialExportaPDFWeb();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se h\u00e1 filiais que exportam PDF para web.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    public static boolean getFilialExportaHtmlWeb() {
        FilialService filService = new FilialService();
        try {
            return filService.getFilialExportaHtmlWeb();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se h\u00e1 filiais que exportam Html para web.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    private void verificaThreadIntegracaoHospital() {
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), this.getSqlConfiguracaoEstacao());
            if (rs.next()) {
                if (rs.getBoolean("est_integracaohospital")) {
                    if (!Funcoes.textoVazio(rs.getString("est_xmlhospital"))) {
                        this.iniciarIntegracaoHospitalConfiguradaPorEstacao(rs.getString("est_xmlhospital"));
                    }
                } else if (ParametrosGerais.getProtocoloIntegracaoHospital().equals((Object)ProtocoloIntegracaoHospital.SALUX)) {
                    this.instanciaIntegracaoSalux();
                } else {
                    rs = Conexao.executeQuery(Conexao.getStatement(), this.getSqlConfiguracaoConvenio());
                    if (rs.next() && !Funcoes.textoVazio(rs.getString("con_integracaohospital"))) {
                        this.iniciarIntegracaoHospitalConfiguradaProConvenio(rs.getString("con_integracaohospital"));
                    }
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel iniciar a Integra\u00e7\u00e3o com o hospital. " + e.getMessage(), e.getStackTrace());
        }
    }

    private String getSqlConfiguracaoEstacao() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select est_integracaohospital ");
        buf.append("       ,est_xmlhospital ");
        buf.append("   from estacoes ");
        buf.append("  where est_codigo = ").append(Variaveis.codigoEstacao);
        return buf.toString();
    }

    private String getSqlConfiguracaoConvenio() {
        StringBuilder sql = new StringBuilder();
        StringBuilder protocolo = new StringBuilder();
        protocolo.append("<").append("protocolo").append(">").append(ParametrosGerais.getProtocoloIntegracaoHospital().getNome()).append("</").append("protocolo").append(">");
        StringBuilder estacao = new StringBuilder();
        estacao.append("<").append("estacaoIntegradora").append(">").append(Variaveis.codigoEstacao).append("</").append("estacaoIntegradora").append(">");
        sql.append(" select con_codigo, con_integracaohospital from convenios ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and con_integracaohospital ilike '%").append(protocolo.toString()).append("%'");
        sql.append(" and con_integracaohospital ilike '%").append(estacao.toString()).append("%'");
        return sql.toString();
    }

    private void iniciarIntegracaoHospitalConfiguradaPorEstacao(String configuracao) {
        String tempo = StringUtil.getValor(configuracao, "TempoIntegracao");
        String ip = StringUtil.getValor(configuracao, "IpBD");
        String porta = StringUtil.getValor(configuracao, "PortaBD");
        String db = StringUtil.getValor(configuracao, "NomeBD");
        String user = StringUtil.getValor(configuracao, "UsuarioConexao");
        String password = StringUtil.getValor(configuracao, "SenhaConexao");
        IntegracaoHospital integracao = FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), configuracao);
        errosIntegracaoHospital = new ErrosIntegracaoHospital();
        integracaoHospital = new TimerIntegracaoHospital(tempo, integracao, errosIntegracaoHospital, ip + ":" + porta + "/" + db, user, password);
        Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
        integracaoHospital.start();
    }

    private void iniciarIntegracaoHospitalConfiguradaProConvenio(String configuracao) {
        IntegracaoHospital integracao = FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), configuracao);
        errosIntegracaoHospital = new ErrosIntegracaoHospital();
        integracaoHospital = new TimerIntegracaoHospital("1", integracao, errosIntegracaoHospital, "", "", "");
        Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
        integracaoHospital.start();
    }

    public static boolean login() {
        Senha senha = new Senha();
        senha.setLocationRelativeTo(null);
        senha.setVisible(true);
        if (senha.getRetorno() == 2) {
            return false;
        }
        Variaveis.login = senha.getLogin();
        Variaveis.nomeUsuario = senha.getNomeUsuario();
        Laboratorio.carregarFiliaisPermitidas(senha.getLogin());
        if (!(Funcoes.textoVazio(senha.getFilial()) || ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W"))) {
            Laboratorio.pegaDadosFilial(senha.getFilial());
            Laboratorio.filialAlterada();
        }
        if (Cliente.getInstancia() != null) {
            Cliente.getInstancia().logar(Variaveis.login);
        }
        return true;
    }

    private static void carregarFiliaisPermitidas(String usuario) {
        Statement st = null;
        try {
            st = Conexao.getStatement();
            Variaveis.filiaisPermitidas = new UsuarioFilialService().buscaFiliaisPermitidas(st, usuario);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Object o = e.getSource();
        if (o == this) {
            if (Variaveis.equip != null) {
                Funcoes.mensagem(this, "O interfaceamento est\u00e1 em uso, \u00e9 necess\u00e1rio finalizar antes de fechar o sistema", 2);
            } else if (Variaveis.exportandoParaWeb && Laboratorio.getFilialExportaPDFWeb()) {
                Funcoes.mensagem(this, "H\u00e1 PDFs de resultado sendo gerados (" + threadCriaPdfWeb.getQuantidadeExportacao() + " restantes).\nO sistema somente poder\u00e1 ser fechado ap\u00f3s a conclus\u00e3o da gera\u00e7\u00e3o dos PDFs.", 2);
            } else if (Variaveis.exportandoParaWeb && !Laboratorio.getFilialExportaPDFWeb()) {
                Funcoes.mensagem(this, "H\u00e1 html de resultado sendo gerados (" + threadCriaHtmlWeb.getQuantidadeExportacao() + " restantes).\nO sistema somente poder\u00e1 ser fechado ap\u00f3s a conclus\u00e3o da gera\u00e7\u00e3o dos HTMLs.", 2);
            } else if (Variaveis.exportandoInterface) {
                if (threadInterfaceExportacao.getQuantidadeExportacao() > 0) {
                    Funcoes.mensagem(this, "H\u00e1 logs de resultado sendo gerados pela exporta\u00e7\u00e3o da interface (" + threadInterfaceExportacao.getQuantidadeExportacao() + " restantes).\nO sistema somente poder\u00e1 ser fechado ap\u00f3s a conclus\u00e3o da exporta\u00e7\u00e3o.", 2);
                } else if (threadInterfaceExportacaoWebIntegracao.getQuantidadeExportacao() > 0) {
                    Funcoes.mensagem(this, "H\u00e1 logs de resultado sendo gerados pela exporta\u00e7\u00e3o da interface (" + threadInterfaceExportacaoWebIntegracao.getQuantidadeExportacao() + " restantes).\nO sistema somente poder\u00e1 ser fechado ap\u00f3s a conclus\u00e3o da exporta\u00e7\u00e3o.", 2);
                }
            } else if (!perguntar || !ParametrosGerais.getPerguntaSaida() || Funcoes.mensagem(this, "Deseja fechar a aplica\u00e7\u00e3o?", 4) == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        Laboratorio.finalizaSistema(false);
                    }
                }.start();
            }
        } else if (o instanceof DisposeListener) {
            this.removeDisposeListener((DisposeListener)o);
        }
    }

    public static ThreadCriaPdfWeb getThreadCriaPdfWeb() {
        return threadCriaPdfWeb;
    }

    public static void setThreadCriaPdfWeb(ThreadCriaPdfWeb threadCriaPdfWeb) {
        Laboratorio.threadCriaPdfWeb = threadCriaPdfWeb;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        Object o = e.getSource();
        if (o instanceof DisposeListener) {
            this.removeDisposeListener((DisposeListener)o);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        Laboratorio.fecharPreSplash();
        ControlaTempoInativo.iniciar();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        Object o = e.getSource();
        if (o instanceof DisposeListener) {
            this.removeDisposeListener((DisposeListener)o);
        }
    }

    public void addDisposeListener(DisposeListener l) {
        this.listenerList.add(DisposeListener.class, l);
        l.addComponentListener(this);
        l.addWindowListener(this);
    }

    public void setInterromperInfoRequisicao(boolean b) {
        this.interromperInfoRequisicao = b;
    }

    public void removeDisposeListener(DisposeListener l) {
        this.listenerList.remove(DisposeListener.class, l);
        l.removeComponentListener(this);
        l.removeWindowListener(this);
    }

    public static void fireDispose() {
        if (instancia != null) {
            DisposeListener[] disp = (DisposeListener[])Laboratorio.instancia.listenerList.getListeners(DisposeListener.class);
            for (int i = 0; i < disp.length; ++i) {
                Laboratorio.instancia.listenerList.remove(DisposeListener.class, disp[i]);
                disp[i].dispose();
            }
        }
    }

    public static void notificarErro(String mensagem, boolean executarEmThread, final boolean isErroConexao) {
        Funcoes.mensagem(null, mensagem + "\nO sistema ser\u00e1 fechado", 1);
        if (!executarEmThread) {
            Laboratorio.finalizaSistema(isErroConexao);
        } else {
            new Thread(){

                @Override
                public void run() {
                    Laboratorio.finalizaSistema(isErroConexao);
                }
            }.start();
        }
    }

    private static void notificarUsuarioLogado(List<String> estacoes) {
        if (ParametrosGerais.getAvisarLoginDuplicado()) {
            StringBuilder bui = new StringBuilder("O usu\u00e1rio \"");
            bui.append(Variaveis.login);
            bui.append("\" est\u00e1 logado ");
            bui.append(estacoes.size() > 1 ? "nas esta\u00e7\u00f5es " : "na esta\u00e7\u00e3o ");
            ListIterator<String> itr = estacoes.listIterator();
            while (itr.hasNext()) {
                if (itr.hasPrevious()) {
                    String tmp = itr.next();
                    bui.append(itr.hasNext() ? ", " : " e ");
                    bui.append(tmp);
                    continue;
                }
                bui.append(itr.next());
            }
            Funcoes.mensagem(null, bui.toString(), 2);
        }
    }

    private static void mostrarPreSplash(String mensagem) {
        preSplash = new JWindow();
        preSplash.getContentPane().setLayout(new BorderLayout());
        preSplash.getContentPane().add((Component)new JLabel(mensagem, 0), "Center");
        preSplash.getContentPane().setBackground(Color.white);
        preSplash.setSize(new Dimension(200, 100));
        preSplash.setLocationRelativeTo(null);
        preSplash.setVisible(true);
    }

    private static void fecharPreSplash() {
        if (preSplash != null) {
            preSplash.dispose();
            preSplash = null;
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    public static Thread getExportaIntegracao() {
        return exportaIntegracao2;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o == this.labelInfoExame) {
            InfoExame info = new InfoExame(this);
            info.setVisible(true);
        } else if (o == this.labelInfoRequisicao) {
            InfoRequisicao info = new InfoRequisicao((Frame)this, this.glassPaneMensagem);
            info.setVisible(true);
            this.getRootPane().setGlassPane(this.glassPaneMensagem);
        } else if (o == this.labelOrcamento) {
            this.abrirOrcamento();
        } else if (o == this.labelLancamento) {
            this.abrirLancamento();
        } else if (o == this.labelImpressoras) {
            this.abrirImpressoras();
        } else if (o == this.labelSenhaAtendimento) {
            this.menuSenha.show(this.labelSenhaAtendimento.getParent(), this.labelSenhaAtendimento.getX(), this.labelSenhaAtendimento.getY() + this.labelSenhaAtendimento.getHeight());
        } else if (o == this.labelInfoConvenio) {
            if (Acesso.getAcesso(InfoConvenio.getModuloAcesso())) {
                InfoConvenio infoConv = new InfoConvenio(this);
                infoConv.setVisible(true);
            }
        } else if (o == this.labelInterface && e.getClickCount() == 2 && Variaveis.equip != null) {
            if (this.menu.telaAberta()) {
                Funcoes.mensagem(instancia, "\u00c9 preciso fechar a tela aberta para reabrir o interfaceamento!", 2);
            } else {
                Laboratorio.setIconeInterfaceamento(null);
                MenuSistema.executarMenu(MenuSistema.getItemMenu(AbstractInterfaceamento.getModuloAcesso()), false);
            }
        }
    }

    private void abrirOrcamento() {
        if (Acesso.getAcesso(Long.parseLong("0000400000"))) {
            Orcamento orc = new Orcamento(true);
            JDialog diag = new JDialog();
            diag.setModal(true);
            diag.setTitle("Or\u00e7amento");
            diag.setSize(650, 480);
            JPanel pc = new JPanel(new BorderLayout());
            pc.add((Component)orc, "Center");
            pc.setBorder(ScreenUtil.criarBordaVazia());
            diag.setContentPane(pc);
            diag.setLocationRelativeTo(this);
            diag.setVisible(true);
        }
    }

    private void abrirLancamento() {
        String contaCaixa = ParametrosLocais.getParametro("contaCaixa");
        if (Acesso.getAcesso(Long.parseLong("0000500000"))) {
            if (!Funcoes.textoVazio(contaCaixa) || !Acesso.getAcesso(Long.parseLong("0600400110"))) {
                Lancamento lanc = new Lancamento(true);
                lanc.defineAcessos();
                lanc.setLabelFormulario("Lan\u00e7amento em caixa");
                JDialog diag = new JDialog();
                diag.setModal(true);
                diag.setTitle("Lancamento em caixa");
                diag.setSize(650, 480);
                JPanel pc = new JPanel(new BorderLayout());
                pc.add((Component)lanc, "Center");
                pc.setBorder(ScreenUtil.criarBordaVazia());
                diag.setContentPane(pc);
                diag.setLocationRelativeTo(this);
                diag.setVisible(true);
            } else {
                Funcoes.mensagem(this, "Conta Caixa n\u00e3o est\u00e1 configurada na esta\u00e7\u00e3o.", 2);
            }
        }
    }

    private void abrirImpressoras() {
        final Impressoras imp = new Impressoras(false);
        JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", this);
        JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", this);
        JPanel panelButton = ComponenteFactory.novoJPanelFlowLayout(2, buttonSalvar, buttonCancelar);
        final JDialog diag = new JDialog();
        diag.setModal(true);
        diag.setTitle("Informa\u00e7\u00f5es de Impressoras");
        diag.setSize(650, 480);
        JPanel pc = new JPanel(new BorderLayout());
        pc.add((Component)imp, "North");
        pc.add((Component)panelButton, "South");
        buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                imp.salvarParamentrosImpressora();
                Funcoes.mensagem(diag, "Par\u00e2metros atualizados com sucesso", 2);
                diag.setVisible(false);
            }
        });
        buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(diag, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    imp.carregaParametros();
                    diag.setVisible(false);
                }
            }
        });
        pc.setBorder(ScreenUtil.criarBordaVazia());
        diag.setContentPane(pc);
        diag.setLocationRelativeTo(this);
        diag.setVisible(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setComponenteMensagemVisivel(boolean isVisible) {
        if (this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem) {
            this.glassPaneMensagem.setVisible(isVisible);
        }
    }

    public boolean getComponenteMensagemVisivel() {
        if (this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem) {
            return this.glassPaneMensagem.isVisible();
        }
        return false;
    }

    public void adicionarComponenteMensagem(JComponent componente, String mensagem) {
        this.adicionarComponenteMensagem(componente, mensagem, 0, false);
    }

    public void adicionarComponenteMensagem(JComponent componente, String mensagem, int posicao, boolean quebrarLinha) {
        if (this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem && componente != null && mensagem != null && !Funcoes.textoVazio(mensagem)) {
            this.glassPaneMensagem.adicionarComponenteMensagem(componente, mensagem, posicao, quebrarLinha);
        }
    }

    public void adicionarImagemGlasspane(ImageIcon imagem, int x, int y, int width, int height) {
        if (this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem) {
            this.glassPaneMensagem.adicionarImagem(imagem, x, y, width, height);
        }
    }

    public void removerImagemGlasspane(ImageIcon imagem) {
        if (this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem) {
            this.glassPaneMensagem.removerImagem(imagem);
        }
    }

    public void removerComponenteMensagem(JComponent componente) {
        if (this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem && componente != null) {
            this.glassPaneMensagem.removerComponenteMensagem(componente);
        }
    }

    public void removerTodosComponenteMensagem() {
        this.glassPaneMensagem.removerTodosComponenteMensagem();
    }

    public static JanelaMonitoramentoExportacaoEmail getJanelaMonitoramentoExportacaoEmail() {
        return janelaMonitoramentoExportacaoEmail;
    }

    public static JanelaMonitoramentoExportacaoSms getJanelaMonitoramentoExportacaoSms() {
        return janelaMonitoramentoExportacaoSms;
    }

    public static JanelaMonitoramentoExportacaoWeb getJanelaMonitoramentoExpoWeb() {
        return janelaMonitoramentoExportacaoWeb;
    }

    public static JanelaMonitoramentoIntegracaoOffline getJanelaMonitoramentoIntegracaoOffLine() {
        return janelaMonitoramentoExportacaoOffLine;
    }

    public static boolean isNovaWeb() {
        return !antigaWeb;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    static {
        perguntar = true;
        bloqueio = new Object();
        antigaWeb = false;
        janelaMonitoramentoExportacaoEmail = null;
        janelaMonitoramentoExportacaoSms = null;
        janelaMonitoramentoExportacaoWeb = null;
        janelaMonitoramentoExportacaoOffLine = null;
        janelaMonitoramentoExportacaoAplicativo = null;
        splashAtiva = null;
        isSistemaFinalizando = false;
        log = null;
    }
}

