/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import jalis.util.Funcoes;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class GlassPaneMensagem
extends JComponent {
    public static final int ALINHAR_ESQUERDA = 0;
    public static final int ALINHAR_DIREITA = 1;
    public static final Font FONTE = new Font("Arial", 1, 11);
    HashMap<JComponent, MensagemPosicao> componentesMensagem = new HashMap();
    HashMap<ImageIcon, Rectangle> imagens = new HashMap();
    private final int ALTURA = 12;
    private final int SOBRA = 10;
    private final int ARCO = 10;
    private final int ALTURA_PERNA = 5;
    private final int LARGURA_PERNA = 5;
    private final int ENCAIXE = 0;
    private final int ANGULO1 = 90;
    private final int ANGULO2 = 180;
    private final int ANGULO3 = -180;
    private final Color COR_PREENCHIMENTO = new Color(1.0f, 0.5f, 0.5f, 0.8f);
    private final Color COR_BORDA = new Color(1.0f, 0.5f, 0.5f, 1.0f);
    private final Color COR_TEXTO = new Color(0.3f, 0.3f, 0.3f);

    public void adicionarComponenteMensagem(JComponent componente, String mensagem) {
        this.adicionarComponenteMensagem(componente, mensagem, 0);
    }

    public void adicionarImagem(ImageIcon imagem, int x, int y, int width, int height) {
        if (imagem != null) {
            this.imagens.put(imagem, new Rectangle(x, y, width, height));
        }
        this.repaint();
    }

    public void adicionarComponenteMensagem(JComponent componente, String mensagem, int posicao) {
        this.adicionarComponenteMensagem(componente, mensagem, posicao, false);
    }

    public void adicionarComponenteMensagem(JComponent componente, String mensagem, int posicao, boolean quebrarLinha) {
        if (componente != null && mensagem != null && !Funcoes.textoVazio(mensagem)) {
            this.componentesMensagem.put(componente, new MensagemPosicao(mensagem, posicao, quebrarLinha));
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void removerImagem(ImageIcon imagem) {
        this.imagens.remove(imagem);
        this.repaint();
    }

    public void removerComponenteMensagem(JComponent componente) {
        if (componente != null) {
            this.componentesMensagem.remove(componente);
        }
        if (this.componentesMensagem.size() > 0) {
            this.setVisible(false);
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void removerTodosComponenteMensagem() {
        this.componentesMensagem.clear();
        this.setVisible(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        Set<JComponent> comps = this.componentesMensagem.keySet();
        for (JComponent aux : comps) {
            if (!aux.isVisible()) continue;
            this.desenhaMensagem(aux, this.componentesMensagem.get(aux), (Graphics2D)g);
        }
        Set<ImageIcon> listaImagens = this.imagens.keySet();
        for (ImageIcon imagem : listaImagens) {
            Rectangle posicao = this.imagens.get(imagem);
            ((Graphics2D)g).drawImage(imagem.getImage(), posicao.x, posicao.y, posicao.width, posicao.height, null);
        }
    }

    private void desenhaMensagem(JComponent componente, MensagemPosicao mensagem, Graphics2D g) {
        block7: {
            int[] y;
            int[] x;
            int width;
            int ALTURA;
            String[] linhas;
            int posY;
            int posX;
            block6: {
                posX = 0;
                posY = 0;
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setFont(FONTE);
                g.setComposite(AlphaComposite.SrcAtop);
                if (mensagem.quebrarLinha) {
                    mensagem.mensagem = this.quebraLinhasMensagem(componente, mensagem.mensagem);
                }
                linhas = mensagem.mensagem.split("\n");
                ALTURA = this.ALTURA * linhas.length;
                JComponent aux = componente;
                while (aux.getParent() != null) {
                    posX += aux.getX();
                    posY += aux.getY();
                    if (!(aux.getParent() instanceof JComponent)) break;
                    aux = (JComponent)aux.getParent();
                }
                if (mensagem.posicao == 0) {
                    posX += componente.getWidth();
                }
                posY = (int)((double)posY - ((double)(this.ALTURA * (linhas.length + 1)) + (double)this.ALTURA * 1.5 - 3.0));
                width = 0;
                for (int i = 0; i < linhas.length; ++i) {
                    int tamLinha = g.getFontMetrics().stringWidth(linhas[i]) + 10;
                    if (tamLinha <= width) continue;
                    width = tamLinha;
                }
                x = null;
                y = null;
                if (mensagem.posicao != 0) break block6;
                x = new int[]{posX, posX - 5, posX - 10, posX - width, posX - width, posX};
                y = new int[]{posY + ALTURA, posY + ALTURA + 5, posY + ALTURA, posY + ALTURA, posY, posY};
                g.setColor(this.COR_PREENCHIMENTO);
                g.fillPolygon(x, y, 6);
                g.fillArc(posX - width - 5 + 0, posY, 10, ALTURA, 90, 180);
                g.fillArc(posX - 5 - 0, posY, 10, ALTURA, 90, -180);
                g.setColor(this.COR_BORDA);
                g.drawLine(x[0], y[0], x[1], y[1]);
                g.drawLine(x[1], y[1], x[2], y[2]);
                g.drawLine(x[2], y[2], x[3], y[3]);
                g.drawLine(x[4], y[4], x[5], y[5]);
                g.drawArc(posX - width - 5 + 0, posY, 10, ALTURA, 90, 180);
                g.drawArc(posX - 5 - 0, posY, 10, ALTURA, 90, -180);
                g.setColor(this.COR_TEXTO);
                for (int i = 0; i < linhas.length; ++i) {
                    g.drawString(linhas[i], posX - width + 5, posY + ALTURA / linhas.length * i + this.ALTURA - 1);
                }
                break block7;
            }
            if (mensagem.posicao != 1) break block7;
            x = new int[]{posX, posX + 5, posX + 10, posX + width, posX + width, posX};
            y = new int[]{posY + ALTURA, posY + ALTURA + 5, posY + ALTURA, posY + ALTURA, posY, posY};
            g.setColor(this.COR_PREENCHIMENTO);
            g.fillPolygon(x, y, 6);
            g.fillArc(posX - 5 - 0, posY, 10, ALTURA, 90, 180);
            g.fillArc(posX + width - 5 + 0, posY, 10, ALTURA, 90, -180);
            g.setColor(this.COR_BORDA);
            g.drawLine(x[0], y[0], x[1], y[1]);
            g.drawLine(x[1], y[1], x[2], y[2]);
            g.drawLine(x[2], y[2], x[3], y[3]);
            g.drawLine(x[4], y[4], x[5], y[5]);
            g.drawArc(posX - 5 - 0, posY, 10, ALTURA, 90, 180);
            g.drawArc(posX + width - 5 + 0, posY, 10, ALTURA, 90, -180);
            g.setColor(this.COR_TEXTO);
            for (int i = 0; i < linhas.length; ++i) {
                g.drawString(linhas[i], posX + 5, posY + ALTURA / linhas.length * i + this.ALTURA - 1);
            }
        }
    }

    private String quebraLinhasMensagem(JComponent componente, String mensagem) {
        if (mensagem == null || componente == null) {
            return null;
        }
        FontMetrics met = this.getFontMetrics(FONTE);
        int widthTexto = met.stringWidth(mensagem);
        int widthMax = componente.getWidth();
        mensagem = mensagem.replaceAll("\t", " ");
        mensagem = mensagem.replaceAll("\n", " ");
        mensagem = mensagem.replaceAll("\r", " ");
        mensagem = mensagem.replaceAll("\f", " ");
        StringTokenizer tokenizer = new StringTokenizer(mensagem, " ", true);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        StringBuilder bufFinal = new StringBuilder();
        StringBuilder bufAux = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            int widthAux = met.stringWidth(bufAux.toString() + token);
            if (widthAux < widthMax) {
                bufAux.append(token);
                if (i != tokens.size() - 1) continue;
                bufFinal.append(bufAux.toString());
                continue;
            }
            bufFinal.append(bufAux.toString().trim()).append("\n");
            if (i == tokens.size() - 1) {
                bufFinal.append(token);
                continue;
            }
            bufAux.setLength(0);
            bufAux.append(token);
        }
        return bufFinal.toString();
    }

    class MensagemPosicao {
        String mensagem = null;
        int posicao = 0;
        boolean quebrarLinha = false;

        public MensagemPosicao(String mensagem, int posicao, boolean quebrarLinha) {
            this.mensagem = mensagem;
            this.posicao = posicao;
            this.quebrarLinha = quebrarLinha;
        }
    }
}

