/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.TempoInativoListener;
import jalis.util.logger.ErrorLogger;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import javax.swing.event.EventListenerList;

public class ControlaTempoInativo
implements Runnable,
AWTEventListener {
    private long tempo = 0L;
    private boolean contando = false;
    private EventListenerList listenerList = new EventListenerList();
    private static Thread thread;
    private static ControlaTempoInativo instancia;

    private ControlaTempoInativo() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 40L);
    }

    public static synchronized void iniciar() {
        ControlaTempoInativo.instancia.contando = true;
    }

    public static synchronized void parar() {
        ControlaTempoInativo.instancia.contando = false;
    }

    public static synchronized boolean contando() {
        return ControlaTempoInativo.instancia.contando;
    }

    public static synchronized void addTempoInativoListener(TempoInativoListener l) {
        ControlaTempoInativo.instancia.listenerList.add(TempoInativoListener.class, l);
    }

    public static synchronized void removeTempoInativoListener(TempoInativoListener l) {
        ControlaTempoInativo.instancia.listenerList.remove(TempoInativoListener.class, l);
    }

    @Override
    public void run() {
        try {
            while (!thread.isInterrupted()) {
                if (this.contando && this.contarTempo() && ++this.tempo > (long)ControlaTempoInativo.tempoLimite()) {
                    this.contando = false;
                    this.fireTempoExpirou();
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ControlaTempoInativo");
        }
    }

    @Override
    public synchronized void eventDispatched(AWTEvent event) {
        this.tempo = 0L;
    }

    private void fireTempoExpirou() {
        TempoInativoListener[] til = (TempoInativoListener[])this.listenerList.getListeners(TempoInativoListener.class);
        for (int i = 0; i < til.length; ++i) {
            til[i].tempoExpirou();
        }
    }

    private static int tempoLimite() {
        String tmp = ParametrosLocais.getParametro("tempoLogout");
        return tmp != null && tmp.matches("\\-?\\d+") ? Integer.parseInt(tmp) * 60 : 0;
    }

    private boolean contarTempo() {
        return ControlaTempoInativo.tempoLimite() > 0;
    }

    static {
        instancia = new ControlaTempoInativo();
        thread = new Thread(instancia);
        thread.start();
    }
}

