/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio;

import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ChangeLog
extends JDialog {
    private JEditorPane editor = new JEditorPane();
    private JScrollPane scroll = new JScrollPane(this.editor);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangeLog.this.setVisible(false);
        }
    }, null, null);

    public ChangeLog(JFrame frame) {
        super(frame, "Changelog", true);
        this.setSize(new Dimension(600, 480));
        this.setLocationRelativeTo(frame);
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getDescription().replaceAll("\"", "");
                    ChangeLog.this.carregarPagina(url);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.scroll, c);
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        this.add((Component)panelBotoes, c);
        panelBotoes.add(this.buttonFechar);
        this.carregarPagina("/jalis/changelog.html");
    }

    private void carregarPagina(String url) {
        try {
            this.editor.setContentType("text/html");
            StringBuilder pagina = new StringBuilder();
            InputStream in = ChangeLog.class.getResourceAsStream(url);
            BufferedInputStream buf = new BufferedInputStream(in);
            while (buf.available() > 0) {
                pagina.append((char)buf.read());
            }
            String s = StringUtil.tratarEntidadesHTML(pagina.toString(), false, false);
            this.editor.setText(s);
            this.editor.setCaretPosition(0);
        }
        catch (Exception e) {
            this.editor.setText("<b>N&atilde;o foi poss&iacute;vel carregar a p&agina: " + e.getMessage() + "</b>");
        }
    }
}

