/*
 * Decompiled with CFR 0.152.
 */
package jalis.integradores.pacientes;

import jalis.integradores.pacientes.SocketClienteListener;
import jalis.util.Funcoes;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class SocketCliente {
    private String ipConectado = "";
    private Socket socket;
    private BufferedInputStream entrada;
    private DataOutputStream saida;
    private boolean executando = true;
    private StringBuilder buf = new StringBuilder();
    private int qtdeReenvio = 0;
    private ArrayList<SocketClienteListener> listener = new ArrayList();

    public SocketCliente(Socket socket) {
        this.socket = socket;
        this.ipConectado = socket.getRemoteSocketAddress().toString();
        try {
            this.entrada = new BufferedInputStream(socket.getInputStream());
            this.saida = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.iniciar();
    }

    private void iniciar() {
        new Thread(){

            @Override
            public void run() {
                while (SocketCliente.this.executando) {
                    SocketCliente.this.lerMensagem();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }.start();
    }

    public String getIpConectado() {
        return this.ipConectado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fechar() {
        try {
            this.executando = false;
            this.entrada.close();
            DataOutputStream dataOutputStream = this.saida;
            synchronized (dataOutputStream) {
                this.saida.close();
            }
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverMensagemChar(String msn) {
        if (this.socket.isConnected()) {
            try {
                DataOutputStream dataOutputStream = this.saida;
                synchronized (dataOutputStream) {
                    this.saida.writeChars(msn);
                    this.saida.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverMensagem(String msn) {
        if (this.socket.isConnected()) {
            try {
                DataOutputStream dataOutputStream = this.saida;
                synchronized (dataOutputStream) {
                    this.saida.writeUTF(msn);
                    this.saida.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void lerMensagem() {
        if (this.socket.isConnected()) {
            try {
                byte[] b = new byte[this.entrada.available()];
                int p = this.entrada.read(b);
                char[] c = new char[b.length];
                for (int i = 0; i < b.length; ++i) {
                    c[i] = (char)b[i];
                }
                if (!Funcoes.textoVazio(String.valueOf(c))) {
                    this.fireMensagemLida(String.valueOf(c).trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void addSocketClienteListener(SocketClienteListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    private void fireMensagemLida(String m) {
        for (SocketClienteListener l : this.listener) {
            l.mensagemLida(this, m);
        }
    }

    public boolean isListenerAdded() {
        return this.listener.size() > 0;
    }

    public int incrementaQtdeReenvio() {
        return this.qtdeReenvio++;
    }

    public int getQtdeReenvio() {
        return this.qtdeReenvio;
    }
}

