/*
 * Decompiled with CFR 0.152.
 */
package jalis.integradores.pacientes;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integradores.pacientes.DadosPaciente;
import jalis.integradores.pacientes.ProcessaEnvio;
import jalis.integradores.pacientes.ProcessaRecebimento;
import jalis.integradores.pacientes.SocketCliente;
import jalis.integradores.pacientes.SocketClienteListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;

public class Servidor
implements Runnable,
SocketClienteListener {
    public static final int PORTA = 4447;
    public static final String PACIENTE_RECEBIDO = "<pacienterecebido/>";
    public static final String REENVIAR_PACIENTE = "<reenviarpaciente/>";
    private static String ipServidor = "127.0.0.1";
    private static String filialServidor = "1";
    private static String ipSocket = "127.0.0.1";
    private static String codigoUsuario;
    private static int portaSocket;
    private static String pathTemporario;
    private static BufferedWriter bufferLog;
    private static int tempoSocket;
    private static boolean debug;
    private ArrayList<DadosPaciente> pacientesRecebidos = new ArrayList();
    private ProcessaEnvio threadEnvio = new ProcessaEnvio(bufferLog);
    private ProcessaRecebimento threadRecebimento = new ProcessaRecebimento(bufferLog);

    public Servidor() {
        ParametrosGerais.carregaParametros();
        new Thread(this).start();
        this.threadEnvio.setServidor(ipSocket, portaSocket);
        this.threadEnvio.setPathTemporario(pathTemporario);
        this.threadRecebimento.setFilial(filialServidor);
        this.threadRecebimento.setUsuario(codigoUsuario);
        this.threadEnvio.start();
        this.threadRecebimento.start();
    }

    public static void main(String[] args) {
        if (Servidor.tratarArgumentos(args)) {
            Variaveis.caminhoBanco = "jdbc:postgresql://" + ipServidor + "/jalis";
            new Servidor();
        } else {
            Servidor.mostraAjuda();
        }
    }

    private static boolean tratarArgumentos(String[] args) {
        boolean retorno = false;
        int pos = Servidor.achaArgumento("-ip", args);
        if (pos > -1) {
            if (pos + 1 <= args.length - 1 && Funcoes.verificaIP(args[pos + 1])) {
                ipServidor = args[pos + 1];
                retorno = true;
            } else {
                System.out.println("Endere\u00e7o IP incorreto");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-filial", args)) > -1) {
            if (pos + 1 <= args.length - 1 && !Funcoes.textoVazio(args[pos + 1]) && Funcoes.isNumeric(args[pos + 1])) {
                filialServidor = args[pos + 1];
                retorno = true;
            } else {
                System.out.println("Codigo da filial incorreto");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-usuario", args)) > -1) {
            if (pos + 1 <= args.length - 1 && !Funcoes.textoVazio(args[pos + 1])) {
                codigoUsuario = args[pos + 1];
                retorno = true;
            } else {
                System.out.println("Codigo do usuario incorreto");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-socket", args)) > -1) {
            if (pos + 1 <= args.length - 1 && Funcoes.verificaIP(args[pos + 1])) {
                ipSocket = args[pos + 1];
                retorno = true;
            } else {
                System.out.println("Endere\u00e7o do socket incorreto");
                retorno = false;
            }
        } else {
            retorno = false;
        }
        pos = Servidor.achaArgumento("-porta", args);
        if (pos > -1) {
            if (pos + 1 <= args.length - 1 && !Funcoes.textoVazio(args[pos + 1]) && Funcoes.isNumeric(args[pos + 1])) {
                portaSocket = Integer.parseInt(args[pos + 1]);
                retorno = true;
            } else {
                System.out.println("Porta do socket incorreta");
                retorno = false;
            }
        } else {
            retorno = false;
        }
        pos = Servidor.achaArgumento("-path", args);
        if (pos > -1) {
            if (pos + 1 <= args.length - 1 && !Funcoes.textoVazio(args[pos + 1]) && Funcoes.diretorioExiste(args[pos + 1])) {
                pathTemporario = args[pos + 1];
                retorno = true;
            } else {
                System.out.println("Diretorio temporario incorreto");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-tempo", args)) > -1 && pos + 1 <= args.length - 1 && !Funcoes.textoVazio(args[pos + 1]) && Funcoes.isNumeric(args[pos + 1])) {
            tempoSocket = Integer.parseInt(args[pos + 1]);
        }
        if ((pos = Servidor.achaArgumento("-log", args)) > -1) {
            try {
                bufferLog = new BufferedWriter(new FileWriter("/var/log/ServidorPacienteJalis.log"));
                bufferLog.write("Servidor de pacientes iniciado em " + Funcoes.formataData(new Date()) + " as " + Funcoes.formataHora(new Date(), true) + "\n");
                bufferLog.flush();
            }
            catch (IOException e) {
                bufferLog = null;
            }
        }
        if (Servidor.achaArgumento("-verao", args) > -1) {
            Funcoes.configurarHorarioVerao(true);
        }
        debug = (pos = Servidor.achaArgumento("-debug", args)) > -1;
        return retorno;
    }

    @Override
    public void run() {
        if (debug) {
            Servidor.mensagemLog(bufferLog, "Tempo de espera definido em " + tempoSocket);
        }
        try {
            ServerSocket server = new ServerSocket(4447);
            Servidor.mensagemLog(bufferLog, "Ouvindo novas conexoes");
            while (!Thread.interrupted()) {
                try {
                    SocketCliente socket = new SocketCliente(server.accept());
                    if (debug) {
                        Servidor.mensagemLog(bufferLog, "Aguardando tempo de espera");
                    }
                    Thread.sleep(tempoSocket);
                    socket.addSocketClienteListener(this);
                    Servidor.mensagemLog(bufferLog, "Conectado ao ip: " + socket.getIpConectado());
                    if (debug && !socket.isListenerAdded()) {
                        Servidor.mensagemLog(bufferLog, "Listener nao adicionado no ip " + socket.getIpConectado());
                    }
                }
                catch (SocketException s) {
                    Servidor.mensagemLog(bufferLog, s.getMessage());
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static int achaArgumento(String argumento, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argumento)) continue;
            return i;
        }
        return -1;
    }

    private static void mostraAjuda() {
        System.out.println("Servidor de integracao de pacientes entre Jalis e D-Max");
        System.out.println("Opcoes:");
        System.out.println("\t-ip numero_ip\n\t  Especifica o numero de IP do banco de dados do Jalis");
        System.out.println("\t  em que o servidor sera conectado.\n");
        System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
        System.out.println("\t  numero de IP 127.0.0.1 por default.\n");
        System.out.println("\t-filial numero_da_filial\n\t  Especifica o codigo da filial que vai receber os pacientes.\n");
        System.out.println("\t  Opcao requerida.\n");
        System.out.println("\t-usuario login\n\t  Especifica o login do usuario quer sera responsavel pelo cadastro dos pacientes.\n");
        System.out.println("\t  Opcao requerida.\n");
        System.out.println("\t-socket numero_ip\n\t  Especifica o numero de IP do servidor de comunicacao do D-Max");
        System.out.println("\t  onde sera gravado os novos pacientes que foram adicionados no Jalis.\n");
        System.out.println("\t  Opcao requerida.\n");
        System.out.println("\t-porta numero_porta\n\t  Especifica a porta do servidor de comunicacao do D-Max");
        System.out.println("\t  onde sera gravado os novos pacientes que foram adicionados no Jalis.\n");
        System.out.println("\t  Opcao requerida.\n");
        System.out.println("\t-path caminho_arquivos_temporarios\n\t  Especifica um diretorio para a gravacao de arquivos temporarios");
        System.out.println("\t  para pacientes que nao podem ser enviados para o D-Max.\n");
        System.out.println("\t-log\n\t  Especifica que o sistema vai criar um log das operacoes realizadas,");
        System.out.println("\t  sendo o arquivo gravado em /var/log/ServidorPacienteJalis.log ");
        System.out.println("\t-verao\n\tInforma ao servidor que o TimeZone padrao sera alterado para contemplar o horario de verao");
        System.out.println("\t-tempo\n\t  Especifica o tempo, em milisegundos, para que o servidor aguarde entre uma conexao de socket ");
        System.out.println("\t  e a adicao dos ouvintes de evento, por padrao o valor e 100 milisegundos ");
        System.out.println("\t-debug\n\t  Especifica ao servidor que ele devera gerar algumas mensagens adicionais no log ");
    }

    public static void mensagemLog(BufferedWriter bufferLog, String mensagem) {
        if (bufferLog != null) {
            try {
                bufferLog.write(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
                bufferLog.write(" >> ");
                bufferLog.write(mensagem);
                bufferLog.write("\n");
                bufferLog.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mensagemLida(SocketCliente socket, String mensagem) {
        if (debug) {
            Servidor.mensagemLog(bufferLog, "Mensagem recebida no ip: " + socket.getIpConectado() + "(" + mensagem + ")");
        }
        this.trataMensagem(socket, mensagem);
    }

    private void trataMensagem(SocketCliente socket, String mensagem) {
        if (debug) {
            Servidor.mensagemLog(bufferLog, "Mensagem tratada no ip: " + socket.getIpConectado() + "(" + mensagem + ")");
        }
        if (Funcoes.textoVazio(mensagem)) {
            return;
        }
        if (mensagem.equals("<fechar/>")) {
            socket.fechar();
        } else if (!Funcoes.textoVazio(StringUtil.getValor(mensagem, "pacientejalis"))) {
            this.pacienteRecebidoJalis(socket, mensagem);
        } else if (!Funcoes.textoVazio(StringUtil.getValor(mensagem, "paciente"))) {
            this.pacienteRecebido(socket, mensagem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pacienteRecebidoJalis(SocketCliente socket, String xml) {
        DadosPaciente paciente;
        if (debug) {
            Servidor.mensagemLog(bufferLog, "Paciente recebido pelo jalis: " + (xml == null ? "null" : xml));
            Servidor.mensagemLog(bufferLog, "Paciente recebido e convertido pelo Jalis: " + (xml == null ? "null" : StringUtil.converteHtmlParaAcentos(xml)));
        }
        if ((paciente = DadosPaciente.getPaciente(StringUtil.converteHtmlParaAcentos(xml))) != null) {
            String hashCalculado = paciente.calcularHash();
            String hashRecebido = paciente.getHash();
            if (debug) {
                Servidor.mensagemLog(bufferLog, xml + "\n" + paciente.getXML() + "\nRecebido:" + paciente.getCodigo() + "\nC:" + hashCalculado + "\nR:" + hashRecebido);
            }
            if (hashCalculado.equalsIgnoreCase(hashRecebido)) {
                socket.escreverMensagem(PACIENTE_RECEBIDO);
                ProcessaEnvio processaEnvio = this.threadEnvio;
                synchronized (processaEnvio) {
                    this.threadEnvio.adicionaPaciente(paciente);
                }
            } else {
                Servidor.mensagemLog(bufferLog, "Paciente recebido (Jalis) com hash incorreto: " + paciente.getCodigo() + "-" + paciente.getNome());
                socket.escreverMensagem(REENVIAR_PACIENTE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pacienteRecebido(SocketCliente socket, String xml) {
        DadosPaciente paciente = DadosPaciente.getPaciente(StringUtil.converteHtmlParaAcentos(xml));
        if (paciente != null) {
            String hashCalculado = paciente.calcularHash();
            String hashRecebido = paciente.getHash();
            if (debug) {
                Servidor.mensagemLog(bufferLog, xml + "\n" + StringUtil.converteHtmlParaAcentos(xml) + "\n" + paciente.getXML() + "\nRecebido:" + paciente.getCodigo() + "\nC:" + hashCalculado + "\nR:" + hashRecebido);
            }
            if (hashCalculado.equalsIgnoreCase(hashRecebido)) {
                ArrayList<DadosPaciente> arrayList = this.pacientesRecebidos;
                synchronized (arrayList) {
                    ProcessaEnvio processaEnvio = this.threadEnvio;
                    synchronized (processaEnvio) {
                        this.threadRecebimento.adicionaPaciente(paciente);
                        socket.escreverMensagem(PACIENTE_RECEBIDO);
                    }
                }
            }
            Servidor.mensagemLog(bufferLog, "Paciente recebido com hash incorreto: " + paciente.getCodigo() + "-" + paciente.getNome());
            if (socket.incrementaQtdeReenvio() <= 5) {
                socket.escreverMensagem(REENVIAR_PACIENTE);
            } else {
                socket.fechar();
                Servidor.mensagemLog(bufferLog, "Tentativa numero 5 de pedido de reenvio de paciente (Integrador <- Jalis)");
            }
        }
    }

    static {
        portaSocket = 4000;
        pathTemporario = "";
        bufferLog = null;
        tempoSocket = 100;
        debug = false;
    }
}

