/*
 * Decompiled with CFR 0.152.
 */
package jalis.integradores.pacientes;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.integradores.pacientes.DadosPaciente;
import jalis.integradores.pacientes.Servidor;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.sql.SalvaDados;
import java.io.BufferedWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

class ProcessaRecebimento
extends Thread {
    private ArrayList<DadosPaciente> pacientes = new ArrayList();
    private boolean executar = true;
    private BufferedWriter bufferLog;
    private String filial;
    private String codigoUsuario;

    public ProcessaRecebimento(BufferedWriter buffer) {
        super("ProcessaRecebimento - Thread");
        this.bufferLog = buffer;
    }

    public void parar() {
        this.executar = false;
    }

    @Override
    public void run() {
        while (this.executar) {
            if (this.pacientes.size() > 0) {
                DadosPaciente p = this.pacientes.get(0);
                Servidor.mensagemLog(this.bufferLog, "Recebendo paciente " + p.getNome());
                this.pacientes.remove(p);
                Statement st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder();
                String senhaWeb = Funcoes.gerarSenhaWeb();
                String codigo = "";
                long codigoOrigemPaciente = -1L;
                if (p.getOperacao().equals("I")) {
                    try {
                        codigoOrigemPaciente = Long.parseLong(DBUtil.getSequencia(st, "paciente", this.filial));
                    }
                    catch (Exception e) {
                        Servidor.mensagemLog(this.bufferLog, e.getMessage());
                    }
                    codigo = DBUtil.formatarValorParaIntegracao(this.filial, String.valueOf(codigoOrigemPaciente), !ParametrosGerais.getTipoIntegracao().equals("N"), 7);
                } else {
                    buf.setLength(0);
                    buf.append("select pac_codigo from paciente where fil_codigo = ").append(this.filial);
                    buf.append(" and pac_codigoapoiado = '").append(StringUtil.textoDB(p.getCodigo())).append("'");
                    buf.append(" and con_codigo is null ");
                    try {
                        ResultSet rs = Conexao.executeQuery(st, buf);
                        if (rs.next()) {
                            codigo = rs.getString("pac_codigo");
                        } else if (!Funcoes.textoVazio(p.getCodigoApoiado()) && Funcoes.isNumeric(p.getCodigoApoiado())) {
                            codigo = p.getCodigoApoiado();
                        }
                    }
                    catch (SQLException ex) {
                        Servidor.mensagemLog(this.bufferLog, ex.getMessage());
                    }
                }
                if (Funcoes.isNumeric(codigo)) {
                    String tipoLogradouro = Tipos.tipoLogradouroDescricao(p.getTipoLogradouro());
                    SalvaDados salvar = new SalvaDados("paciente", p.getOperacao().equals("I") ? 0 : 2);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, this.filial);
                    salvar.adicionaCampo("pac_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("pac_nome", 0, true, false, StringUtil.textoDB(p.getNome()));
                    salvar.adicionaCampo("pac_sexo", 0, true, false, StringUtil.textoDB(p.getSexo().toUpperCase()));
                    salvar.adicionaCampo("pac_datanasc", 1, true, false, p.getDataNascimento());
                    salvar.adicionaCampo("pac_vip", 4, true, false, false);
                    salvar.adicionaCampo("pac_grpsangue", 0, true, false, "");
                    salvar.adicionaCampo("pac_fatorrh", 0, true, false, "");
                    salvar.adicionaCampo("pac_fatordu", 0, true, false, "");
                    salvar.adicionaCampo("pac_cor", 0, true, false, "B");
                    salvar.adicionaCampo("pac_observ", 0, true, false, StringUtil.textoDB(p.getObservacao()));
                    salvar.adicionaCampo("pac_senhaweb", 0, true, false, StringUtil.textoDB(senhaWeb));
                    salvar.adicionaCampo("pac_fumante", 0, true, false, "I");
                    salvar.adicionaCampo("pac_diabetico", 0, true, false, "I");
                    salvar.adicionaCampo("pac_maladireta", 4, true, false, true);
                    salvar.adicionaCampo("pac_rg", 0, true, false, StringUtil.textoDB(p.getRg()));
                    salvar.adicionaCampo("pac_cpf", 0, true, false, StringUtil.textoDB(p.getCpf()));
                    salvar.adicionaCampo("pac_tipopessoa", 0, true, false, "F");
                    salvar.adicionaCampo("pac_pai", 0, true, false, StringUtil.textoDB(p.getPai()));
                    salvar.adicionaCampo("pac_mae", 0, true, false, StringUtil.textoDB(p.getMae()));
                    salvar.adicionaCampo("pac_estcivil", 0, true, false, "I");
                    if (p.getOperacao().equals("I")) {
                        salvar.adicionaCampo("pac_datahora", 5, true, false, 0);
                        salvar.adicionaCampo("usr_codigo", 0, true, false, StringUtil.textoDB(this.codigoUsuario));
                    }
                    salvar.adicionaCampo("pac_datahoraalteracao", 5, true, false, 0);
                    salvar.adicionaCampo("usr_codalteracao", 0, true, false, StringUtil.textoDB(this.codigoUsuario));
                    salvar.adicionaCampo("pac_fax", 0, true, false, StringUtil.textoDB(p.getFax()));
                    salvar.adicionaCampo("pac_celular", 0, true, false, StringUtil.textoDB(p.getCelular()));
                    salvar.adicionaCampo("pac_fonecomercial", 0, true, false, StringUtil.textoDB(p.getFoneComercial()));
                    salvar.adicionaCampo("pac_fone", 0, true, false, StringUtil.textoDB(p.getFone()));
                    salvar.adicionaCampo("pac_complemento", 0, true, false, StringUtil.textoDB(p.getComplemento()));
                    salvar.adicionaCampo("pac_endereco", 0, true, false, StringUtil.textoDB(Funcoes.textoVazio(p.getNumeroEndereco()) ? tipoLogradouro + " " + p.getEndereco() : tipoLogradouro + " " + p.getEndereco().trim() + ", " + p.getNumeroEndereco()));
                    salvar.adicionaCampo("pac_email", 0, true, false, StringUtil.textoDB(p.getEmail()));
                    salvar.adicionaCampo("pac_anomes", 0, true, false, p.getAnoMes());
                    salvar.adicionaCampo("pac_idade", 2, true, false, p.getIdade());
                    salvar.adicionaCampo("pac_cep", 0, true, false, StringUtil.textoDB(p.getCep()));
                    salvar.adicionaCampo("pac_nomecontato", 0, true, false, StringUtil.textoDB(p.getContato()));
                    salvar.adicionaCampo("pac_fonecontato", 0, true, false, StringUtil.textoDB(p.getFoneContato()));
                    salvar.adicionaCampo("pac_codigoapoiado", 0, true, false, String.valueOf(p.getCodigo()));
                    try {
                        DBUtil.gravaAutoCopia(this.filial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaPaciente(), "paciente", Integer.parseInt(codigo), false, codigoOrigemPaciente, null);
                        if (p.getOperacao().equals("A")) {
                            salvar.limpar();
                            salvar.setTabela("pacientelabexterno");
                            salvar.setOperacao(2);
                            salvar.adicionaCampo("fil_codigo", 2, false, true, this.filial);
                            salvar.adicionaCampo("pac_codigo", 2, false, true, codigo);
                            salvar.adicionaCampo("ple_exportado", 4, false, false, false);
                            DBUtil.gravaAutoCopia(this.filial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaPaciente(), null, -1, false, -1L, null);
                        }
                        this.exportarWeb(st, codigo, senhaWeb, p);
                        Conexao.arquivaSQL();
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        Servidor.mensagemLog(this.bufferLog, e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            try {
                ProcessaRecebimento.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    private void exportarWeb(Statement st, String codigoJalis, String senhaWeb, DadosPaciente p) throws SQLException {
        String baseWeb = "";
        FilialService filService = new FilialService();
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, this.filial);
        if (Funcoes.carregouVO(filialVO)) {
            if (Funcoes.isExportarBaseWeb(filialVO) && !Funcoes.textoVazio(baseWeb)) {
                String[] comando = new String[]{"codigoBase", filialVO.getTipoBase(), "codigoPaciente", codigoJalis, "nomePaciente", StringUtil.textoDB(p.getNome()), "senhaPaciente", StringUtil.textoDB(senhaWeb), "cpfPaciente", StringUtil.textoDB(p.getCpf())};
                DBUtil.insereExportaWeb(this.filial, st, "paciente", p.getOperacao().equals("I") ? "I" : "A", comando);
            }
            Statement st2 = Conexao.getStatement();
            if (!Funcoes.textoVazio(StringUtil.getValor(ParametrosGerais.getCopiaPaciente(), "filiais"))) {
                ArrayList<FilialVOAux> listFiliais = filService.getListFilialVOExportaBaseWeb(StringUtil.getValor(ParametrosGerais.getCopiaPaciente(), "filiais"));
                for (FilialVOAux fil : listFiliais) {
                    if (!Funcoes.carregouVO(fil) || !this.isGerarComando(fil)) continue;
                    String[] comando = new String[]{"codigoBase", fil.getTipoBase(), "codigoPaciente", codigoJalis, "nomePaciente", StringUtil.textoDB(p.getNome()), "senhaPaciente", StringUtil.textoDB(senhaWeb), "cpfPaciente", StringUtil.textoDB(p.getCpf())};
                    DBUtil.insereExportaWeb(String.valueOf(fil.getCodigo()), st2, "paciente", p.getOperacao().equals("I") ? "I" : "A", comando);
                }
            }
        }
    }

    private boolean isGerarComando(FilialVOAux fil) {
        return !Funcoes.textoVazio(fil.getTipoBase()) && fil.getCodigo().equals(Integer.parseInt(this.filial));
    }

    public void adicionaPaciente(DadosPaciente p) {
        this.pacientes.add(p);
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }

    public void setUsuario(String usuario) {
        this.codigoUsuario = usuario;
    }
}

