/*
 * Decompiled with CFR 0.152.
 */
package jalis.integradores.pacientes;

import jalis.integradores.pacientes.DadosPaciente;
import jalis.integradores.pacientes.Servidor;
import jalis.integradores.pacientes.SocketCliente;
import jalis.integradores.pacientes.SocketClienteListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;

class ProcessaEnvio
extends Thread {
    private ArrayList<DadosPaciente> pacientes = new ArrayList();
    private boolean executar = true;
    private BufferedWriter bufferLog;
    private String ipServidor;
    private int portaServidor;
    private String pathTemporario = "";
    private boolean gravarTemporario = false;
    private int contador = 0;

    public ProcessaEnvio(BufferedWriter buffer) {
        super("ProcessaEnvio - Thread");
        this.bufferLog = buffer;
    }

    public void setServidor(String ipServidor, int portaServidor) {
        this.ipServidor = ipServidor;
        this.portaServidor = portaServidor;
    }

    public void setPathTemporario(String path) {
        if (path != null && !Funcoes.textoVazio(path)) {
            this.pathTemporario = path;
            this.gravarTemporario = true;
            if (!this.pathTemporario.endsWith("/")) {
                this.pathTemporario = this.pathTemporario + "/";
            }
        }
    }

    public void parar() {
        this.executar = false;
    }

    @Override
    public void run() {
        while (this.executar) {
            block11: {
                if (this.pacientes.size() > 0) {
                    final DadosPaciente p = this.pacientes.get(0);
                    try {
                        Servidor.mensagemLog(this.bufferLog, "Conectando no servidor integrador em " + this.ipServidor + ":" + this.portaServidor);
                        final SocketCliente cliente = new SocketCliente(new Socket(this.ipServidor, this.portaServidor));
                        Thread.sleep(300L);
                        if (cliente.isConnected()) {
                            cliente.addSocketClienteListener(new SocketClienteListener(){

                                @Override
                                public void mensagemLida(SocketCliente socket, String mensagem) {
                                    if (mensagem.equals("<pacienterecebido/>")) {
                                        Servidor.mensagemLog(ProcessaEnvio.this.bufferLog, "Paciente " + p.getCodigo() + " recebido com sucesso");
                                        cliente.fechar();
                                        ProcessaEnvio.this.pacientes.remove(p);
                                        if (ProcessaEnvio.this.gravarTemporario && ProcessaEnvio.this.contador > 0) {
                                            ProcessaEnvio.this.contador = 0;
                                        }
                                    } else if (mensagem.equals("<reenviarpaciente/>")) {
                                        cliente.escreverMensagem(StringUtil.tratarEntidadesHTML(p.getXML(), false, false));
                                        Servidor.mensagemLog(ProcessaEnvio.this.bufferLog, "Reenviando paciente " + p.getCodigo());
                                        if (ProcessaEnvio.this.validaContagemErro(ProcessaEnvio.this.contador++, p)) {
                                            cliente.fechar();
                                            Servidor.mensagemLog(ProcessaEnvio.this.bufferLog, "Servidor nao respondeu por 3 vezes seguidas, ignorando envio do paciente " + p.getCodigo());
                                            if (ProcessaEnvio.this.gravarTemporario && ProcessaEnvio.this.contador > 0) {
                                                ProcessaEnvio.this.contador = 0;
                                            }
                                        }
                                    }
                                }
                            });
                            cliente.escreverMensagem(StringUtil.tratarEntidadesHTML(p.getXML(), false, false));
                        }
                    }
                    catch (UnknownHostException e) {
                        Servidor.mensagemLog(this.bufferLog, "Host do servidor desconhecido");
                        if (this.validaContagemErro(this.contador++, p)) {
                            this.contador = 0;
                        }
                    }
                    catch (IOException e) {
                        Servidor.mensagemLog(this.bufferLog, "Servidor sem permissao de escrita");
                        if (this.validaContagemErro(this.contador++, p)) {
                            this.contador = 0;
                        }
                    }
                    catch (InterruptedException ie) {
                        Servidor.mensagemLog(this.bufferLog, "Erro ao esperar nova conexao");
                        if (!this.validaContagemErro(this.contador++, p)) break block11;
                        this.contador = 0;
                    }
                }
            }
            try {
                ProcessaEnvio.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    private boolean validaContagemErro(int contador, DadosPaciente p) {
        if (this.gravarTemporario && contador == 3) {
            String arquivo = Funcoes.preencheZero(p.getCodigo(), 8) + "_" + Funcoes.formataData("ddMMyyyyHHmmssZ", new Date());
            this.pacientes.remove(p);
            try {
                StringUtil.escreverArquivoTexto(this.pathTemporario + arquivo, p.getXML());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void adicionaPaciente(DadosPaciente p) {
        Servidor.mensagemLog(this.bufferLog, "Paciente adicionado para envio (Jalis): " + p.getCodigo());
        this.pacientes.add(p);
    }
}

