/*
 * Decompiled with CFR 0.152.
 */
package jalis.integradores.pacientes;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class DadosPaciente {
    public static final String INCLUSAO = "I";
    public static final String ALTERACAO = "A";
    public static final String EXCLUSAO = "E";
    public static final String XML_CODIGO = "codigo";
    public static final String XML_NOME = "nome";
    public static final String XML_SEXO = "sexo";
    public static final String XML_DATANASCIMENTO = "datanascimento";
    public static final String XML_RG = "rg";
    public static final String XML_CPF = "cpf";
    public static final String XML_DATAHORACADASTRO = "datahoracadastro";
    public static final String XML_CIDADE = "cidade";
    public static final String XML_ENDERECO = "endereco";
    public static final String XML_COMPLEMENTO = "complemento";
    public static final String XML_BAIRRO = "bairro";
    public static final String XML_CEP = "cep";
    public static final String XML_EMAIL = "email";
    public static final String XML_IDADE = "idade";
    public static final String XML_ANOMES = "anomes";
    public static final String XML_MAE = "mae";
    public static final String XML_PAI = "pai";
    public static final String XML_FONE = "fone";
    public static final String XML_FAX = "fax";
    public static final String XML_CELULAR = "celular";
    public static final String XML_FONECOMERCIAL = "fonecomercial";
    public static final String XML_CONTATO = "contato";
    public static final String XML_FONECONTATO = "fonecontato";
    public static final String XML_OBSERVACAO = "observacao";
    public static final String XML_OPERACAO = "operacao";
    public static final String XML_CODIGO_APOIADO = "codigooriginal";
    public static final String XML_HASH = "hash";
    private String codigo;
    private String nome;
    private String sexo = "F";
    private Date dataNascimento;
    private String rg;
    private String cpf;
    private String dataHoraCadastro;
    private String cidade;
    private String endereco;
    private String numeroEndereco;
    private String tipoLogradouro;
    private String complemento;
    private String bairro;
    private String cep;
    private String email;
    private int idade = -1;
    private String anoMes = "A";
    private String mae;
    private String pai;
    private String fone;
    private String fax;
    private String celular;
    private String foneComercial;
    private String contato;
    private String foneContato;
    private String observacao;
    private String codigoOriginal = "";
    private String operacao = "I";
    private String hashCalculado;
    private StringBuilder hash = new StringBuilder();

    public DadosPaciente(String codigo, String nome, String sexo, String operacao) {
        this.codigo = codigo;
        this.nome = nome;
        this.sexo = sexo;
        this.operacao = operacao;
    }

    public static DadosPaciente getPaciente(String xml) {
        String tmp;
        String paciente = StringUtil.getValor(xml, "paciente");
        if (Funcoes.textoVazio(paciente)) {
            return null;
        }
        String codigo = StringUtil.getValor(paciente, XML_CODIGO);
        String nome = StringUtil.getValor(paciente, XML_NOME);
        String sexo = StringUtil.getValor(paciente, XML_SEXO);
        String operacao = INCLUSAO;
        if (!Funcoes.textoVazio(StringUtil.getValor(paciente, XML_OPERACAO))) {
            operacao = StringUtil.getValor(paciente, XML_OPERACAO);
        }
        DadosPaciente p = new DadosPaciente(codigo, nome, sexo, operacao);
        if (Funcoes.verificaData(StringUtil.getValor(paciente, XML_DATANASCIMENTO))) {
            p.setDataNascimento(Funcoes.stringToDate(StringUtil.getValor(paciente, XML_DATANASCIMENTO)));
        }
        p.setRg(StringUtil.getValor(paciente, XML_RG));
        p.setCpf(StringUtil.getValor(paciente, XML_CPF));
        if (Funcoes.verificaData(StringUtil.getValor(paciente, XML_DATAHORACADASTRO))) {
            p.setDataHoraCadastro(StringUtil.getValor(paciente, XML_DATAHORACADASTRO).toUpperCase());
        }
        p.setCidade(StringUtil.getValor(paciente, XML_CIDADE));
        p.setEndereco(StringUtil.getValor(paciente, XML_ENDERECO));
        p.setComplemento(StringUtil.getValor(paciente, XML_COMPLEMENTO));
        p.setBairro(StringUtil.getValor(paciente, XML_BAIRRO));
        p.setCEP(StringUtil.getValor(paciente, XML_CEP));
        p.setEmail(StringUtil.getValor(paciente, XML_EMAIL));
        if (Funcoes.isNumeric(StringUtil.getValor(paciente, XML_IDADE))) {
            p.setIdade(Integer.parseInt(StringUtil.getValor(paciente, XML_IDADE)));
            p.setAnoMes(StringUtil.getValor(paciente, XML_ANOMES));
        }
        if (Funcoes.isNumeric(tmp = StringUtil.getValor(paciente, XML_CODIGO_APOIADO)) && Long.parseLong(tmp) > -1L) {
            p.setCodigoApoiado(tmp);
        }
        p.setMae(StringUtil.getValor(paciente, XML_MAE));
        p.setPai(StringUtil.getValor(paciente, XML_PAI));
        p.setFone(StringUtil.getValor(paciente, XML_FONE));
        p.setFax(StringUtil.getValor(paciente, XML_FAX));
        p.setCelular(StringUtil.getValor(paciente, XML_CELULAR));
        p.setFoneComercial(StringUtil.getValor(paciente, XML_FONECOMERCIAL));
        p.setContato(StringUtil.getValor(paciente, XML_CONTATO));
        p.setFoneContato(StringUtil.getValor(paciente, XML_FONECONTATO));
        p.setObservacao(StringUtil.getValor(paciente, XML_OBSERVACAO));
        p.setHash(StringUtil.getValor(paciente, XML_HASH));
        return p;
    }

    private String armazenarHash(String s) {
        this.hash.append(s);
        return s;
    }

    public String getXML() {
        this.hash.setLength(0);
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("paciente");
            xml.escrever(XML_CODIGO, this.armazenarHash(this.codigo));
            xml.escrever(XML_NOME, this.armazenarHash(this.nome));
            xml.escrever(XML_SEXO, this.armazenarHash(this.sexo != null ? (this.sexo.length() > 1 ? this.sexo.substring(0, 1) : this.sexo) : "M"));
            if (this.dataNascimento != null) {
                xml.escrever(XML_DATANASCIMENTO, this.armazenarHash(Funcoes.formataData("dd/MM/yyyy", this.dataNascimento)));
            }
            if (!Funcoes.textoVazio(this.rg)) {
                xml.escrever(XML_RG, this.armazenarHash(this.rg));
            }
            if (!Funcoes.textoVazio(this.cpf)) {
                xml.escrever(XML_CPF, this.armazenarHash(this.cpf.length() > 14 ? this.cpf.substring(0, 14) : this.cpf));
            }
            if (Funcoes.verificaData("dd/MM/yyyy HH:mm", this.dataHoraCadastro)) {
                xml.escrever(XML_DATAHORACADASTRO, this.armazenarHash(this.dataHoraCadastro));
            }
            if (!Funcoes.textoVazio(this.cidade)) {
                xml.escrever(XML_CIDADE, this.armazenarHash(this.cidade));
            }
            if (!Funcoes.textoVazio(this.endereco)) {
                xml.escrever(XML_ENDERECO, this.armazenarHash(!Funcoes.textoVazio(this.numeroEndereco) ? this.tipoLogradouro + " " + this.endereco + ", " + this.numeroEndereco : this.endereco));
            }
            if (!Funcoes.textoVazio(this.complemento)) {
                xml.escrever(XML_COMPLEMENTO, this.armazenarHash(this.complemento));
            }
            if (!Funcoes.textoVazio(this.bairro)) {
                xml.escrever(XML_BAIRRO, this.armazenarHash(this.bairro));
            }
            if (!Funcoes.textoVazio(this.cep)) {
                xml.escrever(XML_CEP, this.armazenarHash(this.cep.length() > 9 ? this.cep.substring(0, 9) : this.cep));
            }
            if (!Funcoes.textoVazio(this.email)) {
                xml.escrever(XML_EMAIL, this.armazenarHash(this.email));
            }
            if (this.idade > -1) {
                xml.escrever(XML_IDADE, this.armazenarHash(String.valueOf(this.idade)));
            }
            if (this.idade > -1) {
                xml.escrever(XML_ANOMES, this.armazenarHash(this.anoMes));
            }
            if (!Funcoes.textoVazio(this.mae)) {
                xml.escrever(XML_MAE, this.armazenarHash(this.mae));
            }
            if (!Funcoes.textoVazio(this.pai)) {
                xml.escrever(XML_PAI, this.armazenarHash(this.pai));
            }
            if (!Funcoes.textoVazio(this.fone)) {
                xml.escrever(XML_FONE, this.armazenarHash(this.fone));
            }
            if (!Funcoes.textoVazio(this.fax)) {
                xml.escrever(XML_FAX, this.armazenarHash(this.fax));
            }
            if (!Funcoes.textoVazio(this.celular)) {
                xml.escrever(XML_CELULAR, this.armazenarHash(this.celular));
            }
            if (!Funcoes.textoVazio(this.foneComercial)) {
                xml.escrever(XML_FONECOMERCIAL, this.armazenarHash(this.foneComercial));
            }
            if (!Funcoes.textoVazio(this.contato)) {
                xml.escrever(XML_CONTATO, this.armazenarHash(this.contato));
            }
            if (!Funcoes.textoVazio(this.foneContato)) {
                xml.escrever(XML_FONECONTATO, this.armazenarHash(this.foneContato));
            }
            if (!Funcoes.textoVazio(this.observacao)) {
                xml.escrever(XML_OBSERVACAO, this.armazenarHash(this.observacao));
            }
            if (!Funcoes.textoVazio(this.codigoOriginal)) {
                xml.escrever(XML_CODIGO_APOIADO, this.armazenarHash(this.codigoOriginal));
            }
            xml.escrever(XML_OPERACAO, this.armazenarHash(this.operacao.equalsIgnoreCase(INCLUSAO) ? INCLUSAO : (this.operacao.equalsIgnoreCase(EXCLUSAO) ? EXCLUSAO : ALTERACAO)));
            this.hashCalculado = StringUtil.calcularCodigoHash(this.hash.toString());
            xml.escrever(XML_HASH, this.hashCalculado);
            xml.fechar("paciente");
            return xml.getXML();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setSexo(String sexo) {
        this.sexo = sexo;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public void setDataHoraCadastro(Date dataHoraCadastro) {
        if (dataHoraCadastro != null) {
            this.dataHoraCadastro = Funcoes.formataData("dd/MM/yyyy HH:mm", dataHoraCadastro);
        }
    }

    public void setDataHoraCadastro(String dataHoraCadastro) {
        if (Funcoes.verificaData(dataHoraCadastro)) {
            this.dataHoraCadastro = dataHoraCadastro;
        }
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public void setNumeroEndereco(String numeroEndereco) {
        this.numeroEndereco = numeroEndereco;
    }

    public void setTipologradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public void setCEP(String cep) {
        this.cep = cep;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCodigoApoiado(String codigo) {
        this.codigoOriginal = codigo;
    }

    public void setIdade(int idade) {
        this.idade = idade;
    }

    public void setAnoMes(String anoMes) {
        this.anoMes = anoMes;
    }

    public void setMae(String mae) {
        this.mae = mae;
    }

    public void setPai(String pai) {
        this.pai = pai;
    }

    public void setFone(String fone) {
        this.fone = fone;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public void setFoneComercial(String foneComercial) {
        this.foneComercial = foneComercial;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public void setFoneContato(String foneContato) {
        this.foneContato = foneContato;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setHash(String hashCalculado) {
        this.hashCalculado = hashCalculado;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public String getSexo() {
        return this.sexo;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public String getRg() {
        return this.rg;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getDataHoraCadastro() {
        return this.dataHoraCadastro;
    }

    public String getCidade() {
        return this.cidade;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public String getNumeroEndereco() {
        return this.numeroEndereco;
    }

    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getCep() {
        return this.cep;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCodigoApoiado() {
        return this.codigoOriginal;
    }

    public int getIdade() {
        return this.idade;
    }

    public String getAnoMes() {
        return this.anoMes;
    }

    public String getMae() {
        return this.mae;
    }

    public String getPai() {
        return this.pai;
    }

    public String getFone() {
        return this.fone;
    }

    public String getFax() {
        return this.fax;
    }

    public String getCelular() {
        return this.celular;
    }

    public String getFoneComercial() {
        return this.foneComercial;
    }

    public String getContato() {
        return this.contato;
    }

    public String getFoneContato() {
        return this.foneContato;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public String getOperacao() {
        return this.operacao;
    }

    public String getHash() {
        return this.hashCalculado;
    }

    public String calcularHash() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.codigo);
        buf.append(this.nome);
        buf.append(this.sexo);
        if (this.dataNascimento != null) {
            buf.append(Funcoes.formataData("dd/MM/yyyy", this.dataNascimento));
        }
        if (!Funcoes.textoVazio(this.rg)) {
            buf.append(this.rg);
        }
        if (!Funcoes.textoVazio(this.cpf)) {
            buf.append(this.cpf);
        }
        if (this.dataHoraCadastro != null) {
            buf.append(this.dataHoraCadastro);
        }
        if (!Funcoes.textoVazio(this.cidade)) {
            buf.append(this.cidade);
        }
        if (!Funcoes.textoVazio(this.endereco)) {
            buf.append(this.endereco);
        }
        if (!Funcoes.textoVazio(this.complemento)) {
            buf.append(this.complemento);
        }
        if (!Funcoes.textoVazio(this.bairro)) {
            buf.append(this.bairro);
        }
        if (!Funcoes.textoVazio(this.cep)) {
            buf.append(this.cep);
        }
        if (!Funcoes.textoVazio(this.email)) {
            buf.append(this.email);
        }
        if (this.idade > -1) {
            buf.append(this.idade);
            buf.append(this.anoMes);
        }
        if (!Funcoes.textoVazio(this.mae)) {
            buf.append(this.mae);
        }
        if (!Funcoes.textoVazio(this.pai)) {
            buf.append(this.pai);
        }
        if (!Funcoes.textoVazio(this.fone)) {
            buf.append(this.fone);
        }
        if (!Funcoes.textoVazio(this.fax)) {
            buf.append(this.fax);
        }
        if (!Funcoes.textoVazio(this.celular)) {
            buf.append(this.celular);
        }
        if (!Funcoes.textoVazio(this.foneComercial)) {
            buf.append(this.foneComercial);
        }
        if (!Funcoes.textoVazio(this.contato)) {
            buf.append(this.contato);
        }
        if (!Funcoes.textoVazio(this.foneContato)) {
            buf.append(this.foneContato);
        }
        if (!Funcoes.textoVazio(this.observacao)) {
            buf.append(this.observacao);
        }
        if (!Funcoes.textoVazio(this.codigoOriginal)) {
            buf.append(this.codigoOriginal);
        }
        buf.append(this.operacao);
        try {
            return StringUtil.calcularCodigoHash(buf.toString());
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }
}

