/*
 * Decompiled with CFR 0.152.
 */
package jalis.integradores.pacientes;

import jalis.integradores.pacientes.DadosPaciente;
import jalis.integradores.pacientes.SocketCliente;
import jalis.integradores.pacientes.SocketClienteListener;
import jalis.util.StringUtil;
import java.net.Socket;

public class Cliente
implements SocketClienteListener {
    private SocketCliente socket;
    private DadosPaciente ultimoPaciente = null;
    private final boolean DEBUG = true;

    public boolean conectar(String ip) {
        boolean retorno = false;
        try {
            this.socket = new SocketCliente(new Socket(ip, 4447));
            Thread.sleep(300L);
            this.socket.addSocketClienteListener(this);
            retorno = this.socket.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void enviarPaciente(DadosPaciente p) {
        if (this.socket != null && this.socket.isConnected()) {
            if (this.ultimoPaciente != p) {
                this.ultimoPaciente = p;
            }
            try {
                Thread.sleep(350L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.socket.escreverMensagem("<pacientejalis>" + this.converteAcentosParaHtml(p.getXML()) + "</pacientejalis>");
        }
    }

    @Override
    public void mensagemLida(SocketCliente socket, String mensagem) {
        if (mensagem.equals("<pacienterecebido/>")) {
            this.fecharCliente();
        } else if (mensagem.equals("<reenviarpaciente/>")) {
            this.enviarPaciente(this.ultimoPaciente);
        }
    }

    public static void main(String[] args) {
        int i = 0;
        while (i++ < 1) {
            Cliente c = new Cliente();
            String tmp = "Teste de mensagem com v\u00e1rios acentos e com \u00e7, \u00e1 \u00e9 \u00ed \u00f3 \u00fa \u00c7 \u00c1 \u00c9 \u00cd ' & ~ \u00e3 ";
            System.out.println(tmp);
            tmp = c.converteAcentosParaHtml(tmp);
            System.out.println(tmp);
            System.out.println(StringUtil.converteHtmlParaAcentos(tmp));
            System.exit(0);
        }
    }

    public void fecharCliente() {
        if (this.socket != null && this.socket.isConnected()) {
            this.socket.escreverMensagem("<fechar/>");
            this.socket.fechar();
        }
    }

    private String converteAcentosParaHtml(String xml) {
        return StringUtil.tratarEntidadesHTML(xml, false, false);
    }
}

