/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.util;

import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.laboratorio.Laboratorio;

public class TimerIntegracaoOperadora
extends Thread {
    private static boolean parar = false;
    private static boolean aguardar = false;
    private static boolean isExecutando = false;
    private static final int TEMPO_ESPERA = 33000;
    private AbstractIntegracaoOperadora integracaoOperadora = null;
    private DadosErrosIntegracaoOperadora erros = null;

    public TimerIntegracaoOperadora(AbstractIntegracaoOperadora integracaoOperadora, DadosErrosIntegracaoOperadora erros) {
        super("Thread - IntegracaoOperadora (" + integracaoOperadora.getNomeIntegracaoOperadora() + ")");
        this.setPriority(1);
        this.integracaoOperadora = integracaoOperadora;
        this.erros = erros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!parar) {
            try {
                if (aguardar) continue;
                this.fireIntegracaoIniciada();
                this.erros.errosEnvioResultado.clear();
                this.erros.errosLogin.clear();
                this.erros.errosProcesso.clear();
                this.erros = this.integracaoOperadora.integrarOperadora();
                StringBuilder bufProcesso = new StringBuilder();
                StringBuilder bufOperadora = new StringBuilder();
                if (this.erros != null && this.erros.haErros()) {
                    String erro = "<html>";
                    erro = erro + "<font color = 'red'><b>Clique para visualizar a janela de erros</b></font><br>";
                    if (this.erros.errosProcesso != null && this.erros.errosProcesso.size() > 0) {
                        bufProcesso.append("<b>-- ").append(this.erros.errosProcesso.size()).append(" erro(s) ao processar --</b><br>");
                        for (Exception exception : this.erros.errosProcesso) {
                            if (exception instanceof IntegracaoOperadoraException) {
                                bufProcesso.append(((IntegracaoOperadoraException)exception).getMensagemErro()).append("<br>");
                                continue;
                            }
                            bufProcesso.append(exception.getMessage()).append("<br>");
                        }
                    }
                    erro = erro + bufProcesso.toString();
                    if (this.erros.errosLogin != null && this.erros.errosLogin.size() > 0 || this.erros.errosEnvioResultado != null && this.erros.errosEnvioResultado.size() > 0) {
                        bufOperadora.append("<b>-- ").append(this.erros.errosLogin.size() + this.erros.errosEnvioResultado.size()).append(" erro(s) ao integrar com operadora de sa\u00fade. --</b><br>");
                        for (Exception exception : this.erros.errosLogin) {
                            if (exception instanceof IntegracaoOperadoraException) {
                                bufOperadora.append(((IntegracaoOperadoraException)exception).getMensagemErro()).append("<br>");
                                continue;
                            }
                            bufOperadora.append(exception.getMessage()).append("<br>");
                        }
                        for (Exception exception : this.erros.errosEnvioResultado) {
                            if (exception instanceof IntegracaoOperadoraException) {
                                bufOperadora.append(((IntegracaoOperadoraException)exception).getMensagemErro()).append("<br>");
                                continue;
                            }
                            bufOperadora.append(exception.getMessage()).append("<br>");
                        }
                    }
                    erro = erro + bufOperadora.toString();
                    erro = erro + "</html>";
                    Laboratorio.setIconeIntegracaoOperadora(this.integracaoOperadora, AbstractIntegracaoOperadora.ICONE_ERRO);
                    Laboratorio.setHintIntegracaoOperadora(this.integracaoOperadora, erro);
                    continue;
                }
                Laboratorio.setIconeIntegracaoOperadora(this.integracaoOperadora, AbstractIntegracaoHospital.ICONE_PARADO);
                Laboratorio.setHintIntegracaoOperadora(this.integracaoOperadora, null);
            }
            catch (Exception ex) {
                Laboratorio.setIconeIntegracaoOperadora(this.integracaoOperadora, AbstractIntegracaoHospital.ICONE_ERRO);
                String erro = "<html>";
                erro = erro + "<b>Nenhum log em exporta\u00e7\u00e3o</b><br></html>";
                Laboratorio.setHintIntegracaoOperadora(this.integracaoOperadora, erro);
            }
            finally {
                this.fireIntegracaoFinalizada();
                try {
                    TimerIntegracaoOperadora.sleep(33000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void fireIntegracaoFinalizada() {
        isExecutando = false;
    }

    private void fireIntegracaoIniciada() {
        isExecutando = true;
    }

    public static boolean isExecutando() {
        return isExecutando;
    }

    public void parar() {
        parar = true;
    }
}

