/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.util;

import jalis.laboratorio.Laboratorio;
import jalis.util.logger.ErrorLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUtil {
    FTPClient ftp = new FTPClient();

    public FtpUtil() {
    }

    public FtpUtil(String hostname, String login, String senha) throws Exception {
        int port = 0;
        String[] parts = hostname.split(":");
        if (parts.length == 2) {
            hostname = parts[0];
            port = Integer.parseInt(parts[1]);
        }
        if (port > 0) {
            this.ftp.connect(hostname, port);
        } else {
            this.ftp.connect(hostname);
        }
        this.ftp.login(login, senha);
        if (!FTPReply.isPositiveCompletion((int)this.erroFtp())) {
            this.ftp.disconnect();
        }
        this.ftp.setFileType(2);
        this.ftp.enterLocalPassiveMode();
    }

    public void conectar(String hostname, String login, String senha) throws Exception {
        this.ftp = new FTPClient();
        this.ftp.connect(hostname);
        this.ftp.login(login, senha);
        if (!FTPReply.isPositiveCompletion((int)this.erroFtp())) {
            this.ftp.disconnect();
        }
        this.ftp.setFileType(2);
        this.ftp.enterLocalPassiveMode();
    }

    public boolean uploadAquivo(String localArquivo, String arquivoNome, String diretorio) throws Exception {
        boolean envio = false;
        try {
            FileInputStream arquivo = new FileInputStream(new File(localArquivo));
            envio = this.ftp.storeFile(diretorio + arquivoNome, (InputStream)arquivo);
            ((InputStream)arquivo).close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return envio;
    }

    public boolean uploadAquivoTexto(String texto, String arquivoNome, String diretorio) throws Exception {
        boolean envio = false;
        try {
            OutputStream saida = this.ftp.storeFileStream(diretorio + arquivoNome);
            saida.write(texto.getBytes());
            saida.close();
            saida.flush();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return envio;
    }

    public boolean verificaConexao(String arquivoNome, String diretorio) throws Exception {
        boolean envio = false;
        try {
            ByteArrayInputStream arquivo = new ByteArrayInputStream("testeConexao".getBytes());
            envio = this.ftp.storeFile(diretorio + arquivoNome, (InputStream)arquivo);
            ((InputStream)arquivo).close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return envio;
    }

    public int erroFtp() {
        int resposta = this.ftp.getReplyCode();
        return resposta;
    }

    public boolean isConnected() {
        return this.ftp.isConnected();
    }

    public void desconectar() {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.logout();
                this.ftp.disconnect();
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
    }
}

