/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfigurarValoresReferencia
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_DESCRICAO = 0;
    private static final int COLUNA_MINIMO = 1;
    private static final int COLUNA_MAXIMO = 2;
    private static final int COLUNA_UNIDADE = 3;
    private static final int COLUNA_OBSERVACOES = 4;
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelMinimo = new JLabel("Valor m\u00edn.");
    private JLabel labelMaximo = new JLabel("Valor max.");
    private JLabel labelUnidade = new JLabel("Un. Medida");
    private JLabel labelObservacoes = new JLabel("Observa\u00e7\u00f5es");
    private TTextField textDescricao = new TTextField(1000, 3);
    private TTextField textMinimo = new TTextField(10, 2);
    private TTextField textMaximo = new TTextField(10, 2);
    private TTextField textUnidade = new TTextField(50);
    private TTextField textObservacoes = new TTextField(2000);
    private JButton buttonOkAssociacao = new JButton("OK");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o", "M\u00ednimo", "M\u00e1ximo", "Un. Medida", "Observa\u00e7\u00f5es"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private int linhaEdicao = -1;

    public static ConfigurarValoresReferencia novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfigurarValoresReferencia((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new ConfigurarValoresReferencia((Frame)pai);
        }
        return null;
    }

    public ConfigurarValoresReferencia(Dialog pai) {
        super(pai, "Valores de refer\u00eancia");
        this.montaTela();
    }

    public ConfigurarValoresReferencia(Frame pai) {
        super(pai, "Valores de refer\u00eancia");
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelMinimo, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelMaximo, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelUnidade, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelObservacoes, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        panelCentral.add((Component)this.textDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        d = new Dimension(80, 20);
        this.textMinimo.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textMinimo.setMinimumSize(d);
        panelCentral.add((Component)this.textMinimo, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textMaximo.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textMaximo.setMinimumSize(d);
        panelCentral.add((Component)this.textMaximo, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textUnidade.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textUnidade.setMinimumSize(d);
        panelCentral.add((Component)this.textUnidade, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textObservacoes.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.textObservacoes.setMinimumSize(d);
        panelCentral.add((Component)this.textObservacoes, c);
        ++c.gridx;
        d = new Dimension(40, 20);
        this.buttonOkAssociacao.setMinimumSize(d);
        this.buttonOkAssociacao.setPreferredSize(d);
        this.buttonOkAssociacao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkAssociacao.addActionListener(this);
        this.buttonOkAssociacao.setMnemonic('K');
        panelCentral.add((Component)this.buttonOkAssociacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.modelo.setColumnSize(new int[]{0, 80}, this.table);
        d = new Dimension(20, 120);
        this.scroll.setMinimumSize(d);
        d = new Dimension(20, 120);
        this.scroll.setPreferredSize(d);
        panelCentral.add((Component)this.scroll, c);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfigurarValoresReferencia.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfigurarValoresReferencia.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfigurarValoresReferencia.this.modelo.removeLine(ConfigurarValoresReferencia.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfigurarValoresReferencia.this.table.getSelectedRow() > -1) {
                    ConfigurarValoresReferencia.this.linhaEdicao = ConfigurarValoresReferencia.this.table.getSelectedRow();
                    ConfigurarValoresReferencia.this.textDescricao.setText(ConfigurarValoresReferencia.this.modelo.getValueAt(ConfigurarValoresReferencia.this.linhaEdicao, 0).toString());
                    ConfigurarValoresReferencia.this.textMinimo.setText(Funcoes.formataDecimal(Double.valueOf(ConfigurarValoresReferencia.this.modelo.getValueAt(ConfigurarValoresReferencia.this.linhaEdicao, 1).toString())));
                    ConfigurarValoresReferencia.this.textMaximo.setText(Funcoes.formataDecimal(Double.valueOf(ConfigurarValoresReferencia.this.modelo.getValueAt(ConfigurarValoresReferencia.this.linhaEdicao, 2).toString())));
                    ConfigurarValoresReferencia.this.textUnidade.setText(ConfigurarValoresReferencia.this.modelo.getValueAt(ConfigurarValoresReferencia.this.linhaEdicao, 3).toString());
                    ConfigurarValoresReferencia.this.textObservacoes.setText(ConfigurarValoresReferencia.this.modelo.getValueAt(ConfigurarValoresReferencia.this.linhaEdicao, 4).toString());
                    ScreenUtil.requisitarFoco(ConfigurarValoresReferencia.this.textDescricao);
                }
            }
        });
        this.setSize(550, 350);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        ScreenUtil.requisitarFoco(this.textDescricao);
        Funcoes.montaEnter((JComponent)panelCentral);
    }

    public void setValores(String xml) {
        this.modelo.clear();
        if (!Funcoes.textoVazio(xml)) {
            String[] valores;
            for (String x : valores = StringUtil.getValores(xml, "valorreferencia")) {
                String descricao = StringUtil.getValor(x, "descricao");
                String minimo = StringUtil.getValor(x, "minimo");
                String maximo = StringUtil.getValor(x, "maximo");
                String unidade = StringUtil.getValor(x, "unidade");
                String observacoes = StringUtil.getValor(x, "observacao");
                this.modelo.addLine(new Object[]{descricao, minimo, maximo, unidade, observacoes});
            }
        }
    }

    public String getValores() {
        XMLStringBuilder xml = new XMLStringBuilder();
        if (this.modelo.getRowCount() > 0) {
            try {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    xml.abrir("valorreferencia");
                    xml.escrever("descricao", this.modelo.getValueAt(i, 0).toString());
                    xml.escrever("minimo", this.modelo.getValueAt(i, 1).toString());
                    xml.escrever("maximo", this.modelo.getValueAt(i, 2).toString());
                    xml.escrever("unidade", this.modelo.getValueAt(i, 3).toString());
                    xml.escrever("observacao", this.modelo.getValueAt(i, 4).toString());
                    xml.fechar("valorreferencia");
                }
                return xml.getXML();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBotaoOK()) {
            this.ok = true;
            this.dispose();
        } else if (e.getSource() == this.buttonOkAssociacao) {
            this.adicionaAssociacao();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionaAssociacao() {
        String descricao = this.textDescricao.getText();
        String minimo = this.textMinimo.getText();
        String maximo = this.textMaximo.getText();
        String unidade = this.textUnidade.getText();
        String observacoes = this.textObservacoes.getText();
        if (!this.validarCampos()) {
            return;
        }
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(descricao) || this.linhaEdicao >= 0 && this.linhaEdicao == i) continue;
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o j\u00e1 foi informada.", 2);
            return;
        }
        if (this.linhaEdicao > -1) {
            this.modelo.setValueAt(this.textDescricao.getText(), this.linhaEdicao, 0);
            if (!Funcoes.textoVazio(this.textMinimo.getText())) {
                this.modelo.setValueAt(Funcoes.formataDecimal(this.textMinimo.getMaskDecimal(), Double.parseDouble(this.textMinimo.getText())), this.linhaEdicao, 1);
            }
            if (!Funcoes.textoVazio(this.textMaximo.getText())) {
                this.modelo.setValueAt(Funcoes.formataDecimal(this.textMaximo.getMaskDecimal(), Double.parseDouble(this.textMaximo.getText())), this.linhaEdicao, 2);
            }
            this.modelo.setValueAt(this.textUnidade.getText(), this.linhaEdicao, 3);
            this.modelo.setValueAt(this.textObservacoes.getText(), this.linhaEdicao, 4);
            this.linhaEdicao = -1;
        } else {
            this.modelo.addLine(new Object[]{descricao, minimo, maximo, unidade, observacoes});
        }
        this.textDescricao.clear();
        this.textMinimo.clear();
        this.textMaximo.clear();
        this.textUnidade.clear();
        this.textObservacoes.clear();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private boolean validarCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.textMinimo.getText())) {
            Funcoes.mensagem(this, "O valor min\u00edmo deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textMinimo);
            return false;
        }
        if (Funcoes.textoVazio(this.textMaximo.getText())) {
            Funcoes.mensagem(this, "O valor m\u00e1ximo deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textMaximo);
            return false;
        }
        if (Funcoes.textoVazio(this.textUnidade.getText())) {
            Funcoes.mensagem(this, "A unidade de medida deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textUnidade);
            return false;
        }
        return true;
    }
}

