/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.upy;

import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LAUDOSPortTypeProxy;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINInput;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINInputHASHVARCHAR2OUT;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINInputLOGINVALIDOVARCHAR2OUT;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.LOGINOutput;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.RESULTADOSEXAMESInput;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.RESULTADOSEXAMESInputRESULTADOSEXAMESXMLTYPEINOUT;
import com.oracle.xmlns.orawsv.WEBSERVICE.LAUDOS.RESULTADOSEXAMESOutput;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.upy.AcaoExame;
import jalis.integracaooperadoras.sistemas.upy.ConfiguradorIntegracaoOperadoraUpy;
import jalis.integracaooperadoras.sistemas.upy.ConfiguradorResultadoUpy;
import jalis.integracaooperadoras.sistemas.upy.Exame;
import jalis.integracaooperadoras.sistemas.upy.ExameRealizado;
import jalis.integracaooperadoras.sistemas.upy.FormatoArquivoLaudo;
import jalis.integracaooperadoras.sistemas.upy.Guia;
import jalis.integracaooperadoras.sistemas.upy.Resultado;
import jalis.integracaooperadoras.sistemas.upy.TipoDadoResultado;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.message.MessageElement;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IntegracaoOperadoraUpy
extends AbstractIntegracaoOperadora {
    private String xmlConfiguracao;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String HINT_AGUARDANDO_WS = "AGUARDANDO RETORNO DO WEBSERVICE DO UPY";
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DO UPY";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_BUSCA_DADOS = "buscando dados";
    private static final String PROCESSO_LOGIN = "efetuando login no webservice";
    private static final String PROCESSO_MONTA_LABORATORIO = "montando dados do laborat\u00f3rio";
    private static final String PROCESSO_MONTA_EXAME = "montando dados do exame";
    private static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";
    private static final String PROCESSO_BUSCA_LOGS = "buscando logs de integra\u00e7\u00e3o";
    private static final String PROCESSO_INTEGRAR_DADOS = "integrando dados";
    private static final String PROCESSO_SOLICITA_ENVIO_RESULTADO = "solicitando envio de resultado";
    private static final String PROCESSO_ENVIA_RESULTADO = "enviando resultado";
    private static final String PROCESSO_MARCA_LOG_EXPORTADO = "marcando log como exportado";
    private static final String GUIA_NUMERO = "10011";
    private static final String GUIA_CNPJLABORATORIO = "10012";
    private static final String GUIA_CARTEIRABENEFICIARIO = "10013";
    private static final String GUIA_ATENDIMENTO = "10014";
    private static final String EXAME_ACAO = "10021";
    private static final String EXAME_CODIGO = "10022";
    private static final String EXAME_DESCRICAO = "10023";
    private static final String EXAME_QUANTIDADE = "10024";
    private static final String EXAME_LIBERACAO = "10025";
    private static final String EXAMEREALIZADO_CODIGO = "10031";
    private static final String EXAMEREALIZADO_DESCRICAO = "10032";
    private static final String EXAMEREALIZADO_REALIZACAO = "10033";
    private static final String RESULTADO_DESCRICAO = "10041";
    private static final String RESULTADO__VALOR = "10042";
    private static final String RESULTADO_TIPODADO = "10043";
    private static final String VALIDACAO_GUIA_NUMERO = "20011";
    private static final String VALIDACAO_GUIA_CNPJLABORATORIO = "20012";
    private static final String VALIDACAO_GUIA_CARTEIRABENEFICIARIO = "20013";
    private static final String VALIDACAO_GUIA_ATENDIMENTO = "20014";
    private static final String VALIDACAO_EXAME_ACAO = "20021";
    private static final String VALIDACAO_EXAME__CODIGO = "20022";
    private static final String VALIDACAO_EXAME_QUANTIDADE = "20024";
    private static final String VALIDACAO_EXAME_LIBERACAO = "20025";
    private static final String VALIDACAO_EXAMEREALIZADO_CODIGO = "20031";
    private static final String VALIDACAO_EXAMEREALIZADO_REALIZACAO = "20033";
    private static final String VALIDACAO_RESULTADO_TIPODADO = "20034";
    private static final String VALIDACAO_CARTA_VALIDAO = "9001";
    private static final String SOLICITACAO_JA_EFETUADA = "30011";
    private static final String RESULTADO_JA_REGISTRADO_ENVIOSOLICITACAO = "30012";
    private static final String GUIA_EXAME_NAO_ENCONTRADO = "30021";
    private static final String REGISTRO_NAO_SOLICITADO = "30022";
    private static final String REGISTRO_NAO_AUTORIZADO = "30023";
    private static final String RESULTADO_JA_REGISTRADO_ENVIOREGISTRO = "30024";
    private static final String GUIA_EXAME_NAO_ENCONTRADO_ENVIORETIFICACAO = "30031";
    private static final String SOLICITACAO_JA_EFEUTADA_ENVIORETIFICACAO = "30032";
    private static final String RESULTADO_NAO_REGISTRADO_ENVIORETIFICACAO = "30033";
    private static final String GUIA_EXAME_NAO_ENCONTRADO_REGISTRORETIFICACAO = "30041";
    private static final String RETIFICACAO_NAO_SOLICITADA_REGISTRORETIFICACAO = "30042";
    private static final String RETIFICACAO_NAO_AUTORIZADA_REGISTRORETIFICACAO = "30043";
    private static final String RETIFICACAO_JA_REGISTRADA_REGISTRORETIFICACAO = "30044";
    private String codigoLoginConfiguracao = null;
    private String senhaLoginConfiguracao = null;
    private String codigoLaboratorioConfiguracao = null;
    private RESULTADOSEXAMESOutput retornoEnvioResultado = null;
    private RESULTADOSEXAMESOutput retornoSolicitacao = null;
    String hash = null;
    ArrayList<LogIntegracaoOperadora> listaLogs = null;

    public IntegracaoOperadoraUpy(String xml, int codigoConvenio) {
        this.xmlConfiguracao = xml;
        this.codigoConvenio = codigoConvenio;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            this.codigoLoginConfiguracao = StringUtil.getValor(xml, "login");
            this.senhaLoginConfiguracao = StringUtil.getValor(xml, "senha");
            this.codigoLaboratorioConfiguracao = StringUtil.getValor(xml, "codigoLaboratorio");
            if (!Funcoes.textoVazio(this.codigoLaboratorioConfiguracao)) {
                this.codigoLaboratorioConfiguracao = StringUtil.limpaString(this.codigoLaboratorioConfiguracao, new String[]{",", ".", "/", "-", " ", "\\"});
            }
        }
    }

    public RESULTADOSEXAMESOutput getRetornoEnvioResultado() {
        if (this.retornoEnvioResultado != null) {
            return this.retornoEnvioResultado;
        }
        return this.getRetornoSolicitacao();
    }

    public void setRetornoEnvioResultado(RESULTADOSEXAMESOutput retornoEnvioResultado) {
        this.retornoEnvioResultado = retornoEnvioResultado;
    }

    public RESULTADOSEXAMESOutput getRetornoSolicitacao() {
        return this.retornoSolicitacao;
    }

    public void setRetornoSolicitacao(RESULTADOSEXAMESOutput retornoSolicitacao) {
        this.retornoSolicitacao = retornoSolicitacao;
    }

    public void configuraIntegracaoOperadora(boolean isThread) {
        block14: {
            if (this.erros == null) {
                this.erros = new DadosErrosIntegracaoOperadora();
            } else {
                this.erros.errosEnvioResultado.clear();
                this.erros.errosLogin.clear();
                this.erros.errosProcesso.clear();
            }
            LAUDOSPortTypeProxy proxyWebservice = new LAUDOSPortTypeProxy();
            if (Funcoes.textoVazio(this.codigoLaboratorioConfiguracao)) {
                this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "O CNPJ do laborat\u00f3rio n\u00e3o foi informado nas configura\u00e7\u00f5es do conv\u00eanio.", PROCESSO_CARREGAR_PARAMETROS));
            }
            if (Funcoes.textoVazio(this.senhaLoginConfiguracao)) {
                this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "A senha de login n\u00e3o foi informada nas configura\u00e7\u00f5es do conv\u00eanio.", PROCESSO_CARREGAR_PARAMETROS));
            }
            if (Funcoes.textoVazio(this.codigoLoginConfiguracao)) {
                this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "O login do laborat\u00f3rio n\u00e3o foi informado nas configura\u00e7\u00f5es do conv\u00eanio.", PROCESSO_CARREGAR_PARAMETROS));
            }
            if (isThread) {
                Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
                Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
                try {
                    this.listaLogs = this.getLogsIntegracao(this.codigoConvenio);
                    if (this.listaLogs == null || this.listaLogs.isEmpty()) break block14;
                    try {
                        if (this.listaLogs != null && !this.listaLogs.isEmpty()) {
                            this.hash = this.realizaLogin(proxyWebservice, isThread);
                        }
                    }
                    catch (IntegracaoOperadoraException e) {
                        this.erros.errosLogin.add(e);
                    }
                }
                catch (IntegracaoOperadoraException e) {
                    this.erros.errosProcesso.add(e);
                }
            } else {
                try {
                    this.hash = this.realizaLogin(proxyWebservice, isThread);
                }
                catch (IntegracaoOperadoraException e) {
                    this.erros.errosLogin.add(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DadosErrosIntegracaoOperadora integrarOperadora() {
        this.debug("integra\u00e7\u00e3o iniciada");
        this.configuraIntegracaoOperadora(true);
        try {
            if (this.erros.haErros()) {
                DadosErrosIntegracaoOperadora dadosErrosIntegracaoOperadora = this.erros;
                return dadosErrosIntegracaoOperadora;
            }
            LAUDOSPortTypeProxy proxyWebservice = new LAUDOSPortTypeProxy();
            if (this.listaLogs != null) {
                for (LogIntegracaoOperadora log : this.listaLogs) {
                    try {
                        if (log.getTipoOperacao() == AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) {
                            this.enviarResultado(log, this.hash, proxyWebservice, this.verificarRetificacao(log), true);
                        }
                        if (!log.getSituacao().equals("E")) continue;
                        this.marcaLogExportado(log);
                    }
                    catch (IntegracaoOperadoraException e) {
                        this.erros.errosEnvioResultado.add(e);
                    }
                }
            }
            DadosErrosIntegracaoOperadora dadosErrosIntegracaoOperadora = this.erros;
            return dadosErrosIntegracaoOperadora;
        }
        finally {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_PARADO);
            if (this.erros.haErros()) {
                Laboratorio.setIconeIntegracaoOperadora(this, ICONE_ERRO);
            } else {
                Laboratorio.setHintIntegracaoOperadora(this, null);
            }
            this.debug("integra\u00e7\u00e3o finalizada");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DadosErrosIntegracaoOperadora integrarOperadoraReenviar(LogIntegracaoOperadora log) {
        this.debug("integra\u00e7\u00e3o iniciada");
        this.configuraIntegracaoOperadora(false);
        try {
            if (this.erros.haErros()) {
                DadosErrosIntegracaoOperadora dadosErrosIntegracaoOperadora = this.erros;
                return dadosErrosIntegracaoOperadora;
            }
            LAUDOSPortTypeProxy proxyWebservice = new LAUDOSPortTypeProxy();
            if (log != null) {
                try {
                    if (log.getTipoOperacao() == AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) {
                        this.enviarResultado(log, this.hash, proxyWebservice, this.verificarRetificacao(log), false);
                    }
                    if (log.getSituacao().equals("E")) {
                        this.marcaLogExportado(log);
                    }
                }
                catch (IntegracaoOperadoraException e) {
                    this.erros.errosEnvioResultado.add(e);
                }
            }
            DadosErrosIntegracaoOperadora dadosErrosIntegracaoOperadora = this.erros;
            return dadosErrosIntegracaoOperadora;
        }
        finally {
            this.debug("integra\u00e7\u00e3o finalizada");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!IntegracaoOperadoraUpy.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("            (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequsicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcaLogExportado(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        Statement st = Conexao.getStatement();
        String reqCodigo = StringUtil.getValor(log.getXmlLog(), "codreq");
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaintegracaooperadora ");
            buf.append(" set eio_exportado = true");
            buf.append(", eio_situacao = '").append("E").append("'");
            buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
            buf.append(" and eio_codigo = ").append(log.getCodigoLog());
            Conexao.executeUpdate(log.getCodigoFilial().toString(), st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    throw this.montaExcecao(new Exception(), log, "N\u00e3o foi poss\u00edvel marcar o log como exportado.", PROCESSO_MARCA_LOG_EXPORTADO);
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizarMensagemRetorno(LogIntegracaoOperadora log, String msgRetorno) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append(" set eio_retorno = '").append(msgRetorno).append("'");
        if (this.isLogAntigo(log)) {
            if (log.getCodigoRequisicao() != null) {
                buf.append(" , req_codigo = ").append(log.getCodigoRequisicao());
            }
            if (!Funcoes.textoVazio(log.getCodigoPaciente())) {
                buf.append(" , pac_codigo = '").append(log.getCodigoPaciente()).append("'");
            }
            if (log.getCodigoMaterial() != null) {
                buf.append(" , mco_codigo = ").append(log.getCodigoMaterial());
            }
            if (!Funcoes.textoVazio(log.getCodigoExame())) {
                buf.append(" , exa_codigo = '").append(log.getCodigoExame()).append("'");
            }
        }
        buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
        buf.append(" and eio_codigo = ").append(log.getCodigoLog());
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean isLogAntigo(LogIntegracaoOperadora log) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("select count (eio_codigo) ");
        buf.append("from exportaintegracaooperadora");
        buf.append(" where eio_codigo = ").append(log.getCodigoLog());
        buf.append(" and req_codigo IS NULL");
        buf.append(" and pac_codigo IS NULL");
        buf.append(" and exa_codigo IS NULL");
        buf.append(" and mco_codigo IS NULL");
        if (st != null) {
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next() && rs.getInt("count") >= 1) {
                    return true;
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return false;
    }

    private void atualizaLog(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaintegracaooperadora ");
            buf.append("    set eio_exportado = true ");
            buf.append("   , eio_retorno =  " + log.getRetorno());
            buf.append("   , eio_situacao = " + log.getSituacao());
            buf.append("  where fil_codigo = ").append(log.getCodigoFilial());
            buf.append("    and eio_codigo = ").append(log.getCodigoLog());
            boolean ok = Conexao.execute(log.getCodigoFilial().toString(), st, buf.toString());
            if (!ok) {
                throw this.montaExcecao(new Exception(), log, "N\u00e3o foi poss\u00edvel marcar o log como exportado.", PROCESSO_MARCA_LOG_EXPORTADO);
            }
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel marcar log como exportado.\n" + e.getMessage(), PROCESSO_MARCA_LOG_EXPORTADO);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public void enviarResultado(LogIntegracaoOperadora log, String hash, LAUDOSPortTypeProxy proxyWebservice, boolean isRetificacao, boolean pelaThread) throws IntegracaoOperadoraException {
        Statement st = Conexao.getStatement();
        ResultSet rs = this.getDados(st, log);
        try {
            if (rs != null) {
                String situacaoExame = rs.getString("situacaoExame");
                if (Funcoes.textoVazio(situacaoExame) || !rs.getString("situacaoExame").equals("C") && !rs.getString("situacaoExame").equals("E") && !rs.getString("situacaoExame").equals("I")) {
                    throw this.montaExcecao(new Exception(), log, "Situa\u00e7\u00e3o do exame n\u00e3o permitida.", PROCESSO_ENVIA_RESULTADO);
                }
                if (rs.getBoolean("excluidoExame")) {
                    throw this.montaExcecao(new Exception(), log, "Exame removido da requisi\u00e7\u00e3o.", PROCESSO_ENVIA_RESULTADO);
                }
                if (rs.getBoolean("naoFaturarExame")) {
                    throw this.montaExcecao(new Exception(), log, "Exame marcado para n\u00e3o faturar.", PROCESSO_ENVIA_RESULTADO);
                }
            }
        }
        catch (SQLException e1) {
            throw this.montaExcecao(e1, log, "N\u00e3o foi poss\u00edvel verificar a situa\u00e7\u00e3o do exame.\n" + e1.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        Guia[] guiaSolicitacao = new Guia[]{this.montaGuia(rs, log, isRetificacao, true)};
        Guia[] guiaEnvioResultado = new Guia[]{this.montaGuia(rs, log, isRetificacao, false)};
        this.iniciaStatusAguardandoWS(pelaThread);
        RESULTADOSEXAMESInput resultadosExames = new RESULTADOSEXAMESInput();
        RESULTADOSEXAMESInputRESULTADOSEXAMESXMLTYPEINOUT resultadoExamesInputResultadosExamesXmlTypeINOUT = null;
        try {
            resultadoExamesInputResultadosExamesXmlTypeINOUT = new RESULTADOSEXAMESInputRESULTADOSEXAMESXMLTYPEINOUT(this.montaArquivoEnvioSolicitacao(hash, guiaSolicitacao, log));
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        resultadosExames.setHASHVARCHAR2IN(hash);
        resultadosExames.setRESULTADOSEXAMESXMLTYPEINOUT(resultadoExamesInputResultadosExamesXmlTypeINOUT);
        proxyWebservice.setEndpoint("http://webservice:webservice@webservices.unimedlondrina.com.br/orawsv/WEBSERVICE/LAUDOS/RESULTADOSEXAMES");
        try {
            this.retornoSolicitacao = proxyWebservice.RESULTADOSEXAMES(resultadosExames);
            this.setRetornoSolicitacao(this.retornoSolicitacao);
        }
        catch (RemoteException e) {
            throw this.montaExcecao(new Exception(), log, e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        this.finalizaStatusAguardandoWS(pelaThread);
        boolean isSolicitado = this.validarRetornoSolicitacao(log, this.retornoSolicitacao, proxyWebservice, pelaThread);
        if (isSolicitado) {
            this.registroResultado(log, hash, proxyWebservice, guiaEnvioResultado, resultadosExames, pelaThread);
        }
    }

    public boolean verificarRetificacao(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        boolean isRetificacao = false;
        try {
            isRetificacao = new ExameRequisicaoService().getExameModificadoRetificado(log.getCodigoFilial(), log.getCodigoRequisicao(), log.getCodigoExame(), log.getCodigoMaterial());
        }
        catch (SQLException e) {
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel verificar se o resultado foi modificado/retificado.\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        return isRetificacao;
    }

    private void registroResultado(LogIntegracaoOperadora log, String hash, LAUDOSPortTypeProxy proxyWebservice, Guia[] guiaEnvioResultado, RESULTADOSEXAMESInput resultadosExames, boolean pelaThread) throws IntegracaoOperadoraException {
        try {
            this.iniciaStatusAguardandoWS(pelaThread);
            RESULTADOSEXAMESInputRESULTADOSEXAMESXMLTYPEINOUT resultadoExamesInputResultadosExamesXmlTypeINOUT = new RESULTADOSEXAMESInputRESULTADOSEXAMESXMLTYPEINOUT(this.montaArquivoRegistroResultado(hash, guiaEnvioResultado));
            resultadosExames.setRESULTADOSEXAMESXMLTYPEINOUT(resultadoExamesInputResultadosExamesXmlTypeINOUT);
            this.setRetornoEnvioResultado(proxyWebservice.RESULTADOSEXAMES(resultadosExames));
            this.finalizaStatusAguardandoWS(pelaThread);
        }
        catch (Exception e) {
            this.atualizarMensagemRetorno(log, "N\u00e3o foi poss\u00edvel enviar comando de solicita\u00e7\u00e3o de envio.\n" + e.getMessage());
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel enviar comando de solicita\u00e7\u00e3o de envio.\n" + e.getMessage(), PROCESSO_ENVIA_RESULTADO);
        }
        this.validarRetornoSolicitacaoEnvioResultado(log, this.retornoEnvioResultado, pelaThread, proxyWebservice);
    }

    private void validarRetornoSolicitacaoEnvioResultado(LogIntegracaoOperadora log, RESULTADOSEXAMESOutput retornoResultado, boolean pelaThread, LAUDOSPortTypeProxy proxyWebservice) throws IntegracaoOperadoraException {
        String codigoRetorno = null;
        String[] msgRetorno = null;
        String acao = null;
        String hashInvalido = null;
        for (MessageElement mE : retornoResultado.getRESULTADOSEXAMES().get_any()) {
            try {
                String mensagemRetorno = mE.getAsString();
                if (Funcoes.textoVazio(mensagemRetorno)) continue;
                acao = StringUtil.getValor(mensagemRetorno, "ns1:Acao");
                codigoRetorno = StringUtil.getValor(mensagemRetorno, "ns1:CodigoRetorno");
                msgRetorno = StringUtil.getValores(mensagemRetorno, "ns1:MensagemRetorno");
                hashInvalido = StringUtil.getValor(mensagemRetorno, "ns1:Mensagem");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        if (Funcoes.textoVazio(codigoRetorno) && msgRetorno[0].equalsIgnoreCase("OK")) {
            this.marcaLogExportado(log);
            this.atualizarMensagemRetorno(log, acao + " - " + msgRetorno[0]);
            if (pelaThread) {
                throw this.montaExcecao(new Exception(), log, "RESULTADO ENVIADO COM SUCESSO", PROCESSO_ENVIA_RESULTADO);
            }
            throw this.montaExcecao(new Exception(), log, acao + " OK", PROCESSO_ENVIA_RESULTADO);
        }
        if (!Funcoes.textoVazio(hashInvalido)) {
            throw this.montaExcecao(new Exception(), log, hashInvalido, PROCESSO_ENVIA_RESULTADO);
        }
        if (!Funcoes.textoVazio(codigoRetorno)) {
            if (codigoRetorno.equalsIgnoreCase(GUIA_EXAME_NAO_ENCONTRADO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "EXAME N\u00c3O ENCONTRADO");
                throw this.montaExcecao(new Exception(), log, "EXAME N\u00c3O ENCONTRADO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (codigoRetorno.equalsIgnoreCase(REGISTRO_NAO_SOLICITADO)) {
                this.atualizarSituacao(log, "R");
                throw this.montaExcecao(new Exception(), log, "REGISTRO N\u00c3O SOLICITADO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (codigoRetorno.equalsIgnoreCase(REGISTRO_NAO_AUTORIZADO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "REGISTRO N\u00c3O AUTORIZADO");
                throw this.montaExcecao(new Exception(), log, "REGISTRO N\u00c3O AUTORIZADO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (codigoRetorno.equalsIgnoreCase(RESULTADO_JA_REGISTRADO_ENVIOREGISTRO)) {
                this.marcaLogExportado(log);
                this.atualizarMensagemRetorno(log, msgRetorno[1]);
                throw this.montaExcecao(new Exception(), log, "RESULTADO J\u00c1 REGISTRADO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (codigoRetorno.equalsIgnoreCase(GUIA_EXAME_NAO_ENCONTRADO_REGISTRORETIFICACAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "RETIFICA\u00c7\u00c3O - " + msgRetorno[0]);
                throw this.montaExcecao(new Exception(), log, "EXAME N\u00c3O ENCONTRADO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (codigoRetorno.equalsIgnoreCase(RETIFICACAO_NAO_SOLICITADA_REGISTRORETIFICACAO)) {
                this.enviarResultado(log, this.hash, proxyWebservice, true, pelaThread);
            }
            if (codigoRetorno.equalsIgnoreCase(RETIFICACAO_NAO_AUTORIZADA_REGISTRORETIFICACAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "RETIFICA\u00c7\u00c3O N\u00c3O AUTORIZADA");
                throw this.montaExcecao(new Exception(), log, "RETIFICA\u00c7\u00c3O N\u00c3O AUTORIZADA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (codigoRetorno.equalsIgnoreCase(RETIFICACAO_JA_REGISTRADA_REGISTRORETIFICACAO)) {
                this.marcaLogExportado(log);
                this.atualizarMensagemRetorno(log, msgRetorno[1]);
                throw this.montaExcecao(new Exception(), log, "RETIFICA\u00c7\u00c3O J\u00c1 REGISTRADA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
        } else {
            throw this.montaExcecao(new Exception(), log, "N\u00e3o foi poss\u00edvel obter uma mensagem de retorno do webservice.", PROCESSO_ENVIA_RESULTADO);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validarRetornoSolicitacao(LogIntegracaoOperadora log, RESULTADOSEXAMESOutput retornoSolicitacao, LAUDOSPortTypeProxy proxyWebservice, boolean pelaThread) throws IntegracaoOperadoraException {
        String[] codigoRetorno = null;
        String[] msgRetorno = null;
        String acao = null;
        String hashInvalido = "";
        for (MessageElement mE : retornoSolicitacao.getRESULTADOSEXAMES().get_any()) {
            try {
                String mensagemRetorno = mE.getAsString();
                if (Funcoes.textoVazio(mensagemRetorno)) continue;
                codigoRetorno = StringUtil.getValores(mensagemRetorno, "ns1:CodigoRetorno");
                msgRetorno = StringUtil.getValores(mensagemRetorno, "ns1:MensagemRetorno");
                acao = StringUtil.getValor(mensagemRetorno, "ns1:Acao");
                hashInvalido = StringUtil.getValor(mensagemRetorno, "ns1:Mensagem");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        String novoRetornoOK = "";
        String mensagemCompleta = "";
        boolean acheiOK = false;
        for (MessageElement messageElement : msgRetorno) {
            if (messageElement.equalsIgnoreCase("OK")) {
                novoRetornoOK = messageElement;
                acheiOK = true;
            } else if (!Funcoes.textoVazio(novoRetornoOK) && !messageElement.equalsIgnoreCase(RESULTADO_JA_REGISTRADO_ENVIOSOLICITACAO)) {
                novoRetornoOK = "";
            }
            if (!Funcoes.textoVazio(mensagemCompleta)) {
                mensagemCompleta = mensagemCompleta + ",";
            }
            mensagemCompleta = mensagemCompleta + (String)messageElement;
        }
        String novoCodigoRetorno = null;
        if (codigoRetorno != null) {
            void var15_21;
            String[] stringArray = codigoRetorno;
            int n = stringArray.length;
            boolean bl = false;
            while (var15_21 < n) {
                String s = stringArray[var15_21];
                if (s.equalsIgnoreCase(SOLICITACAO_JA_EFETUADA)) {
                    novoCodigoRetorno = s;
                    break;
                }
                novoCodigoRetorno = s;
                ++var15_21;
            }
        }
        if (acheiOK && (!Funcoes.textoVazio(novoCodigoRetorno) && novoCodigoRetorno.equalsIgnoreCase(RESULTADO_JA_REGISTRADO_ENVIOSOLICITACAO) || codigoRetorno == null || codigoRetorno.length == 0)) {
            this.atualizarMensagemRetorno(log, acao + " - " + mensagemCompleta);
            return true;
        }
        if (!Funcoes.textoVazio(hashInvalido)) {
            throw this.montaExcecao(new Exception(), log, hashInvalido, PROCESSO_SOLICITA_ENVIO_RESULTADO);
        }
        if (novoCodigoRetorno != null) {
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_CARTA_VALIDAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, msgRetorno[0]);
                throw this.montaExcecao(new Exception(), log, msgRetorno[0], PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_GUIA_NUMERO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "GUIA INV\u00c1LIDA");
                throw this.montaExcecao(new Exception(), log, "GUIA INV\u00c1LIDA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_GUIA_CNPJLABORATORIO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "CNPJ DO LABORATORIO INV\u00c1LIDO");
                throw this.montaExcecao(new Exception(), log, "CNPJ DO LABORATORIO INV\u00c1LIDO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_GUIA_CARTEIRABENEFICIARIO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "CARTEIRA DO BENEFICI\u00c1RIO INV\u00c1LIDA");
                throw this.montaExcecao(new Exception(), log, "CARTEIRA DO BENEFICI\u00c1RIO INV\u00c1LIDA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_GUIA_ATENDIMENTO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "DATA DE ATENDIMENTO INV\u00c1LIDO");
                throw this.montaExcecao(new Exception(), log, "DATA DE ATENDIMENTO INV\u00c1LIDO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_EXAME_ACAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "A\u00c7\u00c3O INV\u00c1LIDA");
                throw this.montaExcecao(new Exception(), log, "A\u00c7\u00c3O INV\u00c1LIDA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_EXAME__CODIGO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "C\u00d3DIGO EXAME INV\u00c1LIDO");
                throw this.montaExcecao(new Exception(), log, "C\u00d3DIGO EXAME INV\u00c1LIDO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_EXAME_QUANTIDADE)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "QUANTIDADE INV\u00c1LIDA");
                throw this.montaExcecao(new Exception(), log, "QUANTIDADE INV\u00c1LIDA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_EXAME_LIBERACAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "DATA LIBERA\u00c7\u00c3O INV\u00c1LIDA");
                throw this.montaExcecao(new Exception(), log, "DATA LIBERA\u00c7\u00c3O INV\u00c1LIDA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_EXAMEREALIZADO_CODIGO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "C\u00d3DIGO EXAME INV\u00c1LIDO");
                throw this.montaExcecao(new Exception(), log, "C\u00d3DIGO EXAME INV\u00c1LIDO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_EXAMEREALIZADO_REALIZACAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "DATA REALIZA\u00c7\u00c3O INV\u00c1LIDA");
                throw this.montaExcecao(new Exception(), log, "DATA REALIZA\u00c7\u00c3O INV\u00c1LIDA", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(VALIDACAO_RESULTADO_TIPODADO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "TIPO DADO INV\u00c1LIDO");
                throw this.montaExcecao(new Exception(), log, "TIPO DADO INV\u00c1LIDO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(GUIA_EXAME_NAO_ENCONTRADO_ENVIORETIFICACAO)) {
                this.atualizarSituacao(log, "R");
                this.atualizarMensagemRetorno(log, "RETIFICA\u00c7\u00c3O - " + msgRetorno[0]);
                throw this.montaExcecao(new Exception(), log, "EXAME N\u00c3O ENCONTRADO", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            if (novoCodigoRetorno.equalsIgnoreCase(SOLICITACAO_JA_EFEUTADA_ENVIORETIFICACAO)) {
                return true;
            }
            if (novoCodigoRetorno.equalsIgnoreCase(RESULTADO_NAO_REGISTRADO_ENVIORETIFICACAO)) {
                this.enviarResultado(log, this.hash, proxyWebservice, false, pelaThread);
            }
        } else {
            throw this.montaExcecao(new Exception(), log, "N\u00e3o foi poss\u00edvel obter uma mensagem de retorno do webservice.", PROCESSO_SOLICITA_ENVIO_RESULTADO);
        }
        if (novoCodigoRetorno.equalsIgnoreCase(RESULTADO_JA_REGISTRADO_ENVIOSOLICITACAO)) {
            this.marcaLogExportado(log);
            if (msgRetorno.length > 1) {
                this.atualizarMensagemRetorno(log, msgRetorno[1]);
                throw this.montaExcecao(new Exception(), log, "A solicita\u00e7\u00e3o de envio foi recusada. Situa\u00e7\u00e3o retornada = \"" + msgRetorno[1] + "\".", PROCESSO_SOLICITA_ENVIO_RESULTADO);
            }
            this.atualizarMensagemRetorno(log, msgRetorno[0]);
            throw this.montaExcecao(new Exception(), log, "A solicita\u00e7\u00e3o de envio foi recusada. Situa\u00e7\u00e3o retornada = \"" + msgRetorno[0] + "\".", PROCESSO_SOLICITA_ENVIO_RESULTADO);
        }
        if (novoCodigoRetorno.equalsIgnoreCase(SOLICITACAO_JA_EFETUADA)) {
            return true;
        }
        this.finalizaStatusAguardandoWS(pelaThread);
        return false;
    }

    private MessageElement[] montaArquivoEnvioSolicitacao(String hash, Guia[] guiaSolicitacao, LogIntegracaoOperadora log) throws XMLStringBuilderException, IntegracaoOperadoraException {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("Guias");
            for (Guia g : guiaSolicitacao) {
                xml.abrir("Guia");
                xml.escrever("Numero", this.verificaCampoObrigatorio("Guia/Numero", g.getNumero(), log));
                xml.escrever("CnpjLaboratorio", this.verificaCampoObrigatorio("Guia/cnpjLaboratorio", g.getCnpjLaboratorio(), log));
                xml.escrever("CarteiraBeneficiario", this.verificaCampoObrigatorio("Guia/carteiraBeneficiario", g.getCarteiraBeneficiario(), log));
                xml.escrever("CnsBeneficiario", g.getCnsBeneficiario());
                xml.escrever("Atendimento", this.getData(g.getAtendimento()));
                xml.abrir("Exames");
                for (Exame e : g.getExames()) {
                    xml.abrir("Exame");
                    xml.escrever("Acao", e.getAcao().toString());
                    xml.escrever("Quantidade", e.getQuantidade().toString());
                    xml.escrever("Codigo", this.verificaCampoObrigatorio("Exame/Codigo", e.getCodigo(), log));
                    xml.escrever("Descricao", this.verificaCampoObrigatorio("Exame/Descricao", e.getDescricao(), log));
                    xml.escrever("Liberacao", this.verificaCampoObrigatorio("Exame/Data Liberacao", this.getData(e.getLiberacao()), log));
                    xml.fechar("Exame");
                }
                xml.fechar("Exames");
                xml.fechar("Guia");
                xml.fechar("Guias");
            }
        }
        catch (IntegracaoOperadoraException e) {
            throw this.montaExcecao(new Exception(), log, e.getMensagemErro(), PROCESSO_SOLICITA_ENVIO_RESULTADO);
        }
        String novoXml = StringUtil.removerAcentos(xml.toString());
        MessageElement[] messageElement = new MessageElement[1];
        Document XMLDoc = null;
        try {
            XMLDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(novoXml)));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        if (XMLDoc != null) {
            Element element = XMLDoc.getDocumentElement();
            messageElement[0] = new MessageElement(element);
        }
        return messageElement;
    }

    private String verificaCampoObrigatorio(String tag, String dado, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        if (Funcoes.textoVazio(dado)) {
            this.atualizarSituacao(log, "R");
            this.atualizarMensagemRetorno(log, tag + " deve ser informado.");
            throw new IntegracaoOperadoraException(new Exception(), tag + " deve ser informado.", PROCESSO_SOLICITA_ENVIO_RESULTADO, log);
        }
        return dado;
    }

    private String getData(Calendar c) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String data = simpleDateFormat.format(c.getTime());
        data = data.replace("/", "-");
        return data;
    }

    private MessageElement[] montaArquivoRegistroResultado(String hash, Guia[] guiaSolicitacao) throws XMLStringBuilderException, SAXException, IOException, ParserConfigurationException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("Guias");
        for (Guia g : guiaSolicitacao) {
            xml.abrir("Guia");
            xml.escrever("Numero", g.getNumero());
            xml.escrever("CnpjLaboratorio", g.getCnpjLaboratorio());
            xml.escrever("CarteiraBeneficiario", g.getCarteiraBeneficiario());
            xml.escrever("CnsBeneficiario", g.getCnsBeneficiario());
            xml.escrever("Atendimento", this.getData(g.getAtendimento()));
            xml.abrir("Exames");
            for (Exame e : g.getExames()) {
                xml.abrir("Exame");
                xml.escrever("Acao", e.getAcao().toString());
                xml.escrever("Quantidade", e.getQuantidade().toString());
                xml.escrever("Codigo", e.getCodigo());
                xml.escrever("Descricao", e.getDescricao());
                xml.escrever("Liberacao", this.getData(e.getLiberacao()));
                xml.abrir("ExamesRealizados");
                for (ExameRealizado eR : e.getExamesRealizados()) {
                    xml.abrir("ExameRealizado");
                    xml.escrever("Codigo", eR.getCodigo());
                    xml.escrever("Descricao", eR.getDescricao());
                    xml.escrever("Realizacao", this.getData(eR.getRealizacao()));
                    xml.escrever("Laudo", eR.getLaudo());
                    xml.escrever("FormatoLaudo", eR.getFormatoLaudo().getValue());
                    xml.abrir("Resultados");
                    for (Resultado r : eR.getResultados()) {
                        xml.abrir("Resultado");
                        xml.escrever("Descricao", StringUtil.preencheCData(r.getDescricao()));
                        xml.escrever("Valor", StringUtil.preencheCData(r.getValor()));
                        xml.escrever("UnidadeMedida", StringUtil.preencheCData(r.getUnidadeMedida()));
                        xml.escrever("ValorReferencia", StringUtil.preencheCData(r.getValorReferencia()));
                        xml.escrever("TipoDado", r.getTipoDado().getValue());
                        xml.fechar("Resultado");
                    }
                    xml.fechar("Resultados");
                    xml.fechar("ExameRealizado");
                }
                xml.fechar("ExamesRealizados");
                xml.fechar("Exame");
            }
            xml.fechar("Exames");
            xml.fechar("Guia");
            xml.fechar("Guias");
        }
        String novoXml = StringUtil.removerAcentos(xml.toString());
        MessageElement[] messageElement = new MessageElement[1];
        Document XMLDoc = null;
        try {
            XMLDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(novoXml)));
        }
        catch (SAXException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        if (XMLDoc != null) {
            Element element = XMLDoc.getDocumentElement();
            messageElement[0] = new MessageElement(element);
        }
        return messageElement;
    }

    private ArrayList<LogIntegracaoOperadora> getLogsIntegracao(int codigoConvenio) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> arrayList;
        ArrayList<LogIntegracaoOperadora> listaLogs;
        Statement st;
        block11: {
            boolean usarData = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "upy.jalis");
            String data = "";
            try {
                String x;
                if (usarData && !Funcoes.textoVazio(x = StringUtil.lerArquivoTexto(System.getProperty("user.home") + System.getProperty("file.separator") + "upy.jalis"))) {
                    data = x.length() == 10 ? " and cast(eio_datahora as date) >= '" + x + "' " : x;
                }
            }
            catch (Exception e) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel validar o filtro de data.\nMensagem: " + e.getMessage(), 1);
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_codigo as codigoFilial ");
            buf.append("       ,eio_codigo as codigoLog ");
            buf.append("       ,eio_operacao as operacao ");
            buf.append("       ,pac_codigo   as codigoPaciente");
            buf.append("       ,eio_tipooperacao as tipoOperacao ");
            buf.append("       ,eio_retorno as retorno");
            buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
            buf.append("   from exportaintegracaooperadora ");
            buf.append("  where eio_exportado = false ");
            buf.append("    and con_codigo = ").append(codigoConvenio);
            if (usarData && !Funcoes.textoVazio(data)) {
                buf.append(data);
            }
            buf.append("  order by eio_codigo ");
            st = Conexao.getStatement();
            ResultSet rs = null;
            rs = Conexao.executeQuery(st, buf.toString());
            listaLogs = new ArrayList<LogIntegracaoOperadora>();
            if (rs != null && rs.next()) {
                boolean erroEncontrado = false;
                do {
                    Integer codigoFilial = rs.getInt("codigoFilial");
                    Long codigoLog = rs.getLong("codigoLog");
                    String tipoOperacao = rs.getString("tipoOperacao");
                    String retorno = rs.getString("retorno");
                    String situacao = rs.getString("situacao");
                    String codigoPaciente = rs.getString("codigoPaciente");
                    String operacao = rs.getString("operacao");
                    Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
                    String codigoExame = StringUtil.getValor(operacao, "codexa");
                    Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
                    listaLogs.add(new LogIntegracaoOperadora(codigoFilial, codigoLog, codigoRequisicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, operacao, retorno, situacao, codigoConvenio));
                } while (rs.next());
                break block11;
            }
            ArrayList<LogIntegracaoOperadora> arrayList2 = null;
            Conexao.fecharStatement(st);
            return arrayList2;
        }
        try {
            arrayList = listaLogs;
        }
        catch (SQLException e) {
            try {
                throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), PROCESSO_BUSCA_LOGS);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return arrayList;
    }

    private IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (mensagemErro != null) {
            buf.append(" :: ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    public String realizaLogin(LAUDOSPortTypeProxy proxyWebservice, boolean isThread) throws IntegracaoOperadoraException {
        if (Funcoes.textoVazio(this.codigoLoginConfiguracao)) {
            throw this.montaExcecao(new Exception(), null, "O c\u00f3digo de login n\u00e3o foi informado.", PROCESSO_LOGIN);
        }
        if (Funcoes.textoVazio(this.senhaLoginConfiguracao)) {
            throw this.montaExcecao(new Exception(), null, "A senha de login n\u00e3o foi informada.", PROCESSO_LOGIN);
        }
        try {
            this.iniciaStatusAguardandoWS(isThread);
            LOGINInput login = new LOGINInput();
            LOGINInputHASHVARCHAR2OUT hash = new LOGINInputHASHVARCHAR2OUT();
            LOGINInputLOGINVALIDOVARCHAR2OUT loginValido = new LOGINInputLOGINVALIDOVARCHAR2OUT();
            login.setHASHVARCHAR2OUT(hash);
            login.setLOGINVALIDOVARCHAR2OUT(loginValido);
            login.setUSUARIOVARCHAR2IN(this.codigoLoginConfiguracao);
            login.setSENHAVARCHAR2IN(this.senhaLoginConfiguracao);
            proxyWebservice.setEndpoint("http://webservice:webservice@webservices.unimedlondrina.com.br/orawsv/WEBSERVICE/LAUDOS/LOGIN");
            LOGINOutput retornoLogin = proxyWebservice.LOGIN(login);
            this.finalizaStatusAguardandoWS(isThread);
            if (retornoLogin.getLOGINVALIDO().equalsIgnoreCase("true")) {
                return retornoLogin.getHASH();
            }
            throw this.montaExcecao(new Exception(), null, "O login foi recusado pelo webservice.", PROCESSO_LOGIN);
        }
        catch (Exception e) {
            if (!(e instanceof IntegracaoOperadoraException)) {
                throw this.montaExcecao(e, null, e.getMessage(), PROCESSO_LOGIN);
            }
            throw (IntegracaoOperadoraException)e;
        }
    }

    private void finalizaStatusAguardandoWS(boolean isThread) {
        if (isThread) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_AGUARDANDO_WS);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_AGUARDANDO_WS);
        }
    }

    private void iniciaStatusAguardandoWS(boolean isThread) {
        if (isThread) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        }
    }

    private Guia montaGuia(ResultSet rs, LogIntegracaoOperadora log, boolean isRetificacao, boolean isConsulta) throws IntegracaoOperadoraException {
        if (Funcoes.textoVazio(this.codigoLaboratorioConfiguracao)) {
            throw this.montaExcecao(new Exception(), log, "O c\u00f3digo do laborat\u00f3rio na operadora n\u00e3o foi informado.", PROCESSO_MONTA_LABORATORIO);
        }
        if (rs == null) {
            throw this.montaExcecao(new Exception(), log, "N\u00e3o foi poss\u00edvel montar os dados da guia (mensagem apresentada: ResultSet dos dados = NULL)", PROCESSO_MONTA_LABORATORIO);
        }
        String carteirinha = null;
        String guia = null;
        String cnsBeneficiario = null;
        Calendar dataAtendimento = Calendar.getInstance();
        dataAtendimento.set(dataAtendimento.get(1), dataAtendimento.get(2), dataAtendimento.get(5), 0, 0, 0);
        try {
            carteirinha = rs.getString("carteirinha");
            carteirinha = StringUtil.limpaString(carteirinha, new String[]{".", "-", " "});
            cnsBeneficiario = rs.getString("cnsBeneficiario");
            guia = rs.getString("guiaExame");
        }
        catch (Exception e) {
            e.getMessage();
        }
        if (Funcoes.textoVazio(guia)) {
            this.atualizarSituacao(log, "R");
            this.atualizarMensagemRetorno(log, "REQUISI\u00c7\u00c3O " + log.getCodigoRequisicao() + " N\u00c3O POSSUI UMA GUIA V\u00c1LIDA");
            throw this.montaExcecao(new Exception(), log, "REQUISI\u00c7\u00c3O " + log.getCodigoRequisicao() + " N\u00c3O POSSUI UMA GUIA V\u00c1LIDA", PROCESSO_MONTA_LABORATORIO);
        }
        return new Guia(guia, this.codigoLaboratorioConfiguracao, carteirinha, cnsBeneficiario, dataAtendimento, this.montaExames(rs, log, isRetificacao, isConsulta), null, null);
    }

    private Exame[] montaExames(ResultSet rs, LogIntegracaoOperadora log, boolean isRetificacao, boolean isConsulta) throws IntegracaoOperadoraException {
        ArrayList<Exame> exames = new ArrayList<Exame>();
        try {
            do {
                String codigoProcedimento = null;
                String descricaoProcedimento = null;
                Integer quantidadeProcedimento = 1;
                Calendar dataLiberacao = Calendar.getInstance();
                try {
                    codigoProcedimento = rs.getString("ambExame");
                    if (!Funcoes.textoVazio(codigoProcedimento)) {
                        codigoProcedimento = StringUtil.limpaString(codigoProcedimento, new String[]{",", ".", "/", "-", " ", "\\"});
                    }
                    if (rs.getDate("dataConferenciaExame") != null) {
                        dataLiberacao.setTime(rs.getDate("dataConferenciaExame"));
                    }
                    descricaoProcedimento = rs.getString("descricaoExame");
                }
                catch (Exception e) {
                    throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel montar os dados do exame.\n" + e.getMessage(), PROCESSO_MONTA_EXAME);
                }
                AcaoExame acao = null;
                acao = isConsulta ? (isRetificacao ? AcaoExame.SolicitacaoRetificacao : AcaoExame.SolicitacaoEnvio) : (isRetificacao ? AcaoExame.RegistroRetificacao : AcaoExame.RegistroResultado);
                ExameRealizado[] examesRealizados = isConsulta ? null : this.montaExamesRealizados(rs, log, codigoProcedimento, descricaoProcedimento, dataLiberacao, isRetificacao, isConsulta);
                exames.add(new Exame(acao, quantidadeProcedimento, codigoProcedimento, descricaoProcedimento, dataLiberacao, examesRealizados, null, null));
            } while (rs.next());
            rs.first();
        }
        catch (SQLException e) {
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel montar a listagem de dados do exame.\n" + e.getMessage(), PROCESSO_MONTA_EXAME);
        }
        return exames.toArray(new Exame[exames.size()]);
    }

    private ExameRealizado[] montaExamesRealizados(ResultSet rs, LogIntegracaoOperadora log, String codigoProcedimento, String descricaoProcedimento, Calendar dataLiberacao, boolean isRetificacao, boolean isConsulta) throws IntegracaoOperadoraException {
        ArrayList<ExameRealizado> exames = new ArrayList<ExameRealizado>();
        RetornoImpressaoResultados pdf = null;
        try {
            pdf = ImpressaoResultados.imprimirExames(null, null, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), true, true, null, new String[]{rs.getString("codigoExamePai")}, new String[]{rs.getString("codigoMaterialPai")}, true, null, true, true, null, true, "", true, false);
        }
        catch (Exception e) {
            throw this.montaExcecao(e, log, e.getMessage(), PROCESSO_MONTA_EXAME);
        }
        String pdfBinario = null;
        Resultado[] resultado = null;
        if (!isConsulta) {
            resultado = this.montaResultado(rs, log);
            if (pdf != null) {
                pdfBinario = Base64.encodeBase64String((byte[])pdf.getResultadoPdfWeb());
            }
        }
        ExameRealizado exameRealizado = new ExameRealizado(codigoProcedimento, descricaoProcedimento, dataLiberacao, pdfBinario, FormatoArquivoLaudo.PDF, resultado, null, null);
        exames.add(exameRealizado);
        return exames.toArray(new ExameRealizado[exames.size()]);
    }

    private Resultado[] montaResultado(ResultSet rs, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        String idadePaciente = null;
        String codigoMetodologia = null;
        String numeroGuia = null;
        try {
            idadePaciente = rs.getString("idadePaciente");
            numeroGuia = rs.getString("guiaExame");
            codigoMetodologia = rs.getString("codigoMetodologia");
        }
        catch (Exception e) {
            this.atualizarSituacao(log, "N");
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel buscar a idade do paciente ou c\u00f3digo da metodologia (erro interno).\n" + e.getMessage(), "linha");
        }
        Map<String, Object> mapaResultado = this.getMapaResultado(rs, log);
        if (mapaResultado == null || mapaResultado.size() == 0) {
            this.atualizarSituacao(log, "N");
            this.atualizarMensagemRetorno(log, "N\u00e3o h\u00e1 campos no resultado.");
            throw this.montaExcecao(new Exception(), log, "N\u00e3o h\u00e1 campos no resultado.", PROCESSO_MONTA_LINHA);
        }
        String xmlRelacionamentoLaudo = this.getXMLRelacionamentoLaudo(rs, log);
        if (Funcoes.textoVazio(xmlRelacionamentoLaudo)) {
            this.atualizarSituacao(log, "N");
            this.atualizarMensagemRetorno(log, "N\u00e3o h\u00e1 associa\u00e7\u00e3o de campos do laudo para a idade \"" + idadePaciente + "\" e metodologia \"" + codigoMetodologia + "\".");
            throw this.montaExcecao(new Exception(), log, "N\u00e3o h\u00e1 associa\u00e7\u00e3o de campos do laudo para a idade \"" + idadePaciente + "\" e metodologia \"" + codigoMetodologia + "\".", PROCESSO_MONTA_LINHA);
        }
        String[] linhas = StringUtil.getValores(xmlRelacionamentoLaudo, "linha");
        if (linhas == null || linhas.length == 0) {
            this.atualizarSituacao(log, "N");
            this.atualizarMensagemRetorno(log, "N\u00e3o h\u00e1 configura\u00e7\u00f5es na associa\u00e7\u00e3o de campos do laudo para a idade \"" + idadePaciente + "\" e metodologia \"" + codigoMetodologia + "\".");
            throw this.montaExcecao(new Exception(), log, "N\u00e3o h\u00e1 configura\u00e7\u00f5es na associa\u00e7\u00e3o de campos do laudo para a idade \"" + idadePaciente + "\" e metodologia \"" + codigoMetodologia + "\".", PROCESSO_MONTA_LINHA);
        }
        Resultado[] retorno = new Resultado[linhas.length];
        int contador = 1;
        for (String linha : linhas) {
            String codigo = String.valueOf(contador);
            String descricao = StringUtil.getValor(linha, ConfiguradorResultadoUpy.CamposResultado.DESCRICAO.getTag());
            String tipoDados = StringUtil.getValor(linha, ConfiguradorResultadoUpy.CamposResultado.TIPO_DADOS.getTag());
            if (tipoDados.equalsIgnoreCase("TEXTO")) {
                tipoDados = TipoDadoResultado.ALFANUMERICO.toString();
            }
            String valorResultado = null;
            String campoResultado = StringUtil.getValor(linha, ConfiguradorResultadoUpy.CamposResultado.RESULTADO.getTag());
            if (!Funcoes.textoVazio(campoResultado)) {
                if (mapaResultado.get(campoResultado.toLowerCase()) == null) {
                    campoResultado = "";
                } else {
                    valorResultado = mapaResultado.get(campoResultado.toLowerCase()).toString();
                }
            }
            String unidadeMedida = null;
            String campoUnidadeMedida = StringUtil.getValor(linha, ConfiguradorResultadoUpy.CamposResultado.UNID_MEDIDA.getTag());
            if (!Funcoes.textoVazio(campoUnidadeMedida)) {
                if (mapaResultado.get(campoUnidadeMedida.toLowerCase()) == null) {
                    campoUnidadeMedida = "";
                } else {
                    unidadeMedida = mapaResultado.get(campoUnidadeMedida.toLowerCase()).toString();
                }
            }
            String valorReferencia = null;
            String campoValorReferencia = StringUtil.getValor(linha, ConfiguradorResultadoUpy.CamposResultado.VALOR_REFERENCIA.getTag());
            if (!Funcoes.textoVazio(campoValorReferencia)) {
                valorReferencia = mapaResultado.get(campoValorReferencia.toLowerCase()) == null ? "" : mapaResultado.get(campoValorReferencia.toLowerCase()).toString();
            }
            retorno[contador - 1] = new Resultado(descricao, valorResultado, unidadeMedida, valorReferencia, TipoDadoResultado.fromString(tipoDados), null, null);
            ++contador;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizarSituacao(LogIntegracaoOperadora log, String situacao) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append(" set eio_situacao = '").append(situacao).append("'");
        buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
        buf.append(" and eio_codigo = ").append(log.getCodigoLog());
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private String getXMLRelacionamentoLaudo(ResultSet rs, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        String string;
        String xmlLayout;
        Statement st;
        block7: {
            block6: {
                st = Conexao.getStatement();
                String codigoLayoutConvenio = ExameUtil.getCodigoLayout(rs.getString("codigoFilial"), rs.getString("codigoConvenio"), rs.getString("codigoDestino"), st);
                xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(rs.getString("codigoFilial"), rs.getInt("idadePaciente"), rs.getString("tipoIdadePaciente"), codigoLayoutConvenio, rs.getString("codigoExamePai"), rs.getInt("codigoMaterialPai"), rs.getString("codigoMetodologia"), st);
                if (!Funcoes.textoVazio(xmlLayout)) break block6;
                String string2 = null;
                Conexao.fecharStatement(st);
                return string2;
            }
            xmlLayout = StringUtil.getValor(xmlLayout, "integracaoupy");
            if (!Funcoes.textoVazio(xmlLayout)) break block7;
            String string3 = null;
            Conexao.fecharStatement(st);
            return string3;
        }
        try {
            string = xmlLayout;
        }
        catch (Exception e) {
            try {
                throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel buscar o XML de associa\u00e7\u00e3o de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private Map<String, Object> getMapaResultado(ResultSet rs, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        Object mapaResultado = null;
        try {
            return jalis.laboratorio.digitacao.Resultado.getTodosCamposResultado(rs.getString("resultado"), false);
        }
        catch (Exception e) {
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel buscar os campos de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
        }
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraUpy janelaConfiguracao = ConfiguradorIntegracaoOperadoraUpy.novaInstancia(parent);
        janelaConfiguracao.setXML(xmlConfig);
        janelaConfiguracao.setVisible(true);
        if (janelaConfiguracao.getOK()) {
            return janelaConfiguracao.getXML();
        }
        return xmlConfig;
    }

    private ResultSet getDados(Statement st, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_matricula as carteirinha ");
        buf.append("       ,req.req_validadecarteira as validadeCarteirinha ");
        buf.append("       ,req.req_cartaosus        as cnsBeneficiario");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("       ,exr.exr_ordem as sequenciaExame ");
        buf.append("       ,exr.exr_dataassina as dataConferenciaExame ");
        buf.append("       ,coalesce(exadesm.exa_codigo, exa.exa_codigo) as codigoExame ");
        buf.append("       ,coalesce(exadesm.exa_descricao, exa.exa_descricao) as descricaoExame ");
        buf.append("       ,coalesce(dtpdesm.dtp_codamb, dtp.dtp_codamb) as ambExame ");
        buf.append("       ,req.req_excluida as requisicaoExcluida ");
        buf.append("       ,exr.exr_excluido as exameExcluido ");
        buf.append("       ,coalesce(cio.mco_kodigo, exr.mco_codigo) as codigoMaterial ");
        buf.append("       ,exa.exa_codigo as codigoExamePai ");
        buf.append("       ,exr.mco_codigo as codigoMaterialPai ");
        buf.append("       ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_idade as idadePaciente ");
        buf.append("       ,req.req_anomes as tipoIdadePaciente ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_naofaturar as naoFaturarExame ");
        buf.append("       ,exr.exr_excluido as excluidoExame ");
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo ");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho ");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and exr.exa_codigo = dtm.exa_codigo and exr.mco_codigo = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtmdesm on exr.fil_codigo = dtmdesm.fil_codigo and cio.exa_kodigo = dtmdesm.exa_codigo and cio.mco_kodigo = dtmdesm.mco_codigo and con.tpe_codigo = dtmdesm.tpe_codigo and exr.met_codigo = dtmdesm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtpdesm on exr.fil_codigo = dtpdesm.fil_codigo and cio.exa_kodigo = dtpdesm.exa_codigo and cio.mco_kodigo = dtpdesm.mco_codigo and con.tpe_codigo = dtpdesm.tpe_codigo ");
        }
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("' ");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        buf.append(" UNION ");
        buf.append("select req.fil_codigo as codigoFilial ");
        buf.append("     ,req.req_codigo as codigoRequisicao  ");
        buf.append("     ,req.req_matricula as carteirinha  ");
        buf.append("     ,req.req_validadecarteira as validadeCarteirinha  ");
        buf.append("     ,req.req_cartaosus        as cnsBeneficiario ");
        buf.append("     ,req.req_data as dataRequisicao  ");
        buf.append("     ,req.req_codigo as codigoRequisicao  ");
        buf.append("     ,pac.pac_nome as nomePaciente  ");
        buf.append("     ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("     ,pac.pac_cpf as cpfPaciente  ");
        buf.append("     ,med.med_crm as crmMedico  ");
        buf.append("     ,med.med_nome as nomeMedico  ");
        buf.append("     ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("     ,exr.exr_ordem as sequenciaExame  ");
        buf.append("     ,exr.exr_dataassina as dataConferenciaExame  ");
        buf.append("     ,coalesce(exadesm.exa_codigo, exa.exa_codigo) as codigoExame  ");
        buf.append("     ,coalesce(exadesm.exa_descricao, exa.exa_descricao) as descricaoExame ");
        buf.append("     ,coalesce(dtpdesm.dtp_codamb, dtp.dtp_codamb) as ambExame ");
        buf.append("     ,req.req_excluida as requisicaoExcluida  ");
        buf.append("     ,exr.exr_excluido as exameExcluido  ");
        buf.append("     ,coalesce(cio.mco_kodigo, exr.mco_codigo) as codigoMaterial ");
        buf.append("     ,exa.exa_codigo as codigoExamePai  ");
        buf.append("     ,exr.mco_codigo as codigoMaterialPai \t\t ");
        buf.append("     ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("     ,req.con_codigo as codigoConvenio  ");
        buf.append("     ,req.des_codigo as codigoDestino  ");
        buf.append("     ,req.req_idade as idadePaciente  ");
        buf.append("     ,req.req_anomes as tipoIdadePaciente  ");
        buf.append("     ,exr.met_codigo as codigoMetodologia  ");
        buf.append("     ,exr.exr_situacao as situacaoExame  ");
        buf.append("     ,exr.exr_naofaturar as naoFaturarExame  ");
        buf.append("     ,exr.exr_excluido as excluidoExame ");
        buf.append("from requisicao req ");
        buf.append("join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo and cio.cio_pesquisarequisicao = true ");
        buf.append("join examerequisicao exrfilho on req.fil_codigo = exrfilho.fil_codigo and req.req_codigo = exrfilho.req_codigo and cio.exa_kodigo = exrfilho.exa_codigo and cio.mco_kodigo = exrfilho.mco_codigo ");
        buf.append("join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo  ");
        buf.append("join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho ");
        buf.append("join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo  ");
        buf.append("left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo  ");
        buf.append("left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        buf.append("left join detalhetabelapreco dtpdesm on exr.fil_codigo = dtpdesm.fil_codigo and cio.exa_kodigo = dtpdesm.exa_codigo and cio.mco_kodigo = dtpdesm.mco_codigo and con.tpe_codigo = dtpdesm.tpe_codigo ");
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("' ");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        buf.append("   and coalesce(exrfilho.exr_naofaturar, false) = false ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs;
            }
            return null;
        }
        catch (SQLException e) {
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel buscar dados para enviar \u00e0 operadora.", PROCESSO_BUSCA_DADOS);
        }
    }

    @Override
    public String getNomeIntegracaoOperadora() {
        return FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UPY.getDescricao();
    }

    public String getHash() {
        return this.hash;
    }
}

