/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.upy;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.upy.TipoDadoResultado;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorResultadoUpy
extends AbstractDialogoOKCancelar {
    public static final String TAG_EXAME_INTEGRACOES_INTEGRACAOUPY = "integracaoupy";
    public static final String TAG_EXAME_INTEGRACOES_LINHA_RESULTADO = "linha";
    private static ExameMatCol exa;
    private TTextField textDescricao = new TTextField(25);
    private JComboBox comboTipoDados = new JComboBox<Object>(new Object[]{TipoDadoResultado.ALFANUMERICO, TipoDadoResultado.DECIMAL});
    private JComboBox comboValorResultado = new JComboBox();
    private JComboBox comboUnidadeMedida = new JComboBox();
    private JComboBox comboValorReferencia = new JComboBox();
    private JLabel labelDescricao = new JLabel(CamposResultado.access$000(CamposResultado.DESCRICAO));
    private JLabel labelTipoDados = new JLabel(CamposResultado.access$000(CamposResultado.TIPO_DADOS));
    private JLabel labelValorResultado = new JLabel(CamposResultado.access$000(CamposResultado.RESULTADO));
    private JLabel labelUnidadeMedida = new JLabel(CamposResultado.access$000(CamposResultado.UNID_MEDIDA));
    private JLabel labelValorReferencia = new JLabel(CamposResultado.access$000(CamposResultado.VALOR_REFERENCIA));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{CamposResultado.access$000(CamposResultado.DESCRICAO), CamposResultado.access$000(CamposResultado.TIPO_DADOS), CamposResultado.access$000(CamposResultado.RESULTADO), CamposResultado.access$000(CamposResultado.UNID_MEDIDA), CamposResultado.access$000(CamposResultado.VALOR_REFERENCIA)});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonOK = new JButton("OK");
    JButton bBuscaResultado = new JButton();
    JButton bBuscaUnidadeMedida = new JButton();
    JButton bBuscaReferencia = new JButton();
    private static final int COLUNA_DESCRICAO = 0;
    private static final int COLUNA_TIPO_DADOS = 1;
    private static final int COLUNA_VALOR_RESULTADO = 2;
    private static final int COLUNA_UNIDADE_MEDIDA = 3;
    private static final int COLUNA_VALOR_REFERENCIA = 4;
    private String[] camposLaudo = null;
    private int linhaEdicao = -1;

    public static ConfiguradorResultadoUpy novaInstancia(Window pai, String[] camposLaudo, ExameMatCol ex) {
        exa = ex;
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoUpy((Dialog)pai, camposLaudo);
        }
        return new ConfiguradorResultadoUpy((JFrame)pai, camposLaudo);
    }

    private ConfiguradorResultadoUpy(Dialog pai, String[] camposLaudo) {
        super(pai, "Associando campos de resultados - UPY");
        this.camposLaudo = camposLaudo;
        this.montaTela();
    }

    private ConfiguradorResultadoUpy(JFrame pai, String[] camposLaudo) {
        super((Frame)pai, "Associando campos de resultados - UPY");
        this.camposLaudo = camposLaudo;
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.setSize(new Dimension(800, 400));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('D');
        this.getPanelCentral().add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.labelTipoDados.setLabelFor(this.comboTipoDados);
        this.labelTipoDados.setDisplayedMnemonic('T');
        this.getPanelCentral().add((Component)this.labelTipoDados, c);
        ++c.gridx;
        this.labelValorResultado.setLabelFor(this.comboValorResultado);
        this.labelValorResultado.setDisplayedMnemonic('V');
        this.getPanelCentral().add((Component)this.labelValorResultado, c);
        ++c.gridx;
        ++c.gridx;
        this.labelUnidadeMedida.setLabelFor(this.comboUnidadeMedida);
        this.labelUnidadeMedida.setDisplayedMnemonic('U');
        this.getPanelCentral().add((Component)this.labelUnidadeMedida, c);
        ++c.gridx;
        ++c.gridx;
        this.labelValorReferencia.setLabelFor(this.comboValorReferencia);
        this.labelValorReferencia.setDisplayedMnemonic('R');
        this.getPanelCentral().add((Component)this.labelValorReferencia, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textDescricao.setPreferredSize(new Dimension(200, 20));
        this.textDescricao.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.comboTipoDados.setPreferredSize(new Dimension(140, 20));
        this.comboTipoDados.setMinimumSize(new Dimension(140, 20));
        this.getPanelCentral().add((Component)this.comboTipoDados, c);
        ++c.gridx;
        this.comboValorResultado.setPreferredSize(new Dimension(120, 20));
        this.comboValorResultado.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.comboValorResultado, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.bBuscaResultado.setPreferredSize(new Dimension(20, 20));
        this.bBuscaResultado.setMaximumSize(new Dimension(20, 20));
        this.bBuscaResultado.setMinimumSize(new Dimension(20, 20));
        this.bBuscaResultado.setSize(new Dimension(20, 20));
        this.bBuscaResultado.setText("");
        this.bBuscaResultado.setFocusable(false);
        Funcoes.imagemPesquisa(this.bBuscaResultado);
        this.getPanelCentral().add((Component)this.bBuscaResultado, c);
        ++c.gridx;
        this.comboUnidadeMedida.setPreferredSize(new Dimension(120, 20));
        this.comboUnidadeMedida.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.comboUnidadeMedida, c);
        ++c.gridx;
        this.bBuscaUnidadeMedida.setPreferredSize(new Dimension(20, 20));
        this.bBuscaUnidadeMedida.setMaximumSize(new Dimension(20, 20));
        this.bBuscaUnidadeMedida.setMinimumSize(new Dimension(20, 20));
        this.bBuscaUnidadeMedida.setSize(new Dimension(20, 20));
        this.bBuscaUnidadeMedida.setText("");
        this.bBuscaUnidadeMedida.setFocusable(false);
        Funcoes.imagemPesquisa(this.bBuscaUnidadeMedida);
        this.getPanelCentral().add((Component)this.bBuscaUnidadeMedida, c);
        ++c.gridx;
        this.comboValorReferencia.setPreferredSize(new Dimension(120, 20));
        this.comboValorReferencia.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.comboValorReferencia, c);
        ++c.gridx;
        this.bBuscaReferencia.setPreferredSize(new Dimension(20, 20));
        this.bBuscaReferencia.setMaximumSize(new Dimension(20, 20));
        this.bBuscaReferencia.setMinimumSize(new Dimension(20, 20));
        this.bBuscaReferencia.setSize(new Dimension(20, 20));
        this.bBuscaReferencia.setText("");
        this.bBuscaReferencia.setFocusable(false);
        Funcoes.imagemPesquisa(this.bBuscaReferencia);
        this.getPanelCentral().add((Component)this.bBuscaReferencia, c);
        ++c.gridx;
        this.buttonOK.setPreferredSize(new Dimension(30, 20));
        this.buttonOK.setMinimumSize(new Dimension(30, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.setMnemonic('K');
        this.getPanelCentral().add((Component)this.buttonOK, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)this.scroll, c);
        this.modelo.setColumnSize(new int[]{0, 100, 150, 150, 150}, this.table);
        this.montaListeners();
        this.preencheCombosCamposLaudo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void preencheCombosCamposLaudo() {
        if (this.camposLaudo == null) {
            return;
        }
        this.comboUnidadeMedida.addItem("");
        this.comboValorReferencia.addItem("");
        this.comboValorResultado.addItem("");
        for (String campo : this.camposLaudo) {
            this.comboUnidadeMedida.addItem(campo);
            this.comboValorReferencia.addItem(campo);
            this.comboValorResultado.addItem(campo);
        }
    }

    private void montaListeners() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha = ConfiguradorResultadoUpy.this.table.getSelectedRow();
                if (linha > -1) {
                    if (e.getKeyCode() == 32) {
                        ConfiguradorResultadoUpy.this.modificaLinha(linha);
                    } else if (e.getKeyCode() == 127) {
                        ConfiguradorResultadoUpy.this.removeLinha(linha);
                    }
                }
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUpy.this.adicionaAssociacao();
            }
        });
        this.bBuscaResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUpy.this.configuraCampoResultado();
            }
        });
        this.bBuscaUnidadeMedida.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUpy.this.configuraCampoUnidadeMedida();
            }
        });
        this.bBuscaReferencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUpy.this.configuraCampoReferencia();
            }
        });
    }

    private void configuraCampoResultado() {
        String propriedadeCampoNomeResultado = exa.configuraAssociaCamposDeResultado();
        if (!Funcoes.textoVazio(propriedadeCampoNomeResultado)) {
            for (String campo : this.camposLaudo) {
                if (!campo.equalsIgnoreCase(propriedadeCampoNomeResultado)) continue;
                this.comboValorResultado.setSelectedItem(campo);
            }
        }
    }

    private void configuraCampoUnidadeMedida() {
        String propriedadeCampoNomeUnidade = exa.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            this.comboUnidadeMedida.setSelectedItem(campo);
        }
    }

    private void configuraCampoReferencia() {
        String propriedadeCampoNomeReferencia = exa.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeReferencia)) continue;
            this.comboValorReferencia.setSelectedItem(campo);
        }
    }

    private void adicionaAssociacao() {
        if (this.validaCamposAdicao()) {
            if (this.linhaEdicao > -1) {
                this.modelo.setValueAt(this.comboTipoDados.getSelectedItem() == null ? null : this.comboTipoDados.getSelectedItem().toString(), this.linhaEdicao, 1);
                this.modelo.setValueAt(this.comboUnidadeMedida.getSelectedItem() == null ? null : this.comboUnidadeMedida.getSelectedItem().toString(), this.linhaEdicao, 3);
                this.modelo.setValueAt(this.comboValorReferencia.getSelectedItem() == null ? null : this.comboValorReferencia.getSelectedItem().toString(), this.linhaEdicao, 4);
                this.modelo.setValueAt(this.comboValorResultado.getSelectedItem() == null ? null : this.comboValorResultado.getSelectedItem().toString(), this.linhaEdicao, 2);
            } else {
                boolean jaExiste = false;
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(this.textDescricao.getText())) continue;
                    Funcoes.mensagem(this, "A descri\u00e7\u00e3o j\u00e1 existe.\nUtilize outra descri\u00e7\u00e3o.", 2);
                    ScreenUtil.requisitarFoco(this.textDescricao);
                    return;
                }
                if (!jaExiste) {
                    this.modelo.addLine(new Object[]{this.textDescricao.getText(), this.comboTipoDados.getSelectedItem() == null ? null : this.comboTipoDados.getSelectedItem().toString(), this.comboValorResultado.getSelectedItem() == null ? null : this.comboValorResultado.getSelectedItem().toString(), this.comboUnidadeMedida.getSelectedItem() == null ? null : this.comboUnidadeMedida.getSelectedItem().toString(), this.comboValorReferencia.getSelectedItem() == null ? null : this.comboValorReferencia.getSelectedItem().toString()});
                }
            }
            this.textDescricao.clear();
            this.comboValorResultado.setSelectedItem("");
            this.comboUnidadeMedida.setSelectedItem("");
            this.comboValorReferencia.setSelectedItem("");
            ScreenUtil.requisitarFoco(this.textDescricao);
        }
    }

    private boolean validaCamposAdicao() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (this.comboValorResultado.getSelectedItem() == null || Funcoes.textoVazio(this.comboValorResultado.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "O campo do valor do resultado deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboValorResultado);
            return false;
        }
        return true;
    }

    private void removeLinha(int linha) {
        int resposta = Funcoes.mensagem(this, "Deseja remover a linha de associa\u00e7\u00e3o?", 4, true);
        if (resposta == 0) {
            this.modelo.removeLine(linha);
        }
    }

    private void modificaLinha(int linha) {
        this.linhaEdicao = linha;
        this.textDescricao.setText(this.modelo.getValueAt(linha, 0).toString());
        this.comboTipoDados.setSelectedItem(this.modelo.getValueAt(linha, 1));
        this.comboValorResultado.setSelectedItem(this.modelo.getValueAt(linha, 2));
        this.comboUnidadeMedida.setSelectedItem(this.modelo.getValueAt(linha, 3));
        this.comboValorReferencia.setSelectedItem(this.modelo.getValueAt(linha, 4));
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    public void setXML(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        String[] linhas = StringUtil.getValores(xml, TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
        if (linhas != null) {
            for (String linha : linhas) {
                String descricao = StringUtil.getValor(linha, CamposResultado.DESCRICAO.getTag());
                String tipoDado = StringUtil.getValor(linha, CamposResultado.TIPO_DADOS.getTag());
                String resultado = StringUtil.getValor(linha, CamposResultado.RESULTADO.getTag());
                String valorReferencia = StringUtil.getValor(linha, CamposResultado.VALOR_REFERENCIA.getTag());
                String unidadeMedida = StringUtil.getValor(linha, CamposResultado.UNID_MEDIDA.getTag());
                if (tipoDado.equalsIgnoreCase("TEXTO")) {
                    tipoDado = TipoDadoResultado.ALFANUMERICO.toString();
                }
                this.modelo.addLine(new Object[]{descricao, TipoDadoResultado.fromString(tipoDado), resultado, unidadeMedida, valorReferencia});
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXAME_INTEGRACOES_INTEGRACAOUPY);
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            xml.abrir(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
            xml.escrever(CamposResultado.DESCRICAO.getTag(), this.modelo.getValueAt(i, 0).toString());
            xml.escrever(CamposResultado.TIPO_DADOS.getTag(), this.modelo.getValueAt(i, 1).toString());
            Object aux = this.modelo.getValueAt(i, 3);
            if (aux != null) {
                xml.escrever(CamposResultado.UNID_MEDIDA.getTag(), aux.toString());
            }
            if ((aux = this.modelo.getValueAt(i, 4)) != null) {
                xml.escrever(CamposResultado.VALOR_REFERENCIA.getTag(), aux.toString());
            }
            if ((aux = this.modelo.getValueAt(i, 2)) != null) {
                xml.escrever(CamposResultado.RESULTADO.getTag(), aux.toString());
            }
            try {
                xml.fechar(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
                continue;
            }
            catch (XMLStringBuilderException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar o XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        try {
            xml.fechar(TAG_EXAME_INTEGRACOES_INTEGRACAOUPY);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar o XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public static enum CamposResultado {
        DESCRICAO("Descri\u00e7\u00e3o", "descricao"),
        TIPO_DADOS("Tipo de dado", "tipo"),
        RESULTADO("Valor do resultado", "resultado"),
        UNID_MEDIDA("Unidade de medida", "unidade"),
        VALOR_REFERENCIA("Valor de refer\u00eancia", "referencia");

        private String descricao = null;
        private String tag = null;

        private CamposResultado(String descricao, String tag) {
            this.descricao = descricao;
            this.tag = tag;
        }

        public String toString() {
            return this.descricao;
        }

        public String getTag() {
            return this.tag;
        }

        static /* synthetic */ String access$000(CamposResultado x0) {
            return x0.descricao;
        }
    }
}

