/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.upy;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

class ConfiguradorIntegracaoOperadoraUpy
extends AbstractDialogoOKCancelar {
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_CODIGO_LABORATORIO = "codigoLaboratorio";
    private String xml = null;
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio (login):");
    private JLabel labelSenha = new JLabel("Senha (login):");
    private JLabel labelCodigoLaboratorio = new JLabel("CNPJ do laborat\u00f3rio:");
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelVlrEstacao = new JLabel();
    private TTextField textUsuario = new TTextField(15);
    private TTextField textSenha = new TTextField(15);
    private TTextField textCodigoLaboratorio = new TTextField(18, 7);
    private TTextField textEstacao = new TTextField(10, 1);
    private JButton buttonEstacao = new JButton();

    public static ConfiguradorIntegracaoOperadoraUpy novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraUpy((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraUpy((JFrame)pai);
    }

    private ConfiguradorIntegracaoOperadoraUpy(Dialog pai) {
        super(pai, "Configurando UPY");
        this.montaTela();
    }

    private ConfiguradorIntegracaoOperadoraUpy(JFrame pai) {
        super((Frame)pai, "Configurando UPY");
        this.montaTela();
    }

    public void setXML(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.textEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_LOGIN))) {
                this.textUsuario.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_SENHA))) {
                this.textSenha.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_CODIGO_LABORATORIO);
            if (!Funcoes.textoVazio(xml)) {
                this.textCodigoLaboratorio.setText(aux);
            }
        }
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUpy.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraUpy.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUpy.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraUpy.this.buscaEstacao(ConfiguradorIntegracaoOperadoraUpy.this.textEstacao.getText());
                }
            }
        };
        this.textEstacao.addKeyListener(keyAdapter);
        this.textEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraUpy.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraUpy.this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraUpy.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraUpy.this.textEstacao.clear();
                    ConfiguradorIntegracaoOperadoraUpy.this.labelVlrEstacao.setText("");
                }
            }
        });
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.textEstacao);
        }
    }

    private void pesquisaEstacao() {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        } else {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UPY.getDescricao());
        xml.escrever("estacao", this.textEstacao.getText());
        xml.escrever(TAG_LOGIN, this.textUsuario.getText());
        xml.escrever(TAG_SENHA, this.textSenha.getText());
        xml.escrever(TAG_CODIGO_LABORATORIO, this.textCodigoLaboratorio.getText());
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(450, 175));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelUsuario, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelSenha, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCodigoLaboratorio, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.textEstacao.setPreferredSize(new Dimension(80, 20));
        this.textEstacao.setMinimumSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textEstacao, c);
        ++c.gridx;
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.buttonEstacao.setFocusable(false);
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelVlrEstacao.setPreferredSize(new Dimension(20, 20));
        this.labelVlrEstacao.setMinimumSize(new Dimension(20, 20));
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textUsuario.setPreferredSize(new Dimension(20, 20));
        this.textUsuario.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textUsuario, c);
        ++c.gridy;
        this.textSenha.setPreferredSize(new Dimension(20, 20));
        this.textSenha.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textSenha, c);
        ++c.gridy;
        this.textCodigoLaboratorio.setPreferredSize(new Dimension(20, 20));
        this.textCodigoLaboratorio.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textCodigoLaboratorio, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)new JLabel(), c);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.textEstacao);
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuario)) {
            Funcoes.mensagem(this, "O usu\u00e1rio de login deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenha)) {
            Funcoes.mensagem(this, "A senha de login deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoLaboratorio)) {
            Funcoes.mensagem(this, "O CNPJ do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
            return false;
        }
        return true;
    }
}

