/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.vtrp;

import br.com.unimedvtrp.siga.integracaolaudos.webservice.CabecalhoDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.DetalheArquivoPDFDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.DetalheGuiaDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.DetalheSistemaOrigemDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.DetalhesExecutanteDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ItemExameDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ListaItensExamesDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.MensagemGuiaDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.MensagemProcedimentoDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.MotivoReenvioDomain;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ProcedimentoDetalheDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ResultadosExamesDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ResultadosExamesSaidaDto;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ResultadosExamesWSImplServiceSoapBindingStub;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ResultadosExamesWSProxy;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.TipoExameDomain;
import br.com.unimedvtrp.siga.integracaolaudos.webservice.ValorRefDto;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorAgrupamentoUnimedVTRPModel;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorIntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorResultadoUnimedVTRP;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.operadora.vtrp.ConsultaVtrpDao;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.commons.codec.binary.Base64;

public class IntegracaoOperadoraUnimedVTRP
extends AbstractIntegracaoOperadora {
    private String xmlConfiguracao;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final Long VERSAO_XML = 1L;
    private static final String TAG_CODIGO_LABORATORIO = "laboratorio";
    private static final String TAG_LOGIN = "login";
    private static final String TAG_SENHA = "senha";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";
    private static final String PROCESSO_BUSCA_DADOS = "buscando dados";
    private static final String PROCESSO_BUSCA_LOGS = "buscando logs de integra\u00e7\u00e3o";
    private static final String PROCESSO_MARCA_LOG_EXPORTADO = "marcando log como exportado";
    private static final String PROCESSO_SOLICITA_ENVIO_RESULTADO = "solicitando envio de resultado";
    private static final String PROCESSO_ENVIA_RESULTADO = "enviando resultado";
    private static final String PROCESSO_MONTA_EXAME = "montando dados do exame";
    private String codigoLoginConfiguracao = null;
    private String senhaLoginConfiguracao = null;
    private String codigoLaboratorioConfiguracao = null;
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DA OPERADORA UNIMED VTRP";

    public IntegracaoOperadoraUnimedVTRP(String xml, int codigoConvenio) {
        this.xmlConfiguracao = xml;
        this.codigoConvenio = codigoConvenio;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            this.codigoLaboratorioConfiguracao = StringUtil.getValor(xml, "codigoLaboratorio");
            this.codigoLoginConfiguracao = StringUtil.getValor(xml, TAG_LOGIN);
            this.senhaLoginConfiguracao = StringUtil.getValor(xml, TAG_SENHA);
        }
    }

    public IntegracaoOperadoraUnimedVTRP(String xml, int codigoConvenio, Object[] parametro) {
        this.trataParametro(parametro);
        this.xmlConfiguracao = xml;
        this.codigoConvenio = codigoConvenio;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            this.codigoLaboratorioConfiguracao = StringUtil.getValor(xml, "codigoLaboratorio");
            this.codigoLoginConfiguracao = StringUtil.getValor(xml, TAG_LOGIN);
            this.senhaLoginConfiguracao = StringUtil.getValor(xml, TAG_SENHA);
        }
    }

    private void trataParametro(Object[] parametro) {
        try {
            ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayList = this.ToArrayList(parametro);
            this.setArrayConfiguradorAgrupUnimedModel(arrayList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> ToArrayList(Object[] parametro) throws Exception {
        ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> result = new ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel>();
        for (int i = 0; i < parametro.length; ++i) {
            if (!(parametro[i] instanceof ConfiguradorAgrupamentoUnimedVTRPModel)) {
                throw new Exception("N\u00e3o foi possivel fazer o cast para 'ConfiguradorAgrupamentoUnimedVTRPModel'");
            }
            result.add((ConfiguradorAgrupamentoUnimedVTRPModel)parametro[i]);
        }
        return result;
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        this.debug("integra\u00e7\u00e3o iniciada");
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        if (Funcoes.textoVazio(this.codigoLaboratorioConfiguracao)) {
            this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "O c\u00f3digo do laborat\u00f3rio n\u00e3o foi informado nas configura\u00e7\u00f5es do conv\u00eanio.", PROCESSO_CARREGAR_PARAMETROS));
            return this.erros;
        }
        if (Funcoes.textoVazio(this.codigoLoginConfiguracao)) {
            this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "O login do laborat\u00f3rio n\u00e3o foi informado nas configura\u00e7\u00f5es do conv\u00eanio.", PROCESSO_CARREGAR_PARAMETROS));
            return this.erros;
        }
        if (Funcoes.textoVazio(this.senhaLoginConfiguracao)) {
            this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "A senha de login n\u00e3o foi informada nas configura\u00e7\u00f5es do conv\u00eanio.", PROCESSO_CARREGAR_PARAMETROS));
            return this.erros;
        }
        ArrayList<Object> listaLogs = new ArrayList();
        try {
            listaLogs = this.getLogsIntegracao(this.codigoConvenio);
            this.debug("Quantidade logs carregados: " + String.valueOf(listaLogs.size()));
        }
        catch (IntegracaoOperadoraException e) {
            this.erros.errosProcesso.add(e);
            return this.erros;
        }
        HashMap<String, ArrayList<LogIntegracaoOperadora>> mapRequisicoes = new HashMap<String, ArrayList<LogIntegracaoOperadora>>();
        for (LogIntegracaoOperadora logIntegracaoOperadora : listaLogs) {
            if (logIntegracaoOperadora.getTipoOperacao() != AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) continue;
            try {
                String reqCodigo = logIntegracaoOperadora.getCodigoRequisicao().toString();
                if (mapRequisicoes.containsKey(reqCodigo)) {
                    ((ArrayList)mapRequisicoes.get(reqCodigo)).add(logIntegracaoOperadora);
                } else {
                    ArrayList<LogIntegracaoOperadora> logsIntegracao = new ArrayList<LogIntegracaoOperadora>();
                    logsIntegracao.add(logIntegracaoOperadora);
                    mapRequisicoes.put(reqCodigo, logsIntegracao);
                }
                this.enviarResultado(mapRequisicoes, logIntegracaoOperadora, false, false);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel integrar os dados com a operadora Unimed VTRP.", e.getStackTrace());
            }
        }
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.erros;
    }

    public void reenviarResultado(HashMap<String, ArrayList<LogIntegracaoOperadora>> mapLogs, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        this.enviarResultado(mapLogs, log, true, false);
    }

    private void enviarResultado(HashMap<String, ArrayList<LogIntegracaoOperadora>> mapLogs, LogIntegracaoOperadora log, boolean isReenvio, boolean procedimentoInserido) throws IntegracaoOperadoraException {
        Statement st = Conexao.getStatement();
        ArrayList<String> examesSemRelacionamento = new ArrayList<String>();
        try {
            for (String key : mapLogs.keySet()) {
                ArrayList<LogIntegracaoOperadora> logs = mapLogs.get(key);
                mapLogs.remove(key);
                for (LogIntegracaoOperadora logIntegracao : logs) {
                    ArrayList<Registro> registro = this.getDados(st, logIntegracao);
                    if (registro != null) {
                        for (Registro dadosExames : registro) {
                            if (!dadosExames.getDate("datarequisicao").after(Funcoes.stringToDate("31/08/2017"))) continue;
                            String formato = ExameUtil.pegaLayoutIdade(dadosExames.getString("codigofilial"), dadosExames.getInt("idadepaciente"), dadosExames.getString("tipoidadepaciente"), dadosExames.getString("layout"), dadosExames.getString("codigoexamepai"), dadosExames.getInt("codigomaterialpai"), dadosExames.getInt("codigometodologia"), "elm_formato");
                            String erroRetorno = "";
                            Map<String, Object> mapaResultado = this.getMapaResultado(dadosExames);
                            if (mapaResultado == null || mapaResultado.size() == 0) {
                                throw this.montaExcecao(new Exception(), null, "N\u00e3o h\u00e1 campos no resultado.", PROCESSO_MONTA_LINHA);
                            }
                            String[] linhas = null;
                            String xmlRelacionamentoLaudo = this.getXMLRelacionamentoLaudo(dadosExames);
                            if (Funcoes.textoVazio(xmlRelacionamentoLaudo)) {
                                examesSemRelacionamento.add("Exame sem relacionamento de campos: " + dadosExames.getString("codigoexame") + "- Material: " + dadosExames.getString("codigomaterial"));
                            } else {
                                linhas = StringUtil.getValores(xmlRelacionamentoLaudo, "linha");
                                String campo = "";
                                String valorResultado = "";
                                String unidadeMedida = "";
                                int total = 0;
                                for (String linha : linhas) {
                                    String[] campoResultado = StringUtil.getValor(linha, ConfiguradorResultadoUnimedVTRP.CamposResultado.RESULTADO.getTag());
                                    valorResultado = !Funcoes.textoVazio((String)campoResultado) && mapaResultado.get(campoResultado.toLowerCase()) != null ? mapaResultado.get(campoResultado.toLowerCase()).toString() : "";
                                    if (Funcoes.textoVazio(valorResultado)) continue;
                                    ++total;
                                }
                                int contador = 0;
                                ItemExameDto[] itensExames = new ItemExameDto[total];
                                ProcedimentoDetalheDto[] listaProcedimentosGuia = new ProcedimentoDetalheDto[1];
                                DetalheGuiaDto detalheGuia = new DetalheGuiaDto();
                                detalheGuia.setNrCarteira(StringUtil.limpaString(dadosExames.getString("carteirinha"), new String[]{".", "-", " "}));
                                detalheGuia.setNrGuia(dadosExames.getString("guiaexame"));
                                detalheGuia.setNrSenha(dadosExames.getString("senhaguia"));
                                for (String linha : linhas) {
                                    String campoUnidadeMedida;
                                    campo = StringUtil.getValor(linha, ConfiguradorResultadoUnimedVTRP.CamposResultado.DESCRICAO.getTag());
                                    String campoResultado = StringUtil.getValor(linha, ConfiguradorResultadoUnimedVTRP.CamposResultado.RESULTADO.getTag());
                                    if (!Funcoes.textoVazio(campoResultado)) {
                                        valorResultado = mapaResultado.get(campoResultado.toLowerCase()) != null ? mapaResultado.get(campoResultado.toLowerCase()).toString() : "";
                                    }
                                    if (!Funcoes.textoVazio(campoUnidadeMedida = StringUtil.getValor(linha, ConfiguradorResultadoUnimedVTRP.CamposResultado.UNID_MEDIDA.getTag()))) {
                                        if (campoUnidadeMedida == null) {
                                            this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "N\u00e3o h\u00e1 valor para o campo \"" + campoUnidadeMedida + "\" (configurado como campo de unidade de medida).", PROCESSO_MONTA_LINHA));
                                        } else {
                                            unidadeMedida = mapaResultado.get(campoUnidadeMedida.toLowerCase()) != null ? mapaResultado.get(campoUnidadeMedida.toLowerCase()).toString() : campoUnidadeMedida;
                                        }
                                    }
                                    if (Funcoes.textoVazio(valorResultado)) continue;
                                    ItemExameDto itemExame = new ItemExameDto();
                                    itemExame.setNomeItemExame(campo);
                                    itemExame.setUnidadeItemExame(unidadeMedida);
                                    itemExame.setValorItemExame(valorResultado);
                                    String valorReferencia = StringUtil.getValor(linha, ConfiguradorResultadoUnimedVTRP.CamposResultado.REFERENCIA.getTag());
                                    String[] referencias = StringUtil.getValores(valorReferencia, "valorreferencia");
                                    if (referencias.length > 0) {
                                        ValorRefDto[] listaValorRefDto = new ValorRefDto[referencias.length];
                                        int cont = 0;
                                        for (String ref : referencias) {
                                            BigDecimal valorMinimo = BigDecimal.ZERO;
                                            BigDecimal valorMaximo = BigDecimal.ZERO;
                                            if (!Funcoes.textoVazio(StringUtil.getValor(ref, "minimo"))) {
                                                valorMinimo = new BigDecimal(StringUtil.getValor(ref, "minimo").replaceAll(",", "."));
                                            }
                                            if (!Funcoes.textoVazio(StringUtil.getValor(ref, "maximo"))) {
                                                valorMaximo = new BigDecimal(StringUtil.getValor(ref, "maximo").replaceAll(",", "."));
                                            }
                                            listaValorRefDto[cont] = new ValorRefDto(StringUtil.getValor(ref, "descricao"), StringUtil.getValor(ref, "unidade"), valorMaximo, valorMinimo);
                                            ++cont;
                                        }
                                        itemExame.setListaValorRef(listaValorRefDto);
                                    }
                                    itensExames[contador] = itemExame;
                                    ++contador;
                                }
                                ListaItensExamesDto listaItensExame = new ListaItensExamesDto();
                                listaItensExame.setItemExame(itensExames);
                                DetalhesExecutanteDto executante = new DetalhesExecutanteDto();
                                try {
                                    executante.setCodigoPrestador(Long.parseLong(StringUtil.getValor(dadosExames.getString("xml"), "codigoLaboratorio")));
                                }
                                catch (Exception e) {
                                    logIntegracao.setRetorno("Conv\u00eanio " + dadosExames.getInt("codigoconvenio") + " n\u00e3o configurado!");
                                    this.atualizarSituacao(logIntegracao, "", dadosExames.getInt("codigoconvenio"));
                                    throw new Exception(logIntegracao.getRetorno() + " - " + e.getMessage());
                                }
                                executante.setVersaoXML(VERSAO_XML.longValue());
                                executante.setTipoExame(new TipoExameDomain("L"));
                                DetalheSistemaOrigemDto detalheSistema = new DetalheSistemaOrigemDto();
                                detalheSistema.setDataHoraGeracao(IntegracaoOperadoraUnimedVTRP.ConverterDateEmCalendar(Calendar.getInstance().getTime()));
                                detalheSistema.setNomeSistema(dadosExames.getString("razaosocial"));
                                Long codigoLote = this.getSequenceUnimedVTRP();
                                detalheSistema.setNumeroArquivo(codigoLote.longValue());
                                CabecalhoDto cabecalho = new CabecalhoDto();
                                cabecalho.setDetalhesExecutante(executante);
                                cabecalho.setDetalheSistemaOrigem(detalheSistema);
                                ArrayList<ProcedimentoDetalheDto> listaDeProcedimento = new ArrayList<ProcedimentoDetalheDto>();
                                ProcedimentoDetalheDto procedimento = new ProcedimentoDetalheDto();
                                ResultadosExamesDto resultadosExames = new ResultadosExamesDto();
                                DetalheGuiaDto[] listaGuias = new DetalheGuiaDto[1];
                                DetalheArquivoPDFDto[] listaArquivosPDF = new DetalheArquivoPDFDto[1];
                                procedimento.setDataColeta(IntegracaoOperadoraUnimedVTRP.ConverterDateEmCalendar(dadosExames.getDate("datacoleta")));
                                procedimento.setDataLaudo(IntegracaoOperadoraUnimedVTRP.ConverterDateEmCalendar(dadosExames.getDate("datarequisicao")));
                                procedimento.setDataLiberacao(IntegracaoOperadoraUnimedVTRP.ConverterDateEmCalendar(dadosExames.getDate("dataconferenciaexame")));
                                String codigoAmb = StringUtil.limpaString(dadosExames.getString("codigoamb"), new String[]{".", "-", " "});
                                if (Funcoes.textoVazio(codigoAmb)) {
                                    erroRetorno = "C\u00f3digo AMB n\u00e3o informado " + dadosExames.getString("codigoexame");
                                }
                                procedimento.setCodigoProcedimento(codigoAmb);
                                procedimento.setIdRegistroProcedimento(1L);
                                procedimento.setListaItensExame(listaItensExame);
                                procedimento.setMaterial(dadosExames.getString("descricaomaterial"));
                                procedimento.setMetodo(dadosExames.getString("descricaometodologia"));
                                procedimento.setNomeProcedimento(dadosExames.getString("descricaoexame"));
                                procedimento.setNomeResponsavelLaudo(dadosExames.getString("nomemedico"));
                                procedimento.setNomeResponsavelTecnico(dadosExames.getString("nomemedico"));
                                procedimento.setNrResponsavelTecnico(dadosExames.getString("crmmedico"));
                                procedimento.setNrResponsavelLaudo(dadosExames.getString("crmmedico"));
                                procedimento.setObservacao(dadosExames.getString("observacao"));
                                if (!Funcoes.textoVazio(StringUtil.getValor(formato, "versaoExame"))) {
                                    procedimento.setVersaoExame(Long.parseLong(StringUtil.getValor(formato, "versaoExame")));
                                } else {
                                    procedimento.setVersaoExame(Long.parseLong("1"));
                                }
                                if (isReenvio && (procedimentoInserido || ConsultaVtrpDao.consultarExameRetificado(log))) {
                                    procedimento.setMotivoReenvio(MotivoReenvioDomain.R);
                                }
                                listaDeProcedimento.add(procedimento);
                                listaProcedimentosGuia[0] = procedimento;
                                detalheGuia.setListaProcedimentosGuia(listaProcedimentosGuia);
                                String requisicao = logIntegracao.getCodigoRequisicao().toString();
                                String pdf = this.montaExamesRealizados(dadosExames.getString("codigofilial"), requisicao, dadosExames.getString("codigoexamepai"), dadosExames.getString("codigomaterialpai"));
                                if (!Funcoes.textoVazio(pdf)) {
                                    DetalheArquivoPDFDto detalhePdf = new DetalheArquivoPDFDto();
                                    detalhePdf.setArquivoPDF(pdf);
                                    detalhePdf.setAssinaturaDigitalArquivo("");
                                    String[] listaProcedimentosArquivo = new String[listaDeProcedimento.size()];
                                    listaProcedimentosArquivo[0] = procedimento.getCodigoProcedimento();
                                    detalhePdf.setListaProcedimentosArquivo(listaProcedimentosArquivo);
                                    listaArquivosPDF[0] = detalhePdf;
                                    detalheGuia.setListaArquivosPDF(listaArquivosPDF);
                                    procedimento.setAssinaturaDigitalProcedimento("");
                                    listaGuias[0] = detalheGuia;
                                    resultadosExames.setListaGuias(listaGuias);
                                }
                                if (Funcoes.textoVazio(logIntegracao.getCodigoRequisicao().toString())) {
                                    log.setCodigoRequisicao(dadosExames.getInt("codigorequisicao"));
                                }
                                if (Funcoes.textoVazio(logIntegracao.getCodigoExame())) {
                                    log.setCodigoExame(dadosExames.getString("codigoexame"));
                                }
                                if (Funcoes.textoVazio(logIntegracao.getCodigoMaterial().toString())) {
                                    log.setCodigoMaterial(dadosExames.getInt("codigomaterial"));
                                }
                                if (Funcoes.textoVazio(logIntegracao.getCodigoConvenio().toString()) || logIntegracao.getCodigoConvenio().intValue() != dadosExames.getInt("codigoconvenio")) {
                                    log.setCodigoConvenio(dadosExames.getInt("codigoconvenio"));
                                }
                                try {
                                    String situacaoSolicitacao;
                                    this.debug("Tentando enviar log " + logIntegracao.getCodigoLog());
                                    ResultadosExamesSaidaDto retorno = this.enviarResultado(dadosExames, cabecalho, resultadosExames);
                                    String string = situacaoSolicitacao = retorno.getMensagem() != null ? retorno.getMensagem() : null;
                                    if (Funcoes.textoVazio(situacaoSolicitacao)) {
                                        MensagemGuiaDto[] guias = retorno.getListaGuias();
                                        Long idLote = retorno.getIdLoteXml();
                                        for (int i = 0; i < guias.length; ++i) {
                                            MensagemProcedimentoDto[] procedimentos;
                                            situacaoSolicitacao = guias[i].getMensagem();
                                            if (!Funcoes.textoVazio(situacaoSolicitacao) || (procedimentos = guias[i].getListaProcedimento()) == null || procedimentos.length <= 0) continue;
                                            for (int j = 0; j < procedimentos.length; ++j) {
                                                logIntegracao.setRetorno(procedimentos[j].getMensagem());
                                                if (Funcoes.textoVazio(procedimentos[j].getMensagem())) continue;
                                                situacaoSolicitacao = procedimentos[j].getMensagem();
                                            }
                                        }
                                        System.out.println("\n--------------------------------");
                                        System.out.print("RETORNO: " + log.getCodigoExame() + " - " + log.getCodigoRequisicao() + situacaoSolicitacao + "\n" + retorno.getMensagem());
                                        System.out.println("--------------------------------\n");
                                        if (situacaoSolicitacao.contains("Procedimento enviado com sucesso.")) {
                                            logIntegracao.setRetorno(situacaoSolicitacao);
                                            this.marcaLogExportado(logIntegracao);
                                        } else if (situacaoSolicitacao.contains("Procedimento j\u00e1 enviado, para reenvio do resultado \u00e9 necess\u00e1rio o motivo do reenvio")) {
                                            logIntegracao.setRetorno(situacaoSolicitacao);
                                            ArrayList<LogIntegracaoOperadora> logsIntegracao = new ArrayList<LogIntegracaoOperadora>();
                                            logsIntegracao.add(logIntegracao);
                                            mapLogs.put(key, logsIntegracao);
                                            this.enviarResultado(mapLogs, logIntegracao, true, true);
                                        } else {
                                            logIntegracao.setRetorno(erroRetorno + " - " + situacaoSolicitacao);
                                            this.atualizarSituacao(logIntegracao, "R");
                                            this.erros.errosEnvioResultado.add(this.montaExcecao(new Exception(), logIntegracao, situacaoSolicitacao, PROCESSO_SOLICITA_ENVIO_RESULTADO));
                                        }
                                    } else {
                                        logIntegracao.setRetorno(erroRetorno + " - " + situacaoSolicitacao);
                                        this.atualizarSituacao(logIntegracao, "R");
                                        situacaoSolicitacao = "Erro Retornado pelo webservice da Unimed VTRP: " + situacaoSolicitacao;
                                        this.erros.errosEnvioResultado.add(this.montaExcecao(new Exception(), logIntegracao, situacaoSolicitacao, PROCESSO_SOLICITA_ENVIO_RESULTADO));
                                    }
                                    Thread.sleep(5000L);
                                }
                                catch (Exception e) {
                                    log.setRetorno(erroRetorno + " - " + e.getMessage());
                                    this.atualizarSituacao(logIntegracao, "R");
                                    this.erros.errosProcesso.add(this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel enviar comando de solicita\u00e7\u00e3o de envio.\n" + e.getMessage(), PROCESSO_SOLICITA_ENVIO_RESULTADO));
                                }
                            }
                            if (examesSemRelacionamento.size() <= 0) continue;
                            log.setRetorno("Exame sem relacionamento de campos: " + dadosExames.getString("codigoexame") + "- Material: " + dadosExames.getString("codigomaterial"));
                            this.atualizarSituacao(logIntegracao, "R");
                            this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "Exame sem relacionamento de campos: " + dadosExames.getString("codigoexame") + "- Material: " + dadosExames.getString("codigomaterial"), PROCESSO_MONTA_LINHA));
                        }
                    }
                    this.debug("Log " + logIntegracao.getCodigoLog() + ": " + logIntegracao.getRetorno());
                }
            }
        }
        catch (Exception e) {
            log.setRetorno(e.getMessage() + e.getLocalizedMessage());
            this.atualizarSituacao(log, "");
            this.erros.errosProcesso.add(this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel enviar comando de solicita\u00e7\u00e3o de envio.\n" + e.getMessage(), PROCESSO_SOLICITA_ENVIO_RESULTADO));
        }
    }

    private ResultadosExamesSaidaDto enviarResultado(Registro registro, CabecalhoDto cabecalho, ResultadosExamesDto resultadosExames) throws ServiceException, RemoteException, MalformedURLException {
        ResultadosExamesWSProxy proxy = new ResultadosExamesWSProxy();
        String usuario = StringUtil.getValor(registro.getString("xml"), TAG_LOGIN);
        String senha = StringUtil.getValor(registro.getString("xml"), TAG_SENHA);
        String enderecoWebService = StringUtil.getValor(registro.getString("xml"), "enderecoWebService");
        ResultadosExamesWSImplServiceSoapBindingStub conexao = new ResultadosExamesWSImplServiceSoapBindingStub(new URL(enderecoWebService), null);
        proxy.setEndpoint(enderecoWebService);
        conexao.setUsername(usuario);
        conexao.setPassword(senha);
        conexao._createCall();
        return conexao.resultadosExames(cabecalho, resultadosExames);
    }

    private boolean validarPeriodo(Registro registro) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("  from requisicao req ");
        buf.append(" where req.fil_codigo = ").append(registro.getInt("codigoFilial"));
        buf.append("   and req.req_codigo = ").append(registro.getInt("codigoRequisicao"));
        buf.append("   and req.req_data >= '2017-09-01'");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            return rs.next();
        }
        catch (SQLException e) {
            this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar dados para enviar \u00e0 operadora." + e.getMessage(), PROCESSO_BUSCA_DADOS);
            return false;
        }
    }

    private Long getSequenceUnimedVTRP() {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("select nextval('unimedvtrp_sequence') as codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, bui);
            if (rs.next()) {
                return rs.getLong("codigo");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizaCodigoLote(String xmlAux, String filial, String convenio) {
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        bui.append(" update convenios set con_integracaooperadora = ' ").append(xmlAux.trim()).append("'");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and con_codigo = ").append(convenio);
        try {
            Conexao.executeUpdate(filial, st, bui.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar o c\u00f3digo do lote. \n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void marcaLogExportado(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        Statement st = ConexaoTemporaria.getStatement();
        String logRetorno = StringUtil.textoDBEscape(log.getRetorno());
        if (logRetorno.length() > 2000) {
            logRetorno = log.getRetorno().substring(0, 1999);
        }
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaintegracaooperadora ");
            buf.append(" set eio_exportado = true ");
            buf.append(" ,eio_retorno = ").append(logRetorno);
            buf.append(" ,eio_situacao = '").append("E").append("'");
            buf.append(" ,req_codigo = ").append(log.getCodigoRequisicao());
            buf.append(" ,exa_codigo = '").append(log.getCodigoExame()).append("'");
            buf.append(" ,mco_codigo = ").append(log.getCodigoMaterial());
            buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
            buf.append(" and eio_codigo = ").append(log.getCodigoLog());
            int qtde = ConexaoTemporaria.executeUpdate(st, buf);
            if (qtde == 0) {
                throw this.montaExcecao(new Exception(), log, "N\u00e3o foi poss\u00edvel marcar o log como exportado.", PROCESSO_MARCA_LOG_EXPORTADO);
            }
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel marcar log como exportado.\n" + e.getMessage(), PROCESSO_MARCA_LOG_EXPORTADO);
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private ArrayList<Registro> getDados(Statement st, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_matricula as carteirinha ");
        buf.append("       ,req.req_validadecarteira as validadeCarteirinha ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("       ,exr.exr_ordem as sequenciaExame ");
        buf.append("       ,exr.exr_dataassina as dataConferenciaExame ");
        buf.append("       ,coalesce(exadesm.exa_codigo, exa.exa_codigo) as codigoExame ");
        buf.append("       ,coalesce(exadesm.exa_descricao, exa.exa_descricao) as descricaoExame ");
        buf.append("       ,req.req_excluida as requisicaoExcluida ");
        buf.append("       ,exr.exr_excluido as exameExcluido ");
        buf.append("       ,coalesce(cio.mco_kodigo, exr.mco_codigo) as codigoMaterial ");
        buf.append("       ,matcol.mco_descricao as descricaoMaterial ");
        buf.append("       ,exa.exa_codigo as codigoExamePai ");
        buf.append("       ,exr.mco_codigo as codigoMaterialPai ");
        buf.append("       ,exr.exr_datamaterial as dataColeta ");
        buf.append("       ,exr_codautorizacao as senhaGuia ");
        buf.append("       ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_idade as idadePaciente ");
        buf.append("       ,req.req_anomes as tipoIdadePaciente ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("       ,met.met_descricao as descricaoMetodologia ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_obs as observacao ");
        buf.append("       ,con.con_integracaooperadora as xml ");
        buf.append("       ,con.con_razao as razaoSocial ");
        buf.append("       ,el.lay_codigo as layout ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,dtm.dtm_codamb as codigoAmb ");
        } else {
            buf.append("      ,dtp.dtp_codamb as codigoAmb ");
        }
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and med.med_uf = req.med_uf");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("  join examelayout el on exr.fil_codigo = el.fil_codigo and exr.exa_codigo = el.exa_codigo and exr.mco_codigo = el.mco_codigo and el.ela_padrao = true ");
        buf.append("  join examelayoutmetodo elm on exr.fil_codigo = elm.fil_codigo and exr.exa_codigo = elm.exa_codigo and exr.mco_codigo = elm.mco_codigo and exr.met_codigo = elm.met_codigo and elm.lay_codigo = el.lay_codigo\t");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  join materialcoleta matcol on exr.fil_codigo = matcol.fil_codigo and exr.mco_codigo = matcol.mco_codigo ");
        buf.append("  join metodologia met on exr.fil_codigo = met.fil_codigo and exr.met_codigo = met.met_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtm.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtp.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        buf.append(" UNION ");
        buf.append(" select distinct req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_matricula as carteirinha ");
        buf.append("       ,req.req_validadecarteira as validadeCarteirinha ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("       ,exr.exr_ordem as sequenciaExame ");
        buf.append("       ,exr.exr_dataassina as dataConferenciaExame ");
        buf.append("       ,coalesce(exadesm.exa_codigo, exa.exa_codigo) AS codigoExame ");
        buf.append("       ,coalesce(exadesm.exa_descricao, exa.exa_descricao) AS descricaoExame ");
        buf.append("       ,req.req_excluida as requisicaoExcluida ");
        buf.append("       ,exr.exr_excluido as exameExcluido ");
        buf.append("       ,exr.mco_codigo as codigoMaterial ");
        buf.append("       ,matcol.mco_descricao as descricaoMaterial ");
        buf.append("       ,exa.exa_codigo as codigoExamePai ");
        buf.append("       ,exr.mco_codigo as codigoMaterialPai ");
        buf.append("       ,exr.exr_datamaterial as dataColeta ");
        buf.append("       ,exr_codautorizacao as senhaGuia ");
        buf.append("       ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_idade as idadePaciente ");
        buf.append("       ,req.req_anomes as tipoIdadePaciente ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("       ,met.met_descricao as descricaoMetodologia ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_obs as observacao ");
        buf.append("       ,con.con_integracaooperadora as xml ");
        buf.append("       ,con.con_razao as razaoSocial ");
        buf.append("       ,el.lay_codigo as layout ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,dtm.dtm_codamb as codigoAmb ");
        } else {
            buf.append("      ,dtp.dtp_codamb as codigoAmb ");
        }
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and med.med_uf = req.med_uf");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("  join examelayout el on exr.fil_codigo = el.fil_codigo and exr.exa_codigo = el.exa_codigo and exr.mco_codigo = el.mco_codigo and el.ela_padrao = true ");
        buf.append("  join examelayoutmetodo elm on exr.fil_codigo = elm.fil_codigo and exr.exa_codigo = elm.exa_codigo and exr.mco_codigo = elm.mco_codigo and exr.met_codigo = elm.met_codigo and elm.lay_codigo = el.lay_codigo\t");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  join materialcoleta matcol on exr.fil_codigo = matcol.fil_codigo and exr.mco_codigo = matcol.mco_codigo ");
        buf.append("  join metodologia met on exr.fil_codigo = met.fil_codigo and exr.met_codigo = met.met_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtm.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtp.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            ArrayList<Registro> registro = new ArrayList<Registro>();
            boolean exameConferido = true;
            while (rs.next()) {
                registro.add(new Registro(rs));
                if (!DBUtil.campoNull(rs.getString("dataConferenciaExame"))) continue;
                exameConferido = false;
            }
            if (exameConferido) {
                return registro;
            }
            return null;
        }
        catch (SQLException e) {
            throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar dados para enviar \u00e0 operadora." + e.getMessage(), PROCESSO_BUSCA_DADOS);
        }
    }

    private ArrayList<LogIntegracaoOperadora> getLogsIntegracao(int codigoConvenio) throws IntegracaoOperadoraException {
        boolean usarData = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrp.jalis");
        boolean usaConvenio = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrpConvenio.jalis");
        String data = "";
        String convenio = "";
        try {
            String x;
            if (usarData && !Funcoes.textoVazio(x = StringUtil.lerArquivoTexto(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrp.jalis"))) {
                data = x.length() == 10 ? " and cast(eio_datahora as date) >= '" + x + "' " : x;
            }
            if (usaConvenio && !Funcoes.textoVazio(x = StringUtil.lerArquivoTexto(System.getProperty("user.home") + System.getProperty("file.separator") + "unimedvtrpConvenio.jalis"))) {
                convenio = " and con_codigo in (" + x + ") ";
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel validar os arquivos de data e conv\u00eanio.\nMensagem: " + e.getMessage(), 1);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,eio_situacao as situacao ");
        buf.append("  from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and con_codigo = ").append(codigoConvenio);
        buf.append("    and ( eio_situacao is null or eio_situacao = '') ");
        buf.append("    and eio_operacao ilike '%<nomeintegracaooperadora>Unimed VTRP</nomeintegracaooperadora>%' ");
        if (usarData && !Funcoes.textoVazio(data)) {
            buf.append(data);
        }
        if (usaConvenio && !Funcoes.textoVazio(convenio)) {
            buf.append(convenio);
        }
        buf.append("  order by eio_codigo ");
        buf.append("  limit 50 ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
            if (rs != null && rs.next()) {
                do {
                    listaLogs.add(this.getLogIntegracao(rs));
                } while (rs.next());
            } else {
                ArrayList<LogIntegracaoOperadora> arrayList = null;
                return arrayList;
            }
            ArrayList<LogIntegracaoOperadora> arrayList = listaLogs;
            return arrayList;
        }
        catch (SQLException e) {
            throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), PROCESSO_BUSCA_LOGS);
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private LogIntegracaoOperadora getLogIntegracao(ResultSet rs) throws SQLException {
        Integer codigoFilial = rs.getInt("codigoFilial");
        Integer codigoLog = rs.getInt("codigoLog");
        Integer cod_convenio = rs.getInt("codigoConvenio");
        String tipoOperacao = rs.getString("tipoOperacao");
        String retorno = rs.getString("retorno");
        String situacao = rs.getString("situacao");
        String operacao = rs.getString("operacao");
        Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
        String codigoExame = StringUtil.getValor(operacao, "codexa");
        Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
        LogIntegracaoOperadora logIntegracaoOperadora = new LogIntegracaoOperadora();
        logIntegracaoOperadora.setCodigoFilial(codigoFilial);
        logIntegracaoOperadora.setCodigoLog(codigoLog.intValue());
        logIntegracaoOperadora.setCodigoConvenio(cod_convenio);
        logIntegracaoOperadora.setCodigoRequisicao(codigoRequisicao);
        logIntegracaoOperadora.setCodigoExame(codigoExame);
        logIntegracaoOperadora.setCodigoMaterial(codigoMaterial);
        logIntegracaoOperadora.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(tipoOperacao));
        logIntegracaoOperadora.setXmlLog(operacao);
        logIntegracaoOperadora.setRetorno(retorno);
        logIntegracaoOperadora.setSituacao(situacao);
        return logIntegracaoOperadora;
    }

    private String getXMLRelacionamentoLaudo(Registro registro) throws IntegracaoOperadoraException {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            String codigoLayoutConvenio = ExameUtil.getCodigoLayout(registro.getString("codigofilial"), registro.getString("codigoconvenio"), registro.getString("codigodestino"), st);
            String xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(registro.getString("codigofilial"), registro.getInt("idadepaciente"), registro.getString("tipoidadepaciente"), codigoLayoutConvenio, registro.getString("codigoexamepai"), registro.getInt("codigomaterialpai"), registro.getString("codigometodologia"), st);
            if (Funcoes.textoVazio(xmlLayout)) {
                String string = null;
                return string;
            }
            if (Funcoes.textoVazio(xmlLayout = StringUtil.getValor(xmlLayout, "integracaovtrp"))) {
                String string = null;
                return string;
            }
            String string = xmlLayout;
            return string;
        }
        catch (Exception e) {
            throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar o XML de associa\u00e7\u00e3o de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private String getXMLRelacionamentoLaudo(ResultSet rs, LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        String string;
        String xmlLayout;
        Statement st;
        block7: {
            block6: {
                st = Conexao.getStatement();
                String codigoLayoutConvenio = ExameUtil.getCodigoLayout(rs.getString("codigoFilial"), rs.getString("codigoConvenio"), rs.getString("codigoDestino"), st);
                xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(rs.getString("codigoFilial"), rs.getInt("idadePaciente"), rs.getString("tipoIdadePaciente"), codigoLayoutConvenio, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getString("codigoMetodologia"), st);
                if (!Funcoes.textoVazio(xmlLayout)) break block6;
                String string2 = null;
                Conexao.fecharStatement(st);
                return string2;
            }
            xmlLayout = StringUtil.getValor(xmlLayout, "integracaoupy");
            if (!Funcoes.textoVazio(xmlLayout)) break block7;
            String string3 = null;
            Conexao.fecharStatement(st);
            return string3;
        }
        try {
            string = xmlLayout;
        }
        catch (Exception e) {
            try {
                throw this.montaExcecao(e, log, "N\u00e3o foi poss\u00edvel buscar o XML de associa\u00e7\u00e3o de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private Map<String, Object> getMapaResultado(Registro registro) throws IntegracaoOperadoraException {
        Object mapaResultado = null;
        try {
            return Resultado.getTodosCamposResultado(registro.getString("resultado"), false);
        }
        catch (Exception e) {
            throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar os campos de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
        }
    }

    private IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (excecao != null && excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        } else {
            if (excecao != null) {
                buf.append(" - ").append(excecao.toString());
            }
            if (excecao instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraUnimedVTRP janelaConfiguracao = ConfiguradorIntegracaoOperadoraUnimedVTRP.novaInstancia(parent, this.codigoConvenio, this.getArrayConfiguradorAgrupUnimedModel());
        janelaConfiguracao.setXML(xmlConfig);
        janelaConfiguracao.setVisible(true);
        if (janelaConfiguracao.getOK()) {
            this.setArrayConfiguradorAgrupUnimedModel(janelaConfiguracao.getArrayConfiguradorAgrupUnimedModel());
            return janelaConfiguracao.getXML();
        }
        return xmlConfig;
    }

    public static Calendar ConverterDateEmCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizarSituacao(LogIntegracaoOperadora log, String situacao) {
        Statement st = Conexao.getStatement();
        String logRetorno = log.getRetorno();
        logRetorno = logRetorno.length() > 2000 ? StringUtil.textoDBEscape(logRetorno.substring(0, 1999)) : StringUtil.textoDBEscape(logRetorno);
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append(" set eio_situacao = '").append(situacao).append("'");
        buf.append(" ,eio_retorno = ").append(logRetorno);
        buf.append(" ,req_codigo = ").append(log.getCodigoRequisicao());
        buf.append(" ,exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append(" ,mco_codigo = ").append(log.getCodigoMaterial());
        buf.append(" ,con_codigo = ").append(log.getCodigoConvenio());
        if (!situacao.equals("")) {
            buf.append(" ,eio_exportado = true ");
        }
        buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
        buf.append(" and eio_codigo = ").append(log.getCodigoLog());
        try {
            Conexao.execute(log.getCodigoFilial().toString(), st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizarSituacao(LogIntegracaoOperadora log, String situacao, int con_codigo) {
        Statement st = Conexao.getStatement();
        String logRetorno = log.getRetorno();
        logRetorno = logRetorno.length() > 2000 ? StringUtil.textoDBEscape(logRetorno.substring(0, 1999)) : StringUtil.textoDBEscape(logRetorno);
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append(" set eio_situacao = '").append(situacao).append("'");
        buf.append(" ,eio_retorno = ").append(logRetorno);
        buf.append(" ,req_codigo = ").append(log.getCodigoRequisicao());
        buf.append(" ,exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append(" ,mco_codigo = ").append(log.getCodigoMaterial());
        buf.append(" ,con_codigo = ").append(con_codigo);
        buf.append(" ,eio_exportado = true ");
        buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
        buf.append(" and eio_codigo = ").append(log.getCodigoLog());
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!IntegracaoOperadoraUnimedVTRP.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append(" (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append(" values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequsicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static void atualizarLogExportaIntegracaoOperadoraExameDesmarcadoConferido(Statement st, String codFilial, Registro dadosReq, Registro reg) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update exportaintegracaooperadora set eio_situacao = '").append("D").append("', ");
        sql.append(" eio_retorno = 'Exame desmarcado conferido' ");
        sql.append(" where eio_operacao ilike '%<nomeintegracaooperadora>Unimed VTRP</nomeintegracaooperadora>%' ");
        sql.append(" and fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(dadosReq.getString("req_codigo"));
        sql.append(" and con_codigo = ").append(dadosReq.getString("con_codigo"));
        sql.append(" and pac_codigo = ").append(dadosReq.getString("pac_codigo"));
        sql.append(" and exa_codigo = '").append(reg.getString("exa_codigo")).append("' ");
        sql.append(" and mco_codigo = ").append(reg.getString("mco_codigo"));
        try {
            Conexao.executeUpdate(codFilial, st, sql);
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar log de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private String montaExamesRealizados(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws IntegracaoOperadoraException {
        RetornoImpressaoResultados pdf = null;
        try {
            pdf = ImpressaoResultados.imprimirExames(null, null, codigoFilial, codigoRequisicao, true, true, null, new String[]{codigoExame}, new String[]{codigoMaterial}, true, null, true, true, null, true, "", true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String pdfBinario = null;
        if (pdf != null) {
            pdfBinario = Base64.encodeBase64String((byte[])pdf.getResultadoPdfWeb());
        }
        return pdfBinario;
    }
}

