/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.vtrp;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.util.ConfigurarValoresReferencia;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.Collator;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorResultadoUnimedVTRP
extends AbstractDialogoOKCancelar {
    public static final String TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDVTRP = "integracaovtrp";
    public static final String TAG_EXAME_INTEGRACOES_LINHA_RESULTADO = "linha";
    private TTextField textDescricao = new TTextField(50);
    private JComboBox comboValorResultado = new JComboBox();
    private JComboBox comboUnidadeMedida = new JComboBox();
    private JLabel labelDescricao = new JLabel(CamposResultado.access$000(CamposResultado.DESCRICAO));
    private JLabel labelValorResultado = new JLabel(CamposResultado.access$000(CamposResultado.RESULTADO));
    private JLabel labelUnidadeMedida = new JLabel(CamposResultado.access$000(CamposResultado.UNID_MEDIDA));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{CamposResultado.access$000(CamposResultado.DESCRICAO), CamposResultado.access$000(CamposResultado.RESULTADO), CamposResultado.access$000(CamposResultado.UNID_MEDIDA)});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonReferencia = new JButton("Ref.");
    private static final int COLUNA_DESCRICAO = 0;
    private static final int COLUNA_VALOR_RESULTADO = 1;
    private static final int COLUNA_UNIDADE_MEDIDA = 2;
    private static final int COLUNA_VALORES_REFERENCIA = 3;
    private String[] camposLaudo = null;
    private int linhaEdicao = -1;
    private String valoresReferencia = "";

    public static ConfiguradorResultadoUnimedVTRP novaInstancia(Window pai, String[] camposLaudo) {
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoUnimedVTRP((Dialog)pai, camposLaudo);
        }
        return new ConfiguradorResultadoUnimedVTRP((JFrame)pai, camposLaudo);
    }

    private ConfiguradorResultadoUnimedVTRP(Dialog pai, String[] camposLaudo) {
        super(pai, "Associando campos de resultados - Unimed VTRP");
        this.camposLaudo = camposLaudo;
        this.montaTela();
    }

    private ConfiguradorResultadoUnimedVTRP(JFrame pai, String[] camposLaudo) {
        super((Frame)pai, "Associando campos de resultados - Unimed VTRP");
        this.camposLaudo = camposLaudo;
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.setSize(new Dimension(650, 500));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('D');
        this.getPanelCentral().add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.labelValorResultado.setLabelFor(this.comboValorResultado);
        this.labelValorResultado.setDisplayedMnemonic('V');
        this.getPanelCentral().add((Component)this.labelValorResultado, c);
        ++c.gridx;
        this.labelUnidadeMedida.setLabelFor(this.comboUnidadeMedida);
        this.labelUnidadeMedida.setDisplayedMnemonic('U');
        this.getPanelCentral().add((Component)this.labelUnidadeMedida, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textDescricao.setPreferredSize(new Dimension(180, 20));
        this.textDescricao.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.comboValorResultado.setPreferredSize(new Dimension(130, 20));
        this.comboValorResultado.setMinimumSize(new Dimension(130, 20));
        this.getPanelCentral().add((Component)this.comboValorResultado, c);
        ++c.gridx;
        this.comboUnidadeMedida.setPreferredSize(new Dimension(130, 20));
        this.comboUnidadeMedida.setMinimumSize(new Dimension(130, 20));
        this.getPanelCentral().add((Component)this.comboUnidadeMedida, c);
        ++c.gridx;
        this.buttonReferencia.setPreferredSize(new Dimension(40, 20));
        this.buttonReferencia.setMinimumSize(new Dimension(30, 20));
        this.buttonReferencia.setMargin(new Insets(1, 1, 1, 1));
        this.buttonReferencia.setMnemonic('K');
        this.getPanelCentral().add((Component)this.buttonReferencia, c);
        ++c.gridx;
        this.buttonOK.setPreferredSize(new Dimension(30, 20));
        this.buttonOK.setMinimumSize(new Dimension(30, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.setMnemonic('K');
        this.getPanelCentral().add((Component)this.buttonOK, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)this.scroll, c);
        this.modelo.setColumnSize(new int[]{0, 100, 150}, this.table);
        this.montaListeners();
        this.preencheCombosCamposLaudo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void preencheCombosCamposLaudo() {
        if (this.camposLaudo == null) {
            return;
        }
        Arrays.sort(this.camposLaudo, Collator.getInstance());
        this.comboUnidadeMedida.addItem("");
        this.comboUnidadeMedida.setEditable(true);
        this.comboValorResultado.addItem("");
        for (String campo : this.camposLaudo) {
            this.comboUnidadeMedida.addItem(campo);
            this.comboValorResultado.addItem(campo);
        }
    }

    private void montaListeners() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha = ConfiguradorResultadoUnimedVTRP.this.table.getSelectedRow();
                if (linha > -1) {
                    if (e.getKeyCode() == 32) {
                        ConfiguradorResultadoUnimedVTRP.this.modificaLinha(linha);
                    } else if (e.getKeyCode() == 127) {
                        ConfiguradorResultadoUnimedVTRP.this.removeLinha(linha);
                    }
                }
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUnimedVTRP.this.adicionaAssociacao();
            }
        });
        this.buttonReferencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(ConfiguradorResultadoUnimedVTRP.this.textDescricao.getText()) && ConfiguradorResultadoUnimedVTRP.this.comboValorResultado.getSelectedItem() != null && !ConfiguradorResultadoUnimedVTRP.this.comboValorResultado.getSelectedItem().equals("")) {
                    ConfigurarValoresReferencia va = ConfigurarValoresReferencia.novaInstancia(ConfiguradorResultadoUnimedVTRP.this);
                    if (va != null) {
                        va.setValores(ConfiguradorResultadoUnimedVTRP.this.valoresReferencia);
                        va.setVisible(true);
                        if (va.getOK()) {
                            ConfiguradorResultadoUnimedVTRP.this.valoresReferencia = va.getValores();
                            ConfiguradorResultadoUnimedVTRP.this.adicionaAssociacao();
                        }
                    }
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Informe a descri\u00e7\u00e3o e o valor do resultado para configurar os valores de refer\u00eancia.", 2);
                    ScreenUtil.requisitarFoco(ConfiguradorResultadoUnimedVTRP.this.textDescricao);
                    return;
                }
            }
        });
    }

    private void adicionaAssociacao() {
        if (this.validaCamposAdicao()) {
            if (this.linhaEdicao > -1) {
                this.modelo.setValueAt(this.textDescricao.getText(), this.linhaEdicao, 0);
                this.modelo.setValueAt(this.comboUnidadeMedida.getSelectedItem() == null ? null : this.comboUnidadeMedida.getSelectedItem().toString(), this.linhaEdicao, 2);
                this.modelo.setValueAt(this.comboValorResultado.getSelectedItem() == null ? null : this.comboValorResultado.getSelectedItem().toString(), this.linhaEdicao, 1);
                this.modelo.setValueAt(this.valoresReferencia, this.linhaEdicao, 3);
            } else {
                boolean jaExiste = false;
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(this.textDescricao.getText())) continue;
                    Funcoes.mensagem(this, "A descri\u00e7\u00e3o j\u00e1 existe.\nUtilize outra descri\u00e7\u00e3o.", 2);
                    ScreenUtil.requisitarFoco(this.textDescricao);
                    return;
                }
                if (!jaExiste) {
                    this.modelo.addLine(new Object[]{this.textDescricao.getText(), this.comboValorResultado.getSelectedItem() == null ? null : this.comboValorResultado.getSelectedItem().toString(), this.comboUnidadeMedida.getSelectedItem() == null ? null : this.comboUnidadeMedida.getSelectedItem().toString(), this.valoresReferencia});
                }
            }
            this.textDescricao.clear();
            this.comboValorResultado.setSelectedItem("");
            this.comboUnidadeMedida.setSelectedItem("");
            this.valoresReferencia = "";
            this.linhaEdicao = -1;
            ScreenUtil.requisitarFoco(this.textDescricao);
        }
    }

    private boolean validaCamposAdicao() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (this.comboValorResultado.getSelectedItem() == null || Funcoes.textoVazio(this.comboValorResultado.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "O campo do valor do resultado deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboValorResultado);
            return false;
        }
        return true;
    }

    private void removeLinha(int linha) {
        int resposta = Funcoes.mensagem(this, "Deseja remover a linha de associa\u00e7\u00e3o?", 4, true);
        if (resposta == 0) {
            this.modelo.removeLine(linha);
        }
    }

    private void modificaLinha(int linha) {
        this.linhaEdicao = linha;
        this.textDescricao.setText(this.modelo.getValueAt(linha, 0).toString());
        this.comboValorResultado.setSelectedItem(this.modelo.getValueAt(linha, 1));
        this.comboUnidadeMedida.setSelectedItem(this.modelo.getValueAt(linha, 2));
        this.valoresReferencia = this.modelo.getValueAt(linha, 3) != null ? this.modelo.getValueAt(linha, 3).toString() : "";
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    public void setXML(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        String[] linhas = StringUtil.getValores(xml, TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
        if (linhas != null) {
            for (String linha : linhas) {
                String descricao = StringUtil.getValor(linha, CamposResultado.DESCRICAO.getTag());
                String resultado = StringUtil.getValor(linha, CamposResultado.RESULTADO.getTag());
                String unidadeMedida = StringUtil.getValor(linha, CamposResultado.UNID_MEDIDA.getTag());
                String valores = StringUtil.getValor(linha, CamposResultado.REFERENCIA.getTag());
                this.modelo.addLine(new Object[]{descricao, resultado, unidadeMedida, valores});
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDVTRP);
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            xml.abrir(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
            xml.escrever(CamposResultado.DESCRICAO.getTag(), this.modelo.getValueAt(i, 0).toString());
            Object aux = this.modelo.getValueAt(i, 2);
            if (aux != null) {
                xml.escrever(CamposResultado.UNID_MEDIDA.getTag(), aux.toString());
            }
            if ((aux = this.modelo.getValueAt(i, 1)) != null) {
                xml.escrever(CamposResultado.RESULTADO.getTag(), aux.toString());
            }
            if ((aux = this.modelo.getValueAt(i, 3)) != null) {
                xml.escrever(CamposResultado.REFERENCIA.getTag(), aux.toString());
            }
            try {
                xml.fechar(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
                continue;
            }
            catch (XMLStringBuilderException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar o XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        try {
            xml.fechar(TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDVTRP);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar o XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public static enum CamposResultado {
        DESCRICAO("Descri\u00e7\u00e3o", "descricao"),
        RESULTADO("Valor do resultado", "resultado"),
        UNID_MEDIDA("Unidade de medida", "unidade"),
        REFERENCIA("Refer\u00eancia", "valoresreferencia");

        private String descricao = null;
        private String tag = null;

        private CamposResultado(String descricao, String tag) {
            this.descricao = descricao;
            this.tag = tag;
        }

        public String toString() {
            return this.descricao;
        }

        public String getTag() {
            return this.tag;
        }

        static /* synthetic */ String access$000(CamposResultado x0) {
            return x0.descricao;
        }
    }
}

