/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.vtrp;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorAgrupamentoUnimedVTRP;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorAgrupamentoUnimedVTRPModel;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

class ConfiguradorIntegracaoOperadoraUnimedVTRP
extends AbstractDialogoOKCancelar {
    public static final String TAG_CODIGO_LOTE = "codigoLote";
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_CODIGO_LABORATORIO = "codigoLaboratorio";
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    private static final String AGRUPAMENTO_EXAME = "Agrupamento de Exames";
    private String xml = null;
    private JLabel labelCodigoLote = new JLabel("N\u00famero do lote atual:");
    private JLabel labelCodigoLaboratorio = new JLabel("C\u00f3digo do Laborat\u00f3rio:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio (login):");
    private JLabel labelSenha = new JLabel("Senha (login):");
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelWebService = new JLabel("Web Services:");
    private JLabel labelVlrEstacao = new JLabel();
    private TTextField textLote = new TTextField(10, 1);
    private TTextField textCodigoLaboratorio = new TTextField(20, 1);
    private TTextField textUsuario = new TTextField(15);
    private TTextField textSenha = new TTextField(15);
    private TTextField textEstacao = new TTextField(10, 1);
    protected TTextField textEndWebService = new TTextField(100, 3);
    private JButton buttonEstacao = new JButton();
    private JButton buttonAgrupamentoEx = new JButton("Agrupamento de exames");
    private ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel = new ArrayList();

    public static ConfiguradorIntegracaoOperadoraUnimedVTRP novaInstancia(Window pai, int codigoConvenio, ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraUnimedVTRP((Dialog)pai, codigoConvenio, arrayConfiguradorAgrupUnimedModel);
        }
        return new ConfiguradorIntegracaoOperadoraUnimedVTRP((JFrame)pai, codigoConvenio, arrayConfiguradorAgrupUnimedModel);
    }

    private ConfiguradorIntegracaoOperadoraUnimedVTRP(Dialog pai, int codigoConvenio, ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        super(pai, "Configurando integra\u00e7\u00e3o Unimed VTRP");
        this.montaTela(codigoConvenio);
        this.arrayConfiguradorAgrupUnimedModel = arrayConfiguradorAgrupUnimedModel;
    }

    private ConfiguradorIntegracaoOperadoraUnimedVTRP(JFrame pai, int codigoConvenio, ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        super((Frame)pai, "Configurando integra\u00e7\u00e3o Unimed VTRP");
        this.montaTela(codigoConvenio);
        this.arrayConfiguradorAgrupUnimedModel = arrayConfiguradorAgrupUnimedModel;
    }

    public void setXML(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP.getDescricao()) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.textEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = this.getSequenceUnimedVTRP())) {
                this.textLote.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_LOGIN))) {
                this.textUsuario.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_SENHA))) {
                this.textSenha.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_CODIGO_LABORATORIO);
            if (!Funcoes.textoVazio(xml)) {
                this.textCodigoLaboratorio.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_ENDERECO_WEBSERVICE);
            if (!Funcoes.textoVazio(xml)) {
                this.textEndWebService.setText(aux);
            }
        }
    }

    private String getSequenceUnimedVTRP() {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("SELECT last_value as codigo FROM unimedvtrp_sequence;");
        try {
            ResultSet rs = Conexao.executeQuery(st, bui);
            if (rs.next()) {
                return String.valueOf(rs.getLong("codigo"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void montaListeners(final int codigoConvenio) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedVTRP.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedVTRP.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedVTRP.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedVTRP.this.buscaEstacao(ConfiguradorIntegracaoOperadoraUnimedVTRP.this.textEstacao.getText());
                }
            }
        };
        this.textEstacao.addKeyListener(keyAdapter);
        this.textEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraUnimedVTRP.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraUnimedVTRP.this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraUnimedVTRP.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraUnimedVTRP.this.textEstacao.clear();
                    ConfiguradorIntegracaoOperadoraUnimedVTRP.this.labelVlrEstacao.setText("");
                }
            }
        });
        this.buttonAgrupamentoEx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorAgrupamentoUnimedVTRP agrupamento = ConfiguradorAgrupamentoUnimedVTRP.novaInstancia(Laboratorio.getInstancia(), codigoConvenio, ConfiguradorIntegracaoOperadoraUnimedVTRP.this.arrayConfiguradorAgrupUnimedModel);
                agrupamento.setVisible(true);
                ConfiguradorIntegracaoOperadoraUnimedVTRP.this.arrayConfiguradorAgrupUnimedModel = agrupamento.getArrayConfiguradorAgrupUnimed();
            }
        });
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.textEstacao);
        }
    }

    private void pesquisaEstacao() {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        } else {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
        }
    }

    public ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> getArrayConfiguradorAgrupUnimedModel() {
        return this.arrayConfiguradorAgrupUnimedModel;
    }

    public void setArrayConfiguradorAgrupUnimedModel(ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        this.arrayConfiguradorAgrupUnimedModel = arrayConfiguradorAgrupUnimedModel;
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP.getDescricao());
        xml.escrever("estacao", this.textEstacao.getText());
        xml.escrever(TAG_CODIGO_LOTE, this.textLote.getText());
        xml.escrever(TAG_CODIGO_LABORATORIO, this.textCodigoLaboratorio.getText());
        xml.escrever(TAG_LOGIN, this.textUsuario.getText());
        xml.escrever(TAG_SENHA, this.textSenha.getText());
        xml.escrever(TAG_ENDERECO_WEBSERVICE, this.textEndWebService.getText());
        try {
            xml.fechar("integracaooperadora");
            this.setValorSequence();
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o.", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    private void setValorSequence() {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("alter sequence unimedvtrp_sequence restart with ").append(this.textLote.getText());
        try {
            Conexao.executeUpdate(Variaveis.filialPadrao, st, bui.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private void montaTela(int codigoConvenio) {
        this.setResizable(false);
        this.setSize(new Dimension(480, 240));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCodigoLaboratorio, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelUsuario, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelSenha, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelWebService, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCodigoLote, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.textEstacao.setPreferredSize(new Dimension(80, 20));
        this.textEstacao.setMinimumSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textEstacao, c);
        ++c.gridx;
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.buttonEstacao.setFocusable(false);
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelVlrEstacao.setPreferredSize(new Dimension(20, 20));
        this.labelVlrEstacao.setMinimumSize(new Dimension(20, 20));
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textCodigoLaboratorio.setPreferredSize(new Dimension(20, 20));
        this.textCodigoLaboratorio.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textCodigoLaboratorio, c);
        ++c.gridy;
        this.textUsuario.setPreferredSize(new Dimension(20, 20));
        this.textUsuario.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textUsuario, c);
        ++c.gridy;
        this.textSenha.setPreferredSize(new Dimension(20, 20));
        this.textSenha.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textSenha, c);
        ++c.gridy;
        this.textEndWebService.setPreferredSize(new Dimension(20, 20));
        this.textEndWebService.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textEndWebService, c);
        ++c.gridy;
        this.textLote.setPreferredSize(new Dimension(20, 20));
        this.textLote.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textLote, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)new JLabel(), c);
        c.fill = 13;
        c.ipadx = 160;
        this.buttonAgrupamentoEx.setPreferredSize(new Dimension(20, 200));
        this.buttonAgrupamentoEx.setMinimumSize(new Dimension(20, 200));
        this.getPanelCentral().add((Component)this.buttonAgrupamentoEx, c);
        this.montaListeners(codigoConvenio);
        ScreenUtil.requisitarFoco(this.textEstacao);
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoLaboratorio)) {
            Funcoes.mensagem(this, "O c\u00f3digo do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuario)) {
            Funcoes.mensagem(this, "O usu\u00e1rio de login deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.textLote)) {
            Funcoes.mensagem(this, "O numero do lote atual deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textLote);
            return false;
        }
        if (Integer.parseInt(this.textLote.getText()) < 1) {
            Funcoes.mensagem(this, "O numero do lote atual deve ser maior que zero.", 2);
            ScreenUtil.requisitarFoco(this.textLote);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenha)) {
            Funcoes.mensagem(this, "A senha de login deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.textEndWebService)) {
            Funcoes.mensagem(this, "Informe o campo web services.", 2);
            ScreenUtil.requisitarFoco(this.textEndWebService);
            return false;
        }
        return true;
    }
}

