/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.vtrp;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.ConfiguradorAgrupamentoUnimedVTRPModel;
import jalis.laboratorio.Laboratorio;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConfiguradorAgrupamentoUnimedVTRP
extends AbstractDialogoOKCancelar {
    private final int codigoConvenio;
    private int ESTADO_DA_TELA = 0;
    private final int EDITANDO = 1;
    private final int ADICIONANDO = 0;
    private JLabel labelExamePai = new JLabel("Exame Pai:");
    private JLabel labelExameFilho = new JLabel("Exame Filho:");
    private TTextField textCodExamePai = new TTextField(5, 3);
    private TTextField textCodExameFilho = new TTextField(5, 3);
    private JButton buttonBuscaExamePai = new JButton();
    private JButton buttonBuscaExameFilho = new JButton();
    private JLabel labelDescExamePai = new JLabel();
    private JLabel labelDescExameFilho = new JLabel();
    private JButton buttonOKExame = ComponenteFactory.novoJButton("OK", null);
    private JLabel labelValorSomatorioExames = new JLabel("0,00", 4);
    private JPanel aux = new JPanel(new BorderLayout());
    private ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimed = new ArrayList();
    private ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedOrig = new ArrayList();
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame"});
    private JTable tableAgrupamento = new JTable();
    private JScrollPane scrollMatricula = new JScrollPane(this.tableAgrupamento);
    private JPanel panelExame = new JPanel(new GridBagLayout());
    private JComboBox comboExamePai = ComponenteFactory.novoJcomboBoxPopup(new Object[0], 100, 0);
    private JComboBox comboExameFilho = ComponenteFactory.novoJcomboBoxPopup(new Object[0], 100, 0);
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int TIPO_BUSCA_EXAME = 1;
    private final int COLUNA_DESC_EXAME = 2;
    private final int COLUNA_VALOR_EXAME = 3;
    private boolean pesquisarRequisicao = false;

    public static ConfiguradorAgrupamentoUnimedVTRP novaInstancia(Object pai, int codigoConvenio, ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        if (pai instanceof JFrame) {
            return new ConfiguradorAgrupamentoUnimedVTRP((Frame)pai, codigoConvenio, arrayConfiguradorAgrupUnimedModel);
        }
        if (pai instanceof JDialog) {
            return new ConfiguradorAgrupamentoUnimedVTRP((Dialog)pai, codigoConvenio, arrayConfiguradorAgrupUnimedModel);
        }
        return null;
    }

    public ConfiguradorAgrupamentoUnimedVTRP(Frame owner, int codigoConvenio, ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        super(owner, "Agrupamento de Exames");
        this.codigoConvenio = codigoConvenio;
        this.setArrayConfiguradorAgrupUnimed(arrayConfiguradorAgrupUnimedModel);
        this.montaTela();
    }

    public ConfiguradorAgrupamentoUnimedVTRP(Dialog owner, int codigoConvenio, ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimedModel) {
        super(owner, "Agrupamento de Exames");
        this.codigoConvenio = codigoConvenio;
        this.setArrayConfiguradorAgrupUnimed(arrayConfiguradorAgrupUnimedModel);
        this.montaTela();
    }

    private void montaTela() {
        this.textCodExamePai.setUpperCase(true);
        this.textCodExameFilho.setUpperCase(true);
        this.setResizable(false);
        this.setSize(new Dimension(750, 500));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.panelExame.setLayout(new GridBagLayout());
        this.panelExame.setBorder(new TitledBorder("Agrupamento de Exames"));
        this.panelExame.setPreferredSize(new Dimension(300, 80));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelExamePai.setPreferredSize(new Dimension(78, 20));
        this.labelExamePai.setMinimumSize(new Dimension(78, 20));
        this.labelExamePai.setMaximumSize(new Dimension(78, 20));
        this.panelExame.add((Component)this.labelExamePai, c);
        ++c.gridx;
        this.textCodExamePai.setPreferredSize(new Dimension(80, 20));
        this.textCodExamePai.setMinimumSize(new Dimension(80, 20));
        this.textCodExamePai.setMaximumSize(new Dimension(80, 20));
        this.panelExame.add((Component)this.textCodExamePai, c);
        ++c.gridx;
        this.buttonBuscaExamePai.setPreferredSize(new Dimension(25, 20));
        this.buttonBuscaExamePai.setMinimumSize(new Dimension(25, 20));
        this.buttonBuscaExamePai.setMaximumSize(new Dimension(25, 20));
        this.buttonBuscaExamePai.setFocusable(false);
        this.panelExame.add((Component)this.buttonBuscaExamePai, c);
        ++c.gridx;
        this.comboExamePai.setPreferredSize(new Dimension(80, 20));
        this.comboExamePai.setMinimumSize(new Dimension(80, 20));
        this.comboExamePai.setMaximumSize(new Dimension(80, 20));
        this.panelExame.add((Component)this.comboExamePai, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelDescExamePai.setPreferredSize(new Dimension(450, 20));
        this.labelDescExamePai.setMinimumSize(new Dimension(450, 20));
        this.labelDescExamePai.setMaximumSize(new Dimension(450, 20));
        this.panelExame.add((Component)this.labelDescExamePai, c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        c.fill = 0;
        this.labelExameFilho.setPreferredSize(new Dimension(78, 20));
        this.labelExameFilho.setMinimumSize(new Dimension(78, 20));
        this.labelExameFilho.setMaximumSize(new Dimension(78, 20));
        this.panelExame.add((Component)this.labelExameFilho, c);
        ++c.gridx;
        this.textCodExameFilho.setPreferredSize(new Dimension(80, 20));
        this.textCodExameFilho.setMinimumSize(new Dimension(80, 20));
        this.textCodExameFilho.setMaximumSize(new Dimension(80, 20));
        this.panelExame.add((Component)this.textCodExameFilho, c);
        ++c.gridx;
        this.buttonBuscaExameFilho.setPreferredSize(new Dimension(25, 20));
        this.buttonBuscaExameFilho.setMinimumSize(new Dimension(25, 20));
        this.buttonBuscaExameFilho.setMaximumSize(new Dimension(25, 20));
        this.buttonBuscaExameFilho.setFocusable(false);
        this.panelExame.add((Component)this.buttonBuscaExameFilho, c);
        ++c.gridx;
        this.comboExameFilho.setPreferredSize(new Dimension(80, 20));
        this.comboExameFilho.setMinimumSize(new Dimension(80, 20));
        this.comboExameFilho.setMaximumSize(new Dimension(80, 20));
        this.panelExame.add((Component)this.comboExameFilho, c);
        ++c.gridx;
        c.fill = 1;
        Dimension descExameFilhoDimension = new Dimension(410, 20);
        this.labelDescExameFilho.setPreferredSize(descExameFilhoDimension);
        this.labelDescExameFilho.setMinimumSize(descExameFilhoDimension);
        this.labelDescExameFilho.setMaximumSize(descExameFilhoDimension);
        this.panelExame.add((Component)this.labelDescExameFilho, c);
        ++c.gridx;
        c.weightx = 0.0;
        Dimension buttonOkDimension = new Dimension(40, 20);
        this.buttonOKExame.setPreferredSize(buttonOkDimension);
        this.buttonOKExame.setMinimumSize(buttonOkDimension);
        this.buttonOKExame.setMaximumSize(buttonOkDimension);
        this.buttonOKExame.setFocusable(true);
        this.panelExame.add((Component)this.buttonOKExame, c);
        c.gridx = 0;
        c.gridy = 0;
        this.tableAgrupamento = new JTable(this.modelo);
        this.modelo.setColumnSize(new int[]{100, 100, 550}, this.tableAgrupamento);
        this.scrollMatricula = new JScrollPane(this.tableAgrupamento);
        this.aux.add((Component)this.scrollMatricula, "Center");
        this.getPanelCentral().add((Component)this.aux, "Center");
        this.getPanelCentral().add((Component)this.panelExame, "North");
        Funcoes.imagemPesquisa(this.buttonBuscaExamePai);
        Funcoes.imagemPesquisa(this.buttonBuscaExameFilho);
        ScreenUtil.setBorda(new Component[]{this.labelDescExamePai, this.labelDescExameFilho}, new TitledBorder(""));
        this.montaListeners();
    }

    private void montaListeners() {
        this.buttonBuscaExamePai.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorAgrupamentoUnimedVTRP.this.pesquisaExame(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai);
            }
        });
        this.textCodExamePai.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorAgrupamentoUnimedVTRP.this.pesquisaExame(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai);
                }
            }
        });
        this.buttonBuscaExameFilho.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorAgrupamentoUnimedVTRP.this.pesquisaExame(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho);
            }
        });
        this.textCodExameFilho.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorAgrupamentoUnimedVTRP.this.pesquisaExame(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho);
                }
            }
        });
        this.buttonOKExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.examePaiValido() || !this.exameFilhoValido()) {
                    return;
                }
                if (!(Funcoes.textoVazio(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai) || Funcoes.textoVazio(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText()) || ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.getText().equals("N\u00e3o cadastrado"))) {
                    if (ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText().equals(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai.getText()) && ((DadosMaterial)ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho.getSelectedItem()).equals(ConfiguradorAgrupamentoUnimedVTRP.this.comboExamePai.getSelectedItem())) {
                        Funcoes.mensagem(ConfiguradorAgrupamentoUnimedVTRP.this, "O exame n\u00e3o pode agrupar ele mesmo", 2);
                    } else {
                        try {
                            DadosMaterial material = (DadosMaterial)ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho.getSelectedItem();
                            DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText(), material);
                            DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, ConfiguradorAgrupamentoUnimedVTRP.this.codigoConvenio);
                            int p = ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, dadosExame, material, dadosConvenio, true, false, true, null, null, Integer.parseInt(dadosExame.getCodMetodo()));
                            if (p != 1 && p != 6 && p != 7 && p != 8) {
                                boolean localizaExame = ConfiguradorAgrupamentoUnimedVTRP.this.localizaExameFilho(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText(), material);
                                boolean filhoJaInserido = this.verificaSeFilhoEstaNoArray();
                                if (localizaExame && !filhoJaInserido) {
                                    ConfiguradorAgrupamentoUnimedVTRP.this.modelo.addLine(new Object[]{ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText(), ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho.getSelectedItem(), ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.getText(), dadosExame.getValor()});
                                    ConfiguradorAgrupamentoUnimedVTRP.this.adicionarModelDoAgrupamentoNoArray(ConfiguradorAgrupamentoUnimedVTRP.this.arrayConfiguradorAgrupUnimed, ConfiguradorAgrupamentoUnimedVTRP.this.modelo.getRowCount() - 1);
                                }
                            } else {
                                Funcoes.mensagem(ConfiguradorAgrupamentoUnimedVTRP.this, "Exame n\u00e3o permitido para o conv\u00eanio", 2);
                            }
                        }
                        catch (SQLException sqlex) {
                            Funcoes.mensagem(ConfiguradorAgrupamentoUnimedVTRP.this, "N\u00e3o foi poss\u00edvel obter os dados do exame", 1);
                            ErrorLogger.mostraMensagem(ConfiguradorAgrupamentoUnimedVTRP.this, sqlex.getMessage(), sqlex.getStackTrace(), "AgrupaExame");
                        }
                    }
                    ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.clear();
                    ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho.removeAllItems();
                    ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.setText("");
                    ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.requestFocus();
                }
            }

            private boolean exameFilhoValido() {
                boolean textoVazio = Funcoes.textoVazio(ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.getText());
                boolean filhoNaoLocalizado = ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.getText().equals("N\u00e3o cadastrado");
                return !textoVazio && !filhoNaoLocalizado;
            }

            private boolean examePaiValido() {
                boolean textoVazio = Funcoes.textoVazio(ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExamePai.getText());
                boolean filhoNaoLocalizado = ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExamePai.getText().equals("N\u00e3o cadastrado");
                return !textoVazio && !filhoNaoLocalizado;
            }

            private boolean verificaSeFilhoEstaNoArray() {
                try {
                    DadosMaterial materialFilho = (DadosMaterial)ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho.getSelectedItem();
                    DadosMaterial materialPai = (DadosMaterial)ConfiguradorAgrupamentoUnimedVTRP.this.comboExamePai.getSelectedItem();
                    DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText(), materialFilho);
                    ConfiguradorAgrupamentoUnimedVTRPModel modelFilho = new ConfiguradorAgrupamentoUnimedVTRPModel();
                    modelFilho.setFlCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    modelFilho.setCodExameFilho(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText());
                    modelFilho.setMaterialFilho(materialFilho);
                    modelFilho.setDescExame(dadosExame.getDescricao());
                    modelFilho.setPesquisarRequisicao(ConfiguradorAgrupamentoUnimedVTRP.this.pesquisarRequisicao);
                    modelFilho.setCodExamePai(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai.getText());
                    modelFilho.setMaterialPai(materialPai);
                    modelFilho.setPesquisarRequisicao(ConfiguradorAgrupamentoUnimedVTRP.this.pesquisarRequisicao);
                    for (ConfiguradorAgrupamentoUnimedVTRPModel model : ConfiguradorAgrupamentoUnimedVTRP.this.arrayConfiguradorAgrupUnimed) {
                        if (!model.equals(modelFilho)) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(ConfiguradorAgrupamentoUnimedVTRP.this, e.getMessage(), e.getStackTrace());
                    return false;
                }
            }
        });
        this.tableAgrupamento.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ConfiguradorAgrupamentoUnimedVTRP.this.tableAgrupamento.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(ConfiguradorAgrupamentoUnimedVTRP.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    int posicao = ConfiguradorAgrupamentoUnimedVTRP.this.tableAgrupamento.getSelectedRow();
                    ConfiguradorAgrupamentoUnimedVTRP.this.removeModeloDoAgrupamento(posicao);
                }
            }
        });
        this.textCodExameFilho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ExameUtil.carregarMateriaisColeta(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.getText(), Variaveis.filialPadrao, ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho);
                    if (Funcoes.textoVazio(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho)) {
                        ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.setText("");
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(ConfiguradorAgrupamentoUnimedVTRP.this, ex.getMessage(), ex.getStackTrace(), "AgrupaExame");
                }
            }
        });
        this.textCodExamePai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ExameUtil.carregarMateriaisColeta(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai.getText(), Variaveis.filialPadrao, ConfiguradorAgrupamentoUnimedVTRP.this.comboExamePai);
                    if (Funcoes.textoVazio(ConfiguradorAgrupamentoUnimedVTRP.this.textCodExamePai)) {
                        ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExamePai.setText("");
                    }
                }
                catch (SQLException sqlE) {
                    ErrorLogger.mostraMensagem(ConfiguradorAgrupamentoUnimedVTRP.this, sqlE.getMessage(), sqlE.getStackTrace(), "AgrupaExame");
                }
            }
        });
        this.comboExamePai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                this.buscaExamePai();
            }

            private void buscaExamePai() {
                ConfiguradorAgrupamentoUnimedVTRP.this.searchLabelDescExamePai();
                ConfiguradorAgrupamentoUnimedVTRP.this.modelo.clear();
                if (ConfiguradorAgrupamentoUnimedVTRP.this.examePaiPossuiAgrupamento()) {
                    if (Funcoes.mensagem(ConfiguradorAgrupamentoUnimedVTRP.this, "O exame j\u00e1 possui agrupamento que permite a utiliza\u00e7\u00e3o para todos os conv\u00eanios, deseja edita-lo?", 4) == 0) {
                        ConfiguradorAgrupamentoUnimedVTRP.this.adicionaModelNaGrid();
                    } else {
                        ConfiguradorAgrupamentoUnimedVTRP.this.comboExamePai.requestFocus();
                        ConfiguradorAgrupamentoUnimedVTRP.this.textCodExameFilho.clear();
                        ConfiguradorAgrupamentoUnimedVTRP.this.comboExameFilho.removeAllItems();
                        ConfiguradorAgrupamentoUnimedVTRP.this.labelDescExameFilho.setText("");
                    }
                }
            }
        });
        this.comboExameFilho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorAgrupamentoUnimedVTRP.this.searchLabelDescExameFilho();
            }
        });
    }

    private void removeModeloDoAgrupamento(int posicao) {
        ConfiguradorAgrupamentoUnimedVTRPModel model = new ConfiguradorAgrupamentoUnimedVTRPModel();
        DadosMaterial materialFilho = (DadosMaterial)this.modelo.getValueAt(posicao, 1);
        DadosMaterial materialPai = (DadosMaterial)this.comboExamePai.getSelectedItem();
        model.setFlCodigo(Integer.parseInt(Variaveis.filialPadrao));
        model.setCodExameFilho(this.modelo.getValueAt(posicao, 0).toString());
        model.setMaterialFilho(materialFilho);
        model.setDescExame(this.modelo.getValueAt(posicao, 2).toString());
        model.setPesquisarRequisicao(this.pesquisarRequisicao);
        model.setCodExamePai(this.textCodExamePai.getText());
        model.setMaterialPai(materialPai);
        model.setPesquisarRequisicao(this.pesquisarRequisicao);
        this.arrayConfiguradorAgrupUnimed.remove(model);
        this.modelo.removeLine(posicao);
    }

    private boolean examePaiPossuiAgrupamento() {
        String codExamePai = this.textCodExamePai.getText().trim();
        for (ConfiguradorAgrupamentoUnimedVTRPModel model : this.arrayConfiguradorAgrupUnimed) {
            if (!model.getCodExamePai().equalsIgnoreCase(codExamePai) || !model.getMaterialPai().equals(this.comboExamePai.getSelectedItem())) continue;
            return true;
        }
        return false;
    }

    private void adicionaModelNaGrid() {
        int codMaterial = -1;
        ConfiguradorAgrupamentoUnimedVTRPModel model = null;
        for (int i = 0; i < this.arrayConfiguradorAgrupUnimed.size(); ++i) {
            model = this.arrayConfiguradorAgrupUnimed.get(i);
            codMaterial = ((DadosMaterial)this.comboExamePai.getSelectedItem()).getCodigo();
            if (!model.getCodExamePai().equalsIgnoreCase(this.textCodExamePai.getText()) || model.getMaterialPai().getCodigo() != codMaterial) continue;
            this.adicionarObjetoNaGrid(model);
        }
    }

    private void adicionarObjetoNaGrid(ConfiguradorAgrupamentoUnimedVTRPModel model) {
        Object[] objeto = new Object[]{model.getCodExameFilho(), model.getMaterialFilho(), model.getDescExameFilho()};
        this.modelo.addLine(objeto);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonCancelar) {
            this.setArrayConfiguradorAgrupUnimed(this.arrayConfiguradorAgrupUnimedOrig);
            this.dispose();
        } else if (o == this.buttonOK) {
            this.setArrayConfiguradorAgrupUnimed(this.arrayConfiguradorAgrupUnimed);
            this.ok = true;
            this.dispose();
            this.setVisible(false);
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionaConfiguradorAgrupamento(ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> list) {
        if (!Funcoes.textoVazio(this.textCodExamePai.getText())) {
            this.adicionaConfiguradorAgrupamentoTabela(list);
        }
    }

    private void adicionaConfiguradorAgrupamentoTabela(ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> list) {
        for (int i = 0; i < this.tableAgrupamento.getRowCount(); ++i) {
            this.adicionarModelDoAgrupamentoNoArray(list, i);
        }
    }

    private void adicionarModelDoAgrupamentoNoArray(ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> list, int i) {
        ConfiguradorAgrupamentoUnimedVTRPModel model = new ConfiguradorAgrupamentoUnimedVTRPModel();
        model.setFlCodigo(Integer.parseInt(Variaveis.filialPadrao));
        model.setCodExamePai(this.textCodExamePai.getText());
        model.setMaterialPai((DadosMaterial)this.comboExamePai.getSelectedItem());
        model.setCodExameFilho(this.modelo.getValueAt(i, 0).toString());
        model.setMaterialFilho((DadosMaterial)this.modelo.getValueAt(i, 1));
        model.setDescExame(this.modelo.getValueAt(i, 2).toString());
        model.setPesquisarRequisicao(this.pesquisarRequisicao);
        list.add(model);
    }

    public ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> getArrayConfiguradorAgrupUnimed() {
        return this.arrayConfiguradorAgrupUnimed;
    }

    public void setArrayConfiguradorAgrupUnimed(ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> arrayConfiguradorAgrupUnimed) {
        this.arrayConfiguradorAgrupUnimed = arrayConfiguradorAgrupUnimed;
        this.arrayConfiguradorAgrupUnimedOrig = (ArrayList)arrayConfiguradorAgrupUnimed.clone();
    }

    public ArrayList<ConfiguradorAgrupamentoUnimedVTRPModel> getArrayConfiguradorAgrupUnimedOrig() {
        return this.arrayConfiguradorAgrupUnimedOrig;
    }

    private void calculaValorTotalFilhos() {
        BigDecimal valorTotal = BigDecimal.ZERO;
        for (int i = 0; i < this.tableAgrupamento.getRowCount(); ++i) {
            BigDecimal valor = (BigDecimal)this.modelo.getValueAt(i, 3);
            valorTotal = valorTotal.add(valor);
        }
        valorTotal = valorTotal.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        this.labelValorSomatorioExames.setText(Funcoes.formataDecimal(valorTotal.doubleValue()));
    }

    private boolean localizaExameFilho(String exame, DadosMaterial material) {
        int retorno = ExameUtil.localizaExame(exame, material, this.modelo, 0, 1);
        return retorno < 0;
    }

    private boolean buscaExamePai(int tipoBusca, int codigoConvenio) {
        boolean retorno = false;
        if (Funcoes.textoVazio(this.textCodExamePai.getText())) {
            return retorno;
        }
        Statement st = null;
        try {
            st = Conexao.getStatement();
            StringBuffer buf = new StringBuffer("select a.con_codigo, a.exa_kodigo, a.mco_kodigo, b.exa_descricao  ");
            buf.append("from conveniosintegracaooperadora a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.exa_codigo = ");
            buf.append(this.textCodExamePai.getTextDBEscape());
            buf.append(" and a.con_codigo = ");
            buf.append(codigoConvenio);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next();
            this.modelo.clear();
            if (retorno) {
                if (Funcoes.mensagem(this, "O exame j\u00e1 possui agrupamento que permite a utiliza\u00e7\u00e3o para todos os conv\u00eanios, deseja edita-lo?", 4) == 0) {
                    ExameUtil.carregarMateriaisColeta(this.textCodExamePai.getText(), Variaveis.filialPadrao, this.comboExamePai);
                    if (!Funcoes.textoVazio(this.textCodExamePai)) {
                        buf.delete(0, buf.length());
                        buf.append("fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and con_codigo = ");
                        buf.append(rs.getString("con_codigo"));
                        String string = DBUtil.getDescricao("select con_fantasia from convenios", buf.toString(), "con_fantasia");
                    }
                    do {
                        DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_kodigo"));
                        this.modelo.addLine(new Object[]{rs.getString("exa_kodigo"), material, rs.getString("exa_descricao")});
                    } while (rs.next());
                    this.textCodExameFilho.requestFocus();
                } else {
                    this.textCodExamePai.requestFocus();
                }
            }
            rs.close();
        }
        catch (Exception ex) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.toString(), 1);
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaRequisicao");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void pesquisaExame(TTextField campo) {
        Hashtable resultado = Pesquisas.exame(Laboratorio.getInstancia(), true, false);
        if (resultado != null) {
            campo.setText(resultado.get("exa_codigo").toString());
        }
        campo.requestFocus();
    }

    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodExamePai.getText())) {
            Funcoes.mensagem(this, "Exame pai n\u00e3o informado", 1);
            this.textCodExamePai.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textCodExamePai.getText()) && this.labelDescExamePai.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Exame pai n\u00e3o localizado", 1);
            this.textCodExamePai.grabFocus();
            return false;
        }
        if (this.modelo.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum exame foi agrupado", 1);
            this.textCodExameFilho.requestFocus();
            return false;
        }
        return true;
    }

    private String searchExaDesc(String codExame) {
        String result = "";
        if (!Funcoes.textoVazio(codExame)) {
            StringBuffer buf = new StringBuffer("fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and exa_codigo = '");
            buf.append(codExame);
            buf.append("'");
            try {
                return DBUtil.getDescricao("select exa_descricao from exames", buf.toString(), "exa_descricao");
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaExame");
            }
        }
        return result;
    }

    private void searchLabelDescExamePai() {
        String descricao = this.searchExaDesc(this.textCodExamePai.getText());
        this.labelDescExamePai.setText(descricao);
    }

    private void searchLabelDescExameFilho() {
        String descricao = this.searchExaDesc(this.textCodExameFilho.getText());
        this.labelDescExameFilho.setText(descricao);
    }
}

