/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.uberaba;

import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.UberabaDao;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.models.OperacaoUberabaVO;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.models.RetornoUberabaVO;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.models.UberabaVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class UberabaService {
    public static final String TAG_EXPORTACAO_INTEGRACAO_OPERADORA = "integracaooperadora";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "nomeintegracaooperadora";
    private UberabaDao dao = new UberabaDao();

    public ArrayList<LogIntegracaoOperadora> buscaLogs(String codigoFilial, String codigoConvenio) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> lista = null;
        try {
            lista = this.dao.buscaLogs(codigoFilial, codigoConvenio);
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), "buscando logs de integra\u00e7\u00e3o", null);
        }
        return lista;
    }

    public List<LogIntegracaoOperadora> enviarResultado(String filialPadrao, String codigoConvenio, String xmlConfiguracao) throws IntegracaoOperadoraException {
        UberabaVO uberabaVO = null;
        ArrayList<LogIntegracaoOperadora> listaLogs = null;
        ArrayList<LogIntegracaoOperadora> erros = new ArrayList<LogIntegracaoOperadora>();
        List<OperacaoUberabaVO> listaOperacoes = new ArrayList<OperacaoUberabaVO>();
        listaLogs = this.buscaLogs(Variaveis.filialPadrao, String.valueOf(codigoConvenio));
        for (LogIntegracaoOperadora logIntegracaoOperadora : listaLogs) {
            if (logIntegracaoOperadora.getTipoOperacao() != AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) continue;
            try {
                listaOperacoes = this.dao.buscarResultados(logIntegracaoOperadora, listaOperacoes);
            }
            catch (IntegracaoOperadoraException e) {
                logIntegracaoOperadora.setRetorno(e.getMensagemErro());
                logIntegracaoOperadora.setSituacao("N");
                erros.add(logIntegracaoOperadora);
            }
        }
        if (!listaOperacoes.isEmpty()) {
            uberabaVO = new UberabaVO();
            String xml = xmlConfiguracao;
            String url = StringUtil.getValor(xml, "enderecoWebService");
            String token = StringUtil.getValor(xml, "token");
            uberabaVO.setUrl(url);
            uberabaVO.setToken(token);
            uberabaVO.setListaOperacoes(listaOperacoes);
        }
        if (uberabaVO != null) {
            try {
                URL url = new URL(uberabaVO.getUrl() + uberabaVO.getToken());
                List<OperacaoUberabaVO> listas = uberabaVO.getListaOperacoes();
                ArrayList<RetornoUberabaVO> listaRetornos = new ArrayList<RetornoUberabaVO>();
                for (OperacaoUberabaVO operacaoUberabaVO : listas) {
                    ObjectMapper mapper = new ObjectMapper();
                    HashMap<String, Object> jsonMessage = new HashMap<String, Object>();
                    jsonMessage.put("data", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", operacaoUberabaVO.getExame().getData()));
                    jsonMessage.put("guiaImpresso", operacaoUberabaVO.getGuiaRequisicao());
                    HashMap<String, String> itens = new HashMap<String, String>();
                    itens.put("codigoTuss", operacaoUberabaVO.getExame().getCodigoExame());
                    ArrayList<HashMap<String, String>> listaItens = new ArrayList<HashMap<String, String>>();
                    listaItens.add(itens);
                    jsonMessage.put("itens", listaItens);
                    RetornoImpressaoResultados pdf = ImpressaoResultados.imprimirExames(null, null, operacaoUberabaVO.getCodigoFilial(), operacaoUberabaVO.getCodigoRequisicao(), true, true, null, new String[]{operacaoUberabaVO.getExame().getExaCodigo()}, new String[]{operacaoUberabaVO.getExame().getCodigoMaterial()}, true, null, true, true, null, true, "", true, false);
                    String pdfConvertido = Base64.encodeBase64String((byte[])pdf.getResultadoPdfWeb());
                    jsonMessage.put("arquivoBase64", pdfConvertido);
                    String json = mapper.writeValueAsString(jsonMessage);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "text/plain");
                    conn.setRequestProperty("charset", "utf-8");
                    conn.setDoOutput(true);
                    conn.connect();
                    OutputStream os = conn.getOutputStream();
                    os.write(json.getBytes());
                    if (conn.getResponseCode() == 200) {
                        InputStreamReader in = new InputStreamReader(conn.getInputStream());
                        BufferedReader br = new BufferedReader(in);
                        String identificador = br.readLine();
                        RetornoUberabaVO retornoUberabaVO = new RetornoUberabaVO();
                        retornoUberabaVO.setIdentificador(identificador);
                        retornoUberabaVO.setExame(operacaoUberabaVO.getExame());
                        listaRetornos.add(retornoUberabaVO);
                    } else {
                        LogIntegracaoOperadora log = this.logAtual(listaLogs, operacaoUberabaVO, erros);
                        StringBuilder mensagemRetorno = new StringBuilder(conn.getResponseMessage());
                        if (!Funcoes.objectIsNull(log)) {
                            if (log != null) {
                                log.setSituacao("R");
                            }
                            if (conn.getResponseCode() == 412) {
                                mensagemRetorno.setLength(0);
                                mensagemRetorno.append("A guia ").append(operacaoUberabaVO.getGuiaRequisicao()).append(" da requisi\u00e7\u00e3o ").append(operacaoUberabaVO.getCodigoRequisicao()).append(" para o exame ").append(operacaoUberabaVO.getExame().getExaCodigo()).append(" n\u00e3o foi localizada em nosso sistema.");
                            }
                            if (conn.getResponseCode() == 500) {
                                mensagemRetorno.setLength(0);
                                mensagemRetorno.append("Verifique o c\u00f3digo AMB cadastrado no exame ").append(operacaoUberabaVO.getExame().getExaCodigo()).append(" da requisi\u00e7\u00e3o ").append(operacaoUberabaVO.getCodigoRequisicao()).append(".");
                            }
                            log.setRetorno(mensagemRetorno.toString());
                        }
                        if (log != null) {
                            this.dao.salvarErro(log, log.getSituacao(), log.getRetorno());
                        }
                        erros.add(log);
                    }
                    os.flush();
                }
                List<LogIntegracaoOperadora> logs = this.dao.atualizarLogs(listaRetornos, listaOperacoes, codigoConvenio);
                logs.addAll(erros);
                return logs;
            }
            catch (IOException e) {
                throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel enviar resultados. \n Token inv\u00e1lido!", "buscando logs de integra\u00e7\u00e3o", null);
            }
            catch (SQLException e) {
                throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel enviar resultados. \n Token inv\u00e1lido!", "buscando logs de integra\u00e7\u00e3o", null);
            }
        }
        return null;
    }

    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!this.dao.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTACAO_INTEGRACAO_OPERADORA);
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar(TAG_EXPORTACAO_INTEGRACAO_OPERADORA);
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        this.dao.insereIntegracaoOperadora(protocolo, filial, convenio, codigoRequsicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, xml);
    }

    private LogIntegracaoOperadora logAtual(ArrayList<LogIntegracaoOperadora> listaLogs, OperacaoUberabaVO operacaoUberabaVO, List<LogIntegracaoOperadora> erros) {
        for (LogIntegracaoOperadora lio : listaLogs) {
            if (!operacaoUberabaVO.getCodigoRequisicao().equals(String.valueOf(lio.getCodigoRequisicao())) || !operacaoUberabaVO.getCodigoFilial().equals(String.valueOf(lio.getCodigoFilial())) || !operacaoUberabaVO.getExame().getExaCodigo().equals(lio.getCodigoExame()) || !operacaoUberabaVO.getExame().getCodigoMaterial().equals(String.valueOf(lio.getCodigoMaterial())) || erros.contains(lio)) continue;
            return lio;
        }
        return null;
    }
}

