/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.uberaba;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.models.ExamesUberabaVO;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.models.OperacaoUberabaVO;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.models.RetornoUberabaVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class UberabaDao {
    public static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";

    public ArrayList<LogIntegracaoOperadora> buscaLogs(String codigoFilial, String codigoConvenio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and con_codigo = ").append(codigoConvenio);
        buf.append("  order by eio_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        ArrayList<LogIntegracaoOperadora> listaLogs = null;
        if (!Funcoes.objectIsNull(rs) && rs.next()) {
            listaLogs = new ArrayList<LogIntegracaoOperadora>();
            do {
                String operacao = rs.getString("operacao");
                Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
                String codigoExame = StringUtil.getValor(operacao, "codexa");
                Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
                LogIntegracaoOperadora log = new LogIntegracaoOperadora();
                log.setCodigoFilial(rs.getInt("codigoFilial"));
                log.setCodigoLog(rs.getInt("codigoLog"));
                log.setCodigoConvenio(rs.getInt("codigoConvenio"));
                log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
                log.setRetorno(rs.getString("retorno"));
                log.setSituacao(rs.getString("situacao"));
                log.setCodigoRequisicao(codigoRequisicao);
                log.setCodigoExame(codigoExame);
                log.setCodigoMaterial(codigoMaterial);
                log.setXmlLog(operacao);
                listaLogs.add(log);
            } while (rs.next());
        }
        return listaLogs;
    }

    public List<OperacaoUberabaVO> buscarResultados(LogIntegracaoOperadora logIntegracaoOperadora, List<OperacaoUberabaVO> listaOperacoes) throws IntegracaoOperadoraException {
        StringBuilder bui = new StringBuilder();
        bui.append("select");
        bui.append(" req.req_guia as guia,");
        bui.append(" dtp.dtp_codamb as codigoamb,");
        bui.append(" ert.ert_resultado as resultado,");
        bui.append(" exr.exr_dataassina as data,");
        bui.append(" exr.exa_codigo as codigoexame,");
        bui.append(" exr.mco_codigo as material,");
        bui.append(" exr.exr_situacao as situacao");
        bui.append(" from examerequisicaoresultado ert");
        bui.append(" left join requisicao req on req.fil_codigo = ert.fil_codigo and ert.req_codigo = req.req_codigo");
        bui.append(" left join examerequisicao exr on exr.fil_codigo = ert.fil_codigo and ert.req_codigo = exr.req_codigo and exr.exa_codigo = ert.exa_codigo and ert.mco_codigo = exr.mco_codigo");
        bui.append(" left join exames exa on exa.fil_codigo = ert.fil_codigo and   exa.exa_codigo = ert.exa_codigo");
        bui.append(" left join convenios con on exa.fil_codigo = con.fil_codigo and con.con_codigo = req.con_codigo");
        bui.append(" left join tabelaprecoexames tpe on tpe.fil_codigo = con.fil_codigo and con.tpe_codigo = tpe.tpe_codigo");
        bui.append(" left join detalhetabelapreco dtp on tpe.fil_codigo = dtp.fil_codigo and dtp.tpe_codigo = tpe.tpe_codigo and ert.exa_codigo = dtp.exa_codigo and ert.mco_codigo = dtp.mco_codigo");
        bui.append(" where ert.fil_codigo = ").append(logIntegracaoOperadora.getCodigoFilial());
        bui.append(" and ert.req_codigo = ").append(logIntegracaoOperadora.getCodigoRequisicao());
        bui.append(" and exr.exa_codigo = '").append(logIntegracaoOperadora.getCodigoExame()).append("'");
        Statement stResultado = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(stResultado, bui);
            while (rs.next()) {
                if (!rs.getString("situacao").equals("C")) continue;
                OperacaoUberabaVO operacoesUberabaVO = new OperacaoUberabaVO();
                operacoesUberabaVO.setCodigoFilial(String.valueOf(logIntegracaoOperadora.getCodigoFilial()));
                operacoesUberabaVO.setCodigoRequisicao(String.valueOf(logIntegracaoOperadora.getCodigoRequisicao()));
                operacoesUberabaVO.setGuiaRequisicao(rs.getString("guia"));
                ExamesUberabaVO exame = new ExamesUberabaVO();
                exame.setCodigoExame(rs.getString("codigoamb"));
                exame.setExaCodigo(rs.getString("codigoexame"));
                exame.setCodigoMaterial(rs.getString("material"));
                exame.setData(rs.getTimestamp("data"));
                exame.setResultado(rs.getString("resultado"));
                operacoesUberabaVO.setExame(exame);
                listaOperacoes.add(operacoesUberabaVO);
                this.validarCampos(operacoesUberabaVO, logIntegracaoOperadora);
            }
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar resultado", PROCESSO_MONTA_LINHA, logIntegracaoOperadora);
        }
        return listaOperacoes;
    }

    private void validarCampos(OperacaoUberabaVO operacaoUberabaVO, LogIntegracaoOperadora log) throws IntegracaoOperadoraException, SQLException {
        StringBuilder erro = new StringBuilder();
        if (Funcoes.textoVazio(operacaoUberabaVO.getGuiaRequisicao())) {
            erro.append("Requisi\u00e7\u00e3o ").append(operacaoUberabaVO.getCodigoRequisicao()).append(" sem guia informada.");
            this.salvarErro(log, "N", erro.toString());
            throw new IntegracaoOperadoraException(new Exception("Requisi\u00e7\u00e3o sem guia informada"), erro.toString(), PROCESSO_MONTA_LINHA, log);
        }
        if (Funcoes.textoVazio(operacaoUberabaVO.getExame().getCodigoExame())) {
            erro.append("Verifique o c\u00f3digo AMB cadastrado no exame ").append(operacaoUberabaVO.getExame().getExaCodigo()).append(" da requisi\u00e7\u00e3o ").append(operacaoUberabaVO.getCodigoRequisicao()).append(".");
            this.salvarErro(log, "N", erro.toString());
            throw new IntegracaoOperadoraException(new Exception("Exame sem c\u00f3digo AMB Cadastrado"), erro.toString(), PROCESSO_MONTA_LINHA, log);
        }
        if (Funcoes.textoVazio(operacaoUberabaVO.getExame().getResultado())) {
            erro.append("Exame sem resultado exame: ").append(operacaoUberabaVO.getExame().getExaCodigo()).append(" requisi\u00e7\u00e3o : ").append(operacaoUberabaVO.getCodigoRequisicao()).append(".");
            this.salvarErro(log, "N", erro.toString());
            throw new IntegracaoOperadoraException(new Exception("Exame sem resultado"), erro.toString(), PROCESSO_MONTA_LINHA, log);
        }
    }

    public List<LogIntegracaoOperadora> atualizarLogs(List<RetornoUberabaVO> listaRetornos, List<OperacaoUberabaVO> listaOperacoes, String codigoConvenio) throws IntegracaoOperadoraException, SQLException {
        ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
        if (!Funcoes.objectIsNull(listaRetornos)) {
            for (RetornoUberabaVO retorno : listaRetornos) {
                for (OperacaoUberabaVO operacaoUberabaVO : listaOperacoes) {
                    LogIntegracaoOperadora log;
                    if (retorno.getExame() != operacaoUberabaVO.getExame() || Funcoes.objectIsNull(log = this.buscarLog(Integer.valueOf(operacaoUberabaVO.getCodigoFilial()), codigoConvenio, operacaoUberabaVO, operacaoUberabaVO.getExame())) || !log.getCodigoRequisicao().toString().equals(operacaoUberabaVO.getCodigoRequisicao())) continue;
                    log.setCodigoExame(operacaoUberabaVO.getExame().getExaCodigo());
                    log.setCodigoMaterial(Integer.valueOf(operacaoUberabaVO.getExame().getCodigoMaterial()));
                    log.setRetorno(retorno.getMensagem());
                    if (!Funcoes.textoVazio(retorno.getIdentificador())) {
                        log.setRetorno(retorno.getIdentificador());
                    }
                    log.setSituacao(Funcoes.textoVazio(retorno.getIdentificador()) ? "R" : "E");
                    listaLogs.add(log);
                    this.salvarErro(log, log.getSituacao(), log.getRetorno());
                    this.salvarAutorizacao(log.getRetorno(), log.getCodigoRequisicao(), log.getCodigoFilial(), log.getCodigoExame(), log.getCodigoMaterial());
                }
            }
        }
        return listaLogs;
    }

    public LogIntegracaoOperadora buscarLog(Integer codigoFilial, String codigoConvenio, OperacaoUberabaVO operacaoUberabaVO, ExamesUberabaVO examesUberabaVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,exa_codigo as codigoExame ");
        buf.append("       ,mco_codigo as codigoMaterial ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and fil_codigo = ").append(codigoFilial);
        buf.append("    and con_codigo = ").append(codigoConvenio);
        buf.append("   and eio_operacao ilike '%").append(operacaoUberabaVO.getCodigoRequisicao()).append("%'");
        if (!Funcoes.objectIsNull(examesUberabaVO)) {
            buf.append("   and eio_operacao ilike '%").append(examesUberabaVO.getExaCodigo()).append("%'");
            buf.append("   and eio_operacao ilike '%").append(examesUberabaVO.getCodigoMaterial()).append("%'");
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        LogIntegracaoOperadora log = null;
        while (rs.next()) {
            String codigoRequisicao = StringUtil.getValor(rs.getString("operacao"), "codreq");
            String codigoExame = StringUtil.getValor(rs.getString("operacao"), "codexa");
            String codigoMaterial = StringUtil.getValor(rs.getString("operacao"), "codmat");
            if (!operacaoUberabaVO.getCodigoRequisicao().equals(codigoRequisicao)) continue;
            log = new LogIntegracaoOperadora();
            log.setCodigoFilial(rs.getInt("codigoFilial"));
            log.setCodigoConvenio(rs.getInt("codigoConvenio"));
            log.setCodigoLog(rs.getInt("codigoLog"));
            log.setCodigoRequisicao(Integer.valueOf(codigoRequisicao));
            if (!Funcoes.objectIsNull(examesUberabaVO) && codigoExame.equals(examesUberabaVO.getExaCodigo()) && codigoMaterial.equals(examesUberabaVO.getCodigoMaterial())) {
                log.setCodigoExame(codigoExame);
                log.setCodigoMaterial(Integer.valueOf(codigoMaterial));
            }
            log.setXmlLog(rs.getString("operacao"));
            log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
        }
        return log;
    }

    public void salvarErro(LogIntegracaoOperadora logs, String status, String retornoOperacao) throws IntegracaoOperadoraException, SQLException {
        StringBuilder sql = new StringBuilder();
        String statusRetorno = status.equals("E") ? "t" : "f";
        String filial = logs.getCodigoFilial().toString();
        sql.append("update exportaintegracaooperadora set eio_situacao = '").append(status).append("'");
        sql.append(", eio_retorno = '").append(retornoOperacao).append("'");
        sql.append(", eio_exportado = '").append(statusRetorno).append("'");
        sql.append(", req_codigo = '").append(logs.getCodigoRequisicao()).append("'");
        if (!Funcoes.textoVazio(logs.getCodigoExame())) {
            sql.append(", exa_codigo = '").append(logs.getCodigoExame()).append("'");
        }
        if (!Funcoes.objectIsNull(logs.getCodigoMaterial())) {
            sql.append(", mco_codigo = '").append(logs.getCodigoMaterial()).append("'");
        }
        sql.append(" where eio_codigo in (");
        sql.append(logs.getCodigoLog());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        Conexao.execute(filial, st, sql.toString());
        Conexao.arquivaSQL();
    }

    public void salvarAutorizacao(String codigoAutorizacao, int codigoRequisicao, int codigoFilial, String codigoExame, int codigoMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update examerequisicao set exr_autorizacaouberaba = '");
        sql.append(codigoAutorizacao);
        sql.append("' where req_codigo = ").append(codigoRequisicao);
        sql.append(" and fil_codigo = ").append(codigoFilial);
        sql.append(" and exa_codigo = '").append(codigoExame).append("'");
        sql.append(" and mco_codigo = ").append(codigoMaterial);
        Conexao.execute(String.valueOf(codigoFilial), Conexao.getStatement(), sql.toString());
        Conexao.arquivaSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        boolean bl;
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" select NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL as configurado ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (!rs.next()) break block5;
            boolean bl2 = rs.getBoolean("configurado");
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, XMLStringBuilder xml) {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("(fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" ,").append(convenio);
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(filial)).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(codigoRequsicao);
        buf.append(" , ").append(codigoPaciente);
        buf.append(" , '").append(codigoExame).append("'");
        buf.append(" , ").append(codigoMaterial).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

