/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.uberaba;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.ConfiguradorIntegracaoOperadoraUnimedUberaba;
import jalis.integracaooperadoras.sistemas.unimed.uberaba.UberabaService;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import java.awt.Window;
import java.sql.SQLException;
import java.util.List;

public class IntegracaoOperadoraUnimedUberaba
extends AbstractIntegracaoOperadora {
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DA OPERADORA UNIMED UBERABA";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_BUSCA_LOGS = "buscando logs de integra\u00e7\u00e3o";
    private static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";
    private String codigoLoginConfiguracao = null;
    private String senhaLoginConfiguracao = null;
    private String codigoLaboratorioConfiguracao = null;
    private String xmlConfiguracao;

    public IntegracaoOperadoraUnimedUberaba(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        try {
            List<LogIntegracaoOperadora> retorno = new UberabaService().enviarResultado(Variaveis.filialPadrao, String.valueOf(this.codigoConvenio), this.xmlConfiguracao);
            for (LogIntegracaoOperadora logIntegracaoOperadora : retorno) {
                if (logIntegracaoOperadora.getSituacao().equals("E")) continue;
                this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception(logIntegracaoOperadora.getRetorno()), logIntegracaoOperadora.getRetorno(), "ENVIO RESULTADO", logIntegracaoOperadora));
            }
        }
        catch (IntegracaoOperadoraException e) {
            this.erros.errosProcesso.add(e);
        }
        return this.erros;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraUnimedUberaba config = ConfiguradorIntegracaoOperadoraUnimedUberaba.novaInstancia(parent, this.codigoConvenio);
        config.setXML(xmlConfig);
        config.setVisible(true);
        if (config.getOK()) {
            return config.getXML();
        }
        return xmlConfig;
    }

    private IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        } else {
            if (excecao != null) {
                buf.append(" - ").append(excecao.toString());
            }
            if (excecao instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloCodigo, String codigoFilial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String[] comando) {
        new UberabaService().insereIntegracaoOperadora(protocoloCodigo, codigoFilial, convenio, codigoRequsicao, codigoPaciente, codigoExame, codigoMaterial, tipoOperacao, comando);
    }
}

