/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.uberaba;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraUnimedUberaba
extends AbstractDialogoOKCancelar {
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    public static final String TAG_TOKEN = "token";
    private static String TITULO = "Configurando Unimed Uberaba";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelWebService = new JLabel("Link web services:");
    private JLabel labelToken = new JLabel("Token:");
    private JLabel labelVlrEstacao = new JLabel();
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtEndWebService = new TTextField(200, 3);
    private TTextField txtToken = new TTextField(100);
    private JButton buttonEstacao = new JButton();
    private String xml = null;
    private Integer codigoConvenio;

    public static ConfiguradorIntegracaoOperadoraUnimedUberaba novaInstancia(Window pai, int codigoConvenio) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraUnimedUberaba((Dialog)pai, codigoConvenio);
        }
        return new ConfiguradorIntegracaoOperadoraUnimedUberaba((Frame)pai, codigoConvenio);
    }

    public ConfiguradorIntegracaoOperadoraUnimedUberaba(Dialog pai, int codigoConvenio) {
        super(pai, TITULO);
        this.codigoConvenio = codigoConvenio;
        this.montarTela();
    }

    public ConfiguradorIntegracaoOperadoraUnimedUberaba(Frame pai, int codigoConvenio) {
        super(pai, TITULO);
        this.codigoConvenio = codigoConvenio;
        this.montarTela();
    }

    private void montarTela() {
        this.setResizable(false);
        this.setSize(new Dimension(500, 160));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.txtEstacao.setPreferredSize(new Dimension(80, 20));
        this.txtEstacao.setMinimumSize(new Dimension(80, 20));
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setMinimumSize(new Dimension(20, 20));
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVlrEstacao.setPreferredSize(new Dimension(250, 20));
        this.labelVlrEstacao.setMinimumSize(new Dimension(250, 20));
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelWebService, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.txtEndWebService, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelToken, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtToken, c);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.txtEstacao);
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedUberaba.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedUberaba.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedUberaba.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedUberaba.this.buscaEstacao(ConfiguradorIntegracaoOperadoraUnimedUberaba.this.txtEstacao.getText());
                }
            }
        };
        this.txtEstacao.addKeyListener(keyAdapter);
        this.txtEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraUnimedUberaba.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraUnimedUberaba.this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraUnimedUberaba.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraUnimedUberaba.this.txtEstacao.clear();
                    ConfiguradorIntegracaoOperadoraUnimedUberaba.this.labelVlrEstacao.setText("");
                }
            }
        });
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisaEstacao() {
        this.txtEstacao.clear();
        this.labelVlrEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        }
    }

    public void setXML(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && this.isUberaba() && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_ENDERECO_WEBSERVICE))) {
                this.txtEndWebService.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_TOKEN))) {
                this.txtToken.setText(aux);
            }
        }
    }

    private boolean isUberaba() {
        return StringUtil.getValor(this.xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UBERABA.getDescricao());
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UBERABA.getDescricao());
            xml.escrever("estacao", this.txtEstacao.getText());
            xml.escrever(TAG_ENDERECO_WEBSERVICE, this.txtEndWebService.getText().trim());
            xml.escrever(TAG_TOKEN, this.txtToken.getText().trim());
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o.", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtEndWebService)) {
            Funcoes.mensagem(this, "Endere\u00e7o web service deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEndWebService);
            return false;
        }
        if (Funcoes.textoVazio(this.txtToken)) {
            Funcoes.mensagem(this, "O Token deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtToken);
            return false;
        }
        return true;
    }
}

