/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.sinos;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDao;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.ExameValeDosSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.OperacaoValeDosSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.RetornoValeDosSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.ValeDosSinos;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class ValeDosSinosService {
    public static final String TAG_EXPORTACAO_INTEGRACAO_OPERADORA = "integracaooperadora";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "nomeintegracaooperadora";
    public static final String TAG_EXPORTACAO_FILIAL = "filial";
    public static final String TAG_EXPORTACAO_CODIGO_REQUISICAO = "codreq";
    public static final String TAG_EXPORTACAO_CODIGO_EXAME = "codexa";
    public static final String TAG_EXPORTACAO_CODIGO_MATERIAL = "codmat";
    public static final String TAG_EXPORTACAO_CODIGO_PACIENTE = "codPaciente";
    private ValeDosSinosDao dao;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ValeDosSinosService() {
        this.dao = new ValeDosSinosDao();
    }

    public List<LogIntegracaoOperadora> buscaLogs(String codigoFilial, String codigoConvenio) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> lista = new ArrayList();
        try {
            lista = this.dao.buscaLogs(codigoFilial, codigoConvenio);
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar os logs de integra\u00e7\u00e3o.\n" + e.getMessage(), "buscando logs de integra\u00e7\u00e3o", null);
        }
        return lista;
    }

    public List<LogIntegracaoOperadora> enviarResultado(String codigoConvenio, String xmlConfiguracao) throws IntegracaoOperadoraException {
        ArrayList<LogIntegracaoOperadora> erros = new ArrayList<LogIntegracaoOperadora>();
        List<LogIntegracaoOperadora> logs = new ArrayList<LogIntegracaoOperadora>();
        List<LogIntegracaoOperadora> listaLogs = this.buscaLogs(Variaveis.filialPadrao, String.valueOf(codigoConvenio));
        for (LogIntegracaoOperadora logIntegracaoOperadora : listaLogs) {
            try {
                List<OperacaoValeDosSinos> listaOperacoes = new ArrayList<OperacaoValeDosSinos>();
                if (!Funcoes.textoVazio(logIntegracaoOperadora.getSituacao()) || (listaOperacoes = this.dao.buscarResultados(logIntegracaoOperadora, listaOperacoes)).isEmpty()) continue;
                ValeDosSinos sinos = this.getValeDosSinos(xmlConfiguracao);
                logs = this.integrarOperadora(codigoConvenio, erros, logs, listaLogs, listaOperacoes, sinos);
                Thread.sleep(30000L);
            }
            catch (IntegracaoOperadoraException e) {
                logIntegracaoOperadora.setRetorno(e.getMensagemErro());
                logIntegracaoOperadora.setSituacao("N");
                erros.add(logIntegracaoOperadora);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        return logs;
    }

    private List<LogIntegracaoOperadora> integrarOperadora(String codigoConvenio, List<LogIntegracaoOperadora> erros, List<LogIntegracaoOperadora> logs, List<LogIntegracaoOperadora> listaLogs, List<OperacaoValeDosSinos> listaOperacoes, ValeDosSinos sinos) throws IntegracaoOperadoraException {
        try {
            for (OperacaoValeDosSinos operacao : listaOperacoes) {
                List<ExameValeDosSinos> listaExames = operacao.getListaExames();
                for (ExameValeDosSinos exameValeDosSinos : listaExames) {
                    byte[] message = this.montarMensagemEnvio(sinos, operacao, exameValeDosSinos);
                    HttpsURLConnection conn = this.consultarIntegracao(listaLogs, sinos, message);
                    StringBuilder respostaCompleta = this.getRespostaCompleta(conn);
                    RetornoValeDosSinos retorno = this.getRetornoValeDosSinos(respostaCompleta.toString());
                    conn.disconnect();
                    if (Funcoes.textoVazio(retorno.getGuia())) continue;
                    logs = this.dao.atualizarLogs(retorno, listaOperacoes, codigoConvenio, exameValeDosSinos);
                }
            }
            logs.addAll(erros);
        }
        catch (Exception e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel enviar resultados. \n" + e.getMessage(), "buscando logs de integra\u00e7\u00e3o", null);
        }
        return logs;
    }

    private HttpsURLConnection consultarIntegracao(List<LogIntegracaoOperadora> listaLogs, ValeDosSinos sinos, byte[] json) throws IOException, IntegracaoOperadoraException {
        URL url = new URL(sinos.getUrl());
        String encoding = Base64.encodeBase64String((byte[])sinos.getUsuario().concat(":").concat(sinos.getSenha()).getBytes(StandardCharsets.UTF_8));
        HttpsURLConnection conn = this.montaConexao(url, encoding);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        os.write(json);
        os.flush();
        if (conn.getResponseCode() == 401) {
            LogIntegracaoOperadora log = listaLogs.get(0);
            log.setSituacao("N");
            throw new IntegracaoOperadoraException(new Exception("N\u00e3o foi poss\u00edvel enviar resultados.\n"), "Erro ao enviar resultados. \n Login ou senha inv\u00e1lidos!", "buscando logs de integra\u00e7\u00e3o", log);
        }
        return conn;
    }

    private StringBuilder getRespostaCompleta(HttpsURLConnection conn) throws IOException {
        StringBuilder respostaCompleta = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String temp = "";
        while ((temp = br.readLine()) != null) {
            respostaCompleta.append(temp);
        }
        return respostaCompleta;
    }

    private byte[] montarMensagemEnvio(ValeDosSinos sinos, OperacaoValeDosSinos operacaoValeDosSinos, ExameValeDosSinos exameValeDosSinos) throws SQLException, JsonProcessingException {
        HashMap message = new HashMap();
        HashMap<String, List<Map>> registros = new HashMap<String, List<Map>>();
        HashMap<String, Object> operacao = new HashMap<String, Object>();
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap bytesMessage = new HashMap();
        params.put("operadoraOrigem", sinos.getOperadoraOrigem());
        params.put("prestadorOrigem", sinos.getPrestadorOrigem());
        params.put("sistemaOrigem", sinos.getSistemaOrigem());
        params.put("dataHora", sinos.getDataHora());
        operacao.put("exames", this.getExameIntegracao(exameValeDosSinos));
        operacao.put("anexo", this.getPDFConvertido(operacaoValeDosSinos, exameValeDosSinos));
        operacao.put("formatoArquivo", "PDF");
        operacao.put("tipoOperacao", operacaoValeDosSinos.getTipoOperacao());
        operacao.put("nrCartaoBeneficiario", StringUtil.removeCaracteresNaoNumericos(operacaoValeDosSinos.getNrCartaoBeneficiario()));
        operacao.put("nrExecucaoOperadora", operacaoValeDosSinos.getNrExecucaoOperadora());
        operacao.put("codigoProfissionalResponsavel", operacaoValeDosSinos.getCodigoProfissionalResponsavel());
        operacao.put("cbosProfissionalResponsavel", operacaoValeDosSinos.getCbosProfissionalResponsavel());
        registros.put("registros", Arrays.asList(operacao));
        message.put("header", params);
        message.put("body", registros);
        bytesMessage.put("message", message);
        return new ObjectMapper().writeValueAsBytes(bytesMessage);
    }

    private HttpsURLConnection montaConexao(URL url, String encoding) throws IOException {
        HttpsURLConnection conexao = (HttpsURLConnection)url.openConnection();
        conexao.setRequestMethod("POST");
        conexao.setRequestProperty("Content-Type", "application/json");
        conexao.setRequestProperty("charset", "utf-8");
        conexao.setRequestProperty("Authorization", "Basic " + encoding);
        conexao.setDoOutput(true);
        conexao.setHostnameVerifier((hostname, session) -> hostname.equals(session.getPeerHost()));
        return conexao;
    }

    private String getPDFConvertido(OperacaoValeDosSinos operacaoValeDosSinos, ExameValeDosSinos exame) throws SQLException {
        RetornoImpressaoResultados pdf = ImpressaoResultados.imprimirExames(null, null, operacaoValeDosSinos.getCodigoFilial(), operacaoValeDosSinos.getCodigoRequisicao(), true, true, null, new String[]{exame.getExaCodigo()}, new String[]{exame.getCodigoMaterial()}, true, null, true, true, null, true, "", true, false);
        return Base64.encodeBase64String((byte[])pdf.getResultadoPdfWeb());
    }

    private List<Map<String, Object>> getExameIntegracao(ExameValeDosSinos exameValeDosSinos) {
        HashMap<String, String> exame = new HashMap<String, String>();
        exame.put("codigoTabela", exameValeDosSinos.getCodigoTabela());
        exame.put("codigoExame", exameValeDosSinos.getCodigoExame());
        exame.put("qtde", exameValeDosSinos.getQuantidade());
        exame.put("sequencialExecucao", exameValeDosSinos.getSequencialExecucao());
        return Arrays.asList(exame);
    }

    private RetornoValeDosSinos getRetornoValeDosSinos(String respostaCompleta) throws JSONException {
        RetornoValeDosSinos retorno = new RetornoValeDosSinos();
        if (!Funcoes.textoVazio(respostaCompleta)) {
            this.logger.info(respostaCompleta);
            int inicio = respostaCompleta.indexOf("[");
            int fim = respostaCompleta.indexOf("]");
            String resposta = respostaCompleta.substring(inicio + 1, fim);
            JSONObject respostaJson = new JSONObject(resposta);
            if (respostaJson.has("status")) {
                retorno.setStatus(String.valueOf(respostaJson.getBoolean("status")));
            }
            if (!respostaJson.isNull("motivo") && respostaJson.has("motivo")) {
                retorno.setMensagem(new String(respostaJson.getString("motivo").getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
            }
            if (respostaJson.has("nrExecucaoOperadora")) {
                retorno.setGuia(respostaJson.getString("nrExecucaoOperadora").trim());
            }
            if (respostaJson.has("nrProtocolo")) {
                retorno.setProtoclo(String.valueOf(respostaJson.getInt("nrProtocolo")));
            }
        }
        return retorno;
    }

    private ValeDosSinos getValeDosSinos(String xmlConfiguracao) {
        ValeDosSinos sinos = new ValeDosSinos();
        String xml = xmlConfiguracao;
        String prestadorOrigem = StringUtil.getValor(xml, "prestadorOrigem");
        String operadoraOrigem = StringUtil.getValor(xml, "operadoraOrigem");
        String sistemaOrigem = StringUtil.getValor(xml, "sistemaOrigem");
        String usuario = StringUtil.getValor(xml, "login");
        String senha = StringUtil.getValor(xml, "senha");
        String url = StringUtil.getValor(xml, "enderecoWebService");
        sinos.setUrl(url);
        sinos.setSenha(senha);
        sinos.setUsuario(usuario);
        sinos.setDataHora(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date()));
        sinos.setOperadoraOrigem(operadoraOrigem);
        sinos.setPrestadorOrigem(prestadorOrigem);
        sinos.setSistemaOrigem(sistemaOrigem);
        sinos.setFormatoArquivo("PDF");
        return sinos;
    }

    public void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, ValeDosSinosDTO valeDosSinosDTO, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!this.dao.getConvenioUtilizaIntegracaoOperadora(valeDosSinosDTO.getFilial(), valeDosSinosDTO.getConvenio())) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTACAO_INTEGRACAO_OPERADORA);
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar(TAG_EXPORTACAO_INTEGRACAO_OPERADORA);
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        this.dao.insereIntegracaoOperadora(valeDosSinosDTO, tipoOperacao, xml);
    }

    public void testeLog() {
        String codigoConvenio = "0";
        try {
            List<LogIntegracaoOperadora> listaLogs = this.buscaLogs(Variaveis.filialPadrao, codigoConvenio);
            for (LogIntegracaoOperadora logIntegracaoOperadora : listaLogs) {
                List<OperacaoValeDosSinos> listaOperacoes;
                if (logIntegracaoOperadora.getSituacao() != null && !logIntegracaoOperadora.getSituacao().equals("") || (listaOperacoes = this.dao.buscarResultados(logIntegracaoOperadora, new ArrayList<OperacaoValeDosSinos>())).isEmpty()) continue;
                this.receberLogsTeste(listaOperacoes, codigoConvenio);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel realizar o teste.\nVerifique as configura\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void receberLogsTeste(List<OperacaoValeDosSinos> listaOperacoes, String convenio) throws SQLException {
        for (OperacaoValeDosSinos operacao : listaOperacoes) {
            for (ExameValeDosSinos exame : operacao.getListaExames()) {
                RetornoValeDosSinos retorno = this.getRetornoTeste("R");
                this.dao.atualizarLogs(retorno, listaOperacoes, convenio, exame);
            }
        }
    }

    private RetornoValeDosSinos getRetornoTeste(String tipo) {
        RetornoValeDosSinos retornoTeste = new RetornoValeDosSinos();
        retornoTeste.setGuia("123");
        if (tipo.equalsIgnoreCase("E")) {
            retornoTeste.setMensagem("Retorno de Teste: Enviado");
            retornoTeste.setStatus("true");
        } else if (tipo.equalsIgnoreCase("R")) {
            retornoTeste.setMensagem("Retorno de Teste: Rejeitado");
            retornoTeste.setStatus("false");
        }
        return retornoTeste;
    }
}

