/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.sinos;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.ExameValeDosSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.OperacaoValeDosSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.models.RetornoValeDosSinos;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ValeDosSinosDao {
    public List<LogIntegracaoOperadora> buscaLogs(String codigoFilial, String codigoConvenio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select eio.fil_codigo as codigoFilial ");
        buf.append(" ,eio.eio_codigo as codigoLog ");
        buf.append(" ,eio.con_codigo as codigoConvenio ");
        buf.append(" ,eio.eio_operacao as operacao ");
        buf.append(" ,eio.eio_tipooperacao as tipoOperacao ");
        buf.append(" ,eio.eio_retorno as retorno");
        buf.append(" ,eio.exa_codigo as codigoExame");
        buf.append(" ,eio.mco_codigo as codigoMaterial");
        buf.append(" ,COALESCE(eio.eio_situacao,'') as situacao ");
        buf.append(" from exportaintegracaooperadora eio");
        buf.append(" left join examerequisicao exr on");
        buf.append(" eio.fil_codigo = exr.fil_codigo");
        buf.append(" and eio.req_codigo = exr.req_codigo");
        buf.append(" and eio.exa_codigo = exr.exa_codigo");
        buf.append(" and eio.mco_codigo = exr.mco_codigo");
        buf.append(" where eio.eio_exportado = false and eio.eio_situacao is null");
        buf.append(" and eio.fil_codigo = ").append(codigoFilial);
        buf.append(" and eio.con_codigo = ").append(codigoConvenio);
        buf.append(" and (exr.exr_excluido is null or exr.exr_excluido = false) ");
        buf.append(" order by eio_codigo limit 100 ");
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        rs = Conexao.executeQuery(st, buf.toString());
        ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
        if (rs != null && rs.next()) {
            listaLogs = new ArrayList();
            do {
                String operacao = rs.getString("operacao");
                Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
                String codigoExame = rs.getString("codigoExame");
                Integer codigoMaterial = rs.getInt("codigoMaterial");
                LogIntegracaoOperadora log = new LogIntegracaoOperadora();
                log.setCodigoFilial(rs.getInt("codigoFilial"));
                log.setCodigoLog(rs.getInt("codigoLog"));
                log.setCodigoConvenio(rs.getInt("codigoConvenio"));
                log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
                log.setRetorno(rs.getString("retorno"));
                log.setSituacao(rs.getString("situacao"));
                log.setCodigoRequisicao(codigoRequisicao);
                log.setCodigoExame(codigoExame);
                log.setCodigoMaterial(codigoMaterial);
                log.setXmlLog(operacao);
                listaLogs.add(log);
            } while (rs.next());
        }
        return listaLogs;
    }

    public List<OperacaoValeDosSinos> buscarResultados(LogIntegracaoOperadora logIntegracaoOperadora, List<OperacaoValeDosSinos> listaOperacoes) throws IntegracaoOperadoraException {
        StringBuilder bui = new StringBuilder();
        bui.append("select ");
        bui.append("con.con_integracaooperadora as xml,");
        bui.append("exr.exr_data as data,");
        bui.append("COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guia,");
        bui.append("exr.exr_codautorizacao as senha,");
        bui.append("req.req_matricula as cartao,");
        bui.append("req.req_cartaosus as cartaosus,");
        bui.append("req.med_crm as crmMedico,");
        bui.append("med.med_cbo as cbosMedico,");
        bui.append("pac.pac_nome as beneficiario,");
        bui.append("tpe.tpe_tabelaans AS codigoTabela,");
        bui.append("replace(replace(dtp.dtp_codamb, '.', ''), '-', '') as codigoAmb,");
        bui.append("exa.exa_descricao as descricao,");
        bui.append("ert.ert_resultado as resultado,");
        bui.append("req.req_codigo as requisicao,");
        bui.append("exr.exa_codigo as codigoExame,");
        bui.append("exr.mco_codigo as codigoMaterial, ");
        bui.append("exr.met_codigo as codigoMetodologia,");
        bui.append("exr.exr_situacao as situacao,");
        bui.append("req.req_idade as idadePaciente, ");
        bui.append("ert.fil_codigo as codigoFilial, ");
        bui.append("req.con_codigo as codigoConvenio, ");
        bui.append("req.des_codigo as codigoDestino, ");
        bui.append("req.req_anomes as tipoIdadePaciente ");
        bui.append("from examerequisicaoresultado ert ");
        bui.append("left join requisicao req on req.fil_codigo = ert.fil_codigo and ert.req_codigo = req.req_codigo ");
        bui.append("left join examerequisicao exr on exr.fil_codigo = ert.fil_codigo and ert.req_codigo = exr.req_codigo and exr.exa_codigo = ert.exa_codigo and ert.mco_codigo = exr.mco_codigo ");
        bui.append("left join exames exa on exa.fil_codigo = ert.fil_codigo and   exa.exa_codigo = ert.exa_codigo ");
        bui.append("left join convenios con on exa.fil_codigo = con.fil_codigo and con.con_codigo = req.con_codigo ");
        bui.append("left join tabelaprecoexames tpe on tpe.fil_codigo = con.fil_codigo and con.tpe_codigo = tpe.tpe_codigo ");
        bui.append("left join detalhetabelapreco dtp on tpe.fil_codigo = dtp.fil_codigo and dtp.tpe_codigo = tpe.tpe_codigo and ert.exa_codigo = dtp.exa_codigo and ert.mco_codigo = dtp.mco_codigo ");
        bui.append("left join paciente pac on pac.fil_codigo = ert.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        bui.append("left join medico med on med.fil_codigo = req.fil_codigo and med.med_crm = req.med_crm and  med.med_uf = req.med_uf and med.med_conselho = req.med_conselho ");
        bui.append("left join exportaintegracaooperadora eio on (exr.fil_codigo = eio.fil_codigo and exr.req_codigo = eio.req_codigo and exr.exa_codigo = eio.exa_codigo and exr.mco_codigo = eio.mco_codigo) ");
        bui.append(" where ert.fil_codigo = ").append(logIntegracaoOperadora.getCodigoFilial());
        bui.append(" and ert.req_codigo = ").append(logIntegracaoOperadora.getCodigoRequisicao());
        bui.append(" and exr.exr_situacao in ('").append("C").append("', '").append("E").append("', '").append("I").append("') ");
        bui.append(" and eio.eio_exportado is false and eio.eio_situacao is null");
        bui.append(" and (req.req_excluida is null or req.req_excluida = false) ");
        bui.append(" and (exr.exr_excluido is null or exr.exr_excluido = false) ");
        Statement stResultado = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(stResultado, bui.toString());
            ArrayList<ExameValeDosSinos> listaExames = new ArrayList<ExameValeDosSinos>();
            if (rs.next()) {
                String cboMedico = "225125";
                if (!Funcoes.textoVazio(rs.getString("cbosMedico")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("cbosMedico"), "codigo"))) {
                    cboMedico = StringUtil.getValor(rs.getString("cbosMedico"), "codigo").replace(".", "");
                }
                String crmMedico = rs.getString("crmMedico");
                OperacaoValeDosSinos oSinos = new OperacaoValeDosSinos();
                oSinos.setTipoOperacao("L");
                oSinos.setNrCartaoBeneficiario(rs.getString("cartao"));
                oSinos.setNrExecucaoOperadora(rs.getString("guia"));
                oSinos.setCbosProfissionalResponsavel(cboMedico);
                oSinos.setCodigoProfissionalResponsavel(crmMedico);
                oSinos.setCodigoFilial(rs.getString("codigoFilial"));
                oSinos.setCodigoRequisicao(rs.getString("requisicao"));
                Integer contador = 1;
                do {
                    ExameValeDosSinos exames = new ExameValeDosSinos();
                    if (!rs.getString("situacao").equalsIgnoreCase("A")) {
                        exames.setCodigoTabela(rs.getString("codigoTabela"));
                        exames.setCodigoExame(!Funcoes.textoVazio(rs.getString("codigoAmb")) ? rs.getString("codigoAmb").trim() : rs.getString("codigoAmb"));
                        exames.setExaCodigo(rs.getString("codigoExame"));
                        exames.setCodigoMaterial(rs.getString("codigoMaterial"));
                        exames.setQuantidade("1");
                        exames.setSequencialExecucao(contador.toString());
                        Integer n = contador;
                        Integer n2 = contador = Integer.valueOf(contador + 1);
                    }
                    listaExames.add(exames);
                } while (rs.next());
                oSinos.setListaExames(listaExames);
                listaOperacoes.add(oSinos);
                this.validarCampos(oSinos, logIntegracaoOperadora);
            }
        }
        catch (Exception e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar resultado", "montando linha de resultado", logIntegracaoOperadora);
        }
        return listaOperacoes;
    }

    private void validarCampos(OperacaoValeDosSinos operacaoValeDosSinos, LogIntegracaoOperadora log) throws IntegracaoOperadoraException, SQLException {
        if (Funcoes.textoVazio(operacaoValeDosSinos.getCbosProfissionalResponsavel())) {
            String erro = "Profissional sem CBOS cadastrado na requisi\u00e7\u00e3o " + operacaoValeDosSinos.getCodigoRequisicao();
            this.salvarErro(log, "N", erro);
            throw new IntegracaoOperadoraException(new Exception("Profissional sem CBOS Cadastrado"), erro, "montando linha de resultado", log);
        }
        if (Funcoes.textoVazio(operacaoValeDosSinos.getCodigoProfissionalResponsavel())) {
            String erro = "Profissional sem CRM Cadastrado na requisi\u00e7\u00e3o " + operacaoValeDosSinos.getCodigoRequisicao();
            this.salvarErro(log, "N", erro);
            throw new IntegracaoOperadoraException(new Exception("Profissional sem CRM Cadastrado"), erro, "montando linha de resultado", log);
        }
        if (Funcoes.textoVazio(operacaoValeDosSinos.getNrCartaoBeneficiario())) {
            String erro = "Paciente sem cart\u00e3o Cadastrado na requisi\u00e7\u00e3o " + operacaoValeDosSinos.getCodigoRequisicao();
            this.salvarErro(log, "N", erro);
            throw new IntegracaoOperadoraException(new Exception("Paciente sem cart\u00e3o Cadastrado"), erro, "montando linha de resultado", log);
        }
        if (Funcoes.textoVazio(operacaoValeDosSinos.getNrExecucaoOperadora())) {
            String erro = "Requisi\u00e7\u00e3o " + operacaoValeDosSinos.getCodigoRequisicao() + " sem guia informada";
            this.salvarErro(log, "N", erro);
            throw new IntegracaoOperadoraException(new Exception("Requisi\u00e7\u00e3o sem guia informada"), erro, "montando linha de resultado", log);
        }
        List<ExameValeDosSinos> listaExames = operacaoValeDosSinos.getListaExames();
        for (ExameValeDosSinos examesValeDosSinos : listaExames) {
            if (Funcoes.textoVazio(examesValeDosSinos.getExaCodigo()) || !Funcoes.textoVazio(examesValeDosSinos.getCodigoTabela())) continue;
            String erro = "Exame sem c\u00f3digo AMB Cadastrado exame: " + examesValeDosSinos.getExaCodigo() + " requisi\u00e7\u00e3o : " + operacaoValeDosSinos.getCodigoRequisicao();
            this.salvarErro(log, "N", erro);
            throw new IntegracaoOperadoraException(new Exception("Exame sem c\u00f3digo AMB Cadastrado"), erro, "montando linha de resultado", log);
        }
    }

    public List<LogIntegracaoOperadora> atualizarLogs(RetornoValeDosSinos retorno, List<OperacaoValeDosSinos> listaOperacoes, String codigoConvenio, ExameValeDosSinos exame) throws SQLException {
        ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
        for (OperacaoValeDosSinos operacaoValeDosSinos : listaOperacoes) {
            if (!retorno.getGuia().equals(operacaoValeDosSinos.getNrExecucaoOperadora())) continue;
            List<LogIntegracaoOperadora> logsExame = this.buscarLogExame(Integer.valueOf(operacaoValeDosSinos.getCodigoFilial()), codigoConvenio, operacaoValeDosSinos, exame);
            for (LogIntegracaoOperadora log : logsExame) {
                listaLogs.add(this.getLogAtualizado(retorno, exame, operacaoValeDosSinos, log));
            }
        }
        return listaLogs;
    }

    public LogIntegracaoOperadora getLogAtualizado(RetornoValeDosSinos retorno, ExameValeDosSinos exame, OperacaoValeDosSinos operacaoValeDosSinos, LogIntegracaoOperadora log) throws SQLException {
        if (log != null && log.getCodigoRequisicao().toString().equals(operacaoValeDosSinos.getCodigoRequisicao())) {
            if (!Funcoes.textoVazio(retorno.getProtoclo())) {
                log.setRetorno("Resultados enviados: " + retorno.getProtoclo());
            } else if (retorno.getMensagem() != null) {
                log.setRetorno(retorno.getMensagem());
            }
            log.setSituacao(retorno.getStatus().equals("true") ? "E" : "R");
            this.atualizarExame(log, exame);
        }
        return log;
    }

    public List<LogIntegracaoOperadora> buscarLogExame(Integer codigoFilial, String codigoConvenio, OperacaoValeDosSinos operacaoValeDosSinos, ExameValeDosSinos exame) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial, ");
        buf.append(" req_codigo as codigoReq, ");
        buf.append(" exa_codigo as codigoExame, ");
        buf.append(" mco_codigo as codigoMaterial, ");
        buf.append(" eio_codigo as codigoLog, ");
        buf.append(" con_codigo as codigoConvenio, ");
        buf.append(" exa_codigo as codigoExame, ");
        buf.append(" mco_codigo as codigoMaterial, ");
        buf.append(" eio_operacao as operacao, ");
        buf.append(" eio_tipooperacao as tipoOperacao, ");
        buf.append(" eio_retorno as retorno,");
        buf.append(" COALESCE(eio_situacao,'') as situacao ");
        buf.append(" from exportaintegracaooperadora ");
        buf.append(" where ");
        buf.append(" fil_codigo = ").append(codigoFilial);
        buf.append(" and con_codigo =  ").append(codigoConvenio);
        buf.append(" and req_codigo =  ").append(operacaoValeDosSinos.getCodigoRequisicao());
        buf.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(exame.getExaCodigo()));
        buf.append(" and mco_codigo =  ").append(exame.getCodigoMaterial());
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ArrayList<LogIntegracaoOperadora> logs = new ArrayList<LogIntegracaoOperadora>();
        while (rs.next()) {
            String codigoRequisicao = rs.getString("codigoReq");
            String codigoExame = rs.getString("codigoExame");
            String codigoMaterial = rs.getString("codigoMaterial");
            if (!operacaoValeDosSinos.getCodigoRequisicao().equals(codigoRequisicao)) continue;
            LogIntegracaoOperadora log = new LogIntegracaoOperadora();
            log.setCodigoFilial(rs.getInt("codigoFilial"));
            log.setCodigoConvenio(rs.getInt("codigoConvenio"));
            log.setCodigoLog(rs.getInt("codigoLog"));
            log.setCodigoRequisicao(Integer.valueOf(codigoRequisicao));
            log.setCodigoExame(codigoExame);
            log.setCodigoMaterial(Integer.valueOf(codigoMaterial));
            log.setXmlLog(rs.getString("operacao"));
            log.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
            logs.add(log);
        }
        return logs;
    }

    public void salvarErro(LogIntegracaoOperadora logs, String status, String retornoOperacao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String filial = logs.getCodigoFilial().toString();
        sql.append(" update exportaintegracaooperadora set eio_situacao = '").append(status).append("'");
        sql.append(" , eio_retorno = '").append(retornoOperacao).append("'");
        sql.append(" , eio_exportado = true");
        sql.append(" , req_codigo = '").append(logs.getCodigoRequisicao()).append("'");
        sql.append("  where req_codigo = ").append(logs.getCodigoRequisicao());
        sql.append(" and fil_codigo = ").append(filial);
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(logs.getCodigoExame()));
        sql.append(" and mco_codigo = ").append(logs.getCodigoMaterial());
        Statement st = Conexao.getStatement();
        Conexao.execute(filial, st, sql.toString());
        Conexao.arquivaSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarExame(LogIntegracaoOperadora log, ExameValeDosSinos exame) throws SQLException {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder sql = new StringBuilder();
            String filial = log.getCodigoFilial().toString();
            sql.append(" update exportaintegracaooperadora set eio_situacao = '").append(log.getSituacao()).append("'");
            sql.append(",  eio_tipooperacao = ").append(StringUtil.textoDBEscape(log.getTipoOperacao().toString()));
            sql.append(",  eio_retorno = ").append(StringUtil.textoDBEscape(log.getRetorno()));
            sql.append(",  eio_exportado = true ");
            sql.append("  where req_codigo = ").append(log.getCodigoRequisicao());
            sql.append(" and fil_codigo = ").append(filial);
            sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(exame.getExaCodigo()));
            sql.append(" and mco_codigo = ").append(exame.getCodigoMaterial());
            Conexao.execute(filial, st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getConvenioUtilizaIntegracaoOperadora(String codigoFilial, String codigoConvenio) {
        boolean bl;
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" select NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL as configurado ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (!rs.next()) break block5;
            boolean bl2 = rs.getBoolean("configurado");
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o conv\u00eanio " + codigoConvenio + " utiliza integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insereIntegracaoOperadora(ValeDosSinosDTO valeDosSinosDTO, String tipoOperacao, XMLStringBuilder xml) {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("(fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append(" values (").append(valeDosSinosDTO.getFilial());
        buf.append(" ,").append(valeDosSinosDTO.getConvenio());
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(valeDosSinosDTO.getFilial())).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n+", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(valeDosSinosDTO.getRequisicao());
        buf.append(" , ").append(valeDosSinosDTO.getPaciente());
        buf.append(" , '").append(valeDosSinosDTO.getExame()).append("'");
        buf.append(" , ").append(valeDosSinosDTO.getMaterial()).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.execute(valeDosSinosDTO.getFilial(), st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

