/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.sinos;

import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ConfiguradorIntegracaoOperadoraUnimedValeDosSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosService;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import java.awt.Window;
import java.util.List;

public class IntegracaoOperadoraUnimedValeSinos
extends AbstractIntegracaoOperadora {
    private String xmlConfiguracao;

    public IntegracaoOperadoraUnimedValeSinos(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, "ENVIANDO RESULTADOS AO WEBSERVICE DA OPERADORA UNIMED VALE DOS SINOS");
        try {
            List<LogIntegracaoOperadora> retorno = new ValeDosSinosService().enviarResultado(String.valueOf(this.codigoConvenio), this.xmlConfiguracao);
            for (LogIntegracaoOperadora logIntegracaoOperadora : retorno) {
                if (logIntegracaoOperadora.getSituacao().equals("E")) continue;
                this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception(logIntegracaoOperadora.getRetorno()), logIntegracaoOperadora.getRetorno(), "ENVIO RESULTADO", logIntegracaoOperadora));
            }
        }
        catch (IntegracaoOperadoraException e) {
            this.erros.errosProcesso.add(e);
        }
        return this.erros;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraUnimedValeDosSinos config = ConfiguradorIntegracaoOperadoraUnimedValeDosSinos.novaInstancia(parent);
        config.setXML(xmlConfig);
        config.setVisible(true);
        if (config.getOK()) {
            return config.getXML();
        }
        return xmlConfig;
    }

    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloCodigo, ValeDosSinosDTO valeDosSinosDTO, String tipoOperacao, String[] comando) {
        new ValeDosSinosService().insereIntegracaoOperadora(protocoloCodigo, valeDosSinosDTO, tipoOperacao, comando);
    }
}

