/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.sinos;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraUnimedValeDosSinos
extends AbstractDialogoOKCancelar {
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    public static final String TAG_OPERADORA_ORIGEM = "operadoraOrigem";
    public static final String TAG_PRESTADOR_ORIGEM = "prestadorOrigem";
    public static final String TAG_SISTEMA_ORIGEM = "sistemaOrigem";
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    private static final String TITULO = "Configurando integra\u00e7\u00e3o Unimed Vale Dos Sinos";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelWebService = new JLabel("Link web services:");
    private JLabel labelOperadora = new JLabel("Operadora origem:");
    private JLabel labelPrestador = new JLabel("Prestador origem:");
    private JLabel labelSistema = new JLabel("Sistema origem:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelVlrEstacao = new JLabel();
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtEndWebService = new TTextField(200, 3);
    private TTextField txtOperadora = new TTextField(100);
    private TTextField txtPrestador = new TTextField(100);
    private TTextField txtSistema = new TTextField(100);
    private TTextField txtUsuario = new TTextField(100);
    private TTextField txtSenha = new TTextField(100);
    private JButton buttonEstacao = new JButton();
    private String xml = null;

    public static ConfiguradorIntegracaoOperadoraUnimedValeDosSinos novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraUnimedValeDosSinos((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraUnimedValeDosSinos((Frame)pai);
    }

    public ConfiguradorIntegracaoOperadoraUnimedValeDosSinos(Dialog pai) {
        super(pai, TITULO);
        this.montarTela();
    }

    public ConfiguradorIntegracaoOperadoraUnimedValeDosSinos(Frame pai) {
        super(pai, TITULO);
        this.montarTela();
    }

    private void montarTela() {
        this.setResizable(false);
        this.setSize(new Dimension(500, 250));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.txtEstacao.setPreferredSize(new Dimension(80, 20));
        this.txtEstacao.setMinimumSize(new Dimension(80, 20));
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setMinimumSize(new Dimension(20, 20));
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVlrEstacao.setPreferredSize(new Dimension(250, 20));
        this.labelVlrEstacao.setMinimumSize(new Dimension(250, 20));
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelWebService, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.txtEndWebService, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelOperadora, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtOperadora, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelPrestador, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtPrestador, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelSistema, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtSistema, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelUsuario, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        this.getPanelCentral().add((Component)this.labelSenha, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtSenha, c);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.txtEstacao);
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedValeDosSinos.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedValeDosSinos.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedValeDosSinos.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedValeDosSinos.this.buscaEstacao(ConfiguradorIntegracaoOperadoraUnimedValeDosSinos.this.txtEstacao.getText());
                }
            }
        };
        this.txtEstacao.addKeyListener(keyAdapter);
        this.txtEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(e -> {
            EstacaoService estacaoService = new EstacaoService();
            EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.txtEstacao.clear();
                this.labelVlrEstacao.setText("");
            }
        });
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisaEstacao() {
        this.txtEstacao.clear();
        this.labelVlrEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        }
    }

    public void setXML(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && this.isValeDosSinos() && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            this.setTextoCampo(xml, TAG_LOGIN, this.txtUsuario);
            this.setTextoCampo(xml, TAG_SENHA, this.txtSenha);
            this.setTextoCampo(xml, TAG_OPERADORA_ORIGEM, this.txtOperadora);
            this.setTextoCampo(xml, TAG_PRESTADOR_ORIGEM, this.txtPrestador);
            this.setTextoCampo(xml, TAG_SISTEMA_ORIGEM, this.txtSistema);
            this.setTextoCampo(xml, TAG_ENDERECO_WEBSERVICE, this.txtEndWebService);
            this.setTextoCampo(xml, TAG_LOGIN, this.txtUsuario);
            this.setTextoCampo(xml, TAG_LOGIN, this.txtUsuario);
        }
    }

    private void setTextoCampo(String xml, String tag, TTextField campo) {
        String aux = StringUtil.getValor(xml, tag);
        if (!Funcoes.textoVazio(aux)) {
            campo.setText(aux);
        }
    }

    private boolean isValeDosSinos() {
        return StringUtil.getValor(this.xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS.getDescricao());
    }

    public String getXML() {
        XMLStringBuilder xmlTemp = new XMLStringBuilder();
        try {
            xmlTemp.abrir("integracaooperadora");
            xmlTemp.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS.getDescricao());
            xmlTemp.escrever("estacao", this.txtEstacao.getText());
            xmlTemp.escrever(TAG_ENDERECO_WEBSERVICE, this.txtEndWebService.getText());
            xmlTemp.escrever(TAG_OPERADORA_ORIGEM, this.txtOperadora.getText());
            xmlTemp.escrever(TAG_PRESTADOR_ORIGEM, this.txtPrestador.getText());
            xmlTemp.escrever(TAG_SISTEMA_ORIGEM, this.txtSistema.getText());
            xmlTemp.escrever(TAG_LOGIN, this.txtUsuario.getText());
            xmlTemp.escrever(TAG_SENHA, this.txtSenha.getText());
            xmlTemp.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o.", e.getStackTrace());
            return null;
        }
        return xmlTemp.getXML();
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtUsuario)) {
            Funcoes.mensagem(this, "O usu\u00e1rio de login deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSenha)) {
            Funcoes.mensagem(this, "A senha de login deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSistema)) {
            Funcoes.mensagem(this, "O sistema de origem deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtSistema);
            return false;
        }
        if (Funcoes.textoVazio(this.txtPrestador)) {
            Funcoes.mensagem(this, "O prestador de origem deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtPrestador);
            return false;
        }
        if (Funcoes.textoVazio(this.txtOperadora)) {
            Funcoes.mensagem(this, "A operadora origem deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtOperadora);
            return false;
        }
        if (Funcoes.textoVazio(this.txtEndWebService)) {
            Funcoes.mensagem(this, "Endere\u00e7o web service deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEndWebService);
            return false;
        }
        return true;
    }
}

