/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.pr.model;

import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.ArquivoLaudo;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.Descricao;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.ElementoTerm;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EntidadeSaude;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinico;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoBeneficiario;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinica;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinicaExamesLaboratorio;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorio;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioDetalheAmostra;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioFatores;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExame;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExameResultadosAnalitoResultadoAnalito;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoOrigemInformacao;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoOrigemInformacaoEntidade;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoOrigemInformacaoEntidadeCodigoEntidade;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoOrigemInformacaoEntidadeIdentificacaoEntidade;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.EventosSumarioClinicoOrigemInformacaoIdentificacaoProfissional;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.Medico;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.Profissional;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.RegistroResultadoExamePadrao_ServiceLocator;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.RespostaEventosSumarioClinico;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao.TipoEntidade;
import br.com.unimed.integracao_res.schemas.servico.envio.resultado_exame.padrao_unimed.RegistroResultadoExamePadrao._envioDadosLaboratorioStub;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.pr.model.UnimedPRDao;
import jalis.integracaooperadoras.sistemas.unimed.pr.model.UnimedPRVO;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.rpc.Service;

public class UnimedPRService {
    private DadosErrosIntegracaoOperadora erros;
    private UnimedPRDao dao = new UnimedPRDao();
    private String xmlConfiguracao;
    private String url;
    private String codigoLaboratorio;
    private String codigoUnimed;
    private String medicoExecutor;
    private String codigoMedico;
    private String ufMedico;
    private String conselhoMedico;
    private String usuario;
    private String senha;
    private String cnes;
    private String nomeEntidade;
    private static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";

    public List<LogIntegracaoOperadora> enviarResultado(String codigoConvenio, String xmlConfiguracao) {
        ArrayList<LogIntegracaoOperadora> listaLogs = null;
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoLaboratorio = StringUtil.getValor(xmlConfiguracao, "codigoLaboratorio");
        this.codigoUnimed = StringUtil.getValor(xmlConfiguracao, "codigoUnimed");
        this.medicoExecutor = StringUtil.getValor(xmlConfiguracao, "nomeMedico");
        this.codigoMedico = StringUtil.getValor(xmlConfiguracao, "codigoMedico");
        this.ufMedico = StringUtil.getValor(xmlConfiguracao, "ufMedico");
        this.conselhoMedico = StringUtil.getValor(xmlConfiguracao, "conselhoMedico");
        this.url = StringUtil.getValor(xmlConfiguracao, "enderecoWebService");
        this.usuario = StringUtil.getValor(xmlConfiguracao, "usuario");
        this.senha = StringUtil.getValor(xmlConfiguracao, "senha");
        this.cnes = StringUtil.getValor(xmlConfiguracao, "cnes");
        this.nomeEntidade = StringUtil.getValor(xmlConfiguracao, "nomeEntidade");
        this.erros = new DadosErrosIntegracaoOperadora();
        listaLogs = this.getLogsIntegracao(codigoConvenio);
        HashMap<String, ArrayList<LogIntegracaoOperadora>> mapRequisicoes = new HashMap<String, ArrayList<LogIntegracaoOperadora>>();
        for (LogIntegracaoOperadora log : listaLogs) {
            if (log.getTipoOperacao() != AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) continue;
            try {
                RespostaEventosSumarioClinico resposta;
                String reqCodigo = log.getCodigoRequisicao().toString();
                if (mapRequisicoes.containsKey(reqCodigo)) {
                    ((ArrayList)mapRequisicoes.get(reqCodigo)).add(log);
                } else {
                    ArrayList<LogIntegracaoOperadora> logsIntegracao = new ArrayList<LogIntegracaoOperadora>();
                    logsIntegracao.add(log);
                    mapRequisicoes.put(reqCodigo, logsIntegracao);
                }
                if (null == (resposta = this.enviarResultado(mapRequisicoes, log))) continue;
                log.setRetorno(resposta.getDescricaoMensagem() + " " + resposta.getMensagemEnvioID());
                log.setSituacao("E");
                this.atualizarLog(log, true);
            }
            catch (Exception e) {
                log.setRetorno(e.getMessage());
                log.setSituacao("R");
                try {
                    this.atualizarLog(log, false);
                }
                catch (Exception e1) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException e2) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
        return listaLogs;
    }

    private void atualizarLog(LogIntegracaoOperadora log, boolean exportado) throws Exception {
        this.dao.atualizarLog(log, exportado);
    }

    private RespostaEventosSumarioClinico enviarResultado(HashMap<String, ArrayList<LogIntegracaoOperadora>> mapLogs, LogIntegracaoOperadora log) throws Exception {
        RespostaEventosSumarioClinico resposta = new RespostaEventosSumarioClinico();
        for (String key : mapLogs.keySet()) {
            ArrayList<LogIntegracaoOperadora> logs = mapLogs.get(key);
            mapLogs.remove(key);
            for (LogIntegracaoOperadora logIntegracao : logs) {
                ArrayList<Registro> registros = this.dao.getDados(logIntegracao);
                if (registros == null) continue;
                this.validarCampos(registros, logIntegracao);
                EventosSumarioClinico sumario = new EventosSumarioClinico();
                sumario.setBeneficiario(this.getBeneficiario(registros.get(0)));
                sumario.setOrigemInformacao(this.getOrigemInformacao(registros.get(0)));
                sumario.setInformacaoClinica(this.getInformacaoClinica(registros));
                _envioDadosLaboratorioStub envio = new _envioDadosLaboratorioStub(new URL(this.url), (Service)new RegistroResultadoExamePadrao_ServiceLocator());
                envio.setUsername(this.usuario);
                envio.setPassword(this.senha);
                resposta = envio.registroResultadoExameOperation(sumario);
                return resposta;
            }
        }
        return resposta;
    }

    private void validarCampos(ArrayList<Registro> registros, LogIntegracaoOperadora logIntegracao) throws Exception {
        Registro requisicao = registros.get(0);
        if (Funcoes.textoVazio(this.codigoUnimed)) {
            StringBuilder exception = new StringBuilder();
            exception.append("C\u00f3digo da unimed n\u00e3o informado. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" conv\u00eanio ").append(logIntegracao.getCodigoConvenio());
            throw new Exception(exception.toString());
        }
        if (Funcoes.textoVazio(this.codigoLaboratorio)) {
            StringBuilder exception = new StringBuilder();
            exception.append("C\u00f3digo do laborat\u00f3rio n\u00e3o informado. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" conv\u00eanio ").append(logIntegracao.getCodigoConvenio());
            throw new Exception(exception.toString());
        }
        if (Funcoes.textoVazio(this.usuario)) {
            StringBuilder exception = new StringBuilder();
            exception.append("Usu\u00e1rio n\u00e3o informado. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" conv\u00eanio ").append(logIntegracao.getCodigoConvenio());
            throw new Exception(exception.toString());
        }
        if (Funcoes.textoVazio(this.cnes)) {
            StringBuilder exception = new StringBuilder();
            exception.append("CNES n\u00e3o informado ao conv\u00eanio. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" conv\u00eanio ").append(logIntegracao.getCodigoConvenio());
            throw new Exception(exception.toString());
        }
        if (Funcoes.textoVazio(this.senha)) {
            StringBuilder exception = new StringBuilder();
            exception.append("Senha n\u00e3o informado. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" conv\u00eanio ").append(logIntegracao.getCodigoConvenio());
            throw new IntegracaoOperadoraException(new Exception(), exception.toString(), "Resultado", logIntegracao);
        }
        if (Funcoes.textoVazio(this.medicoExecutor)) {
            StringBuilder exception = new StringBuilder();
            exception.append("M\u00e9dico executor n\u00e3o informado no cadastro do conv\u00eanio. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" conv\u00eanio ").append(logIntegracao.getCodigoConvenio());
            throw new Exception(exception.toString());
        }
        if (Funcoes.textoVazio(requisicao.getString("matricula"))) {
            StringBuilder exception = new StringBuilder();
            exception.append("Matricula n\u00e3o informada. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" requisi\u00e7\u00e3o ").append(logIntegracao.getCodigoRequisicao());
            throw new Exception(exception.toString());
        }
        if (requisicao.getString("matricula").length() != 13 && requisicao.getString("matricula").length() != 17) {
            StringBuilder exception = new StringBuilder();
            exception.append("Matricula deve conter 13 ou 17 dig\u00edtos. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" requisi\u00e7\u00e3o ").append(logIntegracao.getCodigoRequisicao());
            throw new Exception(exception.toString());
        }
        for (Registro exame : registros) {
            if (!Funcoes.textoVazio(exame.getString("codigoamb"))) continue;
            StringBuilder exception = new StringBuilder();
            exception.append("C\u00f3digo amb n\u00e3o informado. \n");
            exception.append("Filial ");
            exception.append(logIntegracao.getCodigoFilial()).append(" requisi\u00e7\u00e3o ").append(logIntegracao.getCodigoRequisicao());
            exception.append(" exame ").append(exame.getString("codigoexame"));
            exception.append(" material ").append(exame.getString("mco_codigo"));
            throw new Exception(exception.toString());
        }
    }

    private EventosSumarioClinicoInformacaoClinica getInformacaoClinica(ArrayList<Registro> registros) throws Exception {
        EventosSumarioClinicoInformacaoClinica informacaoClinica = new EventosSumarioClinicoInformacaoClinica();
        informacaoClinica.setExamesLaboratorio(this.getExamesLaboratorio(registros));
        return informacaoClinica;
    }

    private EventosSumarioClinicoInformacaoClinicaExamesLaboratorio getExamesLaboratorio(ArrayList<Registro> registros) throws Exception {
        EventosSumarioClinicoInformacaoClinicaExamesLaboratorio examesLaboratorio = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorio();
        examesLaboratorio.setResultadoExamesLaboratorio(this.getResultadoExamesLaboratorio(registros));
        return examesLaboratorio;
    }

    private EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorio[] getResultadoExamesLaboratorio(ArrayList<Registro> registros) throws Exception {
        EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorio[] list = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorio[registros.size()];
        EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioDetalheAmostra[] detalhesAmostras = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioDetalheAmostra[registros.size()];
        ArquivoLaudo[] listaLaudos = new ArquivoLaudo[registros.size()];
        Integer i = 0;
        Statement st = Conexao.getStatement();
        String codigoLayoutConvenio = ExameUtil.getCodigoLayout(registros.get(0).getString("codigofilial"), registros.get(0).getString("codigoconvenio"), registros.get(0).getString("codigodestino"), st);
        for (Registro registro : registros) {
            EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorio exames = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorio();
            ElementoTerm elementoExame = new ElementoTerm();
            elementoExame.setDescricaoElemento(registro.getString("codigoexame"));
            elementoExame.setCodigoElemento(StringUtil.removeCaracteresNaoNumericos(registro.getString("codigoamb")));
            exames.setNomeExame(elementoExame);
            EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioDetalheAmostra detalheAmostra = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioDetalheAmostra();
            Calendar dataColeta = this.converterDateEmCalendar(registro.getDate("dataColeta"));
            detalheAmostra.setDataHoraColeta(dataColeta);
            detalhesAmostras[i.intValue()] = detalheAmostra;
            exames.setDetalheAmostra(detalhesAmostras);
            exames.setStatusGeralExame(new ElementoTerm("Final", "FIN"));
            Date date = new Date();
            Calendar dataHoraStatusGeralExame = Calendar.getInstance(TimeZone.getTimeZone("GMT-03:00"));
            dataHoraStatusGeralExame.setTime(date);
            exames.setDataHoraStatusGeralExame(dataHoraStatusGeralExame);
            exames.setResultadosExame(this.getResultadoExame(registro, i, codigoLayoutConvenio));
            Medico medico = new Medico();
            medico.setNomeMedico(this.medicoExecutor);
            medico.setTipoConselho(this.conselhoMedico);
            medico.setCodigoConselho(Long.valueOf(Long.parseLong(this.codigoMedico)));
            medico.setUFConselho(this.ufMedico);
            exames.setEntidadeExecutora(this.getEntidadeExecutora(registro));
            exames.setMedicoExecutor(medico);
            ArquivoLaudo laudo = new ArquivoLaudo();
            String arquivoPDF = registro.getString("codigorequisicao") + "-" + registro.getString("codigoexame") + "-" + Funcoes.formataData("dd-MM-yyyy", new Date()) + ".pdf";
            laudo.setNomeArquivo(arquivoPDF);
            String[] examesJalis = new String[]{registro.getString("codigoexame")};
            String[] materiaisJalis = new String[]{registro.getString("codigomaterial")};
            RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(null, null, registro.getString("codigofilial"), registro.getString("codigorequisicao"), true, true, null, examesJalis, materiaisJalis, true, null, true, true, null, true, "", true, false);
            laudo.setArquivo(retorno.getResultadoPdfWeb());
            laudo.setTipoArquivo("application/pdf");
            Calendar dataHoraLaudo = Calendar.getInstance(TimeZone.getTimeZone("GMT-03:00"));
            dataHoraLaudo.setTime(registro.getDate("dataconferenciaexame"));
            laudo.setDataHoraLaudo(dataHoraLaudo);
            laudo.setTamanhoArquivo(retorno.getResultadoPdfWeb().length);
            laudo.setCategoriaArquivo("LABRES");
            listaLaudos[i.intValue()] = laudo;
            exames.setLaudo(listaLaudos);
            exames.setFatores(new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioFatores());
            list[i.intValue()] = exames;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return list;
    }

    private Calendar converterDateEmCalendar(Date data) {
        if (null != data) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT-03:00"));
            c.setTime(data);
            return c;
        }
        return Calendar.getInstance();
    }

    private EntidadeSaude getEntidadeExecutora(Registro registro) {
        EntidadeSaude entidade = new EntidadeSaude();
        entidade.setNomeEntidade(StringUtil.removerAcentos(this.nomeEntidade));
        entidade.setCNES(Long.valueOf(this.cnes).longValue());
        return entidade;
    }

    private EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExame[] getResultadoExame(Registro registro, Integer i, String codigoLayoutConvenio) throws Exception {
        String xmlRelacionamentoLaudo = this.getXMLRelacionamentoLaudo(registro);
        String[] linhas = null;
        if (Funcoes.textoVazio(xmlRelacionamentoLaudo)) {
            throw new Exception("Campos de relacionamento n\u00e3o informados para o exame - " + registro.getString("codigoexame"));
        }
        linhas = StringUtil.getValores(xmlRelacionamentoLaudo, "linha");
        if (linhas.length <= 0) {
            throw new Exception("Campos de relacionamento n\u00e3o informados para o exame - " + registro.getString("codigoexame"));
        }
        Map<String, Object> mapaResultado = this.getMapaResultado(registro);
        String campo = "";
        String valorResultado = "";
        String unidadeMedida = "";
        String valorDeReferencia = "";
        int total = 0;
        for (String linha : linhas) {
            String campoResultado = StringUtil.getValor(linha, "resultado");
            valorResultado = "";
            if (!Funcoes.textoVazio(campoResultado) && mapaResultado.get(campoResultado.toLowerCase()) != null) {
                valorResultado = mapaResultado.get(campoResultado.toLowerCase()).toString();
            }
            if (Funcoes.textoVazio(valorResultado)) continue;
            ++total;
        }
        int contador = 0;
        long sequencia = 0L;
        if (total == 0) {
            throw new Exception("Campos de resultados n\u00e3o informados para o exame: " + registro.getString("codigoexame") + ", verifique o resultado do exame");
        }
        EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExame[] resultados = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExame[total];
        for (String linha : linhas) {
            String campoUnidadeMedida;
            EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExameResultadosAnalitoResultadoAnalito[] listaResultado = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExameResultadosAnalitoResultadoAnalito[1];
            EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExame resultadoExame = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExame();
            campo = StringUtil.getValor(linha, "descricao");
            String campoResultado = StringUtil.getValor(linha, "resultado");
            if (!Funcoes.textoVazio(campoResultado)) {
                valorResultado = "";
                if (mapaResultado.get(campoResultado.toLowerCase()) != null) {
                    valorResultado = mapaResultado.get(campoResultado.toLowerCase()).toString();
                }
            }
            if (Funcoes.textoVazio(campoUnidadeMedida = StringUtil.getValor(linha, "unidademedida", true))) {
                this.erros.errosProcesso.add(this.montaExcecao(new Exception(), null, "N\u00e3o h\u00e1 valor para o campo \"" + campoUnidadeMedida + "\" (configurado como campo de unidade de medida).", PROCESSO_MONTA_LINHA));
            } else {
                unidadeMedida = "";
                unidadeMedida = campoUnidadeMedida;
                if (mapaResultado.get(campoUnidadeMedida.toLowerCase()) != null) {
                    unidadeMedida = mapaResultado.get(campoUnidadeMedida.toLowerCase()).toString();
                }
            }
            resultadoExame.setSequenciaResultado(Long.valueOf(++sequencia));
            resultadoExame.setNomeAnalito(new Descricao(StringUtil.removerAcentos(campo)));
            if (!Funcoes.textoVazio(valorResultado)) {
                EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExameResultadosAnalitoResultadoAnalito resultado = new EventosSumarioClinicoInformacaoClinicaExamesLaboratorioResultadoExamesLaboratorioExamesLaboratorioResultadosExameResultadoExameResultadosAnalitoResultadoAnalito();
                valorResultado = valorResultado.replaceAll("<.*?>", "");
                resultado.setUnidadeMedida("TEXT");
                valorResultado = valorResultado + " " + (!unidadeMedida.equalsIgnoreCase("TEXT") ? unidadeMedida : "");
                resultado.setValor(valorResultado);
                listaResultado[0] = resultado;
                resultadoExame.setResultadosAnalito(listaResultado);
            }
            String campoValorReferencia = StringUtil.getValor(linha, "valorreferencia", true);
            valorDeReferencia = "";
            if (!Funcoes.textoVazio(campoValorReferencia) && mapaResultado.get(campoValorReferencia.toLowerCase()) != null) {
                valorDeReferencia = mapaResultado.get(campoValorReferencia.toLowerCase()).toString();
            }
            if (!Funcoes.textoVazio(valorDeReferencia)) {
                Descricao orientacaoIntervaloReferencia = new Descricao();
                orientacaoIntervaloReferencia.setDescricao(valorDeReferencia);
                resultadoExame.setOrientacaoIntervaloReferencia(orientacaoIntervaloReferencia);
            }
            Date dataConferenciaExame = registro.getDate("dataconferenciaexame");
            Calendar dataConferenciaExameFormatada = this.converterDateEmCalendar(dataConferenciaExame);
            resultadoExame.setDataHoraValidacao(dataConferenciaExameFormatada);
            ElementoTerm statusResultado = new ElementoTerm("Final", "FIN");
            resultadoExame.setStatusResultado(statusResultado);
            resultadoExame.setDataHoraStatusResultado(dataConferenciaExameFormatada);
            Descricao[] comentarios = new Descricao[1];
            Descricao descricao = new Descricao();
            descricao.setDescricao(registro.getString("descricaometodologia"));
            comentarios[0] = descricao;
            resultadoExame.setComentarios(comentarios);
            if (null == resultadoExame.getResultadosAnalito()) continue;
            resultados[contador] = resultadoExame;
            ++contador;
        }
        return resultados;
    }

    private Map<String, Object> getMapaResultado(Registro registro) throws IntegracaoOperadoraException {
        try {
            return Resultado.getTodosCamposResultado(registro.getString("resultado"), false);
        }
        catch (Exception e) {
            throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar os campos de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
        }
    }

    private String getXMLRelacionamentoLaudo(Registro registro) throws IntegracaoOperadoraException {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            String codigoLayoutConvenio = ExameUtil.getCodigoLayout(registro.getString("codigofilial"), registro.getString("codigoconvenio"), registro.getString("codigodestino"), st);
            String xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(registro.getString("codigofilial"), registro.getInt("idadepaciente"), registro.getString("tipoidadepaciente"), codigoLayoutConvenio, registro.getString("codigoexamepai"), registro.getInt("codigomaterialpai"), registro.getString("codigometodologia"), st);
            if (Funcoes.textoVazio(xmlLayout)) {
                String string = null;
                return string;
            }
            if (Funcoes.textoVazio(xmlLayout = StringUtil.getValor(xmlLayout, "integracaounimedpr"))) {
                String string = null;
                return string;
            }
            String string = xmlLayout;
            return string;
        }
        catch (Exception e) {
            throw this.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar o XML de associa\u00e7\u00e3o de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private EventosSumarioClinicoOrigemInformacao getOrigemInformacao(Registro registro) throws Exception {
        EventosSumarioClinicoOrigemInformacao origem = new EventosSumarioClinicoOrigemInformacao();
        origem.setEntidade(this.getEntidade(registro));
        origem.setIdentificacaoProfissional(this.getIdentificacaoProfissional(registro));
        return origem;
    }

    private EventosSumarioClinicoOrigemInformacaoIdentificacaoProfissional getIdentificacaoProfissional(Registro registro) throws Exception {
        EventosSumarioClinicoOrigemInformacaoIdentificacaoProfissional profissional = new EventosSumarioClinicoOrigemInformacaoIdentificacaoProfissional();
        profissional.setProfissionalNaoSaude(this.getProfissionalSaude(registro));
        return profissional;
    }

    private Profissional getProfissionalSaude(Registro registro) throws Exception {
        Profissional profissional = new Profissional();
        String entidade = StringUtil.removerAcentos(this.nomeEntidade);
        profissional.setAbreviatura(entidade);
        String cnpjFilial = registro.getString("cnpjfilial");
        if (Funcoes.textoVazio(cnpjFilial)) {
            throw new Exception("CNPJ n\u00e3o informado no cadastro da filial");
        }
        cnpjFilial = cnpjFilial.replaceAll("[.-/-]", "");
        profissional.setCadastroPessoaJuridica(cnpjFilial);
        profissional.setLoginProfissional(entidade);
        return profissional;
    }

    private EventosSumarioClinicoOrigemInformacaoEntidade getEntidade(Registro registro) {
        EventosSumarioClinicoOrigemInformacaoEntidade entidade = new EventosSumarioClinicoOrigemInformacaoEntidade();
        entidade.setNomeEntidade(StringUtil.removerAcentos(this.nomeEntidade));
        entidade.setCodigoEntidade(this.getCodigoEntidade(registro));
        entidade.setIdentificacaoEntidade(this.getIdentificaoEntidade(registro));
        return entidade;
    }

    private EventosSumarioClinicoOrigemInformacaoEntidadeIdentificacaoEntidade getIdentificaoEntidade(Registro registro) {
        EventosSumarioClinicoOrigemInformacaoEntidadeIdentificacaoEntidade origemEntidade = new EventosSumarioClinicoOrigemInformacaoEntidadeIdentificacaoEntidade();
        origemEntidade.setCNPJ(StringUtil.removeCaracteresNaoNumericos(registro.getString("cnpjfilial")));
        origemEntidade.setCNES(registro.getString("cnesfilial"));
        return origemEntidade;
    }

    private EventosSumarioClinicoOrigemInformacaoEntidadeCodigoEntidade getCodigoEntidade(Registro registro) {
        EventosSumarioClinicoOrigemInformacaoEntidadeCodigoEntidade codigoEntidade = new EventosSumarioClinicoOrigemInformacaoEntidadeCodigoEntidade();
        codigoEntidade.setTipo(TipoEntidade.PRESTADOR);
        codigoEntidade.setCodigo(this.codigoLaboratorio);
        return codigoEntidade;
    }

    private EventosSumarioClinicoBeneficiario getBeneficiario(Registro registro) throws Exception {
        EventosSumarioClinicoBeneficiario beneficiario = new EventosSumarioClinicoBeneficiario();
        String matricula = registro.getString("matricula");
        if (!Funcoes.textoVazio(matricula)) {
            String codigoUnimed = "";
            String codigoBeneficiario = "";
            if (matricula.length() == 17) {
                codigoUnimed = matricula.substring(0, 4);
                codigoBeneficiario = matricula.substring(4, 17);
            }
            if (matricula.length() == 13) {
                codigoUnimed = this.codigoUnimed;
                codigoBeneficiario = matricula;
            }
            beneficiario.setCodigoUnimed(codigoUnimed);
            beneficiario.setCodigoBeneficiario(codigoBeneficiario);
        }
        return beneficiario;
    }

    private ArrayList<LogIntegracaoOperadora> getLogsIntegracao(String codigoConvenio) {
        UnimedPRDao dao = new UnimedPRDao();
        return dao.getLogsIntegracao(codigoConvenio);
    }

    public void gravarExportaIntegracao(UnimedPRVO unimed) throws Exception {
        UnimedPRDao dao = new UnimedPRDao();
        dao.gravarExportaIntegracao(unimed);
    }

    private IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        } else {
            if (excecao != null) {
                buf.append(" - ").append(excecao.toString());
            }
            if (excecao instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    public boolean isUnimedPR(String codigoFilial, String codigoConvenio) throws SQLException {
        return this.dao.isUnimedPR(codigoFilial, codigoConvenio);
    }
}

