/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.pr.model;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.pr.model.UnimedPRVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class UnimedPRDao {
    public static final String TAG_EXPORTACAO_INTEGRACAO_OPERADORA = "integracaooperadora";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "nomeintegracaooperadora";
    public static final String TAG_EXPORTACAO_FILIAL = "filial";
    public static final String TAG_EXPORTACAO_CODIGO_REQUISICAO = "codreq";
    public static final String TAG_EXPORTACAO_CODIGO_EXAME = "codexa";
    public static final String TAG_EXPORTACAO_CODIGO_MATERIAL = "codmat";
    public static final String TAG_EXPORTACAO_CODIGO_PACIENTE = "codPaciente";
    private static final String PROCESSO_BUSCA_DADOS = "buscando dados";

    public void gravarExportaIntegracao(UnimedPRVO unimed) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append(" values (").append(unimed.getCodigoFilial());
        buf.append(" ,").append(unimed.getCodigoConvenio());
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(unimed.getCodigoFilial())).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(unimed.getXml().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(unimed.getTipoOperacao()).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(unimed.getCodigoRequisicao());
        buf.append(" , ").append(unimed.getCodigoPaciente());
        buf.append(" , '").append(unimed.getCodigoExame()).append("'");
        buf.append(" , ").append(unimed.getCodigoMaterial()).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(unimed.getCodigoFilial(), st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new Exception("N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LogIntegracaoOperadora> getLogsIntegracao(String codigoConvenio) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("  from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("  and con_codigo = ").append(codigoConvenio);
        buf.append("  and eio_retorno is null ");
        buf.append("  order by eio_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
            while (rs.next()) {
                listaLogs.add(this.getLogIntegracao(rs));
            }
            ArrayList<LogIntegracaoOperadora> arrayList = listaLogs;
            return arrayList;
        }
        catch (SQLException sQLException) {
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return null;
    }

    private LogIntegracaoOperadora getLogIntegracao(ResultSet rs) throws SQLException {
        Integer codigoFilial = rs.getInt("codigoFilial");
        Integer codigoLog = rs.getInt("codigoLog");
        Integer cod_convenio = rs.getInt("codigoConvenio");
        String tipoOperacao = rs.getString("tipoOperacao");
        String retorno = rs.getString("retorno");
        String situacao = rs.getString("situacao");
        String operacao = rs.getString("operacao");
        Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, TAG_EXPORTACAO_CODIGO_REQUISICAO));
        String codigoExame = StringUtil.getValor(operacao, TAG_EXPORTACAO_CODIGO_EXAME);
        Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, TAG_EXPORTACAO_CODIGO_MATERIAL));
        LogIntegracaoOperadora logIntegracaoOperadora = new LogIntegracaoOperadora();
        logIntegracaoOperadora.setCodigoFilial(codigoFilial);
        logIntegracaoOperadora.setCodigoLog(codigoLog.intValue());
        logIntegracaoOperadora.setCodigoConvenio(cod_convenio);
        logIntegracaoOperadora.setCodigoRequisicao(codigoRequisicao);
        logIntegracaoOperadora.setCodigoExame(codigoExame);
        logIntegracaoOperadora.setCodigoMaterial(codigoMaterial);
        logIntegracaoOperadora.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(tipoOperacao));
        logIntegracaoOperadora.setXmlLog(operacao);
        logIntegracaoOperadora.setRetorno(retorno);
        logIntegracaoOperadora.setSituacao(situacao);
        return logIntegracaoOperadora;
    }

    public ArrayList<Registro> getDados(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_cartaosus as carteirinha ");
        buf.append("       ,req.req_matricula as matricula ");
        buf.append("       ,req.req_validadecarteira as validadeCarteirinha ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,med.med_cpf as cpfMedico ");
        buf.append("       ,med.med_conselho as conselhoMedico ");
        buf.append("       ,med.med_uf as ufMedico ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("       ,exr.exr_ordem as sequenciaExame ");
        buf.append("       ,exr.exr_dataassina as dataConferenciaExame ");
        buf.append("       ,coalesce(exadesm.exa_codigo, exa.exa_codigo) as codigoExame ");
        buf.append("       ,coalesce(exadesm.exa_descricao, exa.exa_descricao) as descricaoExame ");
        buf.append("       ,req.req_excluida as requisicaoExcluida ");
        buf.append("       ,exr.exr_excluido as exameExcluido ");
        buf.append("       ,coalesce(cio.mco_kodigo, exr.mco_codigo) as codigoMaterial ");
        buf.append("       ,matcol.mco_descricao as descricaoMaterial ");
        buf.append("       ,exa.exa_codigo as codigoExamePai ");
        buf.append("       ,exr.mco_codigo as codigoMaterialPai ");
        buf.append("       ,exr.exr_datamaterial as dataColeta ");
        buf.append("       ,exr_codautorizacao as senhaGuia ");
        buf.append("       ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_idade as idadePaciente ");
        buf.append("       ,req.req_anomes as tipoIdadePaciente ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("       ,met.met_descricao as descricaoMetodologia ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_obs as observacao ");
        buf.append("       ,con.con_integracaooperadora as xml ");
        buf.append("       ,con.con_razao as razaoSocial ");
        buf.append("       ,el.lay_codigo as layout ");
        buf.append("       ,fil.fil_razaosocial as nomeFilial ");
        buf.append("       ,fil_descricao as descricaoFilial ");
        buf.append("       ,fil.fil_cnpj as cnpjFilial ");
        buf.append("       ,fil.fil_cnes as cnesFilial ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,dtm.dtm_codamb as codigoAmb ");
        } else {
            buf.append("      ,dtp.dtp_codamb as codigoAmb ");
        }
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and med.med_uf = req.med_uf");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("  join examelayout el on exr.fil_codigo = el.fil_codigo and exr.exa_codigo = el.exa_codigo and exr.mco_codigo = el.mco_codigo and el.ela_padrao = true ");
        buf.append("  join examelayoutmetodo elm on exr.fil_codigo = elm.fil_codigo and exr.exa_codigo = elm.exa_codigo and exr.mco_codigo = elm.mco_codigo and exr.met_codigo = elm.met_codigo and elm.lay_codigo = el.lay_codigo\t");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  join materialcoleta matcol on exr.fil_codigo = matcol.fil_codigo and exr.mco_codigo = matcol.mco_codigo ");
        buf.append("  join metodologia met on exr.fil_codigo = met.fil_codigo and exr.met_codigo = met.met_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtm.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtp.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append(" join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        buf.append("   and req.con_codigo = ").append(log.getCodigoConvenio());
        buf.append(" UNION ");
        buf.append(" select distinct req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_cartaosus as carteirinha ");
        buf.append("       ,req.req_matricula as matricula ");
        buf.append("       ,req.req_validadecarteira as validadeCarteirinha ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,med.med_cpf as cpfMedico ");
        buf.append("       ,med.med_conselho as conselhoMedico ");
        buf.append("       ,med.med_uf as ufMedico ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("       ,exr.exr_ordem as sequenciaExame ");
        buf.append("       ,exr.exr_dataassina as dataConferenciaExame ");
        buf.append("       ,coalesce(exadesm.exa_codigo, exa.exa_codigo) AS codigoExame ");
        buf.append("       ,coalesce(exadesm.exa_descricao, exa.exa_descricao) AS descricaoExame ");
        buf.append("       ,req.req_excluida as requisicaoExcluida ");
        buf.append("       ,exr.exr_excluido as exameExcluido ");
        buf.append("       ,exr.mco_codigo as codigoMaterial ");
        buf.append("       ,matcol.mco_descricao as descricaoMaterial ");
        buf.append("       ,exa.exa_codigo as codigoExamePai ");
        buf.append("       ,exr.mco_codigo as codigoMaterialPai ");
        buf.append("       ,exr.exr_datamaterial as dataColeta ");
        buf.append("       ,exr_codautorizacao as senhaGuia ");
        buf.append("       ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_idade as idadePaciente ");
        buf.append("       ,req.req_anomes as tipoIdadePaciente ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("       ,met.met_descricao as descricaoMetodologia ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_obs as observacao ");
        buf.append("       ,con.con_integracaooperadora as xml ");
        buf.append("       ,con.con_razao as razaoSocial ");
        buf.append("       ,el.lay_codigo as layout ");
        buf.append("       ,fil.fil_razaosocial as nomeFilial ");
        buf.append("       ,fil_descricao as descricaoFilial ");
        buf.append("       ,fil.fil_cnpj as cnpjFilial ");
        buf.append("       ,fil.fil_cnes as cnesFilial ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,dtm.dtm_codamb as codigoAmb ");
        } else {
            buf.append("      ,dtp.dtp_codamb as codigoAmb ");
        }
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and med.med_uf = req.med_uf");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("  join examelayout el on exr.fil_codigo = el.fil_codigo and exr.exa_codigo = el.exa_codigo and exr.mco_codigo = el.mco_codigo and el.ela_padrao = true ");
        buf.append("  join examelayoutmetodo elm on exr.fil_codigo = elm.fil_codigo and exr.exa_codigo = elm.exa_codigo and exr.mco_codigo = elm.mco_codigo and exr.met_codigo = elm.met_codigo and elm.lay_codigo = el.lay_codigo\t");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  join materialcoleta matcol on exr.fil_codigo = matcol.fil_codigo and exr.mco_codigo = matcol.mco_codigo ");
        buf.append("  join metodologia met on exr.fil_codigo = met.fil_codigo and exr.met_codigo = met.met_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtm.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtp.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append(" join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        buf.append("   and req.con_codigo = ").append(log.getCodigoConvenio());
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            ArrayList<Registro> registro = new ArrayList<Registro>();
            boolean exameConferido = true;
            while (rs.next()) {
                registro.add(new Registro(rs));
                if (!DBUtil.campoNull(rs.getString("dataConferenciaExame"))) continue;
                exameConferido = false;
            }
            if (exameConferido) {
                return registro;
            }
            return null;
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "N\u00e3o foi poss\u00edvel buscar dados para enviar \u00e0 operadora." + e.getMessage(), PROCESSO_BUSCA_DADOS, log);
        }
    }

    public boolean isUnimedPR(String codigoFilial, String codigoConvenio) throws SQLException {
        String xmlConfiguracao;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_integracaooperadora ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and con_codigo = ").append(codigoConvenio);
        ResultSet rsAux = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rsAux.next() && !Funcoes.textoVazio(xmlConfiguracao = rsAux.getString("con_integracaooperadora"))) {
            return xmlConfiguracao.contains("integracaounimedpr");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarLog(LogIntegracaoOperadora log, boolean exportado) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append(" set eio_exportado = ").append(exportado);
        buf.append(" ,eio_retorno = ").append(StringUtil.textoDBEscape(log.getRetorno()));
        buf.append(" ,eio_situacao = '").append(log.getSituacao()).append("'");
        buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
        buf.append(" and req_codigo = ").append(log.getCodigoRequisicao());
        buf.append(" and exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append(" and mco_codigo = ").append(log.getCodigoMaterial());
        buf.append(" and con_codigo = ").append(log.getCodigoConvenio());
        buf.append(" and eio_codigo = ").append(log.getCodigoLog());
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(st, buf);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sqle) {
                throw new Exception("N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage());
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }
}

