/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.pr;

import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.pr.ConfiguradorIntegracaoOperadoraPR;
import jalis.integracaooperadoras.sistemas.unimed.pr.model.UnimedPRService;
import jalis.integracaooperadoras.sistemas.unimed.pr.model.UnimedPRVO;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.util.List;

public class IntegracaoOperadoraPR
extends AbstractIntegracaoOperadora {
    private static final String HINT_EXECUTANDO = "ENVIANDO RESULTADOS AO WEBSERVICE DA OPERADORA SIMUS";
    private String xmlConfiguracao;

    public IntegracaoOperadoraPR(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_EXECUTANDO);
        List<LogIntegracaoOperadora> retorno = null;
        UnimedPRService service = new UnimedPRService();
        retorno = service.enviarResultado(String.valueOf(this.codigoConvenio), this.xmlConfiguracao);
        for (LogIntegracaoOperadora logIntegracaoOperadora : retorno) {
            if (logIntegracaoOperadora.getSituacao().equals("E")) continue;
            this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception(logIntegracaoOperadora.getRetorno()), logIntegracaoOperadora.getRetorno(), "ENVIO RESULTADO", logIntegracaoOperadora));
        }
        return this.erros;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraPR configuradorIntegracaoOperadoraPR = ConfiguradorIntegracaoOperadoraPR.novaInstancia(parent);
        configuradorIntegracaoOperadoraPR.setXML(xmlConfig);
        configuradorIntegracaoOperadoraPR.setVisible(true);
        if (configuradorIntegracaoOperadoraPR.getOK()) {
            return configuradorIntegracaoOperadoraPR.getXML();
        }
        return xmlConfig;
    }

    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        if (!IntegracaoOperadoraPR.getConvenioUtilizaIntegracaoOperadora(filial, convenio)) {
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        UnimedPRVO unimed = new UnimedPRVO();
        unimed.setCodigoFilial(filial);
        unimed.setCodigoRequisicao(codigoRequsicao);
        unimed.setCodigoPaciente(codigoPaciente);
        unimed.setCodigoExame(codigoExame);
        unimed.setCodigoMaterial(codigoMaterial);
        unimed.setCodigoConvenio(convenio);
        unimed.setXml(xml.getXML());
        unimed.setTipoOperacao(tipoOperacao);
        UnimedPRService service = new UnimedPRService();
        try {
            service.gravarExportaIntegracao(unimed);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), null);
        }
    }
}

