/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.pr;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorResultadoUnimedPR
extends AbstractDialogoOKCancelar {
    public static String TITULO = "Associando campos de resultados - Unimed PR";
    private String[] camposLaudo = null;
    public static final String TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDPR = "integracaounimedpr";
    public static final String TAG_EXAME_INTEGRACOES_LINHA_RESULTADO = "linha";
    private TTextField textDescricao = new TTextField(25);
    private JComboBox comboValorResultado = new JComboBox();
    private JComboBox comboUnidadeMedida = new JComboBox();
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelValorResultado = new JLabel("Valor do Resultado");
    private JLabel labelUnidadeMedida = new JLabel("Unidade de medida");
    private JLabel labelValorReferencia = new JLabel("Valor de refer\u00eancia");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{this.labelDescricao.getText(), this.labelValorResultado.getText(), this.labelUnidadeMedida.getText(), this.labelValorReferencia.getText()});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonResultado = new JButton();
    private JButton buttonUnidadeMedida = new JButton();
    private JComboBox comboReferencia = new JComboBox();
    private JButton buttonValorReferencia = new JButton();
    private static ExameMatCol exa;
    private static final int COLUNA_DESCRICAO = 0;
    private static final int COLUNA_VALOR_RESULTADO = 1;
    private static final int COLUNA_UNIDADE_MEDIDA = 2;
    private static final int COLUNA_VALOR_REFERENCIA = 3;
    private int linhaEdicao = -1;

    public static ConfiguradorResultadoUnimedPR novaInstancia(Window pai, String[] camposLaudo, ExameMatCol ex) {
        exa = ex;
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoUnimedPR((Dialog)pai, camposLaudo);
        }
        return new ConfiguradorResultadoUnimedPR((JFrame)pai, camposLaudo);
    }

    public ConfiguradorResultadoUnimedPR(Dialog pai, String[] camposLaudo) {
        super(pai, TITULO);
        this.camposLaudo = camposLaudo;
        this.montaTela();
    }

    public ConfiguradorResultadoUnimedPR(JFrame pai, String[] camposLaudo) {
        super((Frame)pai, TITULO);
        this.camposLaudo = camposLaudo;
        this.montaTela();
    }

    private void montaTela() {
        this.setTitle(TITULO);
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.setSize(new Dimension(670, 450));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.labelDescricao.setDisplayedMnemonic('D');
        this.getPanelCentral().add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.labelValorResultado.setLabelFor(this.comboValorResultado);
        this.labelValorResultado.setDisplayedMnemonic('V');
        this.getPanelCentral().add((Component)this.labelValorResultado, c);
        ++c.gridx;
        ++c.gridx;
        this.labelUnidadeMedida.setLabelFor(this.comboUnidadeMedida);
        this.labelUnidadeMedida.setDisplayedMnemonic('U');
        this.getPanelCentral().add((Component)this.labelUnidadeMedida, c);
        ++c.gridx;
        ++c.gridx;
        this.labelValorReferencia.setLabelFor(this.comboReferencia);
        this.labelValorReferencia.setDisplayedMnemonic('E');
        this.getPanelCentral().add((Component)this.labelValorReferencia, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textDescricao.setPreferredSize(new Dimension(200, 20));
        this.textDescricao.setMinimumSize(new Dimension(200, 20));
        this.textDescricao.setSize(new Dimension(200, 20));
        this.textDescricao.setMaximumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.comboValorResultado.setPreferredSize(new Dimension(120, 20));
        this.comboValorResultado.setMinimumSize(new Dimension(120, 20));
        this.comboValorResultado.setSize(new Dimension(120, 20));
        this.comboValorResultado.setMaximumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.comboValorResultado, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.buttonResultado.setPreferredSize(new Dimension(20, 20));
        this.buttonResultado.setMaximumSize(new Dimension(20, 20));
        this.buttonResultado.setMinimumSize(new Dimension(20, 20));
        this.buttonResultado.setSize(new Dimension(20, 20));
        this.buttonResultado.setText("");
        this.buttonResultado.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonResultado);
        this.getPanelCentral().add((Component)this.buttonResultado, c);
        ++c.gridx;
        this.comboUnidadeMedida.setPreferredSize(new Dimension(145, 20));
        this.comboUnidadeMedida.setMinimumSize(new Dimension(145, 20));
        this.comboUnidadeMedida.setMaximumSize(new Dimension(145, 20));
        this.comboUnidadeMedida.setSize(new Dimension(145, 20));
        this.comboUnidadeMedida.setEditable(true);
        this.getPanelCentral().add((Component)this.comboUnidadeMedida, c);
        ++c.gridx;
        this.buttonUnidadeMedida.setPreferredSize(new Dimension(20, 20));
        this.buttonUnidadeMedida.setMaximumSize(new Dimension(20, 20));
        this.buttonUnidadeMedida.setMinimumSize(new Dimension(20, 20));
        this.buttonUnidadeMedida.setSize(new Dimension(20, 20));
        this.buttonUnidadeMedida.setText("");
        this.buttonUnidadeMedida.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonUnidadeMedida);
        this.getPanelCentral().add((Component)this.buttonUnidadeMedida, c);
        ++c.gridx;
        this.comboReferencia.setPreferredSize(new Dimension(145, 20));
        this.comboReferencia.setMinimumSize(new Dimension(145, 20));
        this.comboReferencia.setMaximumSize(new Dimension(145, 20));
        this.comboReferencia.setSize(new Dimension(145, 20));
        this.comboReferencia.setEditable(false);
        this.getPanelCentral().add((Component)this.comboReferencia, c);
        ++c.gridx;
        this.buttonValorReferencia.setPreferredSize(new Dimension(20, 20));
        this.buttonValorReferencia.setMaximumSize(new Dimension(20, 20));
        this.buttonValorReferencia.setMinimumSize(new Dimension(20, 20));
        this.buttonValorReferencia.setSize(new Dimension(20, 20));
        this.buttonValorReferencia.setText("");
        this.buttonValorReferencia.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonValorReferencia);
        this.getPanelCentral().add((Component)this.buttonValorReferencia, c);
        ++c.gridx;
        this.buttonOK.setPreferredSize(new Dimension(30, 20));
        this.buttonOK.setMinimumSize(new Dimension(30, 20));
        this.buttonOK.setSize(new Dimension(30, 20));
        this.buttonOK.setMaximumSize(new Dimension(30, 20));
        this.buttonOK.setMargin(new Insets(1, 0, 0, 0));
        this.buttonOK.setMnemonic('K');
        this.getPanelCentral().add((Component)this.buttonOK, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)this.scroll, c);
        this.modelo.setColumnSize(new int[]{0, 120, 120, 120}, this.table);
        this.montaListeners();
        this.preencheCombosCamposLaudo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void montaListeners() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha = ConfiguradorResultadoUnimedPR.this.table.getSelectedRow();
                if (linha > -1) {
                    if (e.getKeyCode() == 32) {
                        ConfiguradorResultadoUnimedPR.this.modificaLinha(linha);
                    } else if (e.getKeyCode() == 127) {
                        ConfiguradorResultadoUnimedPR.this.removeLinha(linha);
                    }
                }
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUnimedPR.this.adicionaAssociacao();
            }
        });
        this.buttonResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUnimedPR.this.configuraCampoResultado();
            }
        });
        this.buttonUnidadeMedida.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUnimedPR.this.configuraCampoUnidadeMedida();
            }
        });
        this.buttonValorReferencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorResultadoUnimedPR.this.configuraCampoValorReferencia();
            }
        });
    }

    private void configuraCampoResultado() {
        String propriedadeCampoNomeResultado = exa.configuraAssociaCamposDeResultado();
        if (!Funcoes.textoVazio(propriedadeCampoNomeResultado)) {
            for (String campo : this.camposLaudo) {
                if (!campo.equalsIgnoreCase(propriedadeCampoNomeResultado)) continue;
                this.comboValorResultado.setSelectedItem(campo);
            }
        }
    }

    private void configuraCampoUnidadeMedida() {
        String propriedadeCampoNomeUnidade = exa.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            this.comboUnidadeMedida.setSelectedItem(campo);
        }
    }

    private void configuraCampoValorReferencia() {
        String propriedadeCampoReferencia = exa.configuraAssociaCamposDeResultado();
        if (!Funcoes.textoVazio(propriedadeCampoReferencia)) {
            for (String campo : this.camposLaudo) {
                if (!campo.equalsIgnoreCase(propriedadeCampoReferencia)) continue;
                this.comboReferencia.setSelectedItem(campo);
            }
        }
    }

    private void modificaLinha(int linha) {
        this.linhaEdicao = linha;
        this.textDescricao.setText(this.modelo.getValueAt(linha, 0).toString());
        this.comboValorResultado.setSelectedItem(this.modelo.getValueAt(linha, 1));
        this.comboUnidadeMedida.setSelectedItem(this.modelo.getValueAt(linha, 2));
        this.comboReferencia.setSelectedItem(this.modelo.getValueAt(linha, 3));
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDPR);
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                xml.abrir(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
                xml.escrever("descricao", this.modelo.getValueAt(i, 0).toString());
                Object aux = this.modelo.getValueAt(i, 2);
                if (aux != null) {
                    xml.escrever("unidademedida", aux.toString());
                }
                if ((aux = this.modelo.getValueAt(i, 1)) != null) {
                    xml.escrever("resultado", aux.toString());
                }
                if ((aux = this.modelo.getValueAt(i, 3)) != null) {
                    xml.escrever("valorreferencia", aux.toString());
                }
                xml.fechar(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
            }
            xml.fechar(TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDPR);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar o XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    private void preencheCombosCamposLaudo() {
        if (this.camposLaudo == null) {
            return;
        }
        this.comboUnidadeMedida.addItem("");
        this.comboValorResultado.addItem("");
        this.comboReferencia.addItem("");
        for (String campo : this.camposLaudo) {
            this.comboUnidadeMedida.addItem(campo);
            this.comboValorResultado.addItem(campo);
            this.comboReferencia.addItem(campo);
        }
    }

    public void setXML(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        String[] linhas = StringUtil.getValores(xml, TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
        if (linhas != null) {
            for (String linha : linhas) {
                String descricao = StringUtil.getValor(linha, "descricao");
                String resultado = StringUtil.getValor(linha, "resultado");
                String unidadeMedida = StringUtil.getValor(linha, "unidademedida");
                String valorReferencia = StringUtil.getValor(linha, "valorreferencia");
                this.modelo.addLine(new Object[]{descricao, resultado, unidadeMedida, valorReferencia});
            }
        }
    }

    private void adicionaAssociacao() {
        if (this.validaCamposAdicao()) {
            if (this.linhaEdicao > -1) {
                this.modelo.setValueAt(this.textDescricao.getText(), this.linhaEdicao, 0);
                this.modelo.setValueAt(this.comboUnidadeMedida.getSelectedItem() == null ? null : this.comboUnidadeMedida.getSelectedItem().toString(), this.linhaEdicao, 2);
                this.modelo.setValueAt(this.comboValorResultado.getSelectedItem() == null ? null : this.comboValorResultado.getSelectedItem().toString(), this.linhaEdicao, 1);
                this.modelo.setValueAt(this.comboReferencia.getSelectedItem() == null ? null : this.comboReferencia.getSelectedItem().toString(), this.linhaEdicao, 3);
            } else {
                boolean jaExiste = false;
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(this.textDescricao.getText())) continue;
                    this.modelo.setValueAt(this.comboUnidadeMedida.getSelectedItem().toString(), i, 2);
                    this.modelo.setValueAt(this.comboValorResultado.getSelectedItem().toString(), i, 1);
                    this.modelo.setValueAt(this.comboReferencia.getSelectedItem().toString(), i, 3);
                    jaExiste = true;
                }
                if (!jaExiste) {
                    this.modelo.addLine(new Object[]{this.textDescricao.getText(), this.comboValorResultado.getSelectedItem() == null ? null : this.comboValorResultado.getSelectedItem().toString(), this.comboUnidadeMedida.getSelectedItem() == null ? null : this.comboUnidadeMedida.getSelectedItem().toString(), this.comboReferencia.getSelectedItem() == null ? null : this.comboReferencia.getSelectedItem().toString()});
                }
            }
            this.textDescricao.clear();
            this.comboValorResultado.setSelectedItem("");
            this.comboUnidadeMedida.setSelectedItem("");
            this.comboReferencia.setSelectedItem("");
            ScreenUtil.requisitarFoco(this.textDescricao);
        }
    }

    private void removeLinha(int linha) {
        int resposta = Funcoes.mensagem(this, "Deseja remover a linha de associa\u00e7\u00e3o?", 4, true);
        if (resposta == 0) {
            this.modelo.removeLine(linha);
        }
    }

    private boolean validaCamposAdicao() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.comboValorResultado.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "O valor do resultado deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.comboValorResultado);
            return false;
        }
        if (Funcoes.textoVazio(this.comboUnidadeMedida.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "A unidade de medida deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.comboUnidadeMedida);
            return false;
        }
        return true;
    }
}

