/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.pr;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraPR
extends AbstractDialogoOKCancelar {
    private static String TITULO = "Configurando integra\u00e7\u00e3o Unimed PR";
    public static final String TAG_INTEGRACAO_USUARIO = "usuario";
    public static final String TAG_INTEGRACAO_SENHA = "senha";
    public static final String TAG_INTEGRACAO_ENDERECO = "enderecoWebService";
    public static final String TAG_CODIGO_UNIMED = "codigoUnimed";
    public static final String TAG_CODIGO_LABORATORIO = "codigoLaboratorio";
    public static final String TAG_CODIGO_MEDICO = "codigoMedico";
    public static final String TAG_CODIGO_CNES = "cnes";
    public static final String TAG_NOME_MEDICO = "nomeMedico";
    public static final String TAG_CONSELHO_MEDICO = "conselhoMedico";
    public static final String TAG_UF_MEDICO = "ufMedico";
    public static final String TAG_NOME_ENTIDADE = "nomeEntidade";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelWebService = new JLabel("Web Service:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelCodigo = new JLabel("C\u00f3digo Unimed:");
    private JLabel labelCnes = new JLabel("C\u00f3digo CNES:");
    private JLabel labelCodigoLab = new JLabel("C\u00f3digo do laborat\u00f3rio:");
    private JLabel labelMedico = new JLabel("M\u00e9dico executor:");
    private JLabel labelVMedico = new JLabel();
    private JLabel labelNomeEntidade = new JLabel("Nome entidade");
    private JLabel labelVEstacao = new JLabel();
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtMedico = new TTextField(10, 1);
    private TTextField txtUsuario = new TTextField(310);
    private TTextField txtSenha = new TTextField(310);
    private TTextField txtWebService = new TTextField(310);
    private TTextField txtCodUnimed = new TTextField(4, 1);
    private TTextField txtCodLab = new TTextField(4, 1);
    private TTextField txtCnes = new TTextField(10, 1);
    private TTextField txtNomeEntidade = new TTextField(32, 3);
    private JButton buttonEstacao = new JButton();
    private JButton buttonMedico = new JButton();
    private JComboBox comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private JComboBox comboMedico = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private JPanel panelCentral = new JPanel();

    public static ConfiguradorIntegracaoOperadoraPR novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraPR((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraPR((Frame)pai);
    }

    public ConfiguradorIntegracaoOperadoraPR(Dialog pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraPR(Frame pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(490, 295));
        this.setLayout(new BorderLayout());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.panelCentral.setLayout(new GridBagLayout());
        ScreenUtil.centralizar(this);
        this.montaListeners();
        Dimension d2 = new Dimension(345, 20);
        Dimension db = new Dimension(20, 20);
        Dimension dc = new Dimension(70, 20);
        Dimension d3 = new Dimension(125, 20);
        this.labelCodigoLab.setPreferredSize(d3);
        this.labelCodigoLab.setMaximumSize(d3);
        this.labelCodigoLab.setSize(d3);
        this.labelCodigoLab.setMinimumSize(d3);
        this.labelCodigo.setPreferredSize(d3);
        this.labelCodigo.setMaximumSize(d3);
        this.labelCodigo.setMinimumSize(d3);
        this.labelCnes.setMinimumSize(d3);
        this.labelCnes.setPreferredSize(d3);
        this.labelCnes.setMaximumSize(d3);
        this.labelCnes.setSize(d3);
        this.labelNomeEntidade.setMinimumSize(d3);
        this.labelNomeEntidade.setPreferredSize(d3);
        this.labelNomeEntidade.setMaximumSize(d3);
        this.labelNomeEntidade.setSize(d3);
        this.labelWebService.setMinimumSize(d3);
        this.labelWebService.setPreferredSize(d3);
        this.labelWebService.setMaximumSize(d3);
        this.labelWebService.setSize(d3);
        this.labelEstacao.setSize(d3);
        this.labelEstacao.setMinimumSize(d3);
        this.labelEstacao.setPreferredSize(d3);
        this.labelEstacao.setMaximumSize(d3);
        this.labelMedico.setSize(d3);
        this.labelMedico.setMinimumSize(d3);
        this.labelMedico.setPreferredSize(d3);
        this.labelMedico.setMaximumSize(d3);
        this.labelSenha.setSize(d3);
        this.labelSenha.setMinimumSize(d3);
        this.labelSenha.setPreferredSize(d3);
        this.labelSenha.setMaximumSize(d3);
        this.labelUsuario.setSize(d3);
        this.labelUsuario.setMinimumSize(d3);
        this.labelUsuario.setPreferredSize(d3);
        this.labelUsuario.setMaximumSize(d3);
        this.txtEstacao.setPreferredSize(dc);
        this.txtEstacao.setMinimumSize(dc);
        this.txtEstacao.setSize(dc);
        this.txtWebService.setPreferredSize(d2);
        this.txtWebService.setMinimumSize(d2);
        this.txtWebService.setSize(d2);
        this.txtUsuario.setPreferredSize(d2);
        this.txtUsuario.setMinimumSize(d2);
        this.txtUsuario.setSize(d2);
        this.txtSenha.setPreferredSize(d2);
        this.txtSenha.setMinimumSize(d2);
        this.txtSenha.setSize(d2);
        this.txtCodLab.setSize(d2);
        this.txtCodLab.setMinimumSize(d2);
        this.txtCodLab.setPreferredSize(d2);
        this.txtCodUnimed.setSize(d2);
        this.txtCodUnimed.setMinimumSize(d2);
        this.txtCodUnimed.setPreferredSize(d2);
        this.txtCnes.setSize(d2);
        this.txtCnes.setMinimumSize(d2);
        this.txtCnes.setPreferredSize(d2);
        this.txtNomeEntidade.setSize(d2);
        this.txtNomeEntidade.setMinimumSize(d2);
        this.txtNomeEntidade.setPreferredSize(d2);
        this.buttonEstacao.setPreferredSize(db);
        this.buttonEstacao.setMinimumSize(db);
        this.buttonEstacao.setFocusable(false);
        this.comboMedico.setMinimumSize(dc);
        this.comboMedico.setSize(dc);
        this.comboMedico.setPreferredSize(dc);
        this.comboConselho.setMinimumSize(dc);
        this.comboConselho.setSize(dc);
        this.comboConselho.setPreferredSize(dc);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVEstacao.setPreferredSize(new Dimension(253, 20));
        this.labelVEstacao.setMinimumSize(new Dimension(253, 20));
        this.labelVEstacao.setSize(new Dimension(253, 20));
        this.labelVMedico.setSize(new Dimension(140, 20));
        this.labelVMedico.setMinimumSize(new Dimension(140, 20));
        this.labelVMedico.setPreferredSize(new Dimension(140, 20));
        this.txtMedico.setSize(new Dimension(40, 20));
        this.txtMedico.setMinimumSize(new Dimension(40, 20));
        this.txtMedico.setPreferredSize(new Dimension(40, 20));
        this.buttonMedico.setSize(new Dimension(20, 20));
        this.buttonMedico.setPreferredSize(new Dimension(20, 20));
        this.buttonMedico.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonMedico);
        this.comboMedico.addActionListener(this);
        ScreenUtil.setBorda(new Component[]{this.labelVEstacao, this.labelVMedico}, new TitledBorder(""));
        Integer gridWidth = 7;
        Integer gridWidthI = 1;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = gridWidthI;
        c.gridheight = 1;
        c.insets = new Insets(0, 1, 1, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.panelCentral.add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.gridwidth = 5;
        this.panelCentral.add((Component)this.labelVEstacao, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelWebService, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtWebService, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtUsuario, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelSenha, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtSenha, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtCodUnimed, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelCodigoLab, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtCodLab, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelCnes, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtCnes, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelNomeEntidade, c);
        ++c.gridx;
        c.gridwidth = gridWidth;
        this.panelCentral.add((Component)this.txtNomeEntidade, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = gridWidthI;
        this.panelCentral.add((Component)this.labelMedico, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.comboConselho, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelCentral.add((Component)this.txtMedico, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelCentral.add((Component)this.comboMedico, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.buttonMedico, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.labelVMedico, c);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraPR.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraPR.this.pesquisaEstacao();
                } else if (e.getSource() == ConfiguradorIntegracaoOperadoraPR.this.txtMedico) {
                    ConfiguradorIntegracaoOperadoraPR.this.buscaMedico();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraPR.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraPR.this.buscaEstacao(ConfiguradorIntegracaoOperadoraPR.this.txtEstacao.getText());
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraPR.this.comboMedico) {
                    ConfiguradorIntegracaoOperadoraPR.this.validaMedico();
                }
            }
        };
        this.txtMedico.addKeyListener(keyAdapter);
        this.txtMedico.addFocusListener(focusAdapter);
        this.comboMedico.addFocusListener(focusAdapter);
        this.txtEstacao.addKeyListener(keyAdapter);
        this.txtEstacao.addFocusListener(focusAdapter);
        this.buttonMedico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorIntegracaoOperadoraPR.this.buscaMedico();
            }
        });
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraPR.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraPR.this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraPR.this.labelVEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraPR.this.txtEstacao.clear();
                    ConfiguradorIntegracaoOperadoraPR.this.labelVEstacao.setText("");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(ConfiguradorIntegracaoOperadoraPR.this.txtEstacao);
            }
        });
    }

    private void buscaMedico() {
        ScreenUtil.requisitarFoco(this.txtMedico);
        Hashtable resultado = Pesquisas.medico(this, true);
        if (resultado != null) {
            this.comboConselho.setSelectedItem(resultado.get("med_conselho").toString());
            this.txtMedico.setText(resultado.get("med_crm").toString());
            this.comboMedico.setSelectedItem(resultado.get("med_uf").toString());
            this.labelVMedico.setText(resultado.get("med_nome").toString());
            ScreenUtil.requisitarFoco(this.txtMedico);
        }
    }

    private void validaMedico() {
        if (!Funcoes.textoVazio(this.txtMedico)) {
            Statement st = Conexao.getStatement();
            this.labelVMedico.setText("");
            if (st != null) {
                try {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select med_nome ");
                    buf.append("   from medico ");
                    buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and med_conselho = '").append(this.comboConselho.getSelectedItem()).append("' ");
                    buf.append("    and upper(med_crm) = upper('").append(this.txtMedico.getTextDB()).append("') ");
                    buf.append("    and med_uf = '").append(this.comboMedico.getSelectedItem()).append("' ");
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    this.labelVMedico.setText("N\u00e3o cadastrado");
                    if (rs.next()) {
                        this.labelVMedico.setText(rs.getString("med_nome"));
                    }
                    rs.close();
                }
                catch (SQLException sqlex) {
                    ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace());
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisaEstacao() {
        this.txtEstacao.clear();
        this.labelVEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVEstacao.setText(estacaoVO.getDescricao());
        }
    }

    public static boolean isPR(String xml) {
        return StringUtil.getValor(xml, "protocolo").trim().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR.getDescricao().trim());
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora")) && ConfiguradorIntegracaoOperadoraPR.isPR(xml)) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_SENHA))) {
                this.txtSenha.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_USUARIO))) {
                this.txtUsuario.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_ENDERECO))) {
                this.txtWebService.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_ENDERECO))) {
                this.txtWebService.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_CODIGO_LABORATORIO))) {
                this.txtCodLab.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_CODIGO_UNIMED))) {
                this.txtCodUnimed.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_CODIGO_MEDICO))) {
                this.txtMedico.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_CODIGO_CNES))) {
                this.txtCnes.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_NOME_ENTIDADE))) {
                this.txtNomeEntidade.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_NOME_MEDICO))) {
                this.labelVMedico.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_CONSELHO_MEDICO))) {
                this.comboConselho.setSelectedItem(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_UF_MEDICO))) {
                this.comboMedico.setSelectedItem(aux);
            }
            this.validaMedico();
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.abrir("integracaounimedpr");
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR.getDescricao());
            xml.escrever("estacao", this.txtEstacao.getText());
            xml.escrever(TAG_INTEGRACAO_USUARIO, this.txtUsuario.getText().trim());
            xml.escrever(TAG_INTEGRACAO_SENHA, this.txtSenha.getText().trim());
            xml.escrever(TAG_INTEGRACAO_ENDERECO, this.txtWebService.getText().trim());
            xml.escrever(TAG_CODIGO_LABORATORIO, this.txtCodLab.getText().trim());
            xml.escrever(TAG_CODIGO_UNIMED, this.txtCodUnimed.getText().trim());
            xml.escrever(TAG_CODIGO_CNES, this.txtCnes.getText().trim());
            xml.escrever(TAG_NOME_ENTIDADE, this.txtNomeEntidade.getText().trim());
            xml.escrever(TAG_CODIGO_MEDICO, this.txtMedico.getText().trim());
            xml.escrever(TAG_NOME_MEDICO, this.labelVMedico.getText());
            xml.escrever(TAG_UF_MEDICO, this.comboMedico.getSelectedItem().toString());
            xml.escrever(TAG_CONSELHO_MEDICO, this.comboConselho.getSelectedItem().toString());
            xml.fechar("integracaounimedpr");
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.txtEstacao) || this.labelVEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtUsuario)) {
            Funcoes.mensagem(this, "O usu\u00e1rio da operadora de sa\u00fade deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSenha)) {
            Funcoes.mensagem(this, "A senha da operadora de sa\u00fade deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.txtWebService)) {
            Funcoes.mensagem(this, "O endere\u00e7o do Web Service deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtWebService);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodLab)) {
            Funcoes.mensagem(this, "O c\u00f3digo do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCodLab);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodUnimed)) {
            Funcoes.mensagem(this, "O c\u00f3digo da unimed deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCodUnimed);
            return false;
        }
        if (this.txtCodUnimed.getText().length() < 4) {
            Funcoes.mensagem(this, "O c\u00f3digo da unimed deve conter 4 dig\u00edtos.", 2);
            ScreenUtil.requisitarFoco(this.txtCodUnimed);
            return false;
        }
        if (this.txtCodLab.getText().length() < 4) {
            Funcoes.mensagem(this, "O c\u00f3digo do laborat\u00f3rio deve conter 4 dig\u00edtos.", 2);
            ScreenUtil.requisitarFoco(this.txtCodLab);
            return false;
        }
        if (Funcoes.textoVazio(this.txtMedico)) {
            Funcoes.mensagem(this, "O m\u00e9dico deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtMedico);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCnes)) {
            Funcoes.mensagem(this, "O c\u00f3digo CNES deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCnes);
            return false;
        }
        if (Funcoes.textoVazio(this.txtNomeEntidade)) {
            Funcoes.mensagem(this, "O nome da entidade deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtNomeEntidade);
            return false;
        }
        return true;
    }
}

