/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.ibitinga;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.ibitinga.ConfiguradorIntegracaoOperadoraUnimedIbitinga;
import jalis.integracaooperadoras.sistemas.unimed.ibitinga.ConfiguradorResultadoIbitinga;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.FtpUtil;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class IntegracaoOperadoraUnimedIbitinga
extends AbstractIntegracaoOperadora {
    private String xmlConfiguracao;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String VERSAO_XML = "1.0";
    private static final String ENCODING_XML = "ISO-8859-1";
    private static final String TAG_LOCAL_PASTA = "pastaLocal";
    private static final String TAG_FTP_PASTA = "pastaFtp";
    private static final String TAG_LOGIN = "login";
    private static final String TAG_SENHA = "senha";
    private static final String TAG_FTP = "enderecoFtp";
    private static final String TAG_CODIGO_LABORATORIO = "laboratorio";
    public static final String TAG_UNIMED_IBITINGA_RESULTADO = "resultado";
    public static final String TAG_UNIMED_IBITINGA_LABORATORIO = "laboratorio";
    public static final String TAG_UNIMED_IBITINGA_DATA = "data";
    public static final String TAG_UNIMED_IBITINGA_GUIA = "guia";
    public static final String TAG_UNIMED_IBITINGA_SENHA = "senha";
    public static final String TAG_UNIMED_IBITINGA_CARTAO = "cartao";
    public static final String TAG_UNIMED_IBITINGA_BENEFICIARIO = "beneficiario";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTOS = "procedimentos";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO = "procedimento";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO_CODIGO = "codigo";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO_DESCRICAO = "descricao";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO_LAUDO = "laudo";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO_CAMPO = "campo";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO_VALOR = "valor";
    public static final String TAG_UNIMED_IBITINGA_PROCEDIMENTO_UNIDADE = "unidade";
    private static final String HINT_EXECUTANDO = "CONECTADO COM O FTP DO UNIMED IBITINGA";
    private static final String HINT_PARADO = "SEM CONEX\u00c3O COM FTP DA UNIMED IBITINGA";
    private static final String HINT_GERANDO = "GERANDO ARQUIVOS PARA ENVIAR";
    private static final String HINT_ENVIANDO = "ENVIANDO ARQUIVOS";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_MONTA_LINHA = "montando linha de resultado";
    private String codigoLoginConfiguracao = null;
    private String senhaLoginConfiguracao = null;
    private String codigoLaboratorioConfiguracao = null;
    private String enderecoFtp = null;
    private String pastaFtp = null;
    private String pastaLocal = null;

    public IntegracaoOperadoraUnimedIbitinga(String xml, int codigoConvenio) {
        this.xmlConfiguracao = xml;
        this.codigoConvenio = codigoConvenio;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            this.codigoLoginConfiguracao = StringUtil.getValor(xml, TAG_LOGIN);
            this.senhaLoginConfiguracao = StringUtil.getValor(xml, "senha");
            this.codigoLaboratorioConfiguracao = StringUtil.getValor(xml, "codigoLaboratorio");
            this.enderecoFtp = StringUtil.getValor(xml, TAG_FTP);
            this.pastaFtp = StringUtil.getValor(xml, TAG_FTP_PASTA);
            this.pastaLocal = StringUtil.getValor(xml, TAG_LOCAL_PASTA) + File.separatorChar;
        }
    }

    private static XMLStringBuilder geraXmlResultado(String codigoRequisicao, String codigoExame, String codigoMaterial, DadosErrosIntegracaoOperadora erros) throws IntegracaoOperadoraException {
        XMLStringBuilder xml = new XMLStringBuilder();
        StringBuilder bui = new StringBuilder();
        bui.append("select ");
        bui.append("con.con_integracaooperadora as xml,");
        bui.append("exr.exr_data as data,");
        bui.append("COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guia,");
        bui.append("exr.exr_codautorizacao as senha,");
        bui.append("req.req_matricula as cartao,");
        bui.append("pac.pac_nome as beneficiario,");
        bui.append("dtp.dtp_codamb as codigo,");
        bui.append("exa.exa_descricao as descricao,");
        bui.append("ert.ert_resultado as resultado,");
        bui.append("req.req_codigo as requisicao,");
        bui.append("exr.exa_codigo as codigoexame,");
        bui.append("exr.mco_codigo as material, ");
        bui.append("exr_integracaohospital as xmlIbitinga,");
        bui.append("exr.met_codigo as codigoMetodologia,");
        bui.append("req.req_idade as idadePaciente, ");
        bui.append("ert.fil_codigo as codigoFilial, ");
        bui.append("req.con_codigo as codigoConvenio, ");
        bui.append("req.des_codigo as codigoDestino, ");
        bui.append("req.req_anomes as tipoIdadePaciente ");
        bui.append("from examerequisicaoresultado ert ");
        bui.append("left join requisicao req on req.fil_codigo = ert.fil_codigo and ert.req_codigo = req.req_codigo ");
        bui.append("left join examerequisicao exr on exr.fil_codigo = ert.fil_codigo and ert.req_codigo = exr.req_codigo and exr.exa_codigo = ert.exa_codigo and ert.mco_codigo = exr.mco_codigo ");
        bui.append("left join exames exa on exa.fil_codigo = ert.fil_codigo and   exa.exa_codigo = ert.exa_codigo ");
        bui.append("left join convenios con on exa.fil_codigo = con.fil_codigo and con.con_codigo = req.con_codigo ");
        bui.append("left join tabelaprecoexames tpe on tpe.fil_codigo = con.fil_codigo and con.tpe_codigo = tpe.tpe_codigo ");
        bui.append("left join detalhetabelapreco dtp on tpe.fil_codigo = dtp.fil_codigo and dtp.tpe_codigo = tpe.tpe_codigo and ert.exa_codigo = dtp.exa_codigo and ert.mco_codigo = dtp.mco_codigo ");
        bui.append("left join paciente pac on pac.fil_codigo = ert.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        bui.append(" where ert.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" and ert.req_codigo = ").append(codigoRequisicao);
        bui.append(" and ert.mco_codigo = ").append(codigoMaterial);
        bui.append(" and ert.exa_codigo = '").append(codigoExame).append("'");
        Statement stResultado = ConexaoTemporaria.getStatement();
        ArrayList<String> examesSemRelacionamento = new ArrayList<String>();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(stResultado, bui);
            if (rs.next() && !Funcoes.textoVazio(rs.getString(TAG_UNIMED_IBITINGA_RESULTADO))) {
                Map<String, Object> mapaResultado = IntegracaoOperadoraUnimedIbitinga.getMapaResultado(rs);
                if (mapaResultado == null || mapaResultado.size() == 0) {
                    erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "Requisi\u00e7\u00e3o: " + rs.getString("requisicao") + " N\u00e3o h\u00e1 campos no resultado do exame: " + rs.getString("codigoexame") + ", material: " + rs.getString("material"), PROCESSO_MONTA_LINHA));
                }
                String xmlRelacionamentoLaudo = "";
                String[] linhas = null;
                if (IntegracaoOperadoraUnimedIbitinga.getXMLRelacionamentoLaudo(rs) == null) {
                    examesSemRelacionamento.add("Exame sem relacionamento de campos: " + rs.getString("codigoexame") + "- Material: " + rs.getString("material"));
                } else {
                    xmlRelacionamentoLaudo = IntegracaoOperadoraUnimedIbitinga.getXMLRelacionamentoLaudo(rs);
                    linhas = StringUtil.getValores(xmlRelacionamentoLaudo, "linha");
                    String campo = "";
                    String valorResultado = "";
                    String unidadeMedida = "";
                    xml.abrir(TAG_UNIMED_IBITINGA_RESULTADO);
                    xml.escreveHeader(VERSAO_XML, ENCODING_XML);
                    xml.escrever("laboratorio", StringUtil.getValor(rs.getString("xml"), "codigoLaboratorio"));
                    xml.escrever(TAG_UNIMED_IBITINGA_DATA, Funcoes.formataData("yyyyMMddHHmmss", rs.getTimestamp(TAG_UNIMED_IBITINGA_DATA)));
                    xml.escrever(TAG_UNIMED_IBITINGA_GUIA, rs.getString(TAG_UNIMED_IBITINGA_GUIA).replaceAll("[^a-zZ-Z0-9 ]", "").trim());
                    xml.escreverCData("senha", rs.getString("senha"));
                    xml.escrever(TAG_UNIMED_IBITINGA_CARTAO, rs.getString(TAG_UNIMED_IBITINGA_CARTAO).replaceAll("[^a-zZ-Z0-9]", "").trim());
                    xml.escreverCData(TAG_UNIMED_IBITINGA_BENEFICIARIO, rs.getString(TAG_UNIMED_IBITINGA_BENEFICIARIO));
                    xml.abrir(TAG_UNIMED_IBITINGA_PROCEDIMENTO);
                    xml.escrever(TAG_UNIMED_IBITINGA_PROCEDIMENTO_CODIGO, rs.getString(TAG_UNIMED_IBITINGA_PROCEDIMENTO_CODIGO).replaceAll("[^a-zZ-Z0-9]", "").trim());
                    xml.escreverCData(TAG_UNIMED_IBITINGA_PROCEDIMENTO_DESCRICAO, rs.getString(TAG_UNIMED_IBITINGA_PROCEDIMENTO_DESCRICAO));
                    for (String linha : linhas) {
                        String campoUnidadeMedida;
                        campo = StringUtil.getValor(linha, ConfiguradorResultadoIbitinga.CamposResultado.DESCRICAO.getTag());
                        String campoResultado = StringUtil.getValor(linha, ConfiguradorResultadoIbitinga.CamposResultado.RESULTADO.getTag());
                        if (!Funcoes.textoVazio(campoResultado)) {
                            if (mapaResultado != null && mapaResultado.get(campoResultado.toLowerCase()) == null) {
                                erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "Requisi\u00e7\u00e3o: " + rs.getString("requisicao") + ", n\u00e3o h\u00e1 valor para o campo \"" + campoResultado + "\" (configurado como campo de resultado) no exame: " + rs.getString("codigoexame") + ", material: " + rs.getString("material"), PROCESSO_MONTA_LINHA));
                            } else {
                                valorResultado = mapaResultado.get(campoResultado.toLowerCase()).toString();
                            }
                        }
                        if (!Funcoes.textoVazio(campoUnidadeMedida = StringUtil.getValor(linha, ConfiguradorResultadoIbitinga.CamposResultado.UNID_MEDIDA.getTag()))) {
                            if (campoUnidadeMedida == null) {
                                erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "N\u00e3o h\u00e1 valor para o campo \"" + campoUnidadeMedida + "\" (configurado como campo de unidade de medida).", PROCESSO_MONTA_LINHA));
                            } else {
                                unidadeMedida = mapaResultado != null && mapaResultado.get(campoUnidadeMedida.toLowerCase()) != null ? mapaResultado.get(campoUnidadeMedida.toLowerCase()).toString() : campoUnidadeMedida;
                            }
                        }
                        xml.escreverCData(TAG_UNIMED_IBITINGA_PROCEDIMENTO_CAMPO, campo);
                        xml.escreverCData(TAG_UNIMED_IBITINGA_PROCEDIMENTO_VALOR, valorResultado);
                        xml.escreverCData(TAG_UNIMED_IBITINGA_PROCEDIMENTO_UNIDADE, unidadeMedida);
                    }
                    String resultadoHTML = Resultado.getResultadoHTML(rs.getString(TAG_UNIMED_IBITINGA_RESULTADO), null, rs.getString("requisicao"), rs.getString("codigoexame"), rs.getString("material"), "", true, 0, 0, false).get(TAG_UNIMED_IBITINGA_PROCEDIMENTO_LAUDO).toString();
                    xml.escreverCData(TAG_UNIMED_IBITINGA_PROCEDIMENTO_LAUDO, resultadoHTML);
                    xml.fechar(TAG_UNIMED_IBITINGA_PROCEDIMENTO);
                    xml.fechar(TAG_UNIMED_IBITINGA_RESULTADO);
                }
            }
            if (!examesSemRelacionamento.isEmpty()) {
                erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "Exame sem relacionamento de campos: " + rs.getString("codigoexame") + "- Material: " + rs.getString("material"), PROCESSO_MONTA_LINHA));
            }
        }
        catch (SQLException e2) {
            erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(e2, null, "", PROCESSO_MONTA_LINHA));
        }
        catch (XMLStringBuilderException e) {
            erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(e, null, "", PROCESSO_MONTA_LINHA));
        }
        return xml;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    private static String getXMLRelacionamentoLaudo(ResultSet rs) throws IntegracaoOperadoraException {
        String string;
        String xmlLayout;
        Statement st;
        block7: {
            block6: {
                st = Conexao.getStatement();
                String codigoLayoutConvenio = ExameUtil.getCodigoLayout(rs.getString("codigoFilial"), rs.getString("codigoConvenio"), rs.getString("codigoDestino"), st);
                xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(rs.getString("codigoFilial"), rs.getInt("idadePaciente"), rs.getString("tipoIdadePaciente"), codigoLayoutConvenio, rs.getString("codigoExame"), rs.getInt("material"), rs.getString("codigoMetodologia"), st);
                if (!Funcoes.textoVazio(xmlLayout)) break block6;
                String string2 = null;
                Conexao.fecharStatement(st);
                return string2;
            }
            xmlLayout = StringUtil.getValor(xmlLayout, "integracaoibitinga");
            if (!Funcoes.textoVazio(xmlLayout)) break block7;
            String string3 = null;
            Conexao.fecharStatement(st);
            return string3;
        }
        try {
            string = xmlLayout;
        }
        catch (Exception e) {
            try {
                throw IntegracaoOperadoraUnimedIbitinga.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar o XML de associa\u00e7\u00e3o de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private static Map<String, Object> getMapaResultado(ResultSet rs) throws IntegracaoOperadoraException {
        try {
            return Resultado.getTodosCamposResultado(rs.getString(TAG_UNIMED_IBITINGA_RESULTADO), false);
        }
        catch (Exception e) {
            throw IntegracaoOperadoraUnimedIbitinga.montaExcecao(e, null, "N\u00e3o foi poss\u00edvel buscar os campos de resultado.\n" + e.getMessage(), PROCESSO_MONTA_LINHA);
        }
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraUnimedIbitinga janelaConfiguracao = ConfiguradorIntegracaoOperadoraUnimedIbitinga.novaInstancia(parent);
        janelaConfiguracao.setXML(xmlConfig);
        janelaConfiguracao.setVisible(true);
        if (janelaConfiguracao.getOK()) {
            return janelaConfiguracao.getXML();
        }
        return xmlConfig;
    }

    @Override
    public String getNomeIntegracaoOperadora() {
        return FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IBI.getDescricao();
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        int erro = 0;
        String mensagem = "";
        try {
            mensagem = this.integrarDados();
            if (!Funcoes.textoVazio(mensagem)) {
                this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "N\u00e3o foi possivel conectar ao Ftp da Unimed Ibitinga. ERRO: (" + mensagem + ")", ""));
            }
        }
        catch (Exception e) {
            Laboratorio.setIconeIntegracaoOperadora(this, ICONE_PARADO);
            Laboratorio.setHintIntegracaoOperadora(this, HINT_PARADO);
            if (Funcoes.isNumeric(mensagem)) {
                erro = Integer.parseInt(mensagem);
            }
            switch (erro) {
                case 421: {
                    this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "N\u00e3o foi possivel conectar ao Ftp da Unimed Ibitinga.", ""));
                    break;
                }
                case 452: {
                    this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "Espa\u00e7o insuficiente no servidor. Entre em contato com a Unimed Ibitinga.", ""));
                    break;
                }
                case 530: {
                    this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "Usu\u00e1rio ou senha do FTP est\u00e3o incorretos.", ""));
                    break;
                }
                case 532: {
                    this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "Laborat\u00f3rio n\u00e3o autorizado para enviar arquivo. Entre em contato com a Unimed Ibitinga.", ""));
                    break;
                }
                default: {
                    this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "N\u00e3o foi possivel conectar ao Ftp da Unimed Ibitinga. ERRO: (" + erro + ")", mensagem));
                }
            }
            return this.erros;
        }
        if (Funcoes.textoVazio(this.enderecoFtp)) {
            this.erros.errosProcesso.add(IntegracaoOperadoraUnimedIbitinga.montaExcecao(new Exception(), null, "N\u00e3o foi possivel conectar ao Ftp da Unimed Ibitinga.", PROCESSO_CARREGAR_PARAMETROS));
            return this.erros;
        }
        return this.erros;
    }

    private String integrarDados() {
        int erro = 0;
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_GERANDO);
        FtpUtil ftp = null;
        String mensagemErro = "";
        try {
            File[] exportar;
            File diretorio;
            this.geraArquivosExportacao();
            if (!Funcoes.textoVazio(this.pastaLocal) && (diretorio = new File(this.pastaLocal)).exists() && null != (exportar = diretorio.listFiles()) && exportar.length > 0) {
                ftp = new FtpUtil(this.enderecoFtp, this.codigoLoginConfiguracao, this.senhaLoginConfiguracao);
                if (ftp.isConnected()) {
                    Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
                    Laboratorio.setHintIntegracaoOperadora(this, HINT_ENVIANDO);
                    this.enviaArquivosFtp(exportar, ftp);
                    ftp.desconectar();
                } else {
                    erro = ftp.erroFtp();
                }
            }
        }
        catch (Exception e) {
            if (ftp != null) {
                erro = ftp.erroFtp();
            }
            mensagemErro = e.getMessage();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_PARADO);
        Laboratorio.setHintIntegracaoOperadora(this, HINT_PARADO);
        return mensagemErro;
    }

    private void enviaArquivosFtp(File[] exportar, FtpUtil ftp) throws Exception {
        for (File arquivo : exportar) {
            String nomeArquivo = arquivo.getName();
            if (!arquivo.isFile() || !nomeArquivo.substring(nomeArquivo.lastIndexOf(".") + 1).equalsIgnoreCase("XML") || !ftp.uploadAquivo(this.pastaLocal + nomeArquivo, nomeArquivo, this.pastaFtp)) continue;
            arquivo.delete();
        }
    }

    private int geraArquivosExportacao() throws IntegracaoOperadoraException {
        StringBuilder bui = new StringBuilder();
        Statement st = ConexaoTemporaria.getStatement();
        Statement st2 = ConexaoTemporaria.getStatement();
        int qtdeLogs = 0;
        bui.setLength(0);
        bui.append("select ");
        bui.append("eio_codigo as codigoExp,");
        bui.append("eio_operacao as xmlExp");
        bui.append(" from exportaintegracaooperadora ");
        bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" and con_codigo = ").append(this.codigoConvenio);
        bui.append(" and eio_exportado = false");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, bui);
            while (rs.next()) {
                String codigoMaterial;
                String codigoExame;
                ++qtdeLogs;
                String xmlExp = rs.getString("xmlExp");
                String codigoRequisicao = StringUtil.getValor(xmlExp, "codreq");
                XMLStringBuilder xml = IntegracaoOperadoraUnimedIbitinga.geraXmlResultado(codigoRequisicao, codigoExame = StringUtil.getValor(xmlExp, "codexa"), codigoMaterial = StringUtil.getValor(xmlExp, "codmat"), this.erros);
                if (null == xml || xml.vazio()) continue;
                String fileName = String.format("%s%s_%s%s", this.pastaLocal, this.codigoLaboratorioConfiguracao, Funcoes.formataData("ddMMyyyyHHmmss", new Date()), ".xml");
                StringUtil.escreverArquivoTexto(fileName, xml.getXML());
                bui.setLength(0);
                bui.append("update exportaintegracaooperadora set ");
                bui.append(" eio_exportado = true ");
                bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and con_codigo = ").append(this.codigoConvenio);
                bui.append(" and eio_codigo = ").append(rs.getInt("codigoExp"));
                ConexaoTemporaria.executeUpdate(st2, bui);
                ConexaoTemporaria.arquivaSQL();
                Thread.sleep(1000L);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        catch (InterruptedException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        catch (IntegracaoOperadoraException e) {
            this.erros.errosProcesso.add(e);
        }
        catch (Exception e) {
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel gravar o log de comunica\u00e7\u00e3o.\nMensagem: " + e.getMessage(), 1);
        }
        return qtdeLogs;
    }

    private static IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        } else {
            if (excecao != null) {
                buf.append(" - ").append(excecao.toString());
            }
            if (excecao instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }
}

