/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.ibitinga;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class ConfiguradorIntegracaoOperadoraUnimedIbitinga
extends AbstractDialogoOKCancelar {
    public static final String TAG_LOGIN = "login";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_CODIGO_LABORATORIO = "codigoLaboratorio";
    public static final String TAG_FTP = "enderecoFtp";
    public static final String TAG_FTP_PASTA = "pastaFtp";
    public static final String TAG_LOCAL_PASTA = "pastaLocal";
    private static final String REGEX_PASTA = "[a-zA-Z0-9./-\\_]+";
    private static final String REGEX_SENHA = "[0-9A-Za-z\\_\\-\\!\\@\\#\\$\\%\\&]+";
    private String xml = null;
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio do FTP:");
    private JLabel labelSenha = new JLabel("Senha do FTP:");
    private JLabel labelCodigoLaboratorio = new JLabel("C\u00f3digo do Laborat\u00f3rio:");
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelVlrEstacao = new JLabel();
    private JLabel labelFtp = new JLabel("Endere\u00e7o do FTP:");
    private JLabel labelFtpPasta = new JLabel("Pasta do FTP:");
    private JLabel labelLocalPasta = new JLabel("Pasta Local:");
    private TTextField textFtp = new TTextField(200, "[a-zA-Z0-9./-:]+");
    private TTextField textUsuario = new TTextField(15, "[a-zA-Z0-9]+");
    private TTextField textSenha = new TTextField(15, "[0-9A-Za-z\\_\\-\\!\\@\\#\\$\\%\\&]+");
    private TTextField textCodigoLaboratorio = new TTextField(18, 1);
    private TTextField textEstacao = new TTextField(10, 1);
    private TTextField textFtpPasta = new TTextField(200, "[a-zA-Z0-9./-\\_]+");
    private TTextField textLocalPasta = new TTextField(200, "[a-zA-Z0-9./-\\_]+");
    private JButton buttonComandoExportacao = ComponenteFactory.novoJButton("...", 'P', this);
    private JButton buttonEstacao = new JButton();
    private JPanel panelFTP = new JPanel();
    private TitledBorder titledBorderFTP = new TitledBorder("Configura\u00e7\u00f5es FTP");

    public static ConfiguradorIntegracaoOperadoraUnimedIbitinga novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraUnimedIbitinga((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraUnimedIbitinga((JFrame)pai);
    }

    private ConfiguradorIntegracaoOperadoraUnimedIbitinga(Dialog pai) {
        super(pai, "Configurando Unimed Ibitinga");
        this.montaTela();
    }

    private ConfiguradorIntegracaoOperadoraUnimedIbitinga(JFrame pai) {
        super((Frame)pai, "Configurando Unimed Ibitinga");
        this.montaTela();
    }

    public void setXML(String xml) {
        this.xml = xml;
        if (!Funcoes.textoVazio(xml) && StringUtil.getValor(xml, "protocolo").equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IBI.getDescricao()) && !Funcoes.textoVazio(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.textEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_LOGIN))) {
                this.textUsuario.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_SENHA))) {
                this.textSenha.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_CODIGO_LABORATORIO);
            if (!Funcoes.textoVazio(xml)) {
                this.textCodigoLaboratorio.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_FTP);
            if (!Funcoes.textoVazio(xml)) {
                this.textFtp.setText(aux);
            }
            aux = StringUtil.getValor(xml, TAG_FTP_PASTA);
            if (!Funcoes.textoVazio(xml)) {
                ((TTextField.TDocument)this.textFtpPasta.getDocument()).setRegex("");
                this.textFtpPasta.setText(aux);
                ((TTextField.TDocument)this.textFtpPasta.getDocument()).setRegex(REGEX_PASTA);
            }
            aux = StringUtil.getValor(xml, TAG_LOCAL_PASTA);
            if (!Funcoes.textoVazio(xml)) {
                ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex("");
                this.textLocalPasta.setText(aux);
                ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex(REGEX_PASTA);
            }
        }
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.textEstacao) {
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.buscaEstacao(ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.textEstacao.getText());
                }
            }
        };
        this.textEstacao.addKeyListener(keyAdapter);
        this.textEstacao.addFocusListener(focusAdapter);
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraUnimedIbitinga.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.textEstacao.clear();
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.labelVlrEstacao.setText("");
                }
            }
        });
        this.buttonComandoExportacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.buttonComandoExportacao) {
                    ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.buscaDiretorio(ConfiguradorIntegracaoOperadoraUnimedIbitinga.this.textLocalPasta);
                }
            }
        });
    }

    private void buscaDiretorio(TTextField text) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Selecione um Diret\u00f3rio");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex("");
            text.setText(chooser.getSelectedFile().getAbsolutePath());
            ((TTextField.TDocument)this.textLocalPasta.getDocument()).setRegex(REGEX_PASTA);
        }
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.textEstacao);
        }
    }

    private void pesquisaEstacao() {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        } else {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IBI.getDescricao());
        xml.escrever("estacao", this.textEstacao.getText());
        xml.escreverCData(TAG_LOGIN, this.textUsuario.getText());
        xml.escreverCData(TAG_SENHA, this.textSenha.getText());
        xml.escrever(TAG_CODIGO_LABORATORIO, this.textCodigoLaboratorio.getText());
        xml.escreverCData(TAG_FTP, this.textFtp.getText());
        xml.escreverCData(TAG_FTP_PASTA, this.textFtpPasta.getText());
        xml.escrever(TAG_LOCAL_PASTA, this.textLocalPasta.getText());
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvelcriar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(450, 230));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelEstacao, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelCodigoLaboratorio, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelUsuario, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelSenha, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelFtp, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelFtpPasta, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelLocalPasta, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.textEstacao.setPreferredSize(new Dimension(80, 20));
        this.textEstacao.setMinimumSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textEstacao, c);
        ++c.gridx;
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.buttonEstacao.setFocusable(false);
        this.getPanelCentral().add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelVlrEstacao.setPreferredSize(new Dimension(20, 20));
        this.labelVlrEstacao.setMinimumSize(new Dimension(20, 20));
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.getPanelCentral().add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textCodigoLaboratorio.setPreferredSize(new Dimension(20, 20));
        this.textCodigoLaboratorio.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textCodigoLaboratorio, c);
        ++c.gridy;
        this.textUsuario.setPreferredSize(new Dimension(20, 20));
        this.textUsuario.setMinimumSize(new Dimension(20, 20));
        this.panelFTP.add((Component)this.textUsuario, c);
        this.getPanelCentral().add((Component)this.textUsuario, c);
        ++c.gridy;
        this.textSenha.setPreferredSize(new Dimension(20, 20));
        this.textSenha.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textSenha, c);
        ++c.gridy;
        this.textFtp.setPreferredSize(new Dimension(20, 20));
        this.textFtp.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textFtp, c);
        ++c.gridy;
        this.textFtpPasta.setPreferredSize(new Dimension(20, 20));
        this.textFtpPasta.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textFtpPasta, c);
        ++c.gridy;
        c.fill = 0;
        this.textLocalPasta.setPreferredSize(new Dimension(295, 20));
        this.textLocalPasta.setMinimumSize(new Dimension(295, 20));
        this.getPanelCentral().add((Component)this.textLocalPasta, c);
        ++c.gridx;
        c.anchor = 13;
        this.buttonComandoExportacao.setPreferredSize(new Dimension(20, 20));
        this.buttonComandoExportacao.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonComandoExportacao, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)new JLabel(), c);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.textEstacao);
        this.textLocalPasta.setEditable(false);
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textEstacao) || this.labelVlrEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuario)) {
            Funcoes.mensagem(this, "O usu\u00e1rio de login deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenha)) {
            Funcoes.mensagem(this, "A senha de login deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoLaboratorio)) {
            Funcoes.mensagem(this, "O c\u00f3digo do laborat\u00f3rio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoLaboratorio);
            return false;
        }
        if (Funcoes.textoVazio(this.textFtp)) {
            Funcoes.mensagem(this, "O endere\u00e7o do FTP deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textFtp);
            return false;
        }
        if (Funcoes.textoVazio(this.textFtpPasta)) {
            Funcoes.mensagem(this, "A pasta destino do FTP deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textFtpPasta);
            return false;
        }
        if (Funcoes.textoVazio(this.textLocalPasta)) {
            Funcoes.mensagem(this, "A pasta tempor\u00e1ria deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textLocalPasta);
            return false;
        }
        return true;
    }
}

