/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.guaxupe.model;

import jalis.integracaooperadoras.sistemas.unimed.guaxupe.model.UnimedGuaxupeDao;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.model.UnimedGuaxupeVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UnimedGuaxupeService {
    private UnimedGuaxupeDao dao = new UnimedGuaxupeDao();
    private String token;
    private String endereco;
    private String xml;

    public String consultarToken(String xml) throws IOException, JSONException {
        StringBuilder buf = new StringBuilder(xml);
        String endereco = StringUtil.getValor(xml, "endereco");
        String usuario = StringUtil.getValor(xml, "login");
        String senha = StringUtil.getValor(xml, "senha");
        String encoding = Base64.encodeBase64String((byte[])usuario.concat(":").concat(senha).getBytes("UTF-8"));
        URL url = new URL(endereco + "/api/auth");
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", "Basic " + encoding);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("grant_type", "client_credentials");
        JSONObject msg = new JSONObject(map);
        osw.write(msg.toString());
        osw.flush();
        osw.close();
        conn.getResponseMessage();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String text = "";
        while ((text = br.readLine()) != null) {
            JSONObject json = null;
            json = new JSONObject(text);
            String xmlToken = "";
            xmlToken = json.getString("access_token");
            StringUtil.setValor(buf, "token", xmlToken);
        }
        return buf.toString();
    }

    public void inserirExportaIntegrcao(UnimedGuaxupeVO guaxupe) throws Exception {
        new UnimedGuaxupeDao().gravarExportaIntegracao(guaxupe);
    }

    public List<LogIntegracaoOperadora> enviarResultado(String codigoConvenio, String xmlConfiguracao) throws Exception {
        this.dao = new UnimedGuaxupeDao();
        this.token = StringUtil.getValor(xmlConfiguracao, "token");
        this.endereco = StringUtil.getValor(xmlConfiguracao, "endereco");
        ArrayList<LogIntegracaoOperadora> listaLogs = null;
        listaLogs = this.dao.getLogsIntegracao(codigoConvenio);
        if (listaLogs != null) {
            for (LogIntegracaoOperadora log : listaLogs) {
                this.enviarResultado(log, false, xmlConfiguracao);
            }
        }
        return listaLogs;
    }

    private void enviarResultado(LogIntegracaoOperadora log, boolean isReenvio, String xml) throws Exception {
        StringBuilder retorno = new StringBuilder();
        ArrayList<Registro> listaExames = this.dao.getDadosExame(log);
        if (listaExames == null) {
            return;
        }
        for (Registro dadosExames : listaExames) {
            List<UnimedGuaxupeVO> lista;
            UnimedGuaxupeVO guaxupe;
            String numeroTransacao;
            xml = dadosExames.getString("xml");
            this.token = StringUtil.getValor(xml, "token");
            if (Funcoes.textoVazio(dadosExames.getString("guiaexame"))) {
                retorno.append("Guia do exame  ");
                retorno.append(dadosExames.getString("codigoexame"));
                retorno.append(" da filial ").append(dadosExames.getString("codigofilial"));
                retorno.append(" requisi\u00e7\u00f5a ").append(dadosExames.getString("codigorequisicao"));
                retorno.append(" n\u00e3o informado.");
                log.setRetorno(retorno.toString());
                this.dao.atualizarLog(log);
                return;
            }
            if (!Funcoes.textoVazio(dadosExames.getString("idunimed"))) {
                this.removerResultado(dadosExames.getString("idunimed"), log);
            }
            if (Funcoes.textoVazio(numeroTransacao = dadosExames.getString("transacaoid")) && !Funcoes.textoVazio(numeroTransacao = (guaxupe = this.getSequencialTransacao(dadosExames.getString("guiaexame"), xml, log)).getNumeroTransacao()) && !(lista = this.getTransacaoId(numeroTransacao, xml, log)).isEmpty()) {
                String transacaoId;
                UnimedGuaxupeVO vo = lista.get(0);
                numeroTransacao = transacaoId = vo.getTransacaoId();
            }
            File pdf = this.montaExamesRealizados(log.getCodigoFilial().toString(), log.getCodigoRequisicao().toString(), log.getCodigoExame(), log.getCodigoMaterial().toString());
            this.enviarResultadoOperadora(numeroTransacao, pdf, log);
        }
    }

    private void removerResultado(String transacaoId, LogIntegracaoOperadora log) throws Exception {
        URL url = new URL(this.endereco + "/api/postagem-resultados/" + transacaoId);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("DELETE");
        conn.setRequestProperty("Authorization", "Bearer " + this.token);
        conn.connect();
        if (conn.getResponseCode() == 204) {
            this.dao.atualizarTransacao(transacaoId, log);
            return;
        }
        log.setRetorno("N\u00e3o foi poss\u00edvel remover o reultado na operadora de sa\u00fade.");
    }

    private void enviarResultadoOperadora(String numeroTransacao, File pdf, LogIntegracaoOperadora log) throws IOException, IntegracaoOperadoraException, SQLException, JSONException {
        StringBuilder buf = new StringBuilder();
        URL url = new URL(this.endereco + "/api/postagem-resultados");
        HttpURLConnection conn = null;
        String boundary = UUID.randomUUID().toString();
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", "Bearer " + this.token);
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        conn.setDoOutput(true);
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("arquivos[]", (ContentBody)new FileBody(pdf));
        entity.addPart("observacoes[]", (ContentBody)new StringBody(""));
        entity.addPart("transacaoId", (ContentBody)new StringBody(numeroTransacao));
        conn.setRequestProperty("Content-Type", entity.getContentType().getValue());
        OutputStream os = conn.getOutputStream();
        entity.writeTo(os);
        conn.getResponseMessage();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String text = "";
        while ((text = br.readLine()) != null) {
            buf.append(text);
        }
        if (buf.toString().contains("id")) {
            log.setSituacao("E");
            JSONArray json = new JSONObject(buf.toString()).getJSONArray("sucesso");
            JSONObject obj = json.getJSONObject(0);
            String id = (String)obj.get("id");
            log.setRetorno(buf.toString());
            this.dao.gravarTransacaoId(numeroTransacao, log, id);
            this.dao.atualizarLog(log);
        } else {
            JSONObject jsonRates = new JSONObject(buf.toString());
            log.setSituacao("R");
            log.setRetorno(jsonRates.getJSONArray("erro").getString(0));
            this.dao.atualizarLog(log);
        }
    }

    public UnimedGuaxupeVO getSequencialTransacao(String guia, String xml, LogIntegracaoOperadora log) throws IOException, JSONException, SQLException {
        String sequencial = "";
        URL url = new URL(this.endereco + "/api/transacao?&numeroGuiaOperadora=" + guia);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + this.token);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        conn.connect();
        String resposta = conn.getResponseMessage();
        UnimedGuaxupeVO guaxupe = new UnimedGuaxupeVO();
        if (!Funcoes.textoVazio(resposta)) {
            if (resposta.equals("Unauthorized")) {
                String xmlConfiguracao = this.consultarToken(xml);
                this.dao.atualizarConfiguracaoConvenio(xmlConfiguracao, log);
                this.token = StringUtil.getValor(xmlConfiguracao, "token");
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String text = "";
            while ((text = br.readLine()) != null) {
                JSONObject jsonRates = new JSONObject(text).getJSONObject("_embedded");
                JSONArray jsonTransacao = new JSONObject(jsonRates.toString()).getJSONArray("transacao");
                for (int i = 0; i < jsonTransacao.length(); ++i) {
                    JSONObject obj = jsonTransacao.getJSONObject(i);
                    sequencial = (String)obj.get("sequencialTransacao");
                    guaxupe.setNumeroTransacao(sequencial);
                }
            }
        }
        return guaxupe;
    }

    private List<UnimedGuaxupeVO> getTransacaoId(String numeroTransacao, String xml2, LogIntegracaoOperadora log) throws IOException, JSONException, SQLException {
        String sequencial = "";
        URL url = new URL(this.endereco + "/api/transacao/" + numeroTransacao);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + this.token);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        conn.connect();
        String resposta = conn.getResponseMessage();
        ArrayList<UnimedGuaxupeVO> listaGuaxupe = null;
        if (!Funcoes.textoVazio(resposta)) {
            if (resposta.equals("Unauthorized")) {
                String xmlConfiguracao = this.consultarToken(this.xml);
                this.dao.atualizarConfiguracaoConvenio(xmlConfiguracao, log);
                this.token = StringUtil.getValor(xmlConfiguracao, "token");
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String text = "";
            listaGuaxupe = new ArrayList<UnimedGuaxupeVO>();
            while ((text = br.readLine()) != null) {
                String[] xmExame;
                JSONObject jsonRates = new JSONObject(text);
                String xml = (String)jsonRates.get("xmlResposta");
                sequencial = jsonRates.getString("sequencialTransacao");
                String xmlExames = StringUtil.getValor(xml, "servicosAutorizados");
                for (String ex : xmExame = StringUtil.getValores(xmlExames, "servicoAutorizado")) {
                    String solicitado = StringUtil.getValor(ex, "quantidadeSolicitada");
                    String autorizada = StringUtil.getValor(ex, "quantidadeAutorizada");
                    UnimedGuaxupeVO guaxupe = new UnimedGuaxupeVO();
                    guaxupe.setNumeroTransacao(numeroTransacao);
                    guaxupe.setTransacaoId(sequencial);
                    guaxupe.setAutorizado(Integer.valueOf(solicitado) == Integer.valueOf(autorizada));
                    guaxupe.setCodigoAMB(StringUtil.getValor(ex, "codigoProcedimento"));
                    guaxupe.setCodigoExame(StringUtil.getValor(ex, "descricaoProcedimento"));
                    listaGuaxupe.add(guaxupe);
                }
            }
        }
        return listaGuaxupe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File montaExamesRealizados(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws IntegracaoOperadoraException, SQLException, IOException {
        Object pdf = null;
        File file = null;
        String arquivoPDF = codigoExame + "-" + Funcoes.formataData("dd-MM-yyyy", new Date()) + ".pdf";
        String[] exames = new String[]{codigoExame};
        String[] materiais = new String[]{codigoMaterial};
        RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(null, null, codigoFilial, codigoRequisicao, true, true, null, exames, materiais, true, null, true, true, null, true, "", true, false);
        if (retorno != null) {
            file = new File(arquivoPDF);
            try (FileOutputStream fileOutputStream = null;){
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(retorno.getResultadoPdfWeb());
            }
        }
        return file;
    }

    public List<UnimedGuaxupeVO> parseExames(String codigoFilial, String codigoConvenio, String guia) throws Exception {
        LogIntegracaoOperadora log = new LogIntegracaoOperadora();
        log.setCodigoConvenio(Integer.valueOf(codigoConvenio));
        log.setCodigoFilial(Integer.valueOf(codigoFilial));
        List<UnimedGuaxupeVO> listaProc = new ArrayList<UnimedGuaxupeVO>();
        UnimedGuaxupeDao dao = new UnimedGuaxupeDao();
        this.xml = dao.getXmlConvenio(codigoFilial, codigoConvenio);
        this.endereco = StringUtil.getValor(this.xml, "endereco");
        String usuario = StringUtil.getValor(this.xml, "login");
        String senha = StringUtil.getValor(this.xml, "senha");
        this.token = Base64.encodeBase64String((byte[])usuario.concat(":").concat(senha).getBytes("UTF-8"));
        UnimedGuaxupeVO sequencial = this.getSequencialTransacao(guia, this.xml, log);
        if (sequencial == null) {
            sequencial = this.getSequencialTransacao(guia, this.xml, log);
            if (Funcoes.textoVazio(sequencial.getNumeroTransacao())) {
                throw new Exception("Guia informada inv\u00e1lida.");
            }
            listaProc = this.getTransacaoId(sequencial.getNumeroTransacao(), this.xml, log);
        }
        return listaProc;
    }

    public List<Registro> getExames(String codigoFilial, String codigoConvenio, String codigoAMB, String descricao) throws Exception {
        UnimedGuaxupeDao dao = new UnimedGuaxupeDao();
        return dao.parseExames(codigoFilial, codigoConvenio, codigoAMB, descricao);
    }

    public String getXmlConvenio(String codigoFilial, String codigoConvenio) throws SQLException {
        return new UnimedGuaxupeDao().getXmlConvenio(codigoFilial, codigoConvenio);
    }
}

