/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.guaxupe.model;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.model.UnimedGuaxupeVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracaoOperadoraDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class UnimedGuaxupeDao
extends ConsultaIntegracaoOperadoraDao {
    private static final String TAG_INICIO = "<nomeintegracaooperadora>";
    private static final String TAG_FIM = "</nomeintegracaooperadora>";
    private static final String FILTRO_NAO_ENVIADO = "N\u00e3o Enviados";
    private static final String FILTRO_ENVIADOS = "Enviados";

    public void gravarExportaIntegracao(UnimedGuaxupeVO unimed) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora ");
        buf.append("(fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, ");
        buf.append("req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(unimed.getCodigoFilial());
        buf.append(" ,").append(unimed.getCodigoConvenio());
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(unimed.getCodigoFilial())).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(unimed.getXml().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(unimed.getTipoOperacao()).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(unimed.getCodigoRequisicao());
        buf.append(" , ").append(unimed.getCodigoPaciente());
        buf.append(" , '").append(unimed.getCodigoExame()).append("'");
        buf.append(" , ").append(unimed.getCodigoMaterial()).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(unimed.getCodigoFilial(), st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new Exception("N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LogIntegracaoOperadora> getLogsIntegracao(String codigoConvenio) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,eio_codigo as codigoLog ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,eio_operacao as operacao ");
        buf.append("       ,eio_tipooperacao as tipoOperacao ");
        buf.append("       ,eio_retorno as retorno");
        buf.append("       ,COALESCE(eio_situacao,'') as situacao ");
        buf.append("   from exportaintegracaooperadora ");
        buf.append("  where eio_exportado = false ");
        buf.append("    and con_codigo = ").append(codigoConvenio);
        buf.append("    and (eio_situacao is null or eio_situacao = '')");
        buf.append("  order by eio_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
            if (rs != null && rs.next()) {
                do {
                    listaLogs.add(this.getLogIntegracao(rs));
                } while (rs.next());
                ArrayList<LogIntegracaoOperadora> arrayList = listaLogs;
                return arrayList;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return null;
    }

    private LogIntegracaoOperadora getLogIntegracao(ResultSet rs) throws SQLException {
        Integer codigoFilial = rs.getInt("codigoFilial");
        Integer codigoLog = rs.getInt("codigoLog");
        Integer cod_convenio = rs.getInt("codigoConvenio");
        String tipoOperacao = rs.getString("tipoOperacao");
        String retorno = rs.getString("retorno");
        String situacao = rs.getString("situacao");
        String operacao = rs.getString("operacao");
        Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
        String codigoExame = StringUtil.getValor(operacao, "codexa");
        Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
        LogIntegracaoOperadora logIntegracaoOperadora = new LogIntegracaoOperadora();
        logIntegracaoOperadora.setCodigoFilial(codigoFilial);
        logIntegracaoOperadora.setCodigoLog(codigoLog.intValue());
        logIntegracaoOperadora.setCodigoConvenio(cod_convenio);
        logIntegracaoOperadora.setCodigoRequisicao(codigoRequisicao);
        logIntegracaoOperadora.setCodigoExame(codigoExame);
        logIntegracaoOperadora.setCodigoMaterial(codigoMaterial);
        logIntegracaoOperadora.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(tipoOperacao));
        logIntegracaoOperadora.setXmlLog(operacao);
        logIntegracaoOperadora.setRetorno(retorno);
        logIntegracaoOperadora.setSituacao(situacao);
        return logIntegracaoOperadora;
    }

    public ArrayList<Registro> getDadosExame(LogIntegracaoOperadora log) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_matricula as carteirinha ");
        buf.append("       ,req.req_validadecarteira as validadeCarteirinha ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,exr.exr_transacaoidunimed  as transacaoId ");
        buf.append("       ,exr.exr_idunimed   as idUnimed ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,med.med_crm as crmMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guiaExame ");
        buf.append("       ,exr.exr_ordem as sequenciaExame ");
        buf.append("       ,exr.exr_dataassina as dataConferenciaExame ");
        buf.append("       ,coalesce(exadesm.exa_codigo, exa.exa_codigo) as codigoExame ");
        buf.append("       ,coalesce(exadesm.exa_descricao, exa.exa_descricao) as descricaoExame ");
        buf.append("       ,req.req_excluida as requisicaoExcluida ");
        buf.append("       ,exr.exr_excluido as exameExcluido ");
        buf.append("       ,coalesce(cio.mco_kodigo, exr.mco_codigo) as codigoMaterial ");
        buf.append("       ,matcol.mco_descricao as descricaoMaterial ");
        buf.append("       ,exa.exa_codigo as codigoExamePai ");
        buf.append("       ,exr.mco_codigo as codigoMaterialPai ");
        buf.append("       ,exr.exr_datamaterial as dataColeta ");
        buf.append("       ,exr_codautorizacao as senhaGuia ");
        buf.append("       ,pegaresultadoexame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as resultado ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_idade as idadePaciente ");
        buf.append("       ,req.req_anomes as tipoIdadePaciente ");
        buf.append("       ,exr.met_codigo as codigoMetodologia ");
        buf.append("       ,met.met_descricao as descricaoMetodologia ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_obs as observacao ");
        buf.append("       ,con.con_integracaooperadora as xml ");
        buf.append("       ,con.con_razao as razaoSocial ");
        buf.append("       ,el.lay_codigo as layout ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,dtm.dtm_codamb as codigoAmb ");
        } else {
            buf.append("      ,dtp.dtp_codamb as codigoAmb ");
        }
        buf.append("  from requisicao req ");
        buf.append("  join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("  left join conveniosintegracaooperadora cio on exr.fil_codigo = cio.fil_codigo and exr.exa_codigo = cio.exa_codigo and exr.mco_codigo = cio.mco_codigo and req.con_codigo = cio.con_codigo");
        buf.append("  join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and med.med_uf = req.med_uf");
        buf.append("  join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  left join exames exadesm on cio.fil_codigo = exadesm.fil_codigo and cio.exa_kodigo = exadesm.exa_codigo ");
        buf.append("  join examelayout el on exr.fil_codigo = el.fil_codigo and exr.exa_codigo = el.exa_codigo and exr.mco_codigo = el.mco_codigo and el.ela_padrao = true ");
        buf.append("  join examelayoutmetodo elm on exr.fil_codigo = elm.fil_codigo and exr.exa_codigo = elm.exa_codigo and exr.mco_codigo = elm.mco_codigo and exr.met_codigo = elm.met_codigo and elm.lay_codigo = el.lay_codigo\t");
        buf.append("  join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  join materialcoleta matcol on exr.fil_codigo = matcol.fil_codigo and exr.mco_codigo = matcol.mco_codigo ");
        buf.append("  join metodologia met on exr.fil_codigo = met.fil_codigo and exr.met_codigo = met.met_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtm.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        } else {
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and coalesce(exadesm.exa_codigo, exr.exa_codigo) = dtp.exa_codigo and coalesce(cio.mco_kodigo, exr.mco_codigo) = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        }
        buf.append(" where req.fil_codigo = ").append(log.getCodigoFilial());
        buf.append("   and req.req_codigo = ").append(log.getCodigoRequisicao());
        buf.append("   and exr.exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append("   and exr.mco_codigo = ").append(log.getCodigoMaterial());
        ResultSet rs = Conexao.executeQuery(ConexaoTemporaria.getStatement(), buf.toString());
        ArrayList<Registro> registro = new ArrayList<Registro>();
        boolean exameConferido = true;
        while (rs.next()) {
            registro.add(new Registro(rs));
            if (!DBUtil.campoNull(rs.getString("dataConferenciaExame"))) continue;
            exameConferido = false;
        }
        if (exameConferido) {
            return registro;
        }
        return null;
    }

    public void atualizarLog(LogIntegracaoOperadora logs) throws IntegracaoOperadoraException, SQLException {
        StringBuilder sql = new StringBuilder();
        String statusRetorno = logs.getSituacao().equals("E") ? "t" : "f";
        String filial = logs.getCodigoFilial().toString();
        sql.append("update exportaintegracaooperadora set ");
        sql.append(" eio_situacao = '").append(logs.getSituacao()).append("'");
        sql.append(", eio_retorno = '").append(logs.getRetorno()).append("'");
        sql.append(", eio_exportado = '").append(statusRetorno).append("'");
        sql.append(", req_codigo = '").append(logs.getCodigoRequisicao()).append("'");
        sql.append(" where req_codigo in (");
        sql.append(logs.getCodigoRequisicao());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(filial);
        sql.append(" and eio_exportado = 'f'");
        Statement st = Conexao.getStatement();
        Conexao.execute(filial, st, sql.toString());
        Conexao.arquivaSQL();
    }

    public void gravarTransacaoId(String numeroTransacao, LogIntegracaoOperadora log, String id) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update examerequisicao set exr_transacaoidunimed  = '").append(numeroTransacao).append("',");
        sql.append(" exr_idunimed = ").append(id);
        sql.append(" where req_codigo in (");
        sql.append(log.getCodigoRequisicao());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(log.getCodigoFilial());
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(log.getCodigoExame()));
        sql.append(" and mco_codigo = ").append(log.getCodigoMaterial());
        Statement st = Conexao.getStatement();
        Conexao.execute(log.getCodigoFilial().toString(), st, sql.toString());
        Conexao.arquivaSQL();
    }

    public void atualizarConfiguracaoConvenio(String xmlConfiguracao, LogIntegracaoOperadora log) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update convenios set con_integracaooperadora = '").append(xmlConfiguracao).append("'");
        sql.append(" where con_codigo = ");
        sql.append(log.getCodigoConvenio());
        sql.append(" and fil_codigo = ").append(log.getCodigoFilial());
        Statement st = Conexao.getStatement();
        Conexao.execute(log.getCodigoFilial().toString(), st, sql.toString());
        Conexao.arquivaSQL();
    }

    @Override
    public int consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora unimedguaxupe) throws IntegracaoException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("");
        buf.append("select count(1) as logs from exportaintegracaooperadora eio ");
        buf.append(" where eio_exportado is false");
        buf.append(" and eio_operacao like '%").append(TAG_INICIO).append(unimedguaxupe.getDescricao()).append(TAG_FIM).append("%'");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("logs");
            }
        }
        catch (SQLException e) {
            throw new IntegracaoException(0L, e.getMessage(), "", true);
        }
        throw new IntegracaoException(0L, "N\u00e3o foi poss\u00edvel consultar logs para envio", "", true);
    }

    public List<Registro> buscarRegistrosLog(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        Statement st = Conexao.getStatement();
        ArrayList<Registro> logs = new ArrayList<Registro>();
        try {
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSqlConsulta(intervalo, itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE, filtraLogsRejeitados));
                while (rs.next()) {
                    Registro registro = this.montaDados(rs);
                    logs.add(registro);
                }
            }
            return logs;
        }
        catch (Exception e) {
            throw new IntegracaoException(0L, e.getMessage(), "", true);
        }
    }

    public void marcarParaExportar(LogIntegracaoOperadora log) throws SQLException {
        String sql = "update exportaintegracaooperadora set eio_exportado = false, eio_situacao = null   where eio_codigo = ? and fil_codigo = ? and con_codigo = ?;";
        PreparedStatement pr = Conexao.getPreparedStatement(sql);
        pr.setLong(1, log.getCodigoLog());
        pr.setInt(2, log.getCodigoFilial());
        pr.setInt(3, log.getCodigoConvenio());
        pr.executeUpdate();
        pr.close();
    }

    protected String getSqlConsulta(IntervaloData intervalo, Filtros itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo) {
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct pa.pac_codigo ");
        bui.append(", pa.pac_nome");
        bui.append(", pac_idade");
        bui.append(", exr.exa_codigo");
        bui.append(", exr.mco_codigo");
        bui.append(", mco.mco_abreviatura");
        bui.append(", exr.exr_transacaoidunimed ");
        bui.append(", exr_situacao as situacaoExame");
        bui.append(", exr_dataassina");
        bui.append(", exr.usr_codassina");
        bui.append(", eio.con_codigo");
        bui.append(", con.con_razao");
        bui.append(", req.req_matricula");
        bui.append(", req.req_cartaosus");
        bui.append(", req.req_codigo");
        bui.append(", req.req_data");
        bui.append(", COALESCE(NULLIF(TRIM(exr.exr_guia), '') ");
        bui.append(", req.req_guia) as req_guia");
        bui.append(", exr.exr_dataguia ");
        bui.append(", cast(req.req_dataguia as text) as req_dataguia");
        bui.append(", dtp.dtp_codamb as cod_amb");
        bui.append(", eio.fil_codigo ");
        bui.append(", eio_codigo");
        bui.append(", eio_exportado");
        bui.append(", eio_operacao");
        bui.append(", eio_tipooperacao");
        bui.append(", eio_retorno");
        bui.append(", eio_datahora");
        bui.append(", eio_situacao as situacaoLog ");
        bui.append(", fil.fil_descricao as descricaoFilial");
        bui.append(", e.exa_descricao as descricaoExame");
        bui.append(" from exportaintegracaooperadora eio ");
        bui.append("left join filiais_postocoleta fil on eio.fil_codigo = fil.fil_codigo ");
        bui.append("left join requisicao req on req.fil_codigo = eio.fil_codigo and req.req_codigo = eio.req_codigo ");
        bui.append("left join examerequisicao exr on eio.fil_codigo = exr.fil_codigo and exr.req_codigo = req.req_codigo and eio.exa_codigo = exr.exa_codigo ");
        bui.append("left join materialcoleta mco on eio.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        bui.append("left join paciente pa on pa.fil_codigo = eio.fil_codigo and pa.pac_codigo = req.pac_codigo ");
        bui.append("left join convenios con on con.fil_codigo = eio.fil_codigo and con.con_codigo = eio.con_codigo ");
        bui.append("left join detalhetabelapreco dtp  on exr.fil_codigo = dtp.fil_codigo  and exr.exa_codigo = dtp.exa_codigo  ");
        bui.append("and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        bui.append("left join exames e on exr.fil_codigo = e.fil_codigo  and exr.exa_codigo = e.exa_codigo  ");
        bui.append(" where (req.req_excluida is null or req.req_excluida = false) ");
        if (Funcoes.verificaData(intervalo.dataInicial)) {
            bui.append(" and eio.eio_datahora >= '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", intervalo.dataInicial)).append("' ");
        }
        if (Funcoes.verificaData(intervalo.dataFinal)) {
            bui.append(" and eio.eio_datahora <= ' ").append(Funcoes.formataData("yyyy-MM-dd 23:59:59", intervalo.dataFinal)).append("' ");
        }
        if (itens.itemRequisicao.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.req_codigo", itens.itemRequisicao.getSelecionadosAvancado(0), true));
        }
        if (itens.itemConvenio.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.con_codigo", itens.itemConvenio.getSelecionados(0), false));
        }
        if (itens.itemPaciente.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.pac_codigo", itens.itemPaciente.getSelecionados(0), true));
        }
        if (itens.itemExame.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.exa_codigo", itens.itemExame.getSelecionados(0), true));
        }
        if (itens.itemFilial.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.fil_codigo", itens.itemFilial.getSelecionados(0), true));
        }
        if (itens.itemSituacao.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.eio_situacao", itens.itemSituacao.getSelecionados(0), true));
        }
        if (itens.itemExibirExportado.getSelectedItem().equals(FILTRO_ENVIADOS)) {
            bui.append(" and eio.eio_exportado in (true)");
        } else if (itens.itemExibirExportado.getSelectedItem().equals(FILTRO_NAO_ENVIADO)) {
            bui.append(" and eio.eio_exportado in (false)");
        } else {
            bui.append(" and eio.eio_exportado in (true, false)");
        }
        bui.append(" and eio_operacao like '%").append(TAG_INICIO).append(protocolo.getDescricao()).append(TAG_FIM).append("%'");
        bui.append(" order by eio_codigo");
        return bui.toString();
    }

    public void atualizarTransacao(String transacaoId, LogIntegracaoOperadora log) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update examerequisicao set ");
        sql.append(" exr_idunimed = ").append(transacaoId);
        sql.append(" where req_codigo in (");
        sql.append(log.getCodigoRequisicao());
        sql.append(") ");
        sql.append("and fil_codigo = ").append(log.getCodigoFilial());
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(log.getCodigoExame()));
        sql.append(" and mco_codigo = ").append(log.getCodigoMaterial());
        Statement st = Conexao.getStatement();
        Conexao.execute(log.getCodigoFilial().toString(), st, sql.toString());
        Conexao.arquivaSQL();
    }

    public String getXmlConvenio(String codigoFilial, String codigoConvenio) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select con_integracaooperadora ");
        sql.append(" from convenios ");
        sql.append(" where fil_codigo = ");
        sql.append(codigoFilial);
        sql.append("and con_codigo = ").append(codigoConvenio);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        if (rs.next()) {
            return rs.getString("con_integracaooperadora");
        }
        return null;
    }

    public ArrayList<Registro> parseExames(String filial, String convenio, String codigoAmbExame, String descricao) throws Exception {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT a.exa_codigo as codigoExame, ");
        buf.append("  a.exa_descricao, el.mco_codigo as codigoMaterial, mc.mco_descricao  ");
        buf.append(" FROM exames a  ");
        buf.append(" LEFT JOIN examematcoleta c  ");
        buf.append(" ON a.fil_codigo = c.fil_codigo  ");
        buf.append(" AND c.exa_codigo = a.exa_codigo ");
        buf.append(" AND c.emc_default ");
        buf.append(" JOIN detalhetabelapreco dtp  ");
        buf.append(" ON a.fil_codigo = dtp.fil_codigo  ");
        buf.append(" AND dtp.exa_codigo = a.exa_codigo ");
        buf.append(" AND dtp.mco_codigo = c.mco_codigo ");
        buf.append(" JOIN convenios con");
        buf.append(" ON a.fil_codigo = con.fil_codigo ");
        buf.append(" AND dtp.tpe_codigo = con.tpe_codigo ");
        buf.append(" JOIN examelayout el ");
        buf.append(" ON a.fil_codigo = el.fil_codigo AND a.exa_codigo = el.exa_codigo AND ela_padrao ");
        buf.append(" JOIN materialcoleta mc ON a.fil_codigo = mc.fil_codigo AND el.mco_codigo = mc.mco_codigo ");
        buf.append(" WHERE a.fil_codigo = ").append(filial);
        buf.append(" AND con.con_codigo = ").append(convenio);
        buf.append(" AND replace(replace(dtp.dtp_codamb, '.', ''), '-', '') = ").append("'").append(codigoAmbExame).append("'");
        buf.append(" order by codigoExame ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            do {
                ExameVO exameVO = (ExameVO)new ExameService().load(" where fil_codigo = " + filial + " and exa_codigo = '" + rs.getString("codigoExame") + "' ;").toArray()[0];
                Registro registro = new Registro(rs);
                registro.setValor("objetoExame", exameVO);
                registro.setValor("exame", codigoAmbExame);
                registro.setValor("descricaoExame", descricao);
                exames.add(registro);
            } while (rs.next());
        }
        return exames;
    }
}

