/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.guaxupe;

import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.ConfiguradorIntegracaoOperadoraGuaxupe;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.model.UnimedGuaxupeService;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.model.UnimedGuaxupeVO;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.net.UnknownHostException;
import java.util.List;

public class IntegracaoOperadoraGuaxupe
extends AbstractIntegracaoOperadora {
    private String xmlConfiguracao;

    public IntegracaoOperadoraGuaxupe(String xmlConfiguracao, int codigoConvenio) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.codigoConvenio = codigoConvenio;
    }

    @Override
    public DadosErrosIntegracaoOperadora integrarOperadora() {
        if (this.erros == null) {
            this.erros = new DadosErrosIntegracaoOperadora();
        } else {
            this.erros.errosEnvioResultado.clear();
            this.erros.errosLogin.clear();
            this.erros.errosProcesso.clear();
        }
        Laboratorio.setIconeIntegracaoOperadora(this, ICONE_EXECUTANDO);
        List<LogIntegracaoOperadora> retorno = null;
        UnimedGuaxupeService service = new UnimedGuaxupeService();
        try {
            retorno = service.enviarResultado(String.valueOf(this.codigoConvenio), this.xmlConfiguracao);
        }
        catch (Exception e) {
            this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception("N\u00e3o foi poss\u00edvel enviar o resultado."), "N\u00e3o foi poss\u00edvel enviar o resultado.", "ENVIO RESULTADO", null));
        }
        for (LogIntegracaoOperadora logIntegracaoOperadora : retorno) {
            if (logIntegracaoOperadora.getSituacao().equals("E")) continue;
            this.erros.errosEnvioResultado.add(new IntegracaoOperadoraException(new Exception(logIntegracaoOperadora.getRetorno()), logIntegracaoOperadora.getRetorno(), "ENVIO RESULTADO", logIntegracaoOperadora));
        }
        return this.erros;
    }

    @Override
    public String configurar(Window parent, String xmlConfig) {
        ConfiguradorIntegracaoOperadoraGuaxupe configuradorIntegracaoOperadoraPR = ConfiguradorIntegracaoOperadoraGuaxupe.novaInstancia(parent);
        configuradorIntegracaoOperadoraPR.setXML(xmlConfig);
        configuradorIntegracaoOperadoraPR.setVisible(true);
        if (configuradorIntegracaoOperadoraPR.getOK()) {
            String xml = configuradorIntegracaoOperadoraPR.getXML();
            UnimedGuaxupeService service = new UnimedGuaxupeService();
            try {
                xml = service.consultarToken(xml);
            }
            catch (UnknownHostException e1) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel consultar o token \nVerifique o endere\u00e7o da operadora", 1);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel consultar o token", e.getStackTrace());
            }
            return xml;
        }
        return xmlConfig;
    }

    public static void insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, String filial, String convenio, String codigoRequsicao, String codigoPaciente, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) {
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("integracaooperadora");
            xml.escrever("nomeintegracaooperadora", protocolo.getDescricao());
            for (int i = 0; i < comando.length; i += 2) {
                xml.escrever(comando[i], comando[i + 1]);
            }
            try {
                xml.fechar("integracaooperadora");
            }
            catch (XMLStringBuilderException e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
            }
            UnimedGuaxupeService service = new UnimedGuaxupeService();
            UnimedGuaxupeVO guaxupe = new UnimedGuaxupeVO();
            guaxupe.setCodigoFilial(filial);
            guaxupe.setCodigoRequisicao(codigoRequsicao);
            guaxupe.setCodigoPaciente(codigoPaciente);
            guaxupe.setCodigoExame(codigoExame);
            guaxupe.setCodigoMaterial(codigoMaterial);
            guaxupe.setCodigoConvenio(convenio);
            guaxupe.setXml(xml.getXML());
            guaxupe.setTipoOperacao(tipoOperacao);
            service.inserirExportaIntegrcao(guaxupe);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

