/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.guaxupe;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoOperadoraGuaxupe
extends AbstractDialogoOKCancelar {
    public static final String TAG_INTEGRACAO_SENHA = "senha";
    public static final String TAG_INTEGRACAO_USUARIO = "login";
    public static final String TAG_INTEGRACAO_ENDERECO = "endereco";
    public static final String TAG_INTEGRACAO_SOLICITARPROCEDIMENTO = "proc";
    public static final String TAG_INTEGRACAO_TOKEN = "token";
    public static final String TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDGUAXUPE = "integracaounimedguaxupe";
    private static String TITULO = "Configurando integra\u00e7\u00e3o Unimed Guaxup\u00e9";
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o integradora:");
    private JLabel labelWebService = new JLabel("Endere\u00e7o (Link):");
    private JLabel labelUsuario = new JLabel("Login:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelVEstacao = new JLabel();
    private JLabel labelSolicitarProcedimento = new JLabel("Solicitar Procedimento: ");
    private JCheckBox checkBoxSolicitarProcedimento = new JCheckBox("");
    private TTextField txtEstacao = new TTextField(10, 1);
    private TTextField txtUsuario = new TTextField(310);
    private TTextField txtSenha = new TTextField(310);
    private TTextField txtEndereco = new TTextField(310);
    private JButton buttonEstacao = new JButton();
    private JPanel panelCentral = new JPanel();

    public static ConfiguradorIntegracaoOperadoraGuaxupe novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorIntegracaoOperadoraGuaxupe((Dialog)pai);
        }
        return new ConfiguradorIntegracaoOperadoraGuaxupe((Frame)pai);
    }

    public ConfiguradorIntegracaoOperadoraGuaxupe(Dialog pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    public ConfiguradorIntegracaoOperadoraGuaxupe(Frame pai) {
        super(pai, TITULO);
        this.montaTela();
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(505, 170));
        this.setLayout(new BorderLayout());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        ScreenUtil.setBorda(new Component[]{this.labelVEstacao}, new TitledBorder(""));
        ScreenUtil.centralizar(this);
        Dimension d2 = new Dimension(343, 20);
        Dimension db = new Dimension(20, 20);
        Dimension dc = new Dimension(70, 20);
        Dimension d3 = new Dimension(140, 20);
        this.labelWebService.setMinimumSize(d3);
        this.labelWebService.setPreferredSize(d3);
        this.labelWebService.setMaximumSize(d3);
        this.labelWebService.setSize(d3);
        this.labelEstacao.setSize(d3);
        this.labelEstacao.setMinimumSize(d3);
        this.labelEstacao.setPreferredSize(d3);
        this.labelEstacao.setMaximumSize(d3);
        this.labelSenha.setSize(d3);
        this.labelSenha.setMinimumSize(d3);
        this.labelSenha.setPreferredSize(d3);
        this.labelSenha.setMaximumSize(d3);
        this.labelUsuario.setSize(d3);
        this.labelUsuario.setMinimumSize(d3);
        this.labelUsuario.setPreferredSize(d3);
        this.labelUsuario.setMaximumSize(d3);
        this.labelSolicitarProcedimento.setSize(d3);
        this.labelSolicitarProcedimento.setMinimumSize(d3);
        this.labelSolicitarProcedimento.setPreferredSize(d3);
        this.labelSolicitarProcedimento.setMaximumSize(d3);
        this.txtEstacao.setPreferredSize(dc);
        this.txtEstacao.setMinimumSize(dc);
        this.txtEstacao.setSize(dc);
        this.txtEndereco.setPreferredSize(d2);
        this.txtEndereco.setMinimumSize(d2);
        this.txtEndereco.setSize(d2);
        this.txtUsuario.setPreferredSize(d2);
        this.txtUsuario.setMinimumSize(d2);
        this.txtUsuario.setSize(d2);
        this.txtSenha.setPreferredSize(d2);
        this.txtSenha.setMinimumSize(d2);
        this.txtSenha.setSize(d2);
        this.buttonEstacao.setPreferredSize(db);
        this.buttonEstacao.setMinimumSize(db);
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVEstacao.setPreferredSize(new Dimension(253, 20));
        this.labelVEstacao.setMinimumSize(new Dimension(253, 20));
        this.labelVEstacao.setSize(new Dimension(253, 20));
        this.panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 1, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.panelCentral.add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.txtEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.buttonEstacao, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.labelVEstacao, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.panelCentral.add((Component)this.labelWebService, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.txtEndereco, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelCentral.add((Component)this.labelUsuario, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.txtUsuario, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelCentral.add((Component)this.labelSenha, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.txtSenha, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelCentral.add((Component)this.labelSolicitarProcedimento, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.checkBoxSolicitarProcedimento, c);
        this.montaListeners();
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    private void montaListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoOperadoraGuaxupe.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraGuaxupe.this.pesquisaEstacao();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoOperadoraGuaxupe.this.txtEstacao) {
                    ConfiguradorIntegracaoOperadoraGuaxupe.this.buscaEstacao(ConfiguradorIntegracaoOperadoraGuaxupe.this.txtEstacao.getText());
                }
            }
        };
        this.buttonEstacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstacaoService estacaoService = new EstacaoService();
                EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(ConfiguradorIntegracaoOperadoraGuaxupe.this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
                if (estacaoVO != null) {
                    ConfiguradorIntegracaoOperadoraGuaxupe.this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                    ConfiguradorIntegracaoOperadoraGuaxupe.this.labelVEstacao.setText(estacaoVO.getDescricao());
                } else {
                    ConfiguradorIntegracaoOperadoraGuaxupe.this.txtEstacao.clear();
                    ConfiguradorIntegracaoOperadoraGuaxupe.this.labelVEstacao.setText("");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(ConfiguradorIntegracaoOperadoraGuaxupe.this.txtEstacao);
            }
        });
        this.txtEstacao.addFocusListener(focusAdapter);
        this.txtEstacao.addKeyListener(keyAdapter);
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.txtEstacao.clear();
            this.labelVEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.txtEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.txtEstacao.clear();
            this.labelVEstacao.setText("");
            ScreenUtil.requisitarFoco(this.txtEstacao);
        }
    }

    private void pesquisaEstacao() {
        this.txtEstacao.clear();
        this.labelVEstacao.setText("");
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.txtEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVEstacao.setText(estacaoVO.getDescricao());
        }
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && this.isGuaxupe(xml = StringUtil.getValor(xml, "integracaooperadora"))) {
            String aux = StringUtil.getValor(xml, "estacao");
            if (!Funcoes.textoVazio(aux)) {
                this.txtEstacao.setText(aux);
                this.buscaEstacao(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_SENHA))) {
                this.txtSenha.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_USUARIO))) {
                this.txtUsuario.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_ENDERECO))) {
                this.txtEndereco.setText(aux);
            }
            if (!Funcoes.textoVazio(aux = StringUtil.getValor(xml, TAG_INTEGRACAO_SOLICITARPROCEDIMENTO))) {
                this.checkBoxSolicitarProcedimento.setSelected(aux.equals("t"));
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("integracaooperadora");
            xml.abrir(TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDGUAXUPE);
            xml.escrever("protocolo", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE.getDescricao());
            xml.escrever("estacao", this.txtEstacao.getText());
            xml.escrever(TAG_INTEGRACAO_USUARIO, this.txtUsuario.getText().trim());
            xml.escrever(TAG_INTEGRACAO_SENHA, this.txtSenha.getText().trim());
            xml.escrever(TAG_INTEGRACAO_ENDERECO, this.txtEndereco.getText().trim());
            xml.escrever(TAG_INTEGRACAO_TOKEN, "");
            xml.escrever(TAG_INTEGRACAO_SOLICITARPROCEDIMENTO, this.checkBoxSolicitarProcedimento.isSelected() ? "t" : "f");
            xml.fechar(TAG_EXAME_INTEGRACOES_INTEGRACAO_UNIMEDGUAXUPE);
            xml.fechar("integracaooperadora");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar o XML de configura\u00e7\u00e3o", e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    private boolean isGuaxupe(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            return StringUtil.getValor(xml, "protocolo").trim().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE.getDescricao().trim());
        }
        return false;
    }

    @Override
    protected boolean acaoOk() {
        return this.validaCampos();
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtEstacao) || this.labelVEstacao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o integradora deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtUsuario)) {
            Funcoes.mensagem(this, "O usu\u00e1rio da operadora de sa\u00fade deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.txtUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSenha)) {
            Funcoes.mensagem(this, "A senha da operadora de sa\u00fade deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.txtEndereco)) {
            Funcoes.mensagem(this, "O endere\u00e7o do Web Service deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtEndereco);
            return false;
        }
        return true;
    }
}

