/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.unimed.centro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExames;
import jalis.integracaooperadoras.sistemas.unimed.centro.ConselhoMedico;
import jalis.integracaooperadoras.sistemas.unimed.centro.ConsultaStatusGuia;
import jalis.integracaooperadoras.sistemas.unimed.centro.SelecionaExamesUnimedCentro;
import jalis.integracaooperadoras.sistemas.unimed.centro.UfMedico;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Document;

public class SolicitaStatusGuiaUnimedCentro {
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String TAG_CAPTURA_GUIA = "gui:capturarStatusGuia";
    private static final String TAG_ARG = "arg0";
    private static final String TAG_LOGIN_USUARIO = "loginUsuario";
    private static final String TAG_SENHA_USUARIO = "senhaUsuario";
    private static final String TAG_TIPO_GUIA = "tipoGuia";
    private static final String TAG_NUMERO_GUIA_OPERADORA = "numeroDaGuiaNaOperadora";
    private static final String TAG_NUMERO_GUIA_PRESTADOR = "numeroDaGuiaDoPrestador";
    private static final String TAG_CODIGO_PRESTADOR_EXECUTANTE = "codigoPrestadorExecutante";
    private static final String TAG_CODIGO_BENEFICIARIO = "codigoBeneficiario";
    private static final String TAG_CHAVE_GUIA = "chaveGuia";
    private static final String TAG_NUMERO_AUTORIZACAO = "numeroAutorizacao";
    private static final String TAG_TRANSACAO_ORIGEM = "numeroTransacaoOrigem";
    private static final String TAG_UNIMED_ORIGEM = "unimedOrigem";
    private static final String TAG_RETORNO_STATUS_GUIA = "retornoStatusGuia";
    private static final String TAG_RESPOSTA_PEDIDO = "respostaPedido";
    private static final String TAG_NUMERO_GUIA = "numeroDaGuia";
    private static final String TAG_GUIA_PRESTADOR_RESPONSE = "numeroGuiaPrestador";
    private static final String TAG_DATA_EMISSAO = "dataEmissao";
    private static final String TAG_STATUS = "status";
    private static final String TAG_SENHA = "senha";
    private static final String TAG_ORIGEM_SOLICITACAO = "origemSolicitacao";
    private static final String TAG_DATA_AUTORIZACAO = "dataAutorizacao";
    private static final String TAG_DATA_ENCERRAMENTO = "dataEncerramento";
    private static final String TAG_AUTORIZADO_AUTOMATICO = "autorizadoAutomatico";
    private static final String TAG_CARATER_ATENDIMENTO = "caraterAtendimento";
    private static final String TAG_LISTA_PROCEDIMENTOS_SOLICITADOS = "listaProcedimentosSolicitados";
    private static final String TAG_PROCEDIMENTO = "procedimento";
    private static final String TAG_TIPO_TABELA = "tipoTabela";
    private static final String TAG_CODIGO_SERVICO = "codigoServico";
    private static final String TAG_QUANTIDADE = "quantidade";
    private static final String TAG_QUANTIDADE_AUTORIZADA = "quantidadeAutorizada";
    private static final String TAG_CHAVE_SERVICO = "chaveServico";
    private static final String TAG_DESCRICAO = "descricao";
    private static final String TAG_BENEFICIARIO_GUIA_SERVER = "beneficiarioGuiaServer";
    private static final String TAG_NOME = "nome";
    private static final String TAG_CODIGO_OPERADORA = "codigoOperadora";
    private static final String TAG_CODIGO = "codigo";
    private static final String TAG_TELEFONE = "telefone";
    private static final String TAG_CONTRATADO_SOLICITANTE = "contratadoSolicitante";
    private static final String TAG_PROFISSIONAL_SOLICITANTE = "profissionalSolicitante";
    private static final String TAG_CONSELHO_PROFISSIONAL = "conselhoProfissional";
    private static final String TAG_UF_DO_CONSELHO = "ufDoConselho";
    private static final String TAG_NUMERO_DO_CONSELHO = "numeroDoConselho";
    private static final String TAG_INDICACAO_CLINICA = "indicacaoClinica";
    private static final String TAG_INDICACAO_ACIDENTE = "indicacaoAcidente";
    private static final String TAG_NUMERO_TRANSACAO_DESTINO = "numeroTransacaoDestino";
    private static final String TAG_MENSAGEM_ERRO = "mensagemErro";
    private static final String MSG_CONSULTA_NOVA_GUIA = "Deseja consultar outra guia do paciente na operadora ?";
    private static final String MSG_EXAMES_NAO_AUTORIZADOS = "Exames da guia que n\u00e3o foram inseridos na requisi\u00e7\u00e3o, por estarem com status \"n\u00e3o autorizado\": \n";
    private static final String MSG_TODOS_NAO_AUTORIZADOS = "Todos os exames da guia est\u00e3o com status \"n\u00e3o autorizado\". Consulte a operadora. \n";
    private static final String MSG_TABELA_PRECOS_CONVENIO = "Verifique a tabela de pre\u00e7os do conv\u00eanio. \n";
    private static final String MSG_RETORNO_OPERADORA = "<b>Retorno da operadora:</b> \n";
    private static final String STATUS_CANCELADO_OU_NEGADO = "3";
    final int ALERTA_EXAMES_NAO_AUTORIZADOS = 0;
    final int ALERTA_TODOS_NAO_AUTORIZADOS = 1;
    final int ALERTA_RETORNO_OPERADORA = 2;
    final int ALERTA_EXAME_NAO_LOCALIZADO = 3;
    private String filial = "";
    private String codConvenio = "";
    private String address = "";
    private String loginUsuario = "";
    private String senhaUsuario = "";
    private String tipoGuia = "";
    private String numeroDaGuiaNaOperadora = "";
    private String numeroDaGuiaDoPrestador = "";
    private String codigoPrestadorExecutante = "";
    private String codigoBeneficiario = "";
    private String chaveGuia = "";
    private String numeroAutorizacao = "";
    private String numeroTransacaoOrigem = "";
    private String unimedOrigem = "";
    private ArrayList<String> erros = new ArrayList();
    private ArrayList<String> naoAutorizados = new ArrayList();
    private ArrayList<DadosExames> examesJaAdicionadosRequisicao = new ArrayList();

    public String enviaSolicitacaoStatusGuiaXML() throws Exception {
        String requestSoap = this.getXMLGuia();
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        String url = this.getAddress();
        MimeHeaders headers = new MimeHeaders();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage msg = messageFactory.createMessage(headers, (InputStream)new ByteArrayInputStream(requestSoap.getBytes()));
        try {
            SOAPMessage soapResponse = soapConnection.call(msg, (Object)url);
            Document xmlRespostaARequisicao = soapResponse.getSOAPBody().getOwnerDocument();
            return SolicitaStatusGuiaUnimedCentro.converteXMLParaString(xmlRespostaARequisicao, 0);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com a operadora.", 1);
            return "";
        }
    }

    private String getXMLGuia() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:gui=\"http://guiastatus.uc.saw.unimedcentro.com.br/\">");
            xml.escrever("<soapenv:Header/>");
            xml.escrever("<soapenv:Body>");
            xml.abrir(SolicitaStatusGuiaUnimedCentro.getTagCapturaGuia());
            xml.abrir(SolicitaStatusGuiaUnimedCentro.getTagArg());
            this.montaSolicitacaoStatusGuia(xml);
            xml.fechar(SolicitaStatusGuiaUnimedCentro.getTagArg());
            xml.fechar(SolicitaStatusGuiaUnimedCentro.getTagCapturaGuia());
            xml.escrever("</soapenv:Body>");
            xml.escrever("</soapenv:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        SolicitaStatusGuiaUnimedCentro.debug(xml.getXML());
        return xml.getXML();
    }

    private XMLStringBuilder montaSolicitacaoStatusGuia(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagLoginUsuario(), this.getLoginUsuario());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagSenhaUsuario(), this.getSenhaUsuario());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagTipoGuia(), this.getTipoGuia());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagNumeroGuiaOperadora(), this.getNumeroDaGuiaNaOperadora());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagNumeroGuiaPrestador(), this.getNumeroDaGuiaDoPrestador());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagCodigoPrestadorExecutante(), this.getCodigoPrestadorExecutante());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagCodigoBeneficiario(), this.getCodigoBeneficiario());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagChaveGuia(), this.getChaveGuia());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagNumeroAutorizacao(), this.getNumeroAutorizacao());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagTransacaoOrigem(), this.getNumeroTransacaoOrigem());
        xml.escrever(SolicitaStatusGuiaUnimedCentro.getTagUnimedOrigem(), this.getUnimedOrigem());
        return xml;
    }

    public static String converteXMLParaString(Document xml, int espacosIdentacao) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(espacosIdentacao));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(xml);
            trans.transform(source, result);
            String xmlString = sw.toString();
            SolicitaStatusGuiaUnimedCentro.debug(xmlString);
            return xmlString;
        }
        catch (TransformerException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public List<Registro> adicionaExamesSolicitacaoGuiaUnimedCentro(String autorizacao) throws Exception {
        String msg;
        String erro;
        ArrayList<Registro> examesSelecionados = new ArrayList<Registro>();
        this.erros.clear();
        this.naoAutorizados.clear();
        if (!Funcoes.textoVazio(autorizacao) && !Funcoes.textoVazio(erro = StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagMensagemErro()))) {
            this.exibeMsgAlerta(2, MSG_RETORNO_OPERADORA + erro);
            return null;
        }
        int qtdProcedimentos = 0;
        String[] procedimentos = null;
        if (!Funcoes.textoVazio(StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagListaProcedimentosSolicitados()))) {
            String listaProcedimentos = StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagListaProcedimentosSolicitados());
            procedimentos = listaProcedimentos.split("</procedimento>");
            qtdProcedimentos = procedimentos.length;
        }
        String numeroDaGuia = StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagNumeroGuia());
        String numeroGuiaPrestador = StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagGuiaPrestadorResponse());
        String dataEmissao = StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagDataEmissao());
        String indicacaoClinica = StringUtil.getValor(autorizacao, SolicitaStatusGuiaUnimedCentro.getTagIndicacaoClinica());
        if (qtdProcedimentos > 0 && procedimentos != null) {
            for (int i = 0; i < qtdProcedimentos; ++i) {
                ArrayList<Registro> exames;
                int procedimentosAutorizados;
                block16: {
                    if (Funcoes.textoVazio(procedimentos[i].toString())) continue;
                    procedimentosAutorizados = 0;
                    String quantidade = StringUtil.getValor(procedimentos[i].toString(), SolicitaStatusGuiaUnimedCentro.getTagQuantidade());
                    String status = StringUtil.getValor(procedimentos[i].toString(), SolicitaStatusGuiaUnimedCentro.getTagStatus());
                    if (!Funcoes.textoVazio(quantidade) && !status.equalsIgnoreCase(STATUS_CANCELADO_OU_NEGADO)) {
                        procedimentosAutorizados = Integer.valueOf(quantidade);
                    }
                    String codigoAmbExame = StringUtil.getValor(procedimentos[i].toString(), SolicitaStatusGuiaUnimedCentro.getTagCodigoServico());
                    String descricaoExameAMB = StringUtil.getValor(procedimentos[i].toString(), SolicitaStatusGuiaUnimedCentro.getTagDescricao());
                    if (procedimentosAutorizados <= 0) {
                        this.naoAutorizados.add("<b> " + codigoAmbExame + " - " + descricaoExameAMB + " </b> \n");
                        continue;
                    }
                    exames = new ArrayList<Registro>();
                    StringBuilder buf = new StringBuilder();
                    buf.append(" SELECT a.exa_codigo as codigoExame, ");
                    buf.append(" a.exa_descricao, c.mco_codigo as codigoMaterial, mc.mco_descricao ");
                    buf.append(" FROM detalhetabelapreco dtp ");
                    buf.append(" LEFT JOIN examematcoleta c ON dtp.fil_codigo = c.fil_codigo ");
                    buf.append(" AND c.exa_codigo = dtp.exa_codigo and c.mco_codigo = dtp.mco_codigo ");
                    buf.append(" JOIN exames a ON a.fil_codigo = dtp.fil_codigo ");
                    buf.append(" AND dtp.exa_codigo = a.exa_codigo ");
                    buf.append(" JOIN convenios con ON a.fil_codigo = con.fil_codigo ");
                    buf.append(" AND dtp.tpe_codigo = con.tpe_codigo ");
                    buf.append(" JOIN materialcoleta mc ON a.fil_codigo = mc.fil_codigo ");
                    buf.append(" AND c.mco_codigo = mc.mco_codigo ");
                    buf.append(" WHERE a.fil_codigo = ").append(this.getFilial());
                    buf.append(" AND con.con_codigo = ").append(this.getCodConvenio());
                    buf.append(" AND replace(replace(dtp.dtp_codamb, '.', ''), '-', '') = ").append("'").append(codigoAmbExame).append("'");
                    buf.append(" AND dtp.dtp_proibido = false ");
                    buf.append(" AND a.exa_proibido = false ");
                    buf.append(" ORDER BY codigoExame ");
                    try {
                        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        if (rs.next()) {
                            do {
                                ExameVO exameVO = (ExameVO)new ExameService().load(" where fil_codigo = " + this.getFilial() + " and exa_codigo = '" + rs.getString("codigoExame") + "' ;").toArray()[0];
                                Registro registro = new Registro(rs);
                                registro.setValor("objetoExame", exameVO);
                                registro.setValor("AMBexame", codigoAmbExame);
                                registro.setValor("descricaoExame", descricaoExameAMB);
                                registro.setValor(TAG_NUMERO_GUIA, numeroDaGuia);
                                registro.setValor(TAG_GUIA_PRESTADOR_RESPONSE, numeroGuiaPrestador);
                                registro.setValor(TAG_DATA_EMISSAO, dataEmissao);
                                registro.setValor(TAG_INDICACAO_CLINICA, indicacaoClinica);
                                exames.add(registro);
                            } while (rs.next());
                            break block16;
                        }
                        this.erros.add("Exame: " + codigoAmbExame + " " + descricaoExameAMB + " n\u00e3o foi encontrado. \n");
                        continue;
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                    }
                }
                if (exames == null || exames.isEmpty()) continue;
                if (exames.size() == 1) {
                    examesSelecionados.add((Registro)exames.get(0));
                    continue;
                }
                SelecionaExamesUnimedCentro selecionaExames = SelecionaExamesUnimedCentro.novaInstancia(Laboratorio.getInstancia());
                if (selecionaExames == null) continue;
                selecionaExames.setExamesJaAdicionadosRequisicao(this.getExamesJaAdicionadosRequisicao());
                selecionaExames.setQntAutorizada(procedimentosAutorizados);
                selecionaExames.setExames(exames);
                selecionaExames.setVisible(true);
                if (!selecionaExames.getOK() || selecionaExames.getExames() == null) continue;
                for (Registro item : selecionaExames.getExames()) {
                    examesSelecionados.add(item);
                }
            }
        }
        if (!Funcoes.textoVazio(msg = this.retornaMsgErro(this.erros))) {
            this.exibeMsgAlerta(3, msg + MSG_TABELA_PRECOS_CONVENIO);
        }
        if (!Funcoes.textoVazio(msg = this.retornaMsgErro(this.naoAutorizados))) {
            if (this.naoAutorizados.size() == qtdProcedimentos) {
                this.exibeMsgAlerta(1, MSG_TODOS_NAO_AUTORIZADOS);
            } else {
                this.exibeMsgAlerta(0, MSG_EXAMES_NAO_AUTORIZADOS + msg);
            }
        }
        return examesSelecionados;
    }

    public String consultaOutraGuia() {
        ConsultaStatusGuia guia;
        int resposta = Funcoes.mensagem(Laboratorio.getInstancia(), MSG_CONSULTA_NOVA_GUIA, 4);
        if (resposta == 0 && (guia = ConsultaStatusGuia.novaInstancia(Laboratorio.getInstancia())) != null) {
            guia.setVisible(true);
            if (guia.getOK()) {
                return guia.getNumeroGuia();
            }
        }
        return "";
    }

    public void setExamesJaAdicionadosRequisicao(ArrayList<DadosExames> examesGridRequisicao) {
        this.examesJaAdicionadosRequisicao = examesGridRequisicao;
    }

    public ArrayList<DadosExames> getExamesJaAdicionadosRequisicao() {
        return this.examesJaAdicionadosRequisicao;
    }

    private String retornaMsgErro(ArrayList<String> msg) {
        String erro = "";
        if (msg != null && !msg.isEmpty()) {
            for (String texto : msg) {
                erro = erro + texto;
            }
        }
        return erro;
    }

    private void exibeMsgAlerta(int alerta, String msgAviso) {
        switch (alerta) {
            case 0: {
                Funcoes.mensagem(Laboratorio.getInstancia(), msgAviso, 2);
                break;
            }
            case 1: {
                Funcoes.mensagem(Laboratorio.getInstancia(), msgAviso, 2);
                break;
            }
            case 2: {
                Funcoes.mensagem(Laboratorio.getInstancia(), msgAviso, 2);
                break;
            }
            case 3: {
                Funcoes.mensagem(Laboratorio.getInstancia(), msgAviso, 2);
            }
        }
    }

    private String criptografaSenha(String chaveAcesso) {
        return DigestUtils.md5Hex((String)chaveAcesso);
    }

    public MedicoVO getMedicoUnimedCentro(String profissionalSolicitante) {
        MedicoVO medicoVO = new MedicoVO();
        String nomeMedico = StringUtil.getValor(profissionalSolicitante, TAG_NOME);
        String conselhoProfissional = StringUtil.getValor(profissionalSolicitante, TAG_CONSELHO_PROFISSIONAL);
        String ufDoConselho = StringUtil.getValor(profissionalSolicitante, TAG_UF_DO_CONSELHO);
        String numeroDoConselho = StringUtil.getValor(profissionalSolicitante, TAG_NUMERO_DO_CONSELHO);
        ConselhoMedico conselhoEnum = ConselhoMedico.getConselhoMedicoFromNumero(conselhoProfissional);
        conselhoProfissional = conselhoEnum.name();
        UfMedico ufEnum = UfMedico.getUfMedicoFromNumero(ufDoConselho);
        ufDoConselho = ufEnum.name();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from medico where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and med_crm = '").append(numeroDoConselho).append("'");
        sql.append(" and med_uf = '").append(ufDoConselho).append("'");
        sql.append(" and med_conselho ='").append(conselhoProfissional).append("'");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                medicoVO.setConselho(rs.getString("med_conselho"));
                medicoVO.setCrm(rs.getString("med_crm"));
                FilialVO filial = new FilialVO();
                filial.setCodigo(rs.getInt("fil_codigo"));
                medicoVO.setFilial(filial);
                medicoVO.setNome(rs.getString("med_nome"));
                medicoVO.setUf(rs.getString("med_uf"));
            } else {
                sql = new StringBuilder();
                sql.append("INSERT INTO medico (fil_codigo, med_nome, med_crm, med_uf, med_conselho)");
                sql.append("VALUES(").append(Variaveis.filialPadrao).append(", ");
                sql.append("'").append(nomeMedico).append("' ,");
                sql.append("'").append(numeroDoConselho).append("' ,");
                sql.append("'").append(ufDoConselho).append("' ,");
                sql.append("'").append(conselhoProfissional).append("' )");
                Conexao.execute(Variaveis.filialPadrao, st, sql.toString(), false);
                medicoVO.setConselho(conselhoProfissional);
                medicoVO.setCrm(numeroDoConselho);
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                medicoVO.setFilial(filial);
                medicoVO.setNome(nomeMedico);
                medicoVO.setUf(ufDoConselho);
            }
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return medicoVO;
    }

    public String getFilial() {
        return this.filial;
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }

    public String getCodConvenio() {
        return this.codConvenio;
    }

    public void setCodConvenio(String codConvenio) {
        this.codConvenio = codConvenio;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLoginUsuario() {
        return this.loginUsuario;
    }

    public void setLoginUsuario(String loginUsuario) {
        this.loginUsuario = loginUsuario;
    }

    public String getSenhaUsuario() {
        return this.senhaUsuario;
    }

    public void setSenhaUsuario(String senhaUsuario) {
        this.senhaUsuario = this.criptografaSenha(senhaUsuario);
    }

    public String getTipoGuia() {
        return this.tipoGuia;
    }

    public void setTipoGuia(String tipoGuia) {
        this.tipoGuia = tipoGuia;
    }

    public String getNumeroDaGuiaNaOperadora() {
        return this.numeroDaGuiaNaOperadora;
    }

    public void setNumeroDaGuiaNaOperadora(String numeroDaGuiaNaOperadora) {
        this.numeroDaGuiaNaOperadora = numeroDaGuiaNaOperadora;
    }

    public String getNumeroDaGuiaDoPrestador() {
        return this.numeroDaGuiaDoPrestador;
    }

    public void setNumeroDaGuiaDoPrestador(String numeroDaGuiaDoPrestador) {
        this.numeroDaGuiaDoPrestador = numeroDaGuiaDoPrestador;
    }

    public String getCodigoPrestadorExecutante() {
        return this.codigoPrestadorExecutante;
    }

    public void setCodigoPrestadorExecutante(String codigoPrestadorExecutante) {
        this.codigoPrestadorExecutante = codigoPrestadorExecutante;
    }

    public String getCodigoBeneficiario() {
        return this.codigoBeneficiario;
    }

    public void setCodigoBeneficiario(String codigoBeneficiario) {
        this.codigoBeneficiario = codigoBeneficiario;
    }

    public String getChaveGuia() {
        return this.chaveGuia;
    }

    public void setChaveGuia(String chaveGuia) {
        this.chaveGuia = chaveGuia;
    }

    public String getNumeroAutorizacao() {
        return this.numeroAutorizacao;
    }

    public void setNumeroAutorizacao(String numeroAutorizacao) {
        this.numeroAutorizacao = numeroAutorizacao;
    }

    public String getNumeroTransacaoOrigem() {
        return this.numeroTransacaoOrigem;
    }

    public void setNumeroTransacaoOrigem(String numeroTransacaoOrigem) {
        this.numeroTransacaoOrigem = numeroTransacaoOrigem;
    }

    public String getUnimedOrigem() {
        return this.unimedOrigem;
    }

    public void setUnimedOrigem(String unimedOrigem) {
        this.unimedOrigem = unimedOrigem;
    }

    public static String getTagCapturaGuia() {
        return TAG_CAPTURA_GUIA;
    }

    public static String getTagArg() {
        return TAG_ARG;
    }

    public static String getTagLoginUsuario() {
        return TAG_LOGIN_USUARIO;
    }

    public static String getTagSenhaUsuario() {
        return TAG_SENHA_USUARIO;
    }

    public static String getTagTipoGuia() {
        return TAG_TIPO_GUIA;
    }

    public static String getTagNumeroGuiaOperadora() {
        return TAG_NUMERO_GUIA_OPERADORA;
    }

    public static String getTagNumeroGuiaPrestador() {
        return TAG_NUMERO_GUIA_PRESTADOR;
    }

    public static String getTagCodigoPrestadorExecutante() {
        return TAG_CODIGO_PRESTADOR_EXECUTANTE;
    }

    public static String getTagCodigoBeneficiario() {
        return TAG_CODIGO_BENEFICIARIO;
    }

    public static String getTagChaveGuia() {
        return TAG_CHAVE_GUIA;
    }

    public static String getTagNumeroAutorizacao() {
        return TAG_NUMERO_AUTORIZACAO;
    }

    public static String getTagTransacaoOrigem() {
        return TAG_TRANSACAO_ORIGEM;
    }

    public static String getTagUnimedOrigem() {
        return TAG_UNIMED_ORIGEM;
    }

    public static String getTagRetornoStatusGuia() {
        return TAG_RETORNO_STATUS_GUIA;
    }

    public static String getTagRespostaPedido() {
        return TAG_RESPOSTA_PEDIDO;
    }

    public static String getTagNumeroGuia() {
        return TAG_NUMERO_GUIA;
    }

    public static String getTagGuiaPrestadorResponse() {
        return TAG_GUIA_PRESTADOR_RESPONSE;
    }

    public static String getTagDataEmissao() {
        return TAG_DATA_EMISSAO;
    }

    public static String getTagStatus() {
        return TAG_STATUS;
    }

    public static String getTagSenha() {
        return TAG_SENHA;
    }

    public static String getTagOrigemSolicitacao() {
        return TAG_ORIGEM_SOLICITACAO;
    }

    public static String getTagDataAutorizacao() {
        return TAG_DATA_AUTORIZACAO;
    }

    public static String getTagDataEncerramento() {
        return TAG_DATA_ENCERRAMENTO;
    }

    public static String getTagAutorizadoAutomatico() {
        return TAG_AUTORIZADO_AUTOMATICO;
    }

    public static String getTagCaraterAtendimento() {
        return TAG_CARATER_ATENDIMENTO;
    }

    public static String getTagListaProcedimentosSolicitados() {
        return TAG_LISTA_PROCEDIMENTOS_SOLICITADOS;
    }

    public static String getTagProcedimento() {
        return TAG_PROCEDIMENTO;
    }

    public static String getTagTipoTabela() {
        return TAG_TIPO_TABELA;
    }

    public static String getTagCodigoServico() {
        return TAG_CODIGO_SERVICO;
    }

    public static String getTagQuantidade() {
        return TAG_QUANTIDADE;
    }

    public static String getTagQuantidadeAutorizada() {
        return TAG_QUANTIDADE_AUTORIZADA;
    }

    public static String getTagChaveServico() {
        return TAG_CHAVE_SERVICO;
    }

    public static String getTagDescricao() {
        return TAG_DESCRICAO;
    }

    public static String getTagBeneficiarioGuiaServer() {
        return TAG_BENEFICIARIO_GUIA_SERVER;
    }

    public static String getTagNome() {
        return TAG_NOME;
    }

    public static String getTagCodigoOperadora() {
        return TAG_CODIGO_OPERADORA;
    }

    public static String getTagCodigo() {
        return TAG_CODIGO;
    }

    public static String getTagTelefone() {
        return TAG_TELEFONE;
    }

    public static String getTagContratadoSolicitante() {
        return TAG_CONTRATADO_SOLICITANTE;
    }

    public static String getTagProfissionalSolicitante() {
        return TAG_PROFISSIONAL_SOLICITANTE;
    }

    public static String getTagConselhoProfissional() {
        return TAG_CONSELHO_PROFISSIONAL;
    }

    public static String getTagUfDoConselho() {
        return TAG_UF_DO_CONSELHO;
    }

    public static String getTagNumeroDoConselho() {
        return TAG_NUMERO_DO_CONSELHO;
    }

    public static String getTagIndicacaoClinica() {
        return TAG_INDICACAO_CLINICA;
    }

    public static String getTagIndicacaoAcidente() {
        return TAG_INDICACAO_ACIDENTE;
    }

    public static String getTagNumeroTransacaoDestino() {
        return TAG_NUMERO_TRANSACAO_DESTINO;
    }

    public static String getTagMensagemErro() {
        return TAG_MENSAGEM_ERRO;
    }

    private static void debug(String mensagem) {
        if (DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

