/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.sline.model;

import br.com.resultados.www.enviodocumentosline.EnviodocumentoslineSoapProxy;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.sline.TituloDocumento;
import jalis.integracaooperadoras.sistemas.sline.model.SLineCampos;
import jalis.integracaooperadoras.sistemas.sline.model.SLineDadosEnvioVO;
import jalis.integracaooperadoras.sistemas.sline.model.SLineDao;
import jalis.integracaooperadoras.sistemas.sline.model.SLineVO;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class SLineService {
    private static final String MENSAGEM_MATRICULA_NAO_INFORMADA = "Matr\u00edcula do Paciente n\u00e3o foi informada.\n";
    private static final String MENSAGEM_GUIA_NAO_INFORMADA = "Exame sem C\u00f3digo da Guia.\n";
    private static final String MENSAGEM_CODIGO_AMB_NAO_INFORMADO = "Exame sem C\u00f3digo AMB informado na Tabela de Pre\u00e7os.\n";
    private static final String PROCESSO_GERA_XML_ENVIO_RESULTADO = "gerando xml envio de resultado";
    private static final String PROCESSO_VALIDAR_DADOS_ENVIO_RESULTADO = "validando dados para envio de resultado";
    private static final String PROCESSO_ENVIAR_DADOS_RESULTADO = "validando dados para envio de resultado";
    private static final String XML_DOC_KEY = "xmlDoc";
    private static final String XML_RETORNO_KEY = "xmlRetorno";
    private static final String RESPOSTA_SUCESSO = "<SUCESSO>";
    private static final String RESPOSTA_ERRO = "<ERRO>";
    private SLineDao dao = new SLineDao();
    private DadosErrosIntegracaoOperadora erros;
    private String xmlConfiguracao;
    private String enderecoWebService;
    private String chaveLaboratorio;
    private String senhaLaboratorio;
    private String numRegistroOperadora;
    private TituloDocumento tituloDocumento;
    private EnviodocumentoslineSoapProxy slineProxy;

    public void inserirIntegracaoOperadora(SLineVO vo) throws Exception {
        String xml = this.getXmlIntegracao(vo);
        if (xml.length() > 0) {
            SLineVO slineVO = vo.addXml(xml);
            this.dao.gravarExportaIntegracao(slineVO);
        }
    }

    private String getXmlIntegracao(SLineVO vo) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracaooperadora");
        xml.escrever("nomeintegracaooperadora", FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE.getDescricao());
        xml.escrever("filial", vo.getCodigoFilial());
        xml.escrever("codreq", vo.getCodigoRequisicao());
        xml.escrever("codexa", vo.getCodigoExame());
        xml.escrever("codmat", vo.getCodigoMaterial());
        try {
            xml.fechar("integracaooperadora");
        }
        catch (XMLStringBuilderException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao criar o XML do log de integra\u00e7\u00e3o com operadora de sa\u00fade.\n" + e1.getMessage(), e1.getStackTrace());
        }
        return xml.getXML();
    }

    public List<LogIntegracaoOperadora> enviarResultado(String codigoConvenio, String xmlConfiguracao) {
        ArrayList<Object> logs = new ArrayList();
        this.configurarParametrosIntegracao(xmlConfiguracao);
        logs = this.dao.getLogsIntegracao(codigoConvenio);
        for (LogIntegracaoOperadora logIntegracaoOperadora : logs) {
            if (logIntegracaoOperadora.getTipoOperacao() != AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) continue;
            try {
                List<SLineDadosEnvioVO> examesPorRequisicao = this.dao.getDadosPorRequisicao(logIntegracaoOperadora);
                this.validarPreenchimentoCamposObrigatorios(examesPorRequisicao, logIntegracaoOperadora);
                String xmlDoc = this.getXmlDoc(examesPorRequisicao, logIntegracaoOperadora);
                String xmlDadosValidos = this.validarDadosSLine(xmlDoc, logIntegracaoOperadora);
                if (xmlDadosValidos.contains(RESPOSTA_ERRO)) {
                    this.atualizarLogComErro(logIntegracaoOperadora, xmlDadosValidos);
                    continue;
                }
                this.enviarDadosSLine(xmlDadosValidos, xmlDoc, logIntegracaoOperadora, examesPorRequisicao);
            }
            catch (Exception e) {
                logIntegracaoOperadora.setRetorno(e.getMessage());
                try {
                    this.dao.atualizarLog(logIntegracaoOperadora, false);
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException e2) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
        return logs;
    }

    private void configurarParametrosIntegracao(String xmlConfiguracao) {
        this.xmlConfiguracao = xmlConfiguracao;
        this.enderecoWebService = StringUtil.getValor(xmlConfiguracao, "endereco");
        this.chaveLaboratorio = StringUtil.getValor(xmlConfiguracao, "chave");
        this.senhaLaboratorio = StringUtil.getValor(xmlConfiguracao, "senha");
        this.numRegistroOperadora = StringUtil.getValor(xmlConfiguracao, "numeroRegistro");
        String tituloDocumento = StringUtil.getValor(xmlConfiguracao, "tituloDocumento");
        this.tituloDocumento = TituloDocumento.valueOfConteudoTag(tituloDocumento);
        this.slineProxy = new EnviodocumentoslineSoapProxy(this.enderecoWebService);
    }

    private String getXmlDoc(List<SLineDadosEnvioVO> examesPorRequisicao, LogIntegracaoOperadora log) throws Exception {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.escreveHeader("1.0", "ISO-8859-1");
            xml.abrir(SLineCampos.DADOSDOCUMENTO.getTag());
            xml.escrever(SLineCampos.TIPO.getTag(), "RP");
            xml.escrever(SLineCampos.FORMATO.getTag(), "PDF");
            xml.escrever(SLineCampos.TITULO.getTag(), this.getTituloDocumento(examesPorRequisicao));
            xml.escrever(SLineCampos.DESTINO.getTag(), "O");
            xml.escrever(SLineCampos.COD_DOC.getTag(), log.getCodigoRequisicao().toString());
            xml.escrever(SLineCampos.CHAVE.getTag(), "");
            xml.escrever(SLineCampos.SENHA_CHAVE.getTag(), "");
            LocalDateTime dataConferenciaUltimoExame = examesPorRequisicao.stream().filter(exame -> exame.getDataAssina() != null).map(exame -> exame.getDataAssina()).max(LocalDateTime::compareTo).get();
            xml.escrever(SLineCampos.DT_REALIZACAO.getTag(), dataConferenciaUltimoExame.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
            this.gerarDadosOperadora(examesPorRequisicao, xml);
            this.gerarDadosExames(examesPorRequisicao, xml);
            xml.fechar(SLineCampos.DADOSDOCUMENTO.getTag());
        }
        catch (Exception e) {
            throw this.montaExcecao(new Exception(), log, e.getMessage(), PROCESSO_GERA_XML_ENVIO_RESULTADO);
        }
        return xml.getXML();
    }

    private void gerarDadosOperadora(List<SLineDadosEnvioVO> examesPorRequisicao, XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SLineCampos.OPER.getTag());
        xml.escrever(SLineCampos.OPER_REGANS.getTag(), this.numRegistroOperadora);
        xml.escrever(SLineCampos.OPER_CARTEIRA.getTag(), examesPorRequisicao.get(0).getMatriculaPaciente());
        List guiasExames = examesPorRequisicao.stream().map(SLineDadosEnvioVO::getNumeroGuia).distinct().collect(Collectors.toList());
        for (String guia : guiasExames) {
            HashMap<String, String> atributo = new HashMap<String, String>();
            atributo.put(SLineCampos.COD_GUIA.getTag(), guia);
            xml.abrir(SLineCampos.OPER_GUIA.getTag(), atributo);
            examesPorRequisicao.forEach(e -> {
                if (e.getNumeroGuia().equals(guia) && e.getSituacaoExame().equals("C")) {
                    xml.escrever(SLineCampos.OPER_EXAME.getTag(), e.getCodigoAMB().replace(".", "").replace("-", ""));
                }
            });
            xml.fechar(SLineCampos.OPER_GUIA.getTag());
        }
        xml.fechar(SLineCampos.OPER.getTag());
    }

    private void gerarDadosExames(List<SLineDadosEnvioVO> examesPorRequisicao, XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(SLineCampos.EXAMES.getTag());
        examesPorRequisicao.forEach(e -> {
            String descricaoExame = SLineCampos.NOME.getContudoTagTamanhoMaximo(0, e.getDescricaoExame());
            String pendente = e.getSituacaoExame().equals("C") ? "N" : "S";
            StringBuilder atributos = new StringBuilder(" ").append(SLineCampos.NOME.getTag()).append("=\"").append(descricaoExame).append("\" ").append(SLineCampos.PENDENTE.getTag()).append("=\"").append(pendente).append("\"");
            xml.escrever("<", SLineCampos.EXAME.getTag(), atributos.toString(), "/>");
        });
        xml.fechar(SLineCampos.EXAMES.getTag());
    }

    private String validarDadosSLine(String xmlDoc, LogIntegracaoOperadora log) throws Exception {
        String xmlRetorno = "";
        try {
            xmlRetorno = this.slineProxy.validardados(this.chaveLaboratorio, this.senhaLaboratorio, xmlDoc);
        }
        catch (Exception e) {
            throw this.montaExcecao(new Exception(), log, e.getMessage(), "validando dados para envio de resultado");
        }
        return xmlRetorno;
    }

    private void enviarDadosSLine(String xmlDadosValidos, String xmlDoc, LogIntegracaoOperadora log, List<SLineDadosEnvioVO> examesPorRequisicao) throws IntegracaoOperadoraException {
        String codigoAcesso = StringUtil.getValor(xmlDadosValidos, "CODIGOACESSO");
        String identificacao = StringUtil.getValor(xmlDadosValidos, "IDENTIFICACAO");
        String xmlRetorno = "";
        try {
            List<String> exames = examesPorRequisicao.stream().map(SLineDadosEnvioVO::getCodigoExame).collect(Collectors.toList());
            List<String> materiais = examesPorRequisicao.stream().map(SLineDadosEnvioVO::getCodigoMaterial).collect(Collectors.toList());
            RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(null, null, log.getCodigoFilial().toString(), log.getCodigoRequisicao().toString(), true, true, null, exames.toArray(new String[exames.size()]), materiais.toArray(new String[materiais.size()]), true, null, true, true, null, true, "", true, false);
            xmlRetorno = this.slineProxy.enviardocumento(identificacao, codigoAcesso, xmlDoc, retorno.getResultadoPdfWeb());
            if (xmlRetorno.contains(RESPOSTA_ERRO)) {
                this.atualizarLogComErro(log, xmlRetorno);
            } else {
                log.setSituacao("E");
                log.setRetorno(xmlRetorno);
                this.dao.atualizarLog(log, true);
            }
        }
        catch (Exception e) {
            throw this.montaExcecao(new Exception(), log, e.getMessage(), "validando dados para envio de resultado");
        }
    }

    private IntegracaoOperadoraException montaExcecao(Exception excecao, LogIntegracaoOperadora log, String mensagemErro, String nomeProcesso) {
        StringBuilder buf = new StringBuilder();
        buf.append(nomeProcesso != null ? nomeProcesso.toUpperCase() : "");
        if (excecao instanceof IntegracaoOperadoraException) {
            buf.append(" - ").append(((IntegracaoOperadoraException)excecao).getMensagemErro());
        }
        if (excecao instanceof SQLException) {
            buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
        }
        if (excecao != null) {
            buf.append(" - ").append(excecao.toString());
        }
        if (mensagemErro != null) {
            buf.append(" - ").append(mensagemErro);
        }
        if (log != null) {
            buf.append("\nDADOS DO LOG: filial = ").append(log.getCodigoFilial()).append(", requisi\u00e7\u00e3o = ").append(log.getCodigoRequisicao());
            buf.append(", exame = ").append(log.getCodigoExame()).append(", material = ").append(log.getCodigoMaterial()).append(".");
        }
        IntegracaoOperadoraException novaExcecao = new IntegracaoOperadoraException(excecao, buf.toString(), nomeProcesso, log);
        if (excecao != null) {
            novaExcecao.setStackTrace(excecao.getStackTrace());
        }
        return novaExcecao;
    }

    private String getTituloDocumento(List<SLineDadosEnvioVO> examesPorRequisicao) {
        StringBuilder titulo = new StringBuilder();
        String identificacao = examesPorRequisicao.get(0).getMatriculaPaciente();
        String nome = examesPorRequisicao.get(0).getNomePaciente();
        LocalDate dataNascimento = examesPorRequisicao.get(0).getDataNasciemntoPaciente();
        String nascimento = dataNascimento.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        String separadorTitulo = " - ";
        switch (this.tituloDocumento) {
            case IDENTIFICACAO_NOMEPACIENTE: {
                nome = SLineCampos.TITULO.getContudoTagTamanhoMaximo(identificacao.length() + separadorTitulo.length(), nome);
                titulo.append(identificacao).append(separadorTitulo).append(nome);
                break;
            }
            case NOMEPACIENTE: {
                nome = SLineCampos.TITULO.getContudoTagTamanhoMaximo(nome.length(), nome);
                titulo.append(nome);
                break;
            }
            case NOMEPACIENTE_DATANASCIMENTO_IDENTIFICACAO: {
                int tamanhoEmUso = separadorTitulo.length() * 2 + nascimento.length() + identificacao.length();
                nome = SLineCampos.TITULO.getContudoTagTamanhoMaximo(tamanhoEmUso, nome);
                titulo.append(nome).append(separadorTitulo).append(nascimento).append(separadorTitulo).append(identificacao);
                break;
            }
            case NOMEPACIENTE_IDENTIFICACAO: {
                nome = SLineCampos.TITULO.getContudoTagTamanhoMaximo(identificacao.length(), nome);
                titulo.append(nome).append(separadorTitulo).append(identificacao);
                break;
            }
            default: {
                nome = SLineCampos.TITULO.getContudoTagTamanhoMaximo(nascimento.length() + separadorTitulo.length(), nome);
                titulo.append(nome).append(separadorTitulo).append(nascimento);
            }
        }
        return titulo.toString();
    }

    private void validarPreenchimentoCamposObrigatorios(List<SLineDadosEnvioVO> dados, LogIntegracaoOperadora logIntegracao) throws Exception {
        StringBuilder mensagens = new StringBuilder();
        dados.forEach(vo -> {
            if (vo.getCodigoExame().equals(logIntegracao.getCodigoExame()) && vo.getCodigoMaterial().equals(String.valueOf(logIntegracao.getCodigoMaterial()))) {
                mensagens.append(Funcoes.textoVazio(vo.getMatriculaPaciente()) ? MENSAGEM_MATRICULA_NAO_INFORMADA : "");
                mensagens.append(Funcoes.textoVazio(vo.getNumeroGuia()) ? MENSAGEM_GUIA_NAO_INFORMADA : "");
                mensagens.append(Funcoes.textoVazio(vo.getCodigoAMB()) ? MENSAGEM_CODIGO_AMB_NAO_INFORMADO : "");
            }
        });
        if (mensagens.length() > 0) {
            logIntegracao.setSituacao("N");
            throw new Exception(mensagens.toString());
        }
    }

    private void atualizarLogComErro(LogIntegracaoOperadora log, String xmlRespostaErro) throws Exception {
        log.setSituacao("R");
        log.setRetorno(xmlRespostaErro);
        this.dao.atualizarLog(log, null);
    }
}

