/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaooperadoras.sistemas.sline.model;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.sline.model.SLineDadosEnvioVO;
import jalis.integracaooperadoras.sistemas.sline.model.SLineVO;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SLineDao {
    private static final String PROCESSO_BUSCA_DADOS = "buscando dados";

    public void gravarExportaIntegracao(SLineVO vo) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaooperadora (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo) ");
        buf.append(" values (").append(vo.getCodigoFilial());
        buf.append(" ,").append(vo.getCodigoConvenio());
        buf.append(" , nextval('exportaintegracaooperadora_").append(Integer.parseInt(vo.getCodigoFilial())).append("_sequence') ");
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(vo.getXml().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append((Object)AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO).append("' ");
        buf.append(" , false");
        buf.append(" , ").append(vo.getCodigoRequisicao());
        buf.append(" , ").append(vo.getCodigoPaciente());
        buf.append(" , '").append(vo.getCodigoExame()).append("'");
        buf.append(" , ").append(vo.getCodigoMaterial()).append(")");
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(vo.getCodigoFilial(), st, buf);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new Exception("Erro ao inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public List<SLineDadosEnvioVO> getDadosPorRequisicao(LogIntegracaoOperadora log) throws IntegracaoOperadoraException {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" p.pac_nome, ");
        sql.append(" p.pac_datanasc,  ");
        sql.append(" r.req_matricula, ");
        sql.append(" case when e.exr_guia is null or e.exr_guia = '' then  r.req_guia else e.exr_guia end as guia, ");
        sql.append(" dtp.dtp_codamb, ");
        sql.append(" e.exr_dataassina, ");
        sql.append(" e.exr_situacao, ");
        sql.append(" exa.exa_descricao, ");
        sql.append(" e.exa_codigo, ");
        sql.append(" e.mco_codigo ");
        sql.append(" from requisicao r ");
        sql.append(" left join examerequisicao e on r.fil_codigo = e.fil_codigo and r.req_codigo = e.req_codigo ");
        sql.append(" left join exames exa on e.fil_codigo = exa.fil_codigo and e.exa_codigo = exa.exa_codigo ");
        sql.append(" left join paciente p on r.fil_codigo = p.fil_codigo and r.pac_codigo = p.pac_codigo ");
        sql.append(" left join convenios c on r.fil_codigo = c.fil_codigo and r.con_codigo = c.con_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            sql.append("  left join detalhetabelaprecometodologia dtpm on e.fil_codigo  = dtpm.fil_codigo and e.exa_codigo = dtpm.exa_codigo and e.mco_codigo  = dtpm.mco_codigo and c.tpe_codigo = dtpm.tpe_codigo ");
        } else {
            sql.append("  left join detalhetabelapreco dtp on e.fil_codigo = dtp.fil_codigo and e.exa_codigo = dtp.exa_codigo and e.mco_codigo = dtp.mco_codigo and c.tpe_codigo = dtp.tpe_codigo ");
        }
        sql.append(" where e.fil_codigo = ").append(log.getCodigoFilial());
        sql.append(" and r.con_codigo = ").append(log.getCodigoConvenio());
        sql.append(" and e.req_codigo = ").append(log.getCodigoRequisicao());
        sql.append(" group by ");
        sql.append(" p.pac_nome, p.pac_datanasc, r.req_matricula, guia, dtp.dtp_codamb, e.exr_dataassina, e.exr_situacao, exa.exa_descricao, e.exa_codigo, e.mco_codigo ");
        ArrayList<SLineDadosEnvioVO> dados = new ArrayList<SLineDadosEnvioVO>();
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, sql.toString());
            while (rs.next()) {
                Timestamp dataNasc;
                SLineDadosEnvioVO vo = new SLineDadosEnvioVO();
                vo.setCodigoAMB(rs.getString("dtp_codamb"));
                Timestamp dataAssina = rs.getTimestamp("exr_dataassina");
                if (dataAssina != null) {
                    vo.setDataAssina(dataAssina.toLocalDateTime());
                }
                if ((dataNasc = rs.getTimestamp("pac_datanasc")) != null) {
                    vo.setDataNasciemntoPaciente(dataNasc.toLocalDateTime().toLocalDate());
                }
                vo.setMatriculaPaciente(rs.getString("req_matricula"));
                vo.setNomePaciente(rs.getString("pac_nome"));
                vo.setNumeroGuia(rs.getString("guia"));
                vo.setSituacaoExame(rs.getString("exr_situacao"));
                vo.setDescricaoExame(rs.getString("exa_descricao"));
                vo.setCodigoExame(rs.getString("exa_codigo"));
                vo.setCodigoMaterial(rs.getString("mco_codigo"));
                dados.add(vo);
            }
        }
        catch (SQLException e) {
            throw new IntegracaoOperadoraException(e, "Erro ao buscar dados para enviar \u00e0 operadora." + e.getMessage(), PROCESSO_BUSCA_DADOS, log);
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return dados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LogIntegracaoOperadora> getLogsIntegracao(String codigoConvenio) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo as codigoFilial ");
        sql.append("       ,eio_codigo as codigoLog ");
        sql.append("       ,con_codigo as codigoConvenio ");
        sql.append("       ,eio_operacao as operacao ");
        sql.append("       ,eio_tipooperacao as tipoOperacao ");
        sql.append("       ,eio_retorno as retorno");
        sql.append("       ,COALESCE(eio_situacao,'') as situacao ");
        sql.append("       ,pac_codigo as codigoPaciente ");
        sql.append("  from exportaintegracaooperadora ");
        sql.append("  where eio_exportado = false ");
        sql.append("  and con_codigo = ").append(codigoConvenio);
        sql.append("  and eio_retorno is null ");
        sql.append("  and eio_operacao ilike '%<nomeintegracaooperadora>SLine</nomeintegracaooperadora>%' ");
        sql.append("  order by eio_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        try {
            rs = ConexaoTemporaria.executeQuery(st, sql.toString());
            ArrayList<LogIntegracaoOperadora> listaLogs = new ArrayList<LogIntegracaoOperadora>();
            while (rs.next()) {
                listaLogs.add(this.getLogIntegracao(rs));
            }
            ArrayList<LogIntegracaoOperadora> arrayList = listaLogs;
            return arrayList;
        }
        catch (SQLException sQLException) {
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return null;
    }

    private LogIntegracaoOperadora getLogIntegracao(ResultSet rs) throws SQLException {
        String operacao = rs.getString("operacao");
        Integer codigoRequisicao = Integer.parseInt(StringUtil.getValor(operacao, "codreq"));
        String codigoExame = StringUtil.getValor(operacao, "codexa");
        Integer codigoMaterial = Integer.parseInt(StringUtil.getValor(operacao, "codmat"));
        LogIntegracaoOperadora logIntegracaoOperadora = new LogIntegracaoOperadora();
        logIntegracaoOperadora.setCodigoFilial(rs.getInt("codigoFilial"));
        logIntegracaoOperadora.setCodigoLog(rs.getInt("codigoLog"));
        logIntegracaoOperadora.setCodigoConvenio(rs.getInt("codigoConvenio"));
        logIntegracaoOperadora.setCodigoRequisicao(codigoRequisicao);
        logIntegracaoOperadora.setCodigoExame(codigoExame);
        logIntegracaoOperadora.setCodigoMaterial(codigoMaterial);
        logIntegracaoOperadora.setTipoOperacao(AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.getTipoOperacao(rs.getString("tipoOperacao")));
        logIntegracaoOperadora.setXmlLog(operacao);
        logIntegracaoOperadora.setRetorno(rs.getString("retorno"));
        logIntegracaoOperadora.setSituacao(rs.getString("situacao"));
        logIntegracaoOperadora.setCodigoPaciente(rs.getString("codigoPaciente"));
        return logIntegracaoOperadora;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarLog(LogIntegracaoOperadora log, Boolean exportado) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        if (exportado != null) {
            buf.append(" set eio_exportado = ").append(exportado);
        }
        buf.append(" ,eio_retorno = ").append(StringUtil.textoDBEscape(log.getRetorno()));
        buf.append(" ,eio_situacao = '").append(log.getSituacao()).append("'");
        buf.append(" where fil_codigo = ").append(log.getCodigoFilial());
        buf.append(" and req_codigo = ").append(log.getCodigoRequisicao());
        buf.append(" and exa_codigo = '").append(log.getCodigoExame()).append("'");
        buf.append(" and mco_codigo = ").append(log.getCodigoMaterial());
        buf.append(" and con_codigo = ").append(log.getCodigoConvenio());
        buf.append(" and eio_codigo = ").append(log.getCodigoLog());
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(st, buf);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sqle) {
                throw new Exception("Erro ao inserir entrada de integra\u00e7\u00e3o com a operadora.\n" + e.getMessage());
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }
}

